/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.ClusterNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.SettingUpgrader;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportSettings;

public abstract class RemoteClusterAware {
    public static final Setting.AffixSetting<List<String>> SEARCH_REMOTE_CLUSTERS_SEEDS;
    public static final SettingUpgrader<List<String>> SEARCH_REMOTE_CLUSTER_SEEDS_UPGRADER;
    public static final Setting.AffixSetting<List<String>> REMOTE_CLUSTERS_SEEDS;
    public static final char REMOTE_CLUSTER_INDEX_SEPARATOR = ':';
    public static final String LOCAL_CLUSTER_GROUP_KEY = "";
    public static final Setting.AffixSetting<String> SEARCH_REMOTE_CLUSTERS_PROXY;
    public static final SettingUpgrader<String> SEARCH_REMOTE_CLUSTERS_PROXY_UPGRADER;
    public static final Setting.AffixSetting<String> REMOTE_CLUSTERS_PROXY;
    protected final Settings settings;
    private final ClusterNameExpressionResolver clusterNameResolver;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RemoteClusterAware(Settings settings) {
        this.settings = settings;
        this.clusterNameResolver = new ClusterNameExpressionResolver();
    }

    protected static Map<String, Tuple<String, List<Tuple<String, Supplier<DiscoveryNode>>>>> buildRemoteClustersDynamicConfig(Settings settings) {
        Map<String, Tuple<String, List<Tuple<String, Supplier<DiscoveryNode>>>>> remoteSeeds = RemoteClusterAware.buildRemoteClustersDynamicConfig(settings, REMOTE_CLUSTERS_SEEDS);
        Map<String, Tuple<String, List<Tuple<String, Supplier<DiscoveryNode>>>>> searchRemoteSeeds = RemoteClusterAware.buildRemoteClustersDynamicConfig(settings, SEARCH_REMOTE_CLUSTERS_SEEDS);
        TreeSet<String> intersection = new TreeSet<String>(Arrays.asList((String[])searchRemoteSeeds.keySet().stream().filter(s -> remoteSeeds.keySet().contains(s)).sorted().toArray(String[]::new)));
        if (!intersection.isEmpty()) {
            String message = String.format(Locale.ROOT, "found duplicate remote cluster configurations for cluster alias%s [%s]", intersection.size() == 1 ? LOCAL_CLUSTER_GROUP_KEY : "es", String.join((CharSequence)",", intersection));
            throw new IllegalArgumentException(message);
        }
        return Stream.concat(remoteSeeds.entrySet().stream(), searchRemoteSeeds.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map<String, Tuple<String, List<Tuple<String, Supplier<DiscoveryNode>>>>> buildRemoteClustersDynamicConfig(Settings settings, Setting.AffixSetting<List<String>> seedsSetting) {
        Stream<Setting<List<String>>> allConcreteSettings = seedsSetting.getAllConcreteSettings(settings);
        return allConcreteSettings.collect(Collectors.toMap(seedsSetting::getNamespace, concreteSetting -> {
            String clusterName = seedsSetting.getNamespace((Setting<List<String>>)concreteSetting);
            List addresses = (List)concreteSetting.get(settings);
            boolean proxyMode = REMOTE_CLUSTERS_PROXY.getConcreteSettingForNamespace(clusterName).existsOrFallbackExists(settings);
            ArrayList<Tuple> nodes = new ArrayList<Tuple>(addresses.size());
            for (String address : addresses) {
                nodes.add(Tuple.tuple((Object)address, () -> RemoteClusterAware.buildSeedNode(clusterName, address, proxyMode)));
            }
            return new Tuple((Object)REMOTE_CLUSTERS_PROXY.getConcreteSettingForNamespace(clusterName).get(settings), nodes);
        }));
    }

    static DiscoveryNode buildSeedNode(String clusterName, String address, boolean proxyMode) {
        if (proxyMode) {
            TransportAddress transportAddress = new TransportAddress(TransportAddress.META_ADDRESS, 0);
            String hostName = address.substring(0, RemoteClusterAware.indexOfPortSeparator(address));
            return new DiscoveryNode(LOCAL_CLUSTER_GROUP_KEY, clusterName + "#" + address, UUIDs.randomBase64UUID(), hostName, address, transportAddress, Collections.singletonMap("server_name", hostName), EnumSet.allOf(DiscoveryNode.Role.class), Version.CURRENT.minimumCompatibilityVersion());
        }
        TransportAddress transportAddress = new TransportAddress(RemoteClusterAware.parseSeedAddress(address));
        return new DiscoveryNode(clusterName + "#" + transportAddress.toString(), transportAddress, Version.CURRENT.minimumCompatibilityVersion());
    }

    protected Map<String, List<String>> groupClusterIndices(Set<String> remoteClusterNames, String[] requestIndices, Predicate<String> indexExists) {
        HashMap<String, List<String>> perClusterIndices = new HashMap<String, List<String>>();
        for (String index : requestIndices) {
            int i = index.indexOf(58);
            if (i >= 0) {
                String remoteClusterName = index.substring(0, i);
                List<String> clusters = this.clusterNameResolver.resolveClusterNames(remoteClusterNames, remoteClusterName);
                if (!clusters.isEmpty()) {
                    if (indexExists.test(index)) {
                        throw new IllegalArgumentException("Can not filter indices; index " + index + " exists but there is also a remote cluster named: " + remoteClusterName);
                    }
                    String indexName = index.substring(i + 1);
                    for (String clusterName : clusters) {
                        perClusterIndices.computeIfAbsent(clusterName, k -> new ArrayList()).add(indexName);
                    }
                    continue;
                }
                perClusterIndices.computeIfAbsent(LOCAL_CLUSTER_GROUP_KEY, k -> new ArrayList()).add(index);
                continue;
            }
            perClusterIndices.computeIfAbsent(LOCAL_CLUSTER_GROUP_KEY, k -> new ArrayList()).add(index);
        }
        return perClusterIndices;
    }

    void updateRemoteCluster(String clusterAlias, List<String> addresses, String proxy) {
        Boolean compress = TransportSettings.TRANSPORT_COMPRESS.get(this.settings);
        TimeValue pingSchedule = TransportSettings.PING_SCHEDULE.get(this.settings);
        this.updateRemoteCluster(clusterAlias, addresses, proxy, compress, pingSchedule);
    }

    void updateRemoteCluster(String clusterAlias, Settings settings) {
        String proxy = REMOTE_CLUSTERS_PROXY.getConcreteSettingForNamespace(clusterAlias).get(settings);
        List<String> addresses = REMOTE_CLUSTERS_SEEDS.getConcreteSettingForNamespace(clusterAlias).get(settings);
        Boolean compress = RemoteClusterService.REMOTE_CLUSTER_COMPRESS.getConcreteSettingForNamespace(clusterAlias).get(settings);
        TimeValue pingSchedule = RemoteClusterService.REMOTE_CLUSTER_PING_SCHEDULE.getConcreteSettingForNamespace(clusterAlias).get(settings);
        this.updateRemoteCluster(clusterAlias, addresses, proxy, compress, pingSchedule);
    }

    protected abstract void updateRemoteCluster(String var1, List<String> var2, String var3, boolean var4, TimeValue var5);

    public void listenForUpdates(ClusterSettings clusterSettings) {
        List<Setting.AffixSetting<?>> remoteClusterSettings = Arrays.asList(REMOTE_CLUSTERS_PROXY, REMOTE_CLUSTERS_SEEDS, RemoteClusterService.REMOTE_CLUSTER_COMPRESS, RemoteClusterService.REMOTE_CLUSTER_PING_SCHEDULE);
        clusterSettings.addAffixGroupUpdateConsumer(remoteClusterSettings, this::updateRemoteCluster);
        clusterSettings.addAffixUpdateConsumer(SEARCH_REMOTE_CLUSTERS_PROXY, SEARCH_REMOTE_CLUSTERS_SEEDS, (key, value) -> this.updateRemoteCluster((String)key, (List)value.v2(), (String)value.v1()), (namespace, value) -> {});
    }

    static InetSocketAddress parseSeedAddress(String remoteHost) {
        InetAddress hostAddress;
        Tuple<String, Integer> hostPort = RemoteClusterAware.parseHostPort(remoteHost);
        String host = (String)hostPort.v1();
        if (!$assertionsDisabled && hostPort.v2() == null) {
            throw new AssertionError((Object)remoteHost);
        }
        int port = (Integer)hostPort.v2();
        try {
            hostAddress = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("unknown host [" + host + "]", e);
        }
        return new InetSocketAddress(hostAddress, port);
    }

    public static Tuple<String, Integer> parseHostPort(String remoteHost) {
        String host = remoteHost.substring(0, RemoteClusterAware.indexOfPortSeparator(remoteHost));
        int port = RemoteClusterAware.parsePort(remoteHost);
        return Tuple.tuple((Object)host, (Object)port);
    }

    private static int parsePort(String remoteHost) {
        try {
            int port = Integer.valueOf(remoteHost.substring(RemoteClusterAware.indexOfPortSeparator(remoteHost) + 1));
            if (port <= 0) {
                throw new IllegalArgumentException("port number must be > 0 but was: [" + port + "]");
            }
            return port;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("failed to parse port", e);
        }
    }

    private static int indexOfPortSeparator(String remoteHost) {
        int portSeparator = remoteHost.lastIndexOf(58);
        if (portSeparator == -1 || portSeparator == remoteHost.length()) {
            throw new IllegalArgumentException("remote hosts need to be configured as [host:port], found [" + remoteHost + "] instead");
        }
        return portSeparator;
    }

    public static String buildRemoteIndexName(String clusterAlias, String indexName) {
        return clusterAlias == null || LOCAL_CLUSTER_GROUP_KEY.equals(clusterAlias) ? indexName : clusterAlias + ':' + indexName;
    }

    static {
        boolean bl = $assertionsDisabled = !RemoteClusterAware.class.desiredAssertionStatus();
        if (!$assertionsDisabled && Version.CURRENT.major >= 8) {
            throw new AssertionError();
        }
        SEARCH_REMOTE_CLUSTERS_SEEDS = Setting.affixKeySetting("search.remote.", "seeds", key -> Setting.listSetting(key, Collections.emptyList(), s -> {
            RemoteClusterAware.parsePort(s);
            return s;
        }, Setting.Property.Deprecated, Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSetting[0]);
        SEARCH_REMOTE_CLUSTER_SEEDS_UPGRADER = new SettingUpgrader<List<String>>(){

            @Override
            public Setting<List<String>> getSetting() {
                return SEARCH_REMOTE_CLUSTERS_SEEDS;
            }

            @Override
            public String getKey(String key) {
                return key.replaceFirst("^search", "cluster");
            }
        };
        REMOTE_CLUSTERS_SEEDS = Setting.affixKeySetting("cluster.remote.", "seeds", key -> Setting.listSetting(key, "_na_".equals(key) ? SEARCH_REMOTE_CLUSTERS_SEEDS.getConcreteSettingForNamespace((String)key) : SEARCH_REMOTE_CLUSTERS_SEEDS.getConcreteSetting(key.replaceAll("^cluster", "search")), s -> {
            RemoteClusterAware.parsePort(s);
            return s;
        }, Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSetting[0]);
        SEARCH_REMOTE_CLUSTERS_PROXY = Setting.affixKeySetting("search.remote.", "proxy", key -> Setting.simpleString(key, s -> {
            if (Strings.hasLength(s)) {
                RemoteClusterAware.parsePort(s);
            }
        }, Setting.Property.Deprecated, Setting.Property.Dynamic, Setting.Property.NodeScope), REMOTE_CLUSTERS_SEEDS);
        SEARCH_REMOTE_CLUSTERS_PROXY_UPGRADER = new SettingUpgrader<String>(){

            @Override
            public Setting<String> getSetting() {
                return SEARCH_REMOTE_CLUSTERS_PROXY;
            }

            @Override
            public String getKey(String key) {
                return key.replaceFirst("^search", "cluster");
            }
        };
        REMOTE_CLUSTERS_PROXY = Setting.affixKeySetting("cluster.remote.", "proxy", key -> Setting.simpleString(key, "_na_".equals(key) ? SEARCH_REMOTE_CLUSTERS_PROXY.getConcreteSettingForNamespace((String)key) : SEARCH_REMOTE_CLUSTERS_PROXY.getConcreteSetting(key.replaceAll("^cluster", "search")), s -> {
            if (Strings.hasLength(s)) {
                RemoteClusterAware.parsePort(s);
            }
            return s;
        }, Setting.Property.Dynamic, Setting.Property.NodeScope), REMOTE_CLUSTERS_SEEDS);
    }
}

