/*
 * Decompiled with CFR 0.152.
 */
package plugins.map;

import freemind.controller.actions.generated.instance.Place;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import plugins.map.MapDialog;
import plugins.map.MapMarkerBase;

public class MapSearchMarkerLocation
extends MapMarkerBase {
    public static final int CIRCLE_SELECTED_FACTOR = 2;
    private static final int CIRCLE_DIAMETER = 10;
    private final Place mPlace;

    public MapSearchMarkerLocation(MapDialog pMapDialog, Place pNewPlace) {
        super(pMapDialog);
        this.mBulletColor = Color.RED;
        this.mPlace = pNewPlace;
        this.update();
    }

    public void update() {
        this.setText(this.mPlace.getDisplayName());
        this.setForeground(this.mBulletColor);
        this.setSize(this.getPreferredSize());
    }

    public double getLat() {
        return this.mPlace.getLat();
    }

    public double getLon() {
        return this.mPlace.getLon();
    }

    @Override
    protected void paintCenter(Graphics pG, Point pPosition) {
        if (this.isSelected()) {
            Graphics2D g2 = (Graphics2D)pG;
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(new BasicStroke(4.0f));
            int xo = pPosition.x - 10;
            int xu = pPosition.x + 10;
            int yo = pPosition.y - 10;
            int yu = pPosition.y + 10;
            g2.drawLine(xo, yo, xu, yu);
            g2.drawLine(xu, yo, xo, yu);
            g2.setStroke(oldStroke);
        } else {
            super.paintCenter(pG, pPosition);
        }
    }

    @Override
    public String toString() {
        return "MapSearchMarkerLocation for search text " + this.mPlace.getDisplayName() + " at " + this.getLat() + " " + this.getLon();
    }

    public Place getPlace() {
        return this.mPlace;
    }
}

