/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Utilities;
import com.itextpdf.text.pdf.ArrayBasedStringTokenizer;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.CJKFont;
import com.itextpdf.text.pdf.Glyph;
import com.itextpdf.text.pdf.IntHashtable;
import com.itextpdf.text.pdf.PdfEncodings;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.StringUtils;
import com.itextpdf.text.pdf.TrueTypeFontUnicode;
import com.itextpdf.text.pdf.fonts.otf.Language;
import com.itextpdf.text.pdf.languages.BanglaGlyphRepositioner;
import com.itextpdf.text.pdf.languages.GlyphRepositioner;
import com.itextpdf.text.pdf.languages.IndicCompositeCharacterComparator;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

class FontDetails {
    PdfIndirectReference indirectReference;
    PdfName fontName;
    BaseFont baseFont;
    TrueTypeFontUnicode ttu;
    CJKFont cjkFont;
    byte[] shortTag;
    HashMap<Integer, int[]> longTag;
    IntHashtable cjkTag;
    int fontType;
    boolean symbolic;
    protected boolean subset = true;

    FontDetails(PdfName fontName, PdfIndirectReference indirectReference, BaseFont baseFont) {
        this.fontName = fontName;
        this.indirectReference = indirectReference;
        this.baseFont = baseFont;
        this.fontType = baseFont.getFontType();
        switch (this.fontType) {
            case 0: 
            case 1: {
                this.shortTag = new byte[256];
                break;
            }
            case 2: {
                this.cjkTag = new IntHashtable();
                this.cjkFont = (CJKFont)baseFont;
                break;
            }
            case 3: {
                this.longTag = new HashMap();
                this.ttu = (TrueTypeFontUnicode)baseFont;
                this.symbolic = baseFont.isFontSpecific();
            }
        }
    }

    PdfIndirectReference getIndirectReference() {
        return this.indirectReference;
    }

    PdfName getFontName() {
        return this.fontName;
    }

    BaseFont getBaseFont() {
        return this.baseFont;
    }

    Object[] convertToBytesGid(String gids) {
        if (this.fontType != 3) {
            throw new IllegalArgumentException("GID require TT Unicode");
        }
        try {
            StringBuilder sb = new StringBuilder();
            int totalWidth = 0;
            for (int n : gids.toCharArray()) {
                Integer gl;
                int width = this.ttu.getGlyphWidth(n);
                totalWidth += width;
                int vchar = this.ttu.GetCharFromGlyphId(n);
                if (vchar != 0) {
                    sb.append(Utilities.convertFromUtf32(vchar));
                }
                if (this.longTag.containsKey(gl = Integer.valueOf(n))) continue;
                this.longTag.put(gl, new int[]{n, width, vchar});
            }
            return new Object[]{gids.getBytes("UnicodeBigUnmarked"), sb.toString(), totalWidth};
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    byte[] convertToBytes(String text) {
        byte[] b = null;
        switch (this.fontType) {
            case 5: {
                return this.baseFont.convertToBytes(text);
            }
            case 0: 
            case 1: {
                b = this.baseFont.convertToBytes(text);
                int len = b.length;
                for (int k = 0; k < len; ++k) {
                    this.shortTag[b[k] & 0xFF] = 1;
                }
                break;
            }
            case 2: {
                int len = text.length();
                if (this.cjkFont.isIdentity()) {
                    for (int k = 0; k < len; ++k) {
                        this.cjkTag.put(text.charAt(k), 0);
                    }
                } else {
                    for (int k = 0; k < len; ++k) {
                        int val;
                        if (Utilities.isSurrogatePair(text, k)) {
                            val = Utilities.convertToUtf32(text, k);
                            ++k;
                        } else {
                            val = text.charAt(k);
                        }
                        this.cjkTag.put(this.cjkFont.getCidCode(val), 0);
                    }
                }
                b = this.cjkFont.convertToBytes(text);
                break;
            }
            case 4: {
                b = this.baseFont.convertToBytes(text);
                break;
            }
            case 3: {
                try {
                    int len = text.length();
                    int[] metrics = null;
                    char[] glyph = new char[len];
                    int i = 0;
                    if (this.symbolic) {
                        b = PdfEncodings.convertToBytes(text, "symboltt");
                        len = b.length;
                        for (int k = 0; k < len; ++k) {
                            metrics = this.ttu.getMetricsTT(b[k] & 0xFF);
                            if (metrics == null) continue;
                            this.longTag.put(metrics[0], new int[]{metrics[0], metrics[1], this.ttu.getUnicodeDifferences(b[k] & 0xFF)});
                            glyph[i++] = (char)metrics[0];
                        }
                    } else {
                        if (this.canApplyGlyphSubstitution()) {
                            return this.convertToBytesAfterGlyphSubstitution(text);
                        }
                        for (int k = 0; k < len; ++k) {
                            int val;
                            if (Utilities.isSurrogatePair(text, k)) {
                                val = Utilities.convertToUtf32(text, k);
                                ++k;
                            } else {
                                val = text.charAt(k);
                            }
                            metrics = this.ttu.getMetricsTT(val);
                            if (metrics == null) continue;
                            int m0 = metrics[0];
                            Integer gl = m0;
                            if (!this.longTag.containsKey(gl)) {
                                this.longTag.put(gl, new int[]{m0, metrics[1], val});
                            }
                            glyph[i++] = (char)m0;
                        }
                    }
                    glyph = Utilities.copyOfRange(glyph, 0, i);
                    b = StringUtils.convertCharsToBytes(glyph);
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new ExceptionConverter(e);
                }
            }
        }
        return b;
    }

    private boolean canApplyGlyphSubstitution() {
        return this.fontType == 3 && this.ttu.getGlyphSubstitutionMap() != null;
    }

    private byte[] convertToBytesAfterGlyphSubstitution(String text) throws UnsupportedEncodingException {
        if (!this.canApplyGlyphSubstitution()) {
            throw new IllegalArgumentException("Make sure the font type if TTF Unicode and a valid GlyphSubstitutionTable exists!");
        }
        Map<String, Glyph> glyphSubstitutionMap = this.ttu.getGlyphSubstitutionMap();
        TreeSet<String> compositeCharacters = new TreeSet<String>(new IndicCompositeCharacterComparator());
        compositeCharacters.addAll(glyphSubstitutionMap.keySet());
        ArrayBasedStringTokenizer tokenizer = new ArrayBasedStringTokenizer(compositeCharacters.toArray(new String[0]));
        String[] tokens = tokenizer.tokenize(text);
        ArrayList<Glyph> glyphList = new ArrayList<Glyph>(50);
        for (String token : tokens) {
            Glyph subsGlyph = glyphSubstitutionMap.get(token);
            if (subsGlyph != null) {
                glyphList.add(subsGlyph);
                continue;
            }
            for (char c : token.toCharArray()) {
                int[] metrics = this.ttu.getMetricsTT(c);
                int glyphCode = metrics[0];
                int glyphWidth = metrics[1];
                glyphList.add(new Glyph(glyphCode, glyphWidth, String.valueOf(c)));
            }
        }
        GlyphRepositioner glyphRepositioner = this.getGlyphRepositioner();
        if (glyphRepositioner != null) {
            glyphRepositioner.repositionGlyphs(glyphList);
        }
        char[] charEncodedGlyphCodes = new char[glyphList.size()];
        for (int i = 0; i < glyphList.size(); ++i) {
            Glyph glyph = (Glyph)glyphList.get(i);
            charEncodedGlyphCodes[i] = (char)glyph.code;
            Integer glyphCode = glyph.code;
            if (this.longTag.containsKey(glyphCode)) continue;
            this.longTag.put(glyphCode, new int[]{glyph.code, glyph.width, glyph.chars.charAt(0)});
        }
        return new String(charEncodedGlyphCodes).getBytes("UnicodeBigUnmarked");
    }

    private GlyphRepositioner getGlyphRepositioner() {
        Language language = this.ttu.getSupportedLanguage();
        if (language == null) {
            throw new IllegalArgumentException("The supported language field cannot be null in " + this.ttu.getClass().getName());
        }
        switch (language) {
            case BENGALI: {
                return new BanglaGlyphRepositioner(Collections.unmodifiableMap(this.ttu.cmap31), this.ttu.getGlyphSubstitutionMap());
            }
        }
        return null;
    }

    public void writeFont(PdfWriter writer) {
        try {
            switch (this.fontType) {
                case 5: {
                    this.baseFont.writeFont(writer, this.indirectReference, null);
                    break;
                }
                case 0: 
                case 1: {
                    int lastChar;
                    int firstChar;
                    for (firstChar = 0; firstChar < 256 && this.shortTag[firstChar] == 0; ++firstChar) {
                    }
                    for (lastChar = 255; lastChar >= firstChar && this.shortTag[lastChar] == 0; --lastChar) {
                    }
                    if (firstChar > 255) {
                        firstChar = 255;
                        lastChar = 255;
                    }
                    this.baseFont.writeFont(writer, this.indirectReference, new Object[]{firstChar, lastChar, this.shortTag, this.subset});
                    break;
                }
                case 2: {
                    this.baseFont.writeFont(writer, this.indirectReference, new Object[]{this.cjkTag});
                    break;
                }
                case 3: {
                    this.baseFont.writeFont(writer, this.indirectReference, new Object[]{this.longTag, this.subset});
                }
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public boolean isSubset() {
        return this.subset;
    }

    public void setSubset(boolean subset) {
        this.subset = subset;
    }
}

