/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.envjs.http.simple.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.IoActions;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.resource.Context;
import org.simpleframework.http.resource.Index;

public class SimpleFileServerContainer
implements Container {
    private final Context context;

    public SimpleFileServerContainer(Context context) {
        this.context = context;
    }

    public void handle(Request req, Response resp) {
        Index requestIndex = this.context.getIndex(req.getTarget());
        File targetFile = requestIndex.getFile();
        if (!targetFile.exists()) {
            resp.setCode(404);
            resp.setText("Not Found");
            try {
                resp.getPrintStream().println(String.format("File '%s' does not exist", targetFile.getAbsolutePath()));
                resp.commit();
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
        String contentType = requestIndex.getContentType();
        resp.set("Content-Type", contentType);
        OutputStream output = null;
        try {
            output = resp.getOutputStream();
            if (contentType.startsWith("text/")) {
                resp.set("Content-Encoding", Charset.defaultCharset().name());
                FileReader input = new FileReader(requestIndex.getFile());
                IOUtils.copy((Reader)input, (OutputStream)output);
                IoActions.closeQuietly((Closeable)input);
            } else {
                FileInputStream input = new FileInputStream(requestIndex.getFile());
                IOUtils.copy((InputStream)input, (OutputStream)output);
                IoActions.closeQuietly((Closeable)input);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        finally {
            IoActions.closeQuietly((Closeable)output);
        }
    }
}

