/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.T3;
import org.jmol.export.__RayTracerExporter;
import org.jmol.viewer.Viewer;

public class _PovrayExporter
extends __RayTracerExporter {
    private boolean haveMacros;

    public _PovrayExporter() {
        this.commentChar = "// ";
    }

    @Override
    protected String finalizeOutput() {
        this.finalizeOutput2();
        return this.getAuxiliaryFileData();
    }

    @Override
    protected void outputHeader() {
        float f;
        float offsetY;
        float offsetX;
        this.initVars();
        this.output("// ******************************************************\n");
        this.output("// Created by Jmol " + Viewer.getJmolVersion() + "\n");
        this.output("//\n");
        this.output("// This script was generated on " + this.getExportDate() + "\n");
        this.output("// ******************************************************\n");
        try {
            this.output(this.vwr.getWrappedStateScript());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.output("\n");
        this.output(this.getJmolPerspective());
        this.output("\n");
        this.output("// ******************************************************\n");
        this.output("// Declare the resolution, camera, and light sources.\n");
        this.output("// ******************************************************\n");
        this.output("\n");
        this.output("// NOTE: if you plan to render at a different resolution,\n");
        this.output("// be sure to update the following two lines to maintain\n");
        this.output("// the correct aspect ratio.\n\n");
        this.output("#declare Width = " + this.screenWidth + ";\n");
        this.output("#declare Height = " + this.screenHeight + ";\n");
        this.output("#declare minScreenDimension = " + this.minScreenDimension + ";\n");
        this.output("#declare showAtoms = true;\n");
        this.output("#declare showBonds = true;\n");
        this.output("#declare noShadows = true;\n");
        this.output("camera{\n");
        if (this.wasPerspective) {
            offsetX = this.vwr.tm.getTranslationXPercent() / 100.0f * (float)this.screenWidth;
            offsetY = this.vwr.tm.getTranslationYPercent() / 100.0f * (float)this.screenHeight;
            f = 1.0f / this.vwr.tm.getPerspectiveFactor((this.vwr.tm.getCameraDepth() - 0.5f) * (float)this.vwr.getScreenDim());
            this.output("  perspective\n");
            this.output("  angle " + this.apertureAngle + "\n");
            this.output("  right < " + this.screenWidth + ", 0, 0>\n");
            this.output("  up < 0, " + -this.screenHeight + ", 0 >\n");
        } else {
            f = 0.0f;
            offsetY = 0.0f;
            offsetX = 0.0f;
            this.output("  orthographic\n");
            this.output("  right < " + -this.screenWidth + ", 0, 0>\n");
            this.output("  up < 0, " + this.screenHeight + ", 0 >\n");
        }
        this.output("  sky < 0, -1, 0 >\n");
        this.output("  location < " + ((float)this.screenWidth / 2.0f + offsetX) + ", " + ((float)this.screenHeight / 2.0f + offsetY) + ", 0>\n");
        this.output("  look_at < " + ((float)this.screenWidth / 2.0f + f * offsetX) + ", " + ((float)this.screenHeight / 2.0f + f * offsetY) + ", 1000 >\n");
        this.output("}\n");
        this.output("\n");
        this.output("background { color rgb <" + this.rgbFractionalFromColix(this.backgroundColix) + "> }\n");
        this.output("\n");
        float distance = Math.max(this.screenWidth, this.screenHeight);
        this.output("light_source { <" + this.lightSource.x * distance + "," + this.lightSource.y * distance + ", " + -1.0f * this.lightSource.z * distance + ">  rgb <0.6,0.6,0.6> }\n");
        this.output("\n");
        this.output("\n");
        this.output("// ***********************************************\n");
        this.output("// macros for common shapes\n");
        this.output("// ***********************************************\n");
        this.output("\n");
        this.writeMacros();
    }

    private void writeMacros() {
        this.output("#default { finish {\n  ambient " + (float)this.gdata.getAmbientPercent() / 100.0f + "\n  diffuse " + (float)this.gdata.getDiffusePercent() / 100.0f + "\n  specular " + (float)this.gdata.getSpecularPercent() / 100.0f + "\n  roughness .00001\n  metallic\n  phong 0.9\n  phong_size 120\n}}\n\n");
        this.output("#macro check_shadow()\n #if (noShadows)\n  no_shadow \n #end\n#end\n\n");
        this.output("#declare slabZ = " + this.slabZ + ";\n#declare depthZ = " + this.depthZ + ";\n#declare dzSlab = 10;\n#declare dzDepth = dzSlab;\n#declare dzStep = 0.001;\n\n");
        this.output("#macro clip()\n  clipped_by { box {<0,0,slabZ>,<Width,Height,depthZ>} }\n#end\n\n");
        this.output("#macro circleCap(Z,RADIUS,R,G,B,T)\n// cap for lower clip\n #local cutDiff = Z - slabZ;\n #local cutRadius2 = (RADIUS*RADIUS) - (cutDiff*cutDiff);\n #if (cutRadius2 > 0)\n  #local cutRadius = sqrt(cutRadius2);\n  #if (dzSlab > 0)\n   #declare dzSlab = dzSlab - dzStep;\n  #end\n  cylinder{<X,Y,slabZ-dzSlab>,<X,Y,(slabZ+1)>,cutRadius\n   pigment{rgbt<R,G,B,T>}\n   translucentFinish(T)\n   check_shadow()}\n #end\n// cap for upper clip\n #declare cutDiff = Z - depthZ;\n #declare cutRadius2 = (RADIUS*RADIUS) - (cutDiff*cutDiff);\n #if (cutRadius2 > 0)\n  #local cutRadius = sqrt(cutRadius2);\n  #if (dzDepth > 0)\n   #declare dzDepth = dzDepth - dzStep;\n  #end\n  cylinder{<X,Y,depthZ+dzDepth>,<X,Y,(depthZ-1)>,cutRadius\n   pigment{rgbt<R,G,B,T>}\n   translucentFinish(T)\n   check_shadow()}\n #end\n#end\n\n");
        this.writeMacrosFinish();
        this.writeMacrosAtom();
        this.writeMacrosBond();
    }

    private void writeMacrosFinish() {
        this.output("#macro translucentFinish(T)\n #local shineFactor = T;\n #if (T <= 0.25)\n  #declare shineFactor = (1.0-4*T);\n #end\n #if (T > 0.25)\n  #declare shineFactor = 0;\n #end\n finish {\n  ambient " + (float)this.gdata.getAmbientPercent() / 100.0f + "\n  diffuse " + (float)this.gdata.getDiffusePercent() / 100.0f + "\n  specular " + (float)this.gdata.getSpecularPercent() / 100.0f + "\n  roughness .00001\n  metallic shineFactor\n  phong 0.9*shineFactor\n  phong_size 120*shineFactor\n}#end\n\n");
    }

    private void writeMacrosAtom() {
        this.output("#macro a(X,Y,Z,RADIUS,R,G,B,T)\n sphere{<X,Y,Z>,RADIUS\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  check_shadow()}\n" + (this.isSlabEnabled ? " circleCap(Z,RADIUS,R,G,B,T)\n" : "") + "#end\n\n");
        this.output("#macro q(XX,YY,ZZ,XY,XZ,YZ,X,Y,Z,J,R,G,B,T)\n quadric{<XX,YY,ZZ>,<XY,XZ,YZ>,<X,Y,Z>,J\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  check_shadow()}\n#end\n\n");
    }

    private void writeMacrosBond() {
        this.output("#macro b(X1,Y1,Z1,RADIUS1,X2,Y2,Z2,RADIUS2,R,G,B,T)\n cone{<X1,Y1,Z1>,RADIUS1,<X2,Y2,Z2>,RADIUS2\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  check_shadow()}\n#end\n\n");
        this.output("#macro c(X1,Y1,Z1,RADIUS1,X2,Y2,Z2,RADIUS2,R,G,B,T)\n cone{<X1,Y1,Z1>,RADIUS1,<X2,Y2,Z2>,RADIUS2 open\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  check_shadow()}\n#end\n\n");
    }

    private void writeMacros2() {
        this.output("#macro r(X1,Y1,Z1,X2,Y2,Z2,X3,Y3,Z3,R,G,B,T)\n triangle{<X1,Y1,Z1>,<X2,Y2,Z2>,<X3,Y3,Z3>\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  check_shadow()}\n#end\n\n");
        this.output("#macro p(X,Y,Z,R,G,B,T)\n box{<X,Y,Z>,<X+1,Y+1,Z+1>\n  pigment{rgbt<R,G,B,T>}\n  clip()\n  check_shadow()}\n#end\n\n");
        this.output("#macro barb(X1,Y1,Z1,RADIUS1,X2,Y2,Z2,RADIUS2,R,G,B,T,X3,Y3,Z3,W3)\n cone{<X1,Y1,Z1>,RADIUS1,<X2,Y2,Z2>,RADIUS2\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  clipped_by{plane{<X3,Y3,Z3>,W3}}\n  check_shadow()}\n#end\n\n");
        this.haveMacros = true;
    }

    @Override
    protected String getTriad(T3 pt) {
        if (Float.isNaN(pt.x)) {
            return "0,0,0";
        }
        return pt.x + "," + pt.y + "," + pt.z;
    }

    private String getTriad(int[] i) {
        return i[0] + "," + i[1] + "," + i[2];
    }

    private String color4(short colix) {
        return this.rgbFractionalFromColix(colix) + "," + _PovrayExporter.translucencyFractionalFromColix(colix);
    }

    private String getAuxiliaryFileData() {
        String fName = this.fileName.substring(this.fileName.lastIndexOf("/") + 1);
        fName = fName.substring(fName.lastIndexOf("\\") + 1);
        return "; Created by: Jmol " + Viewer.getJmolVersion() + "\n; Creation date: " + this.getExportDate() + "\n; File created: " + this.fileName + " (" + this.getByteCount() + " bytes)\n\n" + (this.commandLineOptions != null ? this.commandLineOptions : "\n; Jmol state: (embedded in input file)\nInput_File_Name=" + fName + "\nOutput_to_File=true\nOutput_File_Type=N\nOutput_File_Name=" + fName + ".png\nWidth=" + this.screenWidth + "\nHeight=" + this.screenHeight + "\nAntialias=true\nAntialias_Threshold=0.1\nDisplay=true\nPause_When_Done=true\nWarning_Level=5\nVerbose=false\n");
    }

    @Override
    protected void output(T3 pt) {
        this.output(", <" + this.getTriad(pt) + ">");
    }

    @Override
    protected void outputCircle(int x, int y, int z, float radius, short colix, boolean doFill) {
        this.output((doFill ? "b(" : "c(") + x + "," + y + "," + z + "," + radius + "," + x + "," + y + "," + (z + 1) + "," + (radius + (float)(doFill ? 0 : 2)) + "," + this.color4(colix) + ")\n");
    }

    @Override
    protected void outputCone(P3 screenBase, P3 screenTip, float radius, short colix, boolean isBarb) {
        if (isBarb) {
            if (!this.haveMacros) {
                this.writeMacros2();
            }
            this.tempP1.set(screenBase.x, screenTip.y, 12345.679f);
            P4 plane = Measure.getPlaneThroughPoints(screenBase, screenTip, this.tempP1, this.tempV1, this.tempV2, new P4());
            this.output("barb(" + this.getTriad(screenBase) + "," + radius + "," + this.getTriad(screenTip) + ",0," + this.color4(colix) + "," + plane.x + "," + plane.y + "," + plane.z + "," + -plane.w + ")\n");
        } else {
            this.output("b(" + this.getTriad(screenBase) + "," + radius + "," + this.getTriad(screenTip) + ",0," + this.color4(colix) + ")\n");
        }
    }

    @Override
    protected void outputCylinder(P3 screenA, P3 screenB, float radius, short colix, boolean withCaps) {
        String color = this.color4(colix);
        this.output((withCaps ? "b(" : "c(") + this.getTriad(screenA) + "," + radius + "," + this.getTriad(screenB) + "," + radius + "," + color + ")\n");
    }

    @Override
    protected void outputCylinderConical(P3 screenA, P3 screenB, float radius1, float radius2, short colix) {
        this.output("b(" + this.getTriad(screenA) + "," + radius1 + "," + this.getTriad(screenB) + "," + radius2 + "," + this.color4(colix) + ")\n");
    }

    @Override
    protected void outputEllipsoid(P3 center, float radius, double[] coef, short colix) {
        String s = coef[0] + "," + coef[1] + "," + coef[2] + "," + coef[3] + "," + coef[4] + "," + coef[5] + "," + coef[6] + "," + coef[7] + "," + coef[8] + "," + coef[9] + "," + this.color4(colix);
        this.output("q(" + s + ")\n");
    }

    @Override
    protected void outputSurface(T3[] vertices, T3[] normals, short[] colixes, int[][] indices, short[] polygonColixes, int nVertices, int nPolygons, int nTriangles, BS bsPolygons, int faceVertexMax, short colix, Lst<Short> colorList, Map<Short, Integer> htColixes, P3 offset) {
        int i0;
        int i;
        boolean haveNormals;
        if (polygonColixes != null) {
            int i02;
            boolean isAll = bsPolygons == null;
            int i2 = i02 = isAll ? nPolygons - 1 : bsPolygons.nextSetBit(0);
            while (i2 >= 0) {
                this.output("polygon { 4\n");
                for (int j = 0; j <= 3; ++j) {
                    this.outputVertex(vertices[indices[i2][j % 3]], offset);
                }
                this.output("\n");
                colix = polygonColixes[i2];
                this.output("pigment{rgbt<" + this.color4(colix) + ">}\n");
                this.output("  translucentFinish(" + _PovrayExporter.translucencyFractionalFromColix(colix) + ")\n");
                this.output("  check_shadow()\n");
                this.output("  clip()\n");
                this.output("}\n");
                i2 = isAll ? i2 - 1 : bsPolygons.nextSetBit(i2 + 1);
            }
            return;
        }
        this.output("mesh2 {\n");
        this.output("vertex_vectors { " + nVertices);
        for (int i3 = 0; i3 < nVertices; ++i3) {
            this.outputVertex(vertices[i3], offset);
        }
        this.output("\n}\n");
        boolean bl = haveNormals = normals != null;
        if (haveNormals) {
            this.output("normal_vectors { " + nVertices);
            for (int i4 = 0; i4 < nVertices; ++i4) {
                _PovrayExporter.setTempVertex(vertices[i4], offset, this.tempP2);
                this.output(this.getScreenNormal(this.tempP2, normals[i4], 1.0f));
                this.output("\n");
            }
            this.output("\n}\n");
        }
        if (colixes != null) {
            int nColix = colorList.size();
            this.output("texture_list { " + nColix);
            String finish = ">} translucentFinish(" + _PovrayExporter.translucencyFractionalFromColix(colixes[0]) + ")}";
            for (i = 0; i < nColix; ++i) {
                this.output("\n, texture{pigment{rgbt<" + this.color4((Short)colorList.get(i)) + finish);
            }
            this.output("\n}\n");
        }
        this.output("face_indices { " + nTriangles);
        boolean isAll = bsPolygons == null;
        i = i0 = isAll ? nPolygons - 1 : bsPolygons.nextSetBit(0);
        while (i >= 0) {
            this.output(", <" + this.getTriad(indices[i]) + ">");
            if (colixes != null) {
                this.output("," + htColixes.get(colixes[indices[i][0]]));
                this.output("," + htColixes.get(colixes[indices[i][1]]));
                this.output("," + htColixes.get(colixes[indices[i][2]]));
            }
            if (faceVertexMax == 4 && indices[i].length == 4) {
                this.output(", <" + indices[i][0] + "," + indices[i][2] + "," + indices[i][3] + ">");
                if (colixes != null) {
                    this.output("," + htColixes.get(colixes[indices[i][0]]));
                    this.output("," + htColixes.get(colixes[indices[i][2]]));
                    this.output("," + htColixes.get(colixes[indices[i][3]]));
                }
            }
            this.output("\n");
            i = isAll ? i - 1 : bsPolygons.nextSetBit(i + 1);
        }
        this.output("\n}\n");
        if (colixes == null) {
            this.output("pigment{rgbt<" + this.color4(colix) + ">}\n");
            this.output("  translucentFinish(" + _PovrayExporter.translucencyFractionalFromColix(colix) + ")\n");
        }
        this.output("  check_shadow()\n");
        this.output("  clip()\n");
        this.output("}\n");
    }

    @Override
    protected void outputSphere(float x, float y, float z, float radius, short colix) {
        this.output("a(" + x + "," + y + "," + z + "," + radius + "," + this.color4(colix) + ")\n");
    }

    @Override
    protected void outputTextPixel(int x, int y, int z, int argb) {
        if (!this.haveMacros) {
            this.writeMacros2();
        }
        float tr = argb >> 24 & 0xFF;
        tr = (255.0f - tr) / 255.0f;
        this.output("p(" + x + "," + y + "," + z + "," + this.rgbFractionalFromArgb(argb) + "," + tr + ")\n");
    }

    @Override
    protected void outputTriangle(T3 ptA, T3 ptB, T3 ptC, short colix) {
        if (!this.haveMacros) {
            this.writeMacros2();
        }
        this.output("r(" + this.getTriad(ptA) + "," + this.getTriad(ptB) + "," + this.getTriad(ptC) + "," + this.color4(colix) + ")\n");
    }
}

