/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MopacSlaterReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

public class CsfReader
extends MopacSlaterReader {
    private int nAtoms = 0;
    private String strAtomicNumbers = "";
    private int fieldCount;
    private int nVibrations = 0;
    private int nGaussians = 0;
    private int nSlaters = 0;
    private Map<String, Bond> htBonds;
    private Map<String, Integer> propertyItemCounts = new Hashtable<String, Integer>();
    private final int[] fieldTypes = new int[100];
    private static final byte objCls1 = 1;
    private static final byte objID1 = 2;
    private static final byte objCls2 = 3;
    private static final byte objID2 = 4;
    private static final String[] connectorFields = new String[]{"objCls1", "objID1", "objCls2", "objID2"};
    private static final byte[] connectorFieldMap = new byte[]{1, 2, 3, 4};
    private Map<String, String[]> connectors;
    private static final byte ID = -1;
    private static final byte SYM = 1;
    private static final byte ANUM = 2;
    private static final byte CHRG = 3;
    private static final byte XYZ = 4;
    private static final byte PCHRG = 5;
    private static final String[] atomFields = new String[]{"ID", "sym", "anum", "chrg", "xyz_coordinates", "pchrg"};
    private static final byte[] atomFieldMap = new byte[]{-1, 1, 2, 3, 4, 5};
    private static final byte BTYPE = 1;
    private static final String[] bondFields = new String[]{"ID", "type"};
    private static final byte[] bondFieldMap = new byte[]{-1, 1};
    private static final byte NORMAL_MODE = 1;
    private static final byte VIB_ENERGY = 2;
    private static final byte DIPOLE = 3;
    private static final String[] vibFields = new String[]{"ID", "normalMode", "Energy", "transitionDipole"};
    private static final byte[] vibFieldMap = new byte[]{-1, 1, 2, 3};
    private static final byte EIG_VAL = 1;
    private static final byte MO_OCC = 2;
    private static final byte EIG_VEC = 3;
    private static final byte EIG_VEC_COMPRESSED = 4;
    private static final byte COEF_INDICES = 5;
    private static final byte BFXN_ANGL = 6;
    private static final byte STO_EXP = 7;
    private static final byte CONTRACTIONS = 8;
    private static final byte GTO_EXP = 9;
    private static final byte SHELL = 10;
    private static final String[] moFields = new String[]{"ID", "eig_val", "mo_occ", "eig_vec", "eig_vec_compressed", "coef_indices", "bfxn_ang", "sto_exp", "contractions", "gto_exp", "shell"};
    private static final byte[] moFieldMap = new byte[]{-1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.equals("local_transform")) {
            this.processLocalTransform();
            return true;
        }
        if (this.line.startsWith("object_class")) {
            if (this.line.equals("object_class connector")) {
                this.processConnectorObject();
                return false;
            }
            if (this.line.equals("object_class atom")) {
                this.processAtomObject();
                return false;
            }
            if (this.line.equals("object_class bond")) {
                this.processBondObject();
                return false;
            }
            if (this.line.equals("object_class vibrational_level")) {
                this.processVibrationObject();
                return false;
            }
            if (this.line.equals("object_class mol_orbital")) {
                this.processMolecularOrbitalObject();
                return false;
            }
            if (this.line.equals("object_class sto_basis_fxn")) {
                this.processBasisObject("sto");
                return false;
            }
            if (this.line.equals("object_class gto_basis_fxn")) {
                this.processBasisObject("gto");
                return false;
            }
        }
        return true;
    }

    private void processLocalTransform() throws Exception {
        String[] stringArray = PT.getTokens(String.valueOf(this.rd()) + " " + this.rd() + " " + this.rd() + " " + this.rd());
        this.setTransform(this.parseFloatStr(stringArray[0]), this.parseFloatStr(stringArray[1]), this.parseFloatStr(stringArray[2]), this.parseFloatStr(stringArray[4]), this.parseFloatStr(stringArray[5]), this.parseFloatStr(stringArray[6]), this.parseFloatStr(stringArray[8]), this.parseFloatStr(stringArray[9]), this.parseFloatStr(stringArray[10]));
    }

    private int getPropertyCount(String string) {
        Integer n = this.propertyItemCounts.get(string);
        return string.equals("ID") ? 1 : (n == null ? 0 : n);
    }

    private int parseLineParameters(String[] stringArray, byte[] byArray) throws Exception {
        int n = 0;
        while (n < this.fieldCount) {
            this.fieldTypes[n] = 0;
            ++n;
        }
        this.fieldCount = -1;
        if (this.line == null || this.line.startsWith("property_flags:")) {
            this.rd();
        }
        if (this.line == null || this.line.startsWith("object_class")) {
            return this.fieldCount;
        }
        String[] stringArray2 = new String[]{};
        while (this.line != null) {
            stringArray2 = this.getTokens();
            if (this.line.indexOf("property ") == 0) {
                this.propertyItemCounts.put(stringArray2[1], stringArray2[6].equals("STRING") ? 1 : this.parseIntStr(stringArray2[5]));
            } else if (this.line.indexOf("ID") == 0) break;
            this.rd();
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < stringArray2.length) {
            String string = stringArray2[n2];
            int n4 = stringArray.length;
            while (--n4 >= 0) {
                if (!string.equals(stringArray[n4])) continue;
                this.fieldTypes[n3] = byArray[n4];
                this.fieldCount = n3 + 1;
                break;
            }
            n3 += this.getPropertyCount(string);
            ++n2;
        }
        return this.fieldCount;
    }

    private void fillCsfArray(String string, String[] stringArray, int n, Object object, boolean bl) throws Exception {
        int n2 = this.getPropertyCount(string);
        int n3 = n;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n3 + n4;
            if (n5 == stringArray.length) {
                stringArray = PT.getTokens(this.rd());
                n3 -= n5 - n;
                n5 = n;
            }
            if (bl) {
                ((int[])object)[n4] = this.parseIntStr(stringArray[n5]);
            } else {
                ((float[])object)[n4] = this.parseFloatStr(stringArray[n5]);
            }
            ++n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processConnectorObject() throws Exception {
        this.connectors = new Hashtable<String, String[]>();
        this.rd();
        this.parseLineParameters(connectorFields, connectorFieldMap);
        block6: while (this.rd() != null) {
            if (this.line.startsWith("property_flags:")) {
                return;
            }
            String string = null;
            String string2 = null;
            String[] stringArray = this.getTokens();
            String string3 = "";
            boolean bl = false;
            int n = 0;
            while (n < this.fieldCount) {
                String string4 = stringArray[n];
                switch (this.fieldTypes[n]) {
                    case 1: {
                        if (string4.equals("atom")) break;
                        continue block6;
                    }
                    case 3: {
                        string3 = string4;
                        if (string4.equals("sto_basis_fxn")) {
                            ++this.nSlaters;
                            break;
                        }
                        if (string4.equals("gto_basis_fxn")) {
                            ++this.nGaussians;
                            break;
                        }
                        if (string4.equals("vibrational_level")) {
                            bl = true;
                            break;
                        }
                        if (string4.equals("bond")) break;
                        continue block6;
                    }
                    case 2: {
                        string = string4;
                        break;
                    }
                    case 4: {
                        string2 = String.valueOf(string3) + string4;
                        if (!bl) break;
                        this.nVibrations = Math.max(this.nVibrations, this.parseIntStr(string4));
                    }
                }
                ++n;
            }
            if (string == null || string2 == null) continue;
            if (this.connectors.containsKey(string2)) {
                String[] stringArray2 = this.connectors.get(string2);
                stringArray2[1] = string;
                if (this.htBonds == null) continue;
                this.setBond(this.htBonds.get(string2), stringArray2);
                continue;
            }
            String[] stringArray3 = new String[2];
            stringArray3[0] = string;
            this.connectors.put(string2, stringArray3);
        }
    }

    private void setBond(Bond bond, String[] stringArray) {
        bond.atomIndex1 = this.asc.getAtomIndex(stringArray[0]);
        bond.atomIndex2 = this.asc.getAtomIndex(stringArray[1]);
        this.asc.addBond(bond);
    }

    private void processAtomObject() throws Exception {
        this.rd();
        this.parseLineParameters(atomFields, atomFieldMap);
        this.nAtoms = 0;
        while (this.rd() != null) {
            if (this.line.startsWith("property_flags:")) break;
            String[] stringArray = this.getTokens();
            Atom atom = new Atom();
            int n = 0;
            while (n < this.fieldCount) {
                int n2 = this.fieldTypes[n];
                if (n2 != 0) {
                    String string = stringArray[n];
                    if (string == null) {
                        Logger.warn("field == null in " + this.line);
                    }
                    switch (n2) {
                        case -1: {
                            atom.atomSerial = PT.parseInt(string);
                            break;
                        }
                        case 1: {
                            atom.elementSymbol = string;
                            atom.atomName = String.valueOf(string) + atom.atomSerial;
                            break;
                        }
                        case 2: {
                            this.strAtomicNumbers = String.valueOf(this.strAtomicNumbers) + string + " ";
                            break;
                        }
                        case 3: {
                            atom.formalCharge = this.parseIntStr(string);
                            break;
                        }
                        case 5: {
                            atom.partialCharge = this.parseFloatStr(string);
                            break;
                        }
                        case 4: {
                            this.setAtomCoordTokens(atom, stringArray, n);
                            n += 2;
                        }
                    }
                }
                ++n;
            }
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn("atom " + atom.atomName + " has invalid/unknown coordinates");
                continue;
            }
            ++this.nAtoms;
            this.asc.addAtomWithMappedSerialNumber(atom);
        }
    }

    private void processBondObject() throws Exception {
        this.rd();
        this.parseLineParameters(bondFields, bondFieldMap);
        while (this.rd() != null) {
            if (this.line.startsWith("property_flags:")) break;
            String string = null;
            String[] stringArray = this.getTokens();
            int n = 0;
            while (n < this.fieldCount) {
                String string2 = stringArray[n];
                switch (this.fieldTypes[n]) {
                    case -1: {
                        string = "bond" + string2;
                        break;
                    }
                    case 1: {
                        int n2 = 1;
                        if (string2.equals("single")) {
                            n2 = 1;
                        } else if (string2.equals("double")) {
                            n2 = 2;
                        } else if (string2.equals("triple")) {
                            n2 = 3;
                        } else {
                            Logger.warn("unknown CSF bond order: " + string2);
                        }
                        Bond bond = new Bond(-1, -1, 1);
                        bond.order = n2;
                        if (this.connectors == null) {
                            if (this.htBonds == null) {
                                this.htBonds = new Hashtable<String, Bond>();
                            }
                            this.htBonds.put(string, bond);
                            break;
                        }
                        this.setBond(bond, this.connectors.get(string));
                    }
                }
                ++n;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processVibrationObject() throws Exception {
        var1_1 = new float[this.nVibrations][this.nAtoms * 3];
        var2_2 = new String[this.nVibrations];
        this.rd();
        ** GOTO lbl24
        {
            var3_3 = this.getTokens();
            var4_5 = -1;
            var5_6 = 0;
            while (var5_6 < this.fieldCount) {
                var6_7 = var3_3[var5_6];
                switch (this.fieldTypes[var5_6]) {
                    case -1: {
                        var4_5 = this.parseIntStr(var6_7) - 1;
                        break;
                    }
                    case 1: {
                        this.fillCsfArray("normalMode", var3_3, var5_6, var1_1[var4_5], false);
                        break;
                    }
                    case 2: {
                        var2_2[var4_5] = var6_7;
                    }
                }
                ++var5_6;
            }
            do {
                if (this.rd() != null && !this.line.startsWith("property_flags:")) continue block5;
lbl24:
                // 2 sources

            } while (this.line != null && this.parseLineParameters(CsfReader.vibFields, CsfReader.vibFieldMap) > 0);
        }
        var3_4 = 0;
        while (var3_4 < this.nVibrations) {
            if (this.doGetVibration(++this.vibrationNumber)) {
                this.asc.cloneAtomSetWithBonds(false);
                this.asc.setAtomSetFrequency(this.vibrationNumber, null, null, var2_2[var3_4], null);
                var4_5 = 0;
                var5_6 = this.nAtoms * (var3_4 + 1);
                var6_8 = 0;
                while (var6_8 < this.nAtoms) {
                    this.asc.addVibrationVector(var5_6 + var6_8, var1_1[var3_4][var4_5++], var1_1[var3_4][var4_5++], var1_1[var3_4][var4_5++]);
                    ++var6_8;
                }
            }
            ++var3_4;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processMolecularOrbitalObject() throws Exception {
        if (this.nSlaters == 0 && this.nGaussians == 0 || !this.doReadMolecularOrbitals) {
            this.rd();
            return;
        }
        this.nOrbitals = this.nSlaters + this.nGaussians;
        Logger.info("Reading CSF data for " + this.nOrbitals + " molecular orbitals");
        var1_1 = new float[this.nOrbitals];
        var2_2 = new float[this.nOrbitals];
        var3_3 = new float[this.nOrbitals][this.nOrbitals];
        var4_4 = null;
        var5_5 = null;
        var6_6 = 0;
        var7_7 = false;
        this.rd();
        ** GOTO lbl47
        {
            var8_8 = this.getTokens();
            var9_10 = 0;
            while (var9_10 < this.fieldCount) {
                switch (this.fieldTypes[var9_10]) {
                    case -1: {
                        var6_6 = this.parseIntStr(var8_8[var9_10]) - 1;
                        break;
                    }
                    case 1: {
                        var1_1[var6_6] = this.parseFloatStr(var8_8[var9_10]);
                        break;
                    }
                    case 2: {
                        var2_2[var6_6] = this.parseFloatStr(var8_8[var9_10]);
                        break;
                    }
                    case 3: {
                        this.fillCsfArray("eig_vec", var8_8, var9_10, var3_3[var6_6], false);
                        break;
                    }
                    case 4: {
                        var7_7 = true;
                        if (var4_4 == null) {
                            var4_4 = new float[this.nOrbitals][this.nOrbitals];
                        }
                        this.fillCsfArray("eig_vec_compressed", var8_8, var9_10, var4_4[var6_6], false);
                        break;
                    }
                    case 5: {
                        if (var5_5 == null) {
                            var5_5 = new int[this.nOrbitals][this.nOrbitals];
                        }
                        this.fillCsfArray("coef_indices", var8_8, var9_10, var5_5[var6_6], true);
                    }
                }
                ++var9_10;
            }
            do {
                if (this.rd() != null && !this.line.startsWith("property_flags:")) continue block8;
lbl47:
                // 2 sources

            } while (this.line != null && this.parseLineParameters(CsfReader.moFields, CsfReader.moFieldMap) > 0);
        }
        var8_9 = 0;
        while (var8_9 < this.nOrbitals) {
            if (var7_7) {
                var9_12 = 0;
                while (var9_12 < ((void)var5_5[var8_9]).length) {
                    var10_15 = var5_5[var8_9][var9_12] - true;
                    if (var10_15 < 0) break;
                    var3_3[var8_9][var10_15] = var4_4[var8_9][var9_12];
                    ++var9_12;
                }
            }
            var9_13 = 0;
            while (var9_13 < this.nOrbitals) {
                if (Math.abs(var3_3[var8_9][var9_13]) < 1.0E-4f) {
                    var3_3[var8_9][var9_13] = 0.0f;
                }
                ++var9_13;
            }
            var9_14 = new Hashtable<String, Object>();
            var9_14.put("energy", Float.valueOf(var1_1[var8_9]));
            var9_14.put("occupancy", Float.valueOf(var2_2[var8_9]));
            var9_14.put("coefficients", var3_3[var8_9]);
            this.setMO(var9_14);
            ++var8_9;
        }
        this.setMOs("eV");
    }

    private void processBasisObject(String string) throws Exception {
        int n;
        String[] stringArray;
        int n2;
        String[] stringArray2 = PT.getTokens(this.strAtomicNumbers);
        this.atomicNumbers = new int[stringArray2.length];
        int n3 = 0;
        while (n3 < this.atomicNumbers.length) {
            this.atomicNumbers[n3] = this.parseIntStr(stringArray2[n3]);
            ++n3;
        }
        this.nOrbitals = this.nSlaters + this.nGaussians;
        n3 = string.equals("gto") ? 1 : 0;
        float[][] fArray = AU.newFloat2(this.nOrbitals);
        float[][] fArray2 = null;
        String[] stringArray3 = new String[this.nOrbitals];
        int[] nArray = new int[this.nOrbitals];
        int n4 = 0;
        this.rd();
        while (this.line != null && this.parseLineParameters(moFields, moFieldMap) > 0) {
            if (n4 == 0) {
                n4 = this.getPropertyCount(String.valueOf(string) + "_exp");
            }
            n2 = 0;
            while (this.rd() != null && !this.line.startsWith("property_flags:")) {
                stringArray = this.getTokens();
                n = 0;
                while (n < this.fieldCount) {
                    String string2 = stringArray[n];
                    switch (this.fieldTypes[n]) {
                        case -1: {
                            n2 = this.parseIntStr(string2) - 1;
                            break;
                        }
                        case 6: {
                            stringArray3[n2] = string2;
                            break;
                        }
                        case 7: 
                        case 9: {
                            fArray[n2] = new float[n4];
                            this.fillCsfArray(String.valueOf(string) + "_exp", stringArray, n, fArray[n2], false);
                            break;
                        }
                        case 10: {
                            nArray[n2] = this.parseIntStr(string2);
                            break;
                        }
                        case 8: {
                            if (fArray2 == null) {
                                fArray2 = new float[this.nOrbitals][n4];
                            }
                            this.fillCsfArray("contractions", stringArray, n, fArray2[n2], false);
                        }
                    }
                    ++n;
                }
            }
        }
        if (n3 != 0) {
            Lst<int[]> lst = new Lst<int[]>();
            stringArray = new Lst();
            n = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < this.nGaussians) {
                if (nArray[n6] != n) {
                    n = nArray[n6];
                    int[] nArray2 = new int[4];
                    int n7 = this.asc.getAtomIndex(this.connectors.get(String.valueOf(string) + "_basis_fxn" + (n6 + 1))[0]);
                    nArray2[0] = n7 + 1;
                    nArray2[1] = BasisFunctionReader.getQuantumShellTagID(stringArray3[n6].substring(0, 1));
                    int n8 = 0;
                    while (++n8 < n4 && fArray[n6][n8] != 0.0f) {
                    }
                    nArray2[2] = n5;
                    nArray2[3] = n8;
                    lst.addLast(nArray2);
                    n5 += n8;
                    int n9 = 0;
                    while (n9 < n8) {
                        stringArray.addLast(new float[]{fArray[n6][n9], fArray2[n6][n9]});
                        ++n9;
                    }
                }
                ++n6;
            }
            float[][] fArray3 = AU.newFloat2(n5);
            int n10 = 0;
            while (n10 < n5) {
                fArray3[n10] = (float[])stringArray.get(n10);
                ++n10;
            }
            this.moData.put("shells", lst);
            this.moData.put("gaussians", fArray3);
        } else {
            n2 = 0;
            while (n2 < this.nSlaters) {
                int n11 = this.asc.getAtomIndex(this.connectors.get(String.valueOf(string) + "_basis_fxn" + (n2 + 1))[0]);
                n = 0;
                while (n < n4) {
                    if (fArray[n2][n] == 0.0f) break;
                    this.createSphericalSlaterByType(n11, this.atomicNumbers[n11], stringArray3[n2], fArray[n2][n] * (float)(n == 0 ? 1 : -1), fArray2 == null ? 1.0f : fArray2[n2][n]);
                    ++n;
                }
                ++n2;
            }
            this.setSlaters(true, false);
        }
    }
}

