/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.P3;
import javajs.util.P3i;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Pixelator;
import org.jmol.g3d.PrecisionRenderer;
import org.jmol.util.Shader;

final class LineRenderer
extends PrecisionRenderer {
    private final Graphics3D g3d;
    private final Shader shader;
    private BS lineBits;
    private float slope;
    private boolean lineTypeX;
    private int nBits;
    private Map<Float, BS> lineCache = new Hashtable<Float, BS>();
    private Float slopeKey;
    private static final int VISIBILITY_UNCLIPPED = 0;
    private static final int VISIBILITY_CLIPPED = 1;
    private static final int VISIBILITY_OFFSCREEN = 2;
    private int x1t;
    private int y1t;
    private int z1t;
    private int x2t;
    private int y2t;
    private int z2t;

    LineRenderer(Graphics3D graphics3D) {
        this.g3d = graphics3D;
        this.shader = graphics3D.shader;
    }

    void setLineBits(float f, float f2) {
        this.slope = f != 0.0f ? f2 / f : (f2 >= 0.0f ? Float.MAX_VALUE : -3.4028235E38f);
        this.lineTypeX = this.slope <= 1.0f && this.slope >= -1.0f;
        this.nBits = this.lineTypeX ? this.g3d.width : this.g3d.height;
        this.slopeKey = Float.valueOf(this.slope);
        if (this.lineCache.containsKey(this.slopeKey)) {
            this.lineBits = this.lineCache.get(this.slopeKey);
            return;
        }
        this.lineBits = BS.newN(this.nBits);
        if ((f2 = Math.abs(f2)) > (f = Math.abs(f))) {
            float f3 = f;
            f = f2;
            f2 = f3;
        }
        int n = 0;
        float f4 = f + f;
        float f5 = f2 + f2;
        int n2 = 0;
        while (n2 < this.nBits) {
            if ((float)(n = (int)((float)n + f5)) > f) {
                this.lineBits.set(n2);
                n = (int)((float)n - f4);
            }
            ++n2;
        }
        this.lineCache.put(this.slopeKey, this.lineBits);
    }

    void clearLineCache() {
        this.lineCache.clear();
    }

    void plotLineOld(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.x1t = n3;
        this.x2t = n6;
        this.y1t = n4;
        this.y2t = n7;
        this.z1t = n5;
        this.z2t = n8;
        boolean bl = true;
        switch (this.getTrimmedLineImpl()) {
            case 0: {
                bl = false;
                break;
            }
            case 2: {
                return;
            }
        }
        this.plotLineClippedOld(n, n2, n3, n4, n5, n6 - n3, n7 - n4, n8 - n5, bl, 0, 0);
    }

    void plotLineDeltaOld(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        this.x1t = n3;
        this.x2t = n3 + n6;
        this.y1t = n4;
        this.y2t = n4 + n7;
        this.z1t = n5;
        this.z2t = n5 + n8;
        if (bl) {
            switch (this.getTrimmedLineImpl()) {
                case 2: {
                    return;
                }
                case 0: {
                    bl = false;
                }
            }
        }
        this.plotLineClippedOld(n, n2, n3, n4, n5, n6, n7, n8, bl, 0, 0);
    }

    void plotLineDeltaAOld(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        this.x1t = n3;
        this.x2t = n3 + n6;
        this.y1t = n4;
        this.y2t = n4 + n7;
        this.z1t = n5;
        this.z2t = n5 + n8;
        if (bl) {
            switch (this.getTrimmedLineImpl()) {
                case 2: {
                    return;
                }
                case 0: {
                    bl = false;
                }
            }
        }
        int[] nArray3 = this.g3d.zbuf;
        int n9 = this.g3d.width;
        int n10 = 0;
        int n11 = Integer.MAX_VALUE;
        int n12 = 1;
        int n13 = n4 * n9 + n3;
        int n14 = this.g3d.bufferSize;
        int n15 = n2 < 63 ? n2 + 1 : n2;
        int n16 = n2 > 0 ? n2 - 1 : n2;
        int n17 = nArray[n2];
        int n18 = nArray[n15];
        int n19 = nArray[n16];
        int n20 = nArray2[n2];
        int n21 = nArray2[n15];
        int n22 = nArray2[n16];
        int n23 = n17;
        Pixelator pixelator = this.g3d.pixel;
        if (n != 0) {
            pixelator = this.g3d.setScreened((n & 1) == 1);
            this.g3d.currentShadeIndex = 0;
        }
        if (n23 != 0 && !bl && n13 >= 0 && n13 < n14 && n5 < nArray3[n13]) {
            pixelator.addPixel(n13, n5, n23);
        }
        if (n6 == 0 && n7 == 0) {
            return;
        }
        int n24 = 1;
        int n25 = n9;
        int n26 = n3 + n6;
        int n27 = n4 + n7;
        if (n6 < 0) {
            n6 = -n6;
            n24 = -1;
        }
        if (n7 < 0) {
            n7 = -n7;
            n25 = -n9;
        }
        int n28 = n6 + n6;
        int n29 = n7 + n7;
        int n30 = n5 << 10;
        int n31 = n18;
        int n32 = n19;
        if (n7 <= n6) {
            int n33 = n6 - 1;
            if (n8 < 0) {
                n33 = -n33;
            }
            int n34 = ((n8 << 10) + n33) / n6;
            int n35 = 0;
            int n36 = Math.abs(n26 - this.x2t) - 1;
            int n37 = Math.abs(n26 - this.x1t) - 1;
            int n38 = n6 - 1;
            int n39 = n38 / 2;
            while (--n38 >= n36) {
                int n40;
                if (n38 == n39) {
                    n23 = n20;
                    if (n23 == 0) {
                        return;
                    }
                    n31 = n21;
                    n32 = n22;
                    if (n % 3 != 0) {
                        pixelator = this.g3d.setScreened((n & 2) == 2);
                        this.g3d.currentShadeIndex = 0;
                    }
                }
                n13 += n24;
                n30 += n34;
                if ((n35 += n29) > n6) {
                    n13 += n25;
                    n35 -= n28;
                }
                if (n23 != 0 && n38 < n37 && n13 >= 0 && n13 < n14 && n10 < n11 && (n40 = n30 >> 10) < nArray3[n13]) {
                    int n41 = this.shader.nextRandom8Bit();
                    pixelator.addPixel(n13, n40, n41 < 85 ? n32 : (n41 > 170 ? n31 : n23));
                }
                n10 = (n10 + 1) % n12;
            }
        } else {
            int n42 = n7 - 1;
            if (n8 < 0) {
                n42 = -n42;
            }
            int n43 = ((n8 << 10) + n42) / n7;
            int n44 = 0;
            int n45 = Math.abs(n27 - this.y2t) - 1;
            int n46 = Math.abs(n27 - this.y1t) - 1;
            int n47 = n7 - 1;
            int n48 = n47 / 2;
            while (--n47 >= n45) {
                int n49;
                if (n47 == n48) {
                    n23 = n20;
                    if (n23 == 0) {
                        return;
                    }
                    n31 = n21;
                    n32 = n22;
                    if (n % 3 != 0) {
                        pixelator = this.g3d.setScreened((n & 2) == 2);
                        this.g3d.currentShadeIndex = 0;
                    }
                }
                n13 += n25;
                n30 += n43;
                if ((n44 += n28) > n7) {
                    n13 += n24;
                    n44 -= n29;
                }
                if (n23 != 0 && n47 < n46 && n13 >= 0 && n13 < n14 && n10 < n11 && (n49 = n30 >> 10) < nArray3[n13]) {
                    int n50 = this.g3d.shader.nextRandom8Bit();
                    pixelator.addPixel(n13, n49, n50 < 85 ? n32 : (n50 > 170 ? n31 : n23));
                }
                n10 = (n10 + 1) % n12;
            }
        }
    }

    void plotLineDeltaABitsFloat(int[] nArray, int[] nArray2, int n, P3 p3, P3 p32, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = Math.round(p3.x);
        int n11 = Math.round(p3.y);
        int n12 = Math.round(p3.z);
        int n13 = Math.round(p32.x);
        int n14 = Math.round(p32.y);
        int n15 = Math.round(p32.z);
        int n16 = n13 - n10;
        int n17 = n14 - n11;
        this.x1t = n10;
        this.x2t = n13;
        this.y1t = n11;
        this.y2t = n14;
        this.z1t = n12;
        this.z2t = n15;
        if (bl && this.getTrimmedLineImpl() == 2) {
            return;
        }
        int[] nArray3 = this.g3d.zbuf;
        int n18 = this.g3d.width;
        int n19 = 0;
        int n20 = Integer.MAX_VALUE;
        int n21 = 1;
        int n22 = n < 63 ? n + 1 : n;
        int n23 = n > 0 ? n - 1 : n;
        int n24 = nArray[n];
        int n25 = nArray[n22];
        int n26 = nArray[n23];
        int n27 = nArray2[n];
        int n28 = nArray2[n22];
        int n29 = nArray2[n23];
        int n30 = n11 * n18 + n10;
        int n31 = this.g3d.bufferSize;
        if (this.lineTypeX) {
            n9 = n10;
            n8 = this.x1t;
            n7 = this.x2t;
            n6 = n10 + n16 / 2;
            n4 = n5 = n16 >= 0 ? 1 : -1;
            n3 = n17 >= 0 ? n18 : -n18;
            this.setRastABFloat(p3.x, p3.z, p32.x, p32.z);
        } else {
            n9 = n11;
            n8 = this.y1t;
            n7 = this.y2t;
            n6 = n11 + n17 / 2;
            n5 = n17 >= 0 ? 1 : -1;
            n4 = n17 >= 0 ? n18 : -n18;
            n3 = n16 >= 0 ? 1 : -1;
            this.setRastABFloat(p3.y, p3.z, p32.y, p32.z);
        }
        float f = n12;
        int n32 = n24;
        int n33 = n25;
        int n34 = n26;
        boolean bl2 = false;
        Pixelator pixelator = this.g3d.pixel;
        if (n2 != 0) {
            pixelator = this.g3d.setScreened((n2 & 1) == 1);
            this.g3d.currentShadeIndex = 0;
        }
        int n35 = n9;
        int n36 = n9;
        while (true) {
            if (n35 == n8) {
                bl2 = true;
            }
            if (n35 == n6) {
                n32 = n27;
                if (n32 == 0) {
                    return;
                }
                n33 = n28;
                n34 = n29;
                if (n2 % 3 != 0) {
                    pixelator = this.g3d.setScreened((n2 & 2) == 2);
                    this.g3d.currentShadeIndex = 0;
                }
            }
            if (n32 != 0 && bl2 && n30 >= 0 && n30 < n31 && n19 < n20 && (f = (float)this.getZCurrent(this.a, this.b, n35)) < (float)nArray3[n30]) {
                int n37 = this.shader.nextRandom8Bit();
                pixelator.addPixel(n30, (int)f, n37 < 85 ? n34 : (n37 > 170 ? n33 : n32));
            }
            if (n35 == n7) break;
            n19 = (n19 + 1) % n21;
            n30 += n4;
            while (n36 < 0) {
                n36 += this.nBits;
            }
            if (this.lineBits.get(n36 % this.nBits)) {
                n30 += n3;
            }
            n35 += n5;
            n36 += n5;
        }
    }

    void plotLineDeltaABitsInt(int[] nArray, int[] nArray2, int n, P3i p3i, P3i p3i2, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = p3i.x;
        int n11 = p3i.y;
        int n12 = p3i.z;
        int n13 = p3i2.x;
        int n14 = p3i2.y;
        int n15 = p3i2.z;
        int n16 = n13 - n10;
        int n17 = n14 - n11;
        this.x1t = n10;
        this.x2t = n13;
        this.y1t = n11;
        this.y2t = n14;
        this.z1t = n12;
        this.z2t = n15;
        if (bl && this.getTrimmedLineImpl() == 2) {
            return;
        }
        int[] nArray3 = this.g3d.zbuf;
        int n18 = this.g3d.width;
        int n19 = 0;
        int n20 = Integer.MAX_VALUE;
        int n21 = 1;
        int n22 = n < 63 ? n + 1 : n;
        int n23 = n > 0 ? n - 1 : n;
        int n24 = nArray[n];
        int n25 = nArray[n22];
        int n26 = nArray[n23];
        int n27 = nArray2[n];
        int n28 = nArray2[n22];
        int n29 = nArray2[n23];
        int n30 = n11 * n18 + n10;
        int n31 = this.g3d.bufferSize;
        if (this.lineTypeX) {
            n9 = n10;
            n8 = this.x1t;
            n7 = this.x2t;
            n6 = n10 + n16 / 2;
            n4 = n5 = n16 >= 0 ? 1 : -1;
            n3 = n17 >= 0 ? n18 : -n18;
            this.setRastAB(p3i.x, p3i.z, p3i2.x, p3i2.z);
        } else {
            n9 = n11;
            n8 = this.y1t;
            n7 = this.y2t;
            n6 = n11 + n17 / 2;
            n5 = n17 >= 0 ? 1 : -1;
            n4 = n17 >= 0 ? n18 : -n18;
            n3 = n16 >= 0 ? 1 : -1;
            this.setRastAB(p3i.y, p3i.z, p3i2.y, p3i2.z);
        }
        float f = n12;
        int n32 = n24;
        int n33 = n25;
        int n34 = n26;
        boolean bl2 = false;
        Pixelator pixelator = this.g3d.pixel;
        if (n2 != 0) {
            pixelator = this.g3d.setScreened((n2 & 1) == 1);
            this.g3d.currentShadeIndex = 0;
        }
        int n35 = n9;
        int n36 = n9;
        while (true) {
            if (n35 == n8) {
                bl2 = true;
            }
            if (n35 == n6) {
                n32 = n27;
                if (n32 == 0) {
                    return;
                }
                n33 = n28;
                n34 = n29;
                if (n2 % 3 != 0) {
                    pixelator = this.g3d.setScreened((n2 & 2) == 2);
                    this.g3d.currentShadeIndex = 0;
                }
            }
            if (n32 != 0 && bl2 && n30 >= 0 && n30 < n31 && n19 < n20 && (f = (float)this.getZCurrent(this.a, this.b, n35)) < (float)nArray3[n30]) {
                int n37 = this.shader.nextRandom8Bit();
                pixelator.addPixel(n30, (int)f, n37 < 85 ? n34 : (n37 > 170 ? n33 : n32));
            }
            if (n35 == n7) break;
            n19 = (n19 + 1) % n21;
            n30 += n4;
            while (n36 < 0) {
                n36 += this.nBits;
            }
            if (this.lineBits.get(n36 % this.nBits)) {
                n30 += n3;
            }
            n35 += n5;
            n36 += n5;
        }
    }

    void plotLineBits(int n, int n2, P3i p3i, P3i p3i2, int n3, int n4, boolean bl) {
        if (p3i.z <= 1 || p3i2.z <= 1) {
            return;
        }
        boolean bl2 = true;
        this.x1t = p3i.x;
        this.y1t = p3i.y;
        this.z1t = p3i.z;
        this.x2t = p3i2.x;
        this.y2t = p3i2.y;
        this.z2t = p3i2.z;
        switch (this.getTrimmedLineImpl()) {
            case 2: {
                return;
            }
            case 0: {
                bl2 = false;
                break;
            }
            default: {
                if (!bl) break;
                p3i.set(this.x1t, this.y1t, this.z1t);
                p3i2.set(this.x2t, this.y2t, this.z2t);
            }
        }
        int[] nArray = this.g3d.zbuf;
        int n5 = this.g3d.width;
        int n6 = 0;
        if (n3 == 0) {
            n4 = Integer.MAX_VALUE;
            n3 = 1;
        }
        int n7 = p3i.x;
        int n8 = p3i.y;
        int n9 = p3i.z;
        int n10 = p3i2.x - n7;
        int n11 = n7 + n10;
        int n12 = p3i2.y - n8;
        int n13 = n8 + n12;
        int n14 = n8 * n5 + n7;
        int n15 = this.g3d.bufferSize;
        int n16 = n;
        Pixelator pixelator = this.g3d.pixel;
        if (n16 != 0 && !bl2 && n14 >= 0 && n14 < n15 && n9 < nArray[n14]) {
            pixelator.addPixel(n14, n9, n16);
        }
        if (n10 == 0 && n12 == 0) {
            return;
        }
        int n17 = 1;
        int n18 = 1;
        int n19 = n5;
        if (n10 < 0) {
            n10 = -n10;
            n17 = -1;
        }
        if (n12 < 0) {
            n12 = -n12;
            n19 = -n5;
            n18 = -1;
        }
        int n20 = n10 + n10;
        int n21 = n12 + n12;
        if (n12 <= n10) {
            this.setRastAB(p3i.x, p3i.z, p3i2.x, p3i2.z);
            int n22 = 0;
            int n23 = Math.abs(n11 - this.x2t) - 1;
            int n24 = Math.abs(n11 - this.x1t) - 1;
            int n25 = n10 - 1;
            int n26 = n25 / 2;
            while (--n25 >= n23) {
                int n27;
                if (n25 == n26 && (n16 = n2) == 0) {
                    return;
                }
                n14 += n17;
                n7 += n17;
                if ((n22 += n21) > n10) {
                    n14 += n19;
                    n22 -= n20;
                }
                if (n16 != 0 && n25 < n24 && n14 >= 0 && n14 < n15 && n6 < n4 && (n27 = this.getZCurrent(this.a, this.b, n7)) < nArray[n14]) {
                    pixelator.addPixel(n14, n27, n16);
                }
                n6 = (n6 + 1) % n3;
            }
        } else {
            this.setRastAB(p3i.y, p3i.z, p3i2.y, p3i2.z);
            int n28 = 0;
            int n29 = Math.abs(n13 - this.y2t) - 1;
            int n30 = Math.abs(n13 - this.y1t) - 1;
            int n31 = n12 - 1;
            int n32 = n31 / 2;
            while (--n31 >= n29) {
                int n33;
                if (n31 == n32 && (n16 = n2) == 0) {
                    return;
                }
                n14 += n19;
                n8 += n18;
                if ((n28 += n20) > n12) {
                    n14 += n17;
                    n28 -= n21;
                }
                if (n16 != 0 && n31 < n30 && n14 >= 0 && n14 < n15 && n6 < n4 && (n33 = this.getZCurrent(this.a, this.b, n8)) < nArray[n14]) {
                    pixelator.addPixel(n14, n33, n16);
                }
                n6 = (n6 + 1) % n3;
            }
        }
    }

    private int getTrimmedLineImpl() {
        int n = this.g3d.clipCode3(this.x1t, this.y1t, this.z1t);
        int n2 = this.g3d.clipCode3(this.x2t, this.y2t, this.z2t);
        int n3 = n | n2;
        if ((n | n2) == 0) {
            return 0;
        }
        if (n3 == -1) {
            return 2;
        }
        int n4 = this.g3d.xLast;
        int n5 = this.g3d.yLast;
        int n6 = this.g3d.slab;
        int n7 = this.g3d.depth;
        do {
            if ((n & n2) != 0) {
                return 2;
            }
            float f = this.x2t - this.x1t;
            float f2 = this.y2t - this.y1t;
            float f3 = this.z2t - this.z1t;
            if (n != 0) {
                if ((n & 8) != 0) {
                    this.y1t += (int)((float)(-this.x1t) * f2 / f);
                    this.z1t += (int)((float)(-this.x1t) * f3 / f);
                    this.x1t = 0;
                } else if ((n & 4) != 0) {
                    this.y1t += (int)((float)(n4 - this.x1t) * f2 / f);
                    this.z1t += (int)((float)(n4 - this.x1t) * f3 / f);
                    this.x1t = n4;
                } else if ((n & 2) != 0) {
                    this.x1t += (int)((float)(-this.y1t) * f / f2);
                    this.z1t += (int)((float)(-this.y1t) * f3 / f2);
                    this.y1t = 0;
                } else if ((n & 1) != 0) {
                    this.x1t += (int)((float)(n5 - this.y1t) * f / f2);
                    this.z1t += (int)((float)(n5 - this.y1t) * f3 / f2);
                    this.y1t = n5;
                } else if ((n & 0x20) != 0) {
                    this.x1t += (int)((float)(n6 - this.z1t) * f / f3);
                    this.y1t += (int)((float)(n6 - this.z1t) * f2 / f3);
                    this.z1t = n6;
                } else {
                    this.x1t += (int)((float)(n7 - this.z1t) * f / f3);
                    this.y1t += (int)((float)(n7 - this.z1t) * f2 / f3);
                    this.z1t = n7;
                }
                n = this.g3d.clipCode3(this.x1t, this.y1t, this.z1t);
                continue;
            }
            if ((n2 & 8) != 0) {
                this.y2t += (int)((float)(-this.x2t) * f2 / f);
                this.z2t += (int)((float)(-this.x2t) * f3 / f);
                this.x2t = 0;
            } else if ((n2 & 4) != 0) {
                this.y2t += (int)((float)(n4 - this.x2t) * f2 / f);
                this.z2t += (int)((float)(n4 - this.x2t) * f3 / f);
                this.x2t = n4;
            } else if ((n2 & 2) != 0) {
                this.x2t += (int)((float)(-this.y2t) * f / f2);
                this.z2t += (int)((float)(-this.y2t) * f3 / f2);
                this.y2t = 0;
            } else if ((n2 & 1) != 0) {
                this.x2t += (int)((float)(n5 - this.y2t) * f / f2);
                this.z2t += (int)((float)(n5 - this.y2t) * f3 / f2);
                this.y2t = n5;
            } else if ((n2 & 0x20) != 0) {
                this.x2t += (int)((float)(n6 - this.z2t) * f / f3);
                this.y2t += (int)((float)(n6 - this.z2t) * f2 / f3);
                this.z2t = n6;
            } else {
                this.x2t += (int)((float)(n7 - this.z2t) * f / f3);
                this.y2t += (int)((float)(n7 - this.z2t) * f2 / f3);
                this.z2t = n7;
            }
            n2 = this.g3d.clipCode3(this.x2t, this.y2t, this.z2t);
        } while ((n | n2) != 0);
        return 1;
    }

    private void plotLineClippedOld(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, int n9, int n10) {
        int[] nArray = this.g3d.zbuf;
        int n11 = this.g3d.width;
        int n12 = 0;
        if (n9 == 0) {
            n10 = Integer.MAX_VALUE;
            n9 = 1;
        }
        int n13 = n4 * n11 + n3;
        int n14 = this.g3d.bufferSize;
        int n15 = n;
        Pixelator pixelator = this.g3d.pixel;
        if (n15 != 0 && !bl && n13 >= 0 && n13 < n14 && n5 < nArray[n13]) {
            pixelator.addPixel(n13, n5, n15);
        }
        if (n6 == 0 && n7 == 0) {
            return;
        }
        int n16 = 1;
        int n17 = n11;
        int n18 = n3 + n6;
        int n19 = n4 + n7;
        if (n6 < 0) {
            n6 = -n6;
            n16 = -1;
        }
        if (n7 < 0) {
            n7 = -n7;
            n17 = -n11;
        }
        int n20 = n6 + n6;
        int n21 = n7 + n7;
        int n22 = n5 << 10;
        if (n7 <= n6) {
            int n23 = n6 - 1;
            if (n8 < 0) {
                n23 = -n23;
            }
            int n24 = ((n8 << 10) + n23) / n6;
            int n25 = 0;
            int n26 = Math.abs(n18 - this.x2t) - 1;
            int n27 = Math.abs(n18 - this.x1t) - 1;
            int n28 = n6 - 1;
            int n29 = n28 / 2;
            while (--n28 >= n26) {
                int n30;
                if (n28 == n29 && (n15 = n2) == 0) {
                    return;
                }
                n13 += n16;
                n22 += n24;
                if ((n25 += n21) > n6) {
                    n13 += n17;
                    n25 -= n20;
                }
                if (n15 != 0 && n28 < n27 && n13 >= 0 && n13 < n14 && n12 < n10 && (n30 = n22 >> 10) < nArray[n13]) {
                    pixelator.addPixel(n13, n30, n15);
                }
                n12 = (n12 + 1) % n9;
            }
        } else {
            int n31 = n7 - 1;
            if (n8 < 0) {
                n31 = -n31;
            }
            int n32 = ((n8 << 10) + n31) / n7;
            int n33 = 0;
            int n34 = Math.abs(n19 - this.y2t) - 1;
            int n35 = Math.abs(n19 - this.y1t) - 1;
            int n36 = n7 - 1;
            int n37 = n36 / 2;
            while (--n36 >= n34) {
                int n38;
                if (n36 == n37 && (n15 = n2) == 0) {
                    return;
                }
                n13 += n17;
                n22 += n32;
                if ((n33 += n20) > n7) {
                    n13 += n16;
                    n33 -= n21;
                }
                if (n15 != 0 && n36 < n35 && n13 >= 0 && n13 < n14 && n12 < n10 && (n38 = n22 >> 10) < nArray[n13]) {
                    pixelator.addPixel(n13, n38, n15);
                }
                n12 = (n12 + 1) % n9;
            }
        }
    }
}

