/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.calls;

import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.ir.backend.js.JsIntrinsics;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.CallsTransformer;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.lazy.IrLazySymbolTable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/DynamicCallsTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/CallsTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "originToIrFunction", "", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "transformCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "backend.js"})
public final class DynamicCallsTransformer
implements CallsTransformer {
    private final Map<IrStatementOriginImpl, IrSimpleFunction> originToIrFunction;
    private final JsIrBackendContext context;

    @Override
    @NotNull
    public IrExpression transformCall(@NotNull IrCall call2) {
        Object object;
        Intrinsics.checkParameterIsNotNull(call2, "call");
        IrFunctionSymbol symbol2 = call2.getSymbol();
        IrFunction function2 = call2.getSymbol().getOwner();
        if (IrUtilsKt.isDynamic(function2)) {
            object = call2.getOrigin();
            if (Intrinsics.areEqual(object, IrStatementOrigin.GET_PROPERTY.INSTANCE)) {
                IrLazySymbolTable irLazySymbolTable = this.context.getSymbolTable().getLazyWrapper();
                FunctionDescriptor functionDescriptor = symbol2.getDescriptor();
                if (functionDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor");
                }
                PropertyDescriptor propertyDescriptor2 = ((PropertyAccessorDescriptor)functionDescriptor).getCorrespondingProperty();
                Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor2, "(symbol.descriptor as Pr\u2026or).correspondingProperty");
                IrFieldSymbol fieldSymbol = irLazySymbolTable.referenceField(propertyDescriptor2);
                return JsIrBuilder.buildGetField$default(JsIrBuilder.INSTANCE, fieldSymbol, call2.getDispatchReceiver(), null, call2.getType(), 4, null);
            }
            if (Intrinsics.areEqual(object, IrStatementOrigin.EQ.INSTANCE) && symbol2.getDescriptor() instanceof PropertyAccessorDescriptor) {
                IrLazySymbolTable irLazySymbolTable = this.context.getSymbolTable().getLazyWrapper();
                FunctionDescriptor functionDescriptor = symbol2.getDescriptor();
                if (functionDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor");
                }
                PropertyDescriptor propertyDescriptor3 = ((PropertyAccessorDescriptor)functionDescriptor).getCorrespondingProperty();
                Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor3, "(symbol.descriptor as Pr\u2026or).correspondingProperty");
                IrFieldSymbol fieldSymbol = irLazySymbolTable.referenceField(propertyDescriptor3);
                IrCall irCall = call2;
                boolean bl = false;
                boolean bl2 = false;
                IrCall $this$run = irCall;
                boolean bl3 = false;
                IrExpression irExpression = $this$run.getDispatchReceiver();
                IrExpression irExpression2 = $this$run.getValueArgument(0);
                if (irExpression2 == null) {
                    Intrinsics.throwNpe();
                }
                return JsIrBuilder.buildSetField$default(JsIrBuilder.INSTANCE, fieldSymbol, irExpression, irExpression2, $this$run.getType(), null, 16, null);
            }
        }
        if (IrUtilsKt.isDynamic(function2)) {
            object = this.originToIrFunction;
            IrStatementOrigin irStatementOrigin = call2.getOrigin();
            boolean bl = false;
            IrSimpleFunction irSimpleFunction = (IrSimpleFunction)object.get(irStatementOrigin);
            if (irSimpleFunction != null) {
                object = irSimpleFunction;
                boolean bl4 = false;
                bl = false;
                Object it = object;
                boolean bl5 = false;
                return IrUtilsKt.irCall$default((IrMemberAccessExpression)call2, it.getSymbol(), true, false, 8, null);
            }
        }
        return call2;
    }

    public DynamicCallsTransformer(@NotNull JsIrBackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
        JsIntrinsics jsIntrinsics = this.context.getIntrinsics();
        DynamicCallsTransformer dynamicCallsTransformer = this;
        boolean bl = false;
        boolean bl2 = false;
        JsIntrinsics $this$run = jsIntrinsics;
        boolean bl3 = false;
        Map map2 = MapsKt.mapOf(TuplesKt.to(IrStatementOrigin.EXCL.INSTANCE, $this$run.getJsNot()), TuplesKt.to(IrStatementOrigin.LT.INSTANCE, $this$run.getJsLt()), TuplesKt.to(IrStatementOrigin.GT.INSTANCE, $this$run.getJsGt()), TuplesKt.to(IrStatementOrigin.LTEQ.INSTANCE, $this$run.getJsLtEq()), TuplesKt.to(IrStatementOrigin.GTEQ.INSTANCE, $this$run.getJsGtEq()), TuplesKt.to(IrStatementOrigin.EQEQ.INSTANCE, $this$run.getJsEqeq()), TuplesKt.to(IrStatementOrigin.EQEQEQ.INSTANCE, $this$run.getJsEqeqeq()), TuplesKt.to(IrStatementOrigin.EXCLEQ.INSTANCE, $this$run.getJsNotEq()), TuplesKt.to(IrStatementOrigin.EXCLEQEQ.INSTANCE, $this$run.getJsNotEqeq()), TuplesKt.to(IrStatementOrigin.ANDAND.INSTANCE, $this$run.getJsAnd()), TuplesKt.to(IrStatementOrigin.OROR.INSTANCE, $this$run.getJsOr()), TuplesKt.to(IrStatementOrigin.UMINUS.INSTANCE, $this$run.getJsUnaryMinus()), TuplesKt.to(IrStatementOrigin.UPLUS.INSTANCE, $this$run.getJsUnaryPlus()), TuplesKt.to(IrStatementOrigin.PLUS.INSTANCE, $this$run.getJsPlus()), TuplesKt.to(IrStatementOrigin.MINUS.INSTANCE, $this$run.getJsMinus()), TuplesKt.to(IrStatementOrigin.MUL.INSTANCE, $this$run.getJsMult()), TuplesKt.to(IrStatementOrigin.DIV.INSTANCE, $this$run.getJsDiv()), TuplesKt.to(IrStatementOrigin.PERC.INSTANCE, $this$run.getJsMod()), TuplesKt.to(IrStatementOrigin.PLUSEQ.INSTANCE, $this$run.getJsPlusAssign()), TuplesKt.to(IrStatementOrigin.MINUSEQ.INSTANCE, $this$run.getJsMinusAssign()), TuplesKt.to(IrStatementOrigin.MULTEQ.INSTANCE, $this$run.getJsMultAssign()), TuplesKt.to(IrStatementOrigin.DIVEQ.INSTANCE, $this$run.getJsDivAssign()), TuplesKt.to(IrStatementOrigin.PERCEQ.INSTANCE, $this$run.getJsModAssign()), TuplesKt.to(IrStatementOrigin.PREFIX_INCR.INSTANCE, $this$run.getJsPrefixInc()), TuplesKt.to(IrStatementOrigin.PREFIX_DECR.INSTANCE, $this$run.getJsPrefixDec()), TuplesKt.to(IrStatementOrigin.POSTFIX_INCR.INSTANCE, $this$run.getJsPostfixInc()), TuplesKt.to(IrStatementOrigin.POSTFIX_DECR.INSTANCE, $this$run.getJsPostfixDec()), TuplesKt.to(IrStatementOrigin.GET_ARRAY_ELEMENT.INSTANCE, $this$run.getJsArrayGet()), TuplesKt.to(IrStatementOrigin.EQ.INSTANCE, $this$run.getJsArraySet()));
        dynamicCallsTransformer.originToIrFunction = map2;
    }
}

