/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.facade;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.SourceLocationConsumer;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithSource;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.sourceMap.SourceMapMappingConsumer;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;

public class SourceMapBuilderConsumer
implements SourceLocationConsumer {
    @NotNull
    private final File sourceBaseDir;
    @NotNull
    private final SourceMapMappingConsumer mappingConsumer;
    @NotNull
    private final SourceFilePathResolver pathResolver;
    private final boolean provideCurrentModuleContent;
    private final boolean provideExternalModuleContent;
    @NotNull
    private final List<Object> sourceStack;

    public SourceMapBuilderConsumer(@NotNull File sourceBaseDir, @NotNull SourceMapMappingConsumer mappingConsumer, @NotNull SourceFilePathResolver pathResolver, boolean provideCurrentModuleContent, boolean provideExternalModuleContent) {
        if (sourceBaseDir == null) {
            SourceMapBuilderConsumer.$$$reportNull$$$1(0);
        }
        if (mappingConsumer == null) {
            SourceMapBuilderConsumer.$$$reportNull$$$1(1);
        }
        if (pathResolver == null) {
            SourceMapBuilderConsumer.$$$reportNull$$$1(2);
        }
        if (sourceBaseDir == null) {
            SourceMapBuilderConsumer.$$$reportNull$$$0(0);
        }
        if (mappingConsumer == null) {
            SourceMapBuilderConsumer.$$$reportNull$$$0(1);
        }
        if (pathResolver == null) {
            SourceMapBuilderConsumer.$$$reportNull$$$0(2);
        }
        this.sourceStack = new ArrayList<Object>();
        this.sourceBaseDir = sourceBaseDir;
        this.mappingConsumer = mappingConsumer;
        this.pathResolver = pathResolver;
        this.provideCurrentModuleContent = provideCurrentModuleContent;
        this.provideExternalModuleContent = provideExternalModuleContent;
    }

    @Override
    public void newLine() {
        this.mappingConsumer.newLine();
    }

    @Override
    public void pushSourceInfo(@Nullable Object info) {
        this.sourceStack.add(info);
        this.addMapping(info);
    }

    @Override
    public void popSourceInfo() {
        this.sourceStack.remove(this.sourceStack.size() - 1);
        Object sourceInfo = !this.sourceStack.isEmpty() ? this.sourceStack.get(this.sourceStack.size() - 1) : null;
        this.addMapping(sourceInfo);
    }

    private void addMapping(@Nullable Object sourceInfo) {
        if (sourceInfo == null) {
            this.mappingConsumer.addEmptyMapping();
        }
        if (sourceInfo instanceof PsiElement) {
            PsiElement element = (PsiElement)sourceInfo;
            try {
                JsLocation location2 = PsiUtils.extractLocationFromPsi(element, this.pathResolver);
                PsiFile psiFile = element.getContainingFile();
                File file2 = new File(psiFile.getViewProvider().getVirtualFile().getPath());
                Supplier<Reader> contentSupplier = this.provideCurrentModuleContent ? () -> {
                    try {
                        return new InputStreamReader((InputStream)new FileInputStream(file2), Charset.forName("UTF-8"));
                    }
                    catch (IOException e) {
                        return null;
                    }
                } : () -> null;
                this.mappingConsumer.addMapping(location2.getFile(), null, contentSupplier, location2.getStartLine(), location2.getStartChar());
            }
            catch (IOException e) {
                throw new RuntimeException("IO error occurred generating source maps", e);
            }
        } else if (sourceInfo instanceof JsLocationWithSource) {
            String path2;
            File absFile;
            JsLocationWithSource location3 = (JsLocationWithSource)sourceInfo;
            Supplier<Reader> contentSupplier = this.provideExternalModuleContent ? location3.getSourceProvider()::invoke : () -> null;
            File file3 = absFile = new File(location3.getFile()).isAbsolute() ? new File(location3.getFile()) : new File(this.sourceBaseDir, location3.getFile());
            if (absFile.isAbsolute()) {
                try {
                    path2 = this.pathResolver.getPathRelativeToSourceRoots(absFile);
                }
                catch (IOException e) {
                    path2 = location3.getFile();
                }
            } else {
                path2 = location3.getFile();
            }
            this.mappingConsumer.addMapping(path2, location3.getIdentityObject(), contentSupplier, location3.getStartLine(), location3.getStartChar());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sourceBaseDir";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "mappingConsumer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "pathResolver";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/js/facade/SourceMapBuilderConsumer";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sourceBaseDir";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "mappingConsumer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "pathResolver";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/js/facade/SourceMapBuilderConsumer";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

