/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;

public class WeakEventHandler<T extends Event>
implements EventHandler<T> {
    private final WeakReference<EventHandler<T>> ref;
    private final EventTarget target;
    private final EventType type;

    public WeakEventHandler(EventTarget eventTarget, EventType eventType, EventHandler<T> eventHandler) {
        if (eventHandler == null) {
            throw new NullPointerException("Listener must be specified.");
        }
        this.target = eventTarget;
        this.type = eventType;
        this.ref = new WeakReference<EventHandler<EventHandler<T>>>(eventHandler);
    }

    @Override
    public void handle(T t) {
        EventHandler eventHandler = (EventHandler)this.ref.get();
        if (eventHandler != null) {
            eventHandler.handle(t);
        } else {
            try {
                Method method = this.target.getClass().getMethod("removeEventHandler", EventType.class, EventHandler.class);
                method.invoke((Object)this.target, this.type, this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

