/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.platform.graphics;

import com.sun.webpane.platform.Invoker;
import com.sun.webpane.platform.graphics.BufferData;
import com.sun.webpane.platform.graphics.GraphicsDecoder;
import com.sun.webpane.platform.graphics.Ref;
import com.sun.webpane.platform.graphics.WCGraphicsContext;
import com.sun.webpane.platform.graphics.WCGraphicsManager;
import com.sun.webpane.platform.graphics.WCRectangle;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCRenderQueue
extends Ref {
    private static final AtomicInteger idCountObj = new AtomicInteger(0);
    private static final Logger log = Logger.getLogger(WCRenderQueue.class.getName());
    public static final int MAX_QUEUE_SIZE = 524288;
    private LinkedList<BufferData> buffers = new LinkedList();
    private BufferData currentBuffer = new BufferData();
    private WCRectangle clip;
    private int size = 0;
    private WCGraphicsContext gc;

    public WCRenderQueue(WCGraphicsContext wCGraphicsContext) {
        this.gc = wCGraphicsContext;
    }

    public WCRenderQueue(WCRectangle wCRectangle) {
        this.clip = wCRectangle;
    }

    public synchronized int getSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBuffer(ByteBuffer byteBuffer) {
        WCRenderQueue wCRenderQueue = this;
        synchronized (wCRenderQueue) {
            if (log.isLoggable(Level.FINE) && this.buffers.isEmpty()) {
                log.log(Level.FINE, "'{'WCRenderQueue{0}[{1}]", new Object[]{this.hashCode(), idCountObj.incrementAndGet()});
            }
            this.currentBuffer.setBuffer(byteBuffer);
            this.buffers.addLast(this.currentBuffer);
            this.currentBuffer = new BufferData();
            this.size += byteBuffer.capacity();
        }
        if (this.size > 524288 && this.gc != null) {
            this.flush();
        }
    }

    public synchronized boolean isEmpty() {
        return this.buffers.isEmpty();
    }

    public synchronized void decode(WCGraphicsContext wCGraphicsContext) {
        for (BufferData bufferData : this.buffers) {
            try {
                GraphicsDecoder.decode(WCGraphicsManager.getGraphicsManager(), wCGraphicsContext, bufferData);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
        this.dispose();
    }

    public synchronized void decode() {
        assert (this.gc != null);
        this.decode(this.gc);
    }

    public void flush() {
        if (!this.isEmpty()) {
            Invoker.getInvoker().runOnRenderThread(new Runnable(){

                @Override
                public void run() {
                    WCRenderQueue.this.decode();
                }
            });
            this.size = 0;
        }
    }

    private void fwkFlush() {
        this.flush();
    }

    private void fwkAddBuffer(ByteBuffer byteBuffer) {
        this.addBuffer(byteBuffer);
    }

    public WCRectangle getClip() {
        return this.clip;
    }

    public synchronized void dispose() {
        int n = this.buffers.size();
        if (n > 0) {
            int n2 = 0;
            final Object[] objectArray = new Object[n];
            for (BufferData bufferData : this.buffers) {
                objectArray[n2++] = bufferData.getBuffer();
            }
            this.buffers.clear();
            Invoker.getInvoker().invokeOnEventThread(new Runnable(){

                @Override
                public void run() {
                    WCRenderQueue.this.twkRelease(objectArray);
                }
            });
            this.size = 0;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "'}'WCRenderQueue{0}[{1}]", new Object[]{this.hashCode(), idCountObj.decrementAndGet()});
            }
        }
    }

    private native void twkRelease(Object[] var1);

    private int refString(String string) {
        return this.currentBuffer.addString(string);
    }

    private int refIntArr(int[] nArray) {
        return this.currentBuffer.addIntArray(nArray);
    }

    private int refFloatArr(float[] fArray) {
        return this.currentBuffer.addFloatArray(fArray);
    }
}

