/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;

public class VariantNameBuilder {
    private final Map<List<String>, DisplayName> names = Maps.newHashMap();

    public DisplayName getVariantName(@Nullable List<String> parts) {
        if (parts == null) {
            return null;
        }
        DisplayName displayName = this.names.get(parts);
        if (displayName == null) {
            displayName = VariantNameBuilder.variantName(parts);
            this.names.put(parts, displayName);
        }
        return displayName;
    }

    private static DisplayName variantName(List<String> parts) {
        if (parts.size() == 1) {
            return Describables.of((Object)parts.get(0));
        }
        return new MultipleVariantName(parts);
    }

    private static class MultipleVariantName
    implements DisplayName {
        private final List<String> parts;

        private MultipleVariantName(List<String> parts) {
            this.parts = parts;
        }

        public String getCapitalizedDisplayName() {
            return StringUtils.capitalize((String)this.getDisplayName());
        }

        public String getDisplayName() {
            StringBuilder sb = new StringBuilder(16 * this.parts.size());
            boolean appendPlus = false;
            for (String part : this.parts) {
                if (appendPlus) {
                    sb.append("+");
                }
                sb.append(part);
                appendPlus = true;
            }
            return sb.toString();
        }
    }
}

