/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties.annotations;

import org.gradle.api.internal.tasks.properties.BeanPropertyContext;
import org.gradle.api.internal.tasks.properties.FileParameterUtils;
import org.gradle.api.internal.tasks.properties.InputFilePropertyType;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.annotations.PropertyAnnotationHandler;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.internal.reflect.ParameterValidationContext;
import org.gradle.internal.reflect.PropertyMetadata;
import org.gradle.work.Incremental;

public abstract class AbstractInputFilePropertyAnnotationHandler
implements PropertyAnnotationHandler {
    @Override
    public boolean isPropertyRelevant() {
        return true;
    }

    @Override
    public boolean shouldVisit(PropertyVisitor visitor) {
        return !visitor.visitOutputFilePropertiesOnly();
    }

    @Override
    public void visitPropertyValue(String propertyName, PropertyValue value, PropertyMetadata propertyMetadata, PropertyVisitor visitor, BeanPropertyContext context) {
        PathSensitive pathSensitive = (PathSensitive)propertyMetadata.getAnnotation(PathSensitive.class);
        Class<? extends FileNormalizer> fileNormalizer = pathSensitive == null ? null : FileParameterUtils.determineNormalizerForPathSensitivity(pathSensitive.value());
        visitor.visitInputFileProperty(propertyName, propertyMetadata.isAnnotationPresent(Optional.class), propertyMetadata.isAnnotationPresent(SkipWhenEmpty.class), propertyMetadata.isAnnotationPresent(Incremental.class), fileNormalizer, value, this.getFilePropertyType());
    }

    @Override
    public void validatePropertyMetadata(PropertyMetadata propertyMetadata, ParameterValidationContext visitor) {
    }

    protected abstract InputFilePropertyType getFilePropertyType();
}

