/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PWriter
extends PrintWriter {
    private String lineSeparator = System.getProperty("line.separator");
    private String fieldSeparator;
    private StringWriter stringWriter;
    private boolean newLine = true;
    private SimpleDateFormat dateFormat;
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    public static PWriter create() {
        StringWriter stringWriter = new StringWriter();
        PWriter printWriter = new PWriter(stringWriter);
        printWriter.stringWriter = stringWriter;
        return printWriter;
    }

    public static PWriter forFile(File file, Charset charset) throws IOException {
        OutputStream stream = new FileOutputStream(file);
        stream = new BufferedOutputStream(stream);
        OutputStreamWriter writer = new OutputStreamWriter(stream, charset);
        PWriter pwriter = new PWriter(writer);
        return pwriter;
    }

    @Override
    public void close() {
        try {
            this.flush();
        }
        finally {
            super.close();
        }
    }

    public static PWriter forFile(File file) throws IOException {
        return PWriter.forFile(file, Charset.defaultCharset());
    }

    public PWriter(OutputStream out) {
        super(out);
    }

    public PWriter(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public PWriter(Writer out) {
        super(out);
    }

    public String toString() {
        if (this.stringWriter != null) {
            return this.stringWriter.toString();
        }
        return super.toString();
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat == null ? null : new SimpleDateFormat(dateFormat);
    }

    public PWriter(Writer out, boolean autoFlush, String lineSeparator) {
        super(out, autoFlush);
        this.lineSeparator = lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    @Override
    public void print(String s) {
        if (this.newLine) {
            if (this.dateFormat != null) {
                super.print(this.dateFormat.format(new Date()));
                super.print(": ");
            }
            this.newLine = false;
        }
        super.print(s);
    }

    @Override
    public void println() {
        super.print(this.lineSeparator);
        this.newLine = true;
    }

    @Override
    public void println(boolean arg0) {
        this.print(arg0);
        this.println();
    }

    @Override
    public void println(char arg0) {
        this.print(arg0);
        this.println();
    }

    @Override
    public void println(char[] arg0) {
        this.print(arg0);
        this.println();
    }

    @Override
    public void println(double arg0) {
        this.print(arg0);
        this.println();
    }

    @Override
    public void println(float arg0) {
        this.print(arg0);
        this.println();
    }

    @Override
    public void println(int arg0) {
        this.print(arg0);
        this.println();
    }

    @Override
    public void println(long arg0) {
        this.print(arg0);
        this.println();
    }

    @Override
    public void println(Object arg0) {
        this.print(arg0);
        this.println();
    }

    @Override
    public void println(String arg0) {
        this.print(arg0);
        this.println();
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(String fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public void printFields(Object ... fields) {
        boolean first = true;
        for (Object field : fields) {
            if (!first) {
                this.print(this.fieldSeparator);
            }
            first = false;
            this.print(field);
        }
        this.println();
    }
}

