/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.SwingUtilities;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SnapshotsListener;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.impl.SnapshotsWindowHelper;
import org.netbeans.modules.profiler.v2.impl.SnapshotsWindowUI;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class SnapshotsWindow {
    private static SnapshotsWindow INSTANCE;
    private final SnapshotsListener snapshotsListener = (SnapshotsListener)Lookup.getDefault().lookup(SnapshotsWindowHelper.class);
    private SnapshotsWindowUI ui;

    public static synchronized SnapshotsWindow instance() {
        if (INSTANCE == null) {
            INSTANCE = new SnapshotsWindow();
        }
        return INSTANCE;
    }

    private SnapshotsWindow() {
        TopComponent.getRegistry().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("tcClosed".equals(propertyChangeEvent.getPropertyName()) && SnapshotsWindow.this.ui != null && propertyChangeEvent.getNewValue() == SnapshotsWindow.this.ui) {
                    SnapshotsWindow.this.ui = null;
                }
            }
        });
    }

    public void showStandalone() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SnapshotsWindowUI snapshotsWindowUI = SnapshotsWindow.this.getUI(true);
                snapshotsWindowUI.open();
                snapshotsWindowUI.requestActive();
            }
        });
    }

    public void sessionOpened(final ProfilerSession profilerSession) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SnapshotsWindowUI snapshotsWindowUI = SnapshotsWindow.this.getUI(false);
                if (snapshotsWindowUI == null && ProfilerIDESettings.getInstance().getSnapshotWindowOpenPolicy() == 1) {
                    snapshotsWindowUI = SnapshotsWindow.this.getUI(true);
                    snapshotsWindowUI.setProject(profilerSession.getProject());
                    snapshotsWindowUI.open();
                } else if (snapshotsWindowUI != null) {
                    snapshotsWindowUI.setProject(profilerSession.getProject());
                }
            }
        });
    }

    public void sessionActivated(final ProfilerSession profilerSession) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SnapshotsWindowUI snapshotsWindowUI = SnapshotsWindow.this.getUI(false);
                if (snapshotsWindowUI == null && ProfilerIDESettings.getInstance().getSnapshotWindowOpenPolicy() == 2) {
                    snapshotsWindowUI = SnapshotsWindow.this.getUI(true);
                    snapshotsWindowUI.setProject(profilerSession.getProject());
                    snapshotsWindowUI.open();
                } else if (snapshotsWindowUI != null) {
                    snapshotsWindowUI.setProject(profilerSession.getProject());
                }
            }
        });
    }

    public void sessionDeactivated(final ProfilerSession profilerSession) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SnapshotsWindowUI snapshotsWindowUI = SnapshotsWindow.this.getUI(false);
                if (snapshotsWindowUI != null) {
                    if (ProfilerIDESettings.getInstance().getSnapshotWindowClosePolicy() == 2) {
                        snapshotsWindowUI.close();
                    }
                    snapshotsWindowUI.resetProject(profilerSession.getProject());
                }
            }
        });
    }

    public void sessionClosed(final ProfilerSession profilerSession) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SnapshotsWindowUI snapshotsWindowUI = SnapshotsWindow.this.getUI(false);
                if (snapshotsWindowUI != null) {
                    if (ProfilerIDESettings.getInstance().getSnapshotWindowClosePolicy() == 1) {
                        snapshotsWindowUI.close();
                    }
                    snapshotsWindowUI.resetProject(profilerSession.getProject());
                }
            }
        });
    }

    public void snapshotSaved(LoadedSnapshot loadedSnapshot) {
        assert (!SwingUtilities.isEventDispatchThread());
        int n = ProfilerIDESettings.getInstance().getSnapshotWindowOpenPolicy();
        if (n == 3 && ResultsManager.getDefault().getSnapshotsCountFor(loadedSnapshot.getProject()) == 1 || n == 4) {
            final Lookup.Provider provider = loadedSnapshot.getProject();
            ProfilerSession profilerSession = ProfilerSession.currentSession();
            if (profilerSession != null && Objects.equals(profilerSession.getProject(), provider)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SnapshotsWindowUI snapshotsWindowUI = SnapshotsWindow.this.getUI(false);
                        if (snapshotsWindowUI == null) {
                            snapshotsWindowUI = SnapshotsWindow.this.getUI(true);
                            snapshotsWindowUI.setProject(provider);
                            snapshotsWindowUI.open();
                        }
                    }
                });
            }
        }
    }

    public void refreshFolder(final FileObject fileObject, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SnapshotsWindowUI snapshotsWindowUI = SnapshotsWindow.this.getUI(false);
                if (snapshotsWindowUI != null) {
                    snapshotsWindowUI.refreshFolder(fileObject, bl);
                }
            }
        });
    }

    private SnapshotsWindowUI getUI(boolean bl) {
        if (this.ui == null) {
            WindowManager windowManager = WindowManager.getDefault();
            for (TopComponent topComponent : TopComponent.getRegistry().getOpened()) {
                if (topComponent.getClientProperty((Object)"SnapshotsWindowUI") == null) continue;
                this.ui = (SnapshotsWindowUI)topComponent;
            }
            if (this.ui == null && bl) {
                this.ui = (SnapshotsWindowUI)windowManager.findTopComponent("SnapshotsWindowUI");
            }
            if (this.ui == null && bl) {
                this.ui = new SnapshotsWindowUI();
            }
        }
        return this.ui;
    }
}

