/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.impl;

import java.io.File;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.SnapshotsListener;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.v2.SnapshotsWindow;
import org.netbeans.modules.profiler.v2.impl.WeakProcessor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class SnapshotsWindowHelper
implements SnapshotsListener {
    static final WeakProcessor PROCESSOR = new WeakProcessor("Snapshots Window Processor");

    @Override
    public void snapshotTaken(LoadedSnapshot loadedSnapshot) {
        if (ProfilerIDESettings.getInstance().getAutoOpenSnapshot()) {
            ResultsManager.getDefault().openSnapshot(loadedSnapshot);
        }
        if (ProfilerIDESettings.getInstance().getAutoSaveSnapshot()) {
            ResultsManager.getDefault().saveSnapshot(loadedSnapshot);
            if (!ProfilerIDESettings.getInstance().getAutoOpenSnapshot()) {
                ResultsManager.getDefault().closeSnapshot(loadedSnapshot);
            }
        }
    }

    @Override
    public void snapshotLoaded(LoadedSnapshot loadedSnapshot) {
    }

    @Override
    public void snapshotSaved(final LoadedSnapshot loadedSnapshot) {
        this.refreshSnapshots(loadedSnapshot);
        PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                SnapshotsWindow.instance().snapshotSaved(loadedSnapshot);
            }
        });
    }

    @Override
    public void snapshotRemoved(LoadedSnapshot loadedSnapshot) {
        SnapshotResultsWindow.closeWindow(loadedSnapshot);
        this.refreshSnapshots(loadedSnapshot);
    }

    private void refreshSnapshots(final LoadedSnapshot loadedSnapshot) {
        PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                FileObject fileObject;
                File file = loadedSnapshot.getFile();
                File file2 = file == null ? null : file.getParentFile();
                FileObject fileObject2 = fileObject = file2 == null ? null : FileUtil.toFileObject((File)file2);
                if (fileObject != null) {
                    SnapshotsWindow.instance().refreshFolder(fileObject, true);
                }
            }
        });
    }
}

