/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.SBlock;
import org.objectweb.asm.Label;

public final class SWhile
extends AStatement {
    private AExpression condition;
    private final SBlock block;
    private boolean continuous = false;

    public SWhile(Location location, AExpression condition, SBlock block) {
        super(location);
        this.condition = Objects.requireNonNull(condition);
        this.block = block;
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.condition.extractVariables(variables);
        if (this.block != null) {
            this.block.extractVariables(variables);
        }
    }

    @Override
    void analyze(Locals locals) {
        locals = Locals.newLocalScope(locals);
        this.condition.expected = Boolean.TYPE;
        this.condition.analyze(locals);
        this.condition = this.condition.cast(locals);
        if (this.condition.constant != null) {
            this.continuous = (Boolean)this.condition.constant;
            if (!this.continuous) {
                throw this.createError(new IllegalArgumentException("Extraneous while loop."));
            }
            if (this.block == null) {
                throw this.createError(new IllegalArgumentException("While loop has no escape."));
            }
        }
        if (this.block != null) {
            this.block.beginLoop = true;
            this.block.inLoop = true;
            this.block.analyze(locals);
            if (this.block.loopEscape && !this.block.anyContinue) {
                throw this.createError(new IllegalArgumentException("Extraneous while loop."));
            }
            if (this.continuous && !this.block.anyBreak) {
                this.methodEscape = true;
                this.allEscape = true;
            }
            this.block.statementCount = Math.max(1, this.block.statementCount);
        }
        this.statementCount = 1;
        if (locals.hasVariable("#loop")) {
            this.loopCounter = locals.getVariable(this.location, "#loop");
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeStatementOffset(this.location);
        Label begin = new Label();
        Label end = new Label();
        writer.mark(begin);
        if (!this.continuous) {
            this.condition.write(writer, globals);
            writer.ifZCmp(153, end);
        }
        if (this.block != null) {
            if (this.loopCounter != null) {
                writer.writeLoopCounter(this.loopCounter.getSlot(), Math.max(1, this.block.statementCount), this.location);
            }
            this.block.continu = begin;
            this.block.brake = end;
            this.block.write(writer, globals);
        } else if (this.loopCounter != null) {
            writer.writeLoopCounter(this.loopCounter.getSlot(), 1, this.location);
        }
        if (this.block == null || !this.block.allEscape) {
            writer.goTo(begin);
        }
        writer.mark(end);
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.condition, this.block);
    }
}

