/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.application.tasks;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import javax.annotation.Nullable;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.plugins.StartScriptGenerator;
import org.gradle.api.internal.plugins.UnixStartScriptGenerator;
import org.gradle.api.internal.plugins.WindowsStartScriptGenerator;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.application.scripts.ScriptGenerator;
import org.gradle.util.GUtil;

public class CreateStartScripts
extends ConventionTask {
    private File outputDir;
    private String executableDir = "bin";
    private String mainClassName;
    private Iterable<String> defaultJvmOpts = Lists.newLinkedList();
    private String applicationName;
    private String optsEnvironmentVar;
    private String exitEnvironmentVar;
    private FileCollection classpath;
    private ScriptGenerator unixStartScriptGenerator = new UnixStartScriptGenerator();
    private ScriptGenerator windowsStartScriptGenerator = new WindowsStartScriptGenerator();

    @Nullable
    @Optional
    @Input
    public String getOptsEnvironmentVar() {
        if (GUtil.isTrue((Object)this.optsEnvironmentVar)) {
            return this.optsEnvironmentVar;
        }
        if (!GUtil.isTrue((Object)this.getApplicationName())) {
            return null;
        }
        return GUtil.toConstant((CharSequence)this.getApplicationName()) + "_OPTS";
    }

    @Nullable
    @Optional
    @Input
    public String getExitEnvironmentVar() {
        if (GUtil.isTrue((Object)this.exitEnvironmentVar)) {
            return this.exitEnvironmentVar;
        }
        if (!GUtil.isTrue((Object)this.getApplicationName())) {
            return null;
        }
        return GUtil.toConstant((CharSequence)this.getApplicationName()) + "_EXIT_CONSOLE";
    }

    @Internal
    public File getUnixScript() {
        return new File(this.getOutputDir(), this.getApplicationName());
    }

    @Internal
    public File getWindowsScript() {
        return new File(this.getOutputDir(), this.getApplicationName() + ".bat");
    }

    @OutputDirectory
    @Nullable
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(@Nullable File outputDir) {
        this.outputDir = outputDir;
    }

    @Incubating
    @Input
    public String getExecutableDir() {
        return this.executableDir;
    }

    @Incubating
    public void setExecutableDir(String executableDir) {
        this.executableDir = executableDir;
    }

    @Input
    @Nullable
    public String getMainClassName() {
        return this.mainClassName;
    }

    public void setMainClassName(@Nullable String mainClassName) {
        this.mainClassName = mainClassName;
    }

    @Nullable
    @Optional
    @Input
    public Iterable<String> getDefaultJvmOpts() {
        return this.defaultJvmOpts;
    }

    public void setDefaultJvmOpts(@Nullable Iterable<String> defaultJvmOpts) {
        this.defaultJvmOpts = defaultJvmOpts;
    }

    @Nullable
    @Input
    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(@Nullable String applicationName) {
        this.applicationName = applicationName;
    }

    public void setOptsEnvironmentVar(@Nullable String optsEnvironmentVar) {
        this.optsEnvironmentVar = optsEnvironmentVar;
    }

    public void setExitEnvironmentVar(@Nullable String exitEnvironmentVar) {
        this.exitEnvironmentVar = exitEnvironmentVar;
    }

    @Internal
    @Nullable
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(@Nullable FileCollection classpath) {
        this.classpath = classpath;
    }

    @Internal
    public ScriptGenerator getUnixStartScriptGenerator() {
        return this.unixStartScriptGenerator;
    }

    public void setUnixStartScriptGenerator(ScriptGenerator unixStartScriptGenerator) {
        this.unixStartScriptGenerator = unixStartScriptGenerator;
    }

    @Internal
    public ScriptGenerator getWindowsStartScriptGenerator() {
        return this.windowsStartScriptGenerator;
    }

    public void setWindowsStartScriptGenerator(ScriptGenerator windowsStartScriptGenerator) {
        this.windowsStartScriptGenerator = windowsStartScriptGenerator;
    }

    @TaskAction
    public void generate() {
        StartScriptGenerator generator = new StartScriptGenerator(this.unixStartScriptGenerator, this.windowsStartScriptGenerator);
        generator.setApplicationName(this.getApplicationName());
        generator.setMainClassName(this.getMainClassName());
        generator.setDefaultJvmOpts(this.getDefaultJvmOpts());
        generator.setOptsEnvironmentVar(this.getOptsEnvironmentVar());
        generator.setExitEnvironmentVar(this.getExitEnvironmentVar());
        generator.setClasspath(this.getRelativeClasspath());
        generator.setScriptRelPath(this.getExecutableDir() + "/" + this.getUnixScript().getName());
        generator.generateUnixScript(this.getUnixScript());
        generator.generateWindowsScript(this.getWindowsScript());
    }

    @Input
    protected Iterable<String> getRelativeClasspath() {
        FileCollection classpathNullable = this.getClasspath();
        if (classpathNullable == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)classpathNullable.getFiles(), (Function)new Function<File, String>(){

            public String apply(File input) {
                return "lib/" + input.getName();
            }
        }));
    }
}

