/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionUtils;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;
import org.opentest4j.AssertionFailedError;

class AssertDoesNotThrow {
    private AssertDoesNotThrow() {
    }

    static void assertDoesNotThrow(Executable executable) {
        AssertDoesNotThrow.assertDoesNotThrow(executable, null);
    }

    static void assertDoesNotThrow(Executable executable, String message) {
        AssertDoesNotThrow.assertDoesNotThrow(executable, (Object)message);
    }

    static void assertDoesNotThrow(Executable executable, Supplier<String> messageSupplier) {
        AssertDoesNotThrow.assertDoesNotThrow(executable, messageSupplier);
    }

    private static void assertDoesNotThrow(Executable executable, Object messageOrSupplier) {
        try {
            executable.execute();
        }
        catch (Throwable t) {
            String message = AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageOrSupplier)) + "Unexpected exception thrown: " + t.getClass().getName();
            throw new AssertionFailedError(message, t);
        }
    }

    static <T> T assertDoesNotThrow(ThrowingSupplier<T> supplier) {
        return AssertDoesNotThrow.assertDoesNotThrow(supplier, null);
    }

    static <T> T assertDoesNotThrow(ThrowingSupplier<T> supplier, String message) {
        return AssertDoesNotThrow.assertDoesNotThrow(supplier, (Object)message);
    }

    static <T> T assertDoesNotThrow(ThrowingSupplier<T> supplier, Supplier<String> messageSupplier) {
        return AssertDoesNotThrow.assertDoesNotThrow(supplier, messageSupplier);
    }

    private static <T> T assertDoesNotThrow(ThrowingSupplier<T> supplier, Object messageOrSupplier) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            String message = AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageOrSupplier)) + "Unexpected exception thrown: " + t.getClass().getName();
            throw new AssertionFailedError(message, t);
        }
    }
}

