/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.dssx;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.dssx.AnnotationParser;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.HBond;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.BasePair;
import org.jmol.modelsetbio.BioModel;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class DSSR1
extends AnnotationParser {
    private static final String DSSR_PATHS = "..bulges.nts_long..coaxstacks.stems.pairs.nt*..hairpins.nts_long..hbonds.atom1_id;atom2_id..helices.pairs.nt*..iloops.nts_long..isocanonpairs.nt*..junctions.nts_long..kissingloops.hairpins.nts_long..multiplets.nts_long..nonstack.nts_long..nts.nt_id..pairs.nt*..sssegments.nts_long..stacks.nts_long..stems.pairs.nt*..";

    @Override
    public String calculateDSSRStructure(Viewer viewer, BS bS) {
        BS bS2 = viewer.ms.getModelBS(bS == null ? viewer.bsA() : bS, true);
        String string = "";
        int n = bS2.nextSetBit(0);
        while (n >= 0) {
            string = String.valueOf(string) + this.getDSSRForModel(viewer, n) + "\n";
            n = bS2.nextSetBit(n + 1);
        }
        return string;
    }

    private String getDSSRForModel(Viewer viewer, int n) {
        Map<String, Object> map = null;
        String string = null;
        if (viewer.ms.am[n].isBioModel && !(map = viewer.ms.getModelAuxiliaryInfo(n)).containsKey("dssr")) {
            BS bS = viewer.getModelUndeletedAtomsBitSet(n);
            bS.and(viewer.ms.getAtoms(0x20000E, null));
            if (bS.nextClearBit(0) < 0) {
                map = null;
            } else {
                try {
                    String string2 = (String)viewer.setLoadFormat("=dssrModel/", '=', false);
                    string2 = PT.rep(string2, "%20", " ");
                    Logger.info("fetching " + string2 + "[pdb data]");
                    String string3 = viewer.getPdbAtomData(bS, null, false, false);
                    int n2 = viewer.getModelNumber(viewer.ms.getModelBS(bS, false).nextSetBit(0));
                    String string4 = "          " + n2;
                    string3 = "MODEL" + string4.substring(string4.length() - 9) + "\n" + string3 + "ENDMDL\n";
                    string3 = viewer.getFileAsString3(String.valueOf(string2) + string3, false, null);
                    Map<String, Object> map2 = viewer.parseJSONMap(string3);
                    if (map2 != null) {
                        map.put("dssr", map2);
                        this.setGroup1(viewer.ms, n);
                        this.fixDSSRJSONMap(map2);
                        this.setBioPolymers((BioModel)viewer.ms.am[n], false);
                    }
                }
                catch (Throwable throwable) {
                    map = null;
                    string = "" + throwable;
                }
            }
        }
        return map != null ? PT.rep(Escape.escapeMap((Map)((Map)map.get("dssr")).get("counts")), ",", ",\n") : (string == null ? "model has no nucleotides" : string);
    }

    @Override
    public String fixDSSRJSONMap(Map<String, Object> map) {
        String string = "";
        try {
            this.fixIndices(map, "kissingLoops", "hairpin");
            this.fixIndices(map, "coaxStacks", "stem");
            if (map.containsKey("counts")) {
                string = String.valueOf(string) + "_M.dssr.counts = " + map.get("counts").toString() + "\n";
            }
            if (map.containsKey("dbn")) {
                string = String.valueOf(string) + "_M.dssr.dbn = " + map.get("dbn").toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    private void fixIndices(Map<String, Object> map, String string, String string2) {
        String string3 = String.valueOf(string2) + "_indices";
        String string4 = String.valueOf(string2) + "s";
        Lst lst = (Lst)map.get(string);
        if (lst != null) {
            Lst lst2 = (Lst)map.get(string4);
            int n = lst.size();
            while (--n >= 0) {
                Map map2 = (Map)lst.get(n);
                Lst lst3 = (Lst)map2.get(string3);
                int n2 = lst3.size();
                if (n2 <= 0) continue;
                Lst lst4 = new Lst();
                map2.put(string4, lst4);
                int n3 = n2;
                while (--n3 >= 0) {
                    lst4.addLast(lst2.get((Integer)lst3.get(n3) - 1));
                }
            }
        }
    }

    @Override
    public void getBasePairs(Viewer viewer, int n) {
        Lst lst;
        ModelSet modelSet = viewer.ms;
        Map map = (Map)modelSet.getInfo(n, "dssr");
        Lst lst2 = map == null ? null : (Lst)map.get("pairs");
        Lst lst3 = lst = map == null ? null : (Lst)map.get("ssSegments");
        if (lst2 == null && lst == null) {
            this.setBioPolymers((BioModel)viewer.ms.am[n], true);
            return;
        }
        BS bS = modelSet.am[n].bsAtoms;
        try {
            String string;
            Map map2;
            int n2;
            BS bS2 = new BS();
            Atom[] atomArray = modelSet.at;
            if (lst2 != null) {
                n2 = lst2.size();
                while (--n2 >= 0) {
                    map2 = (Map)lst2.get(n2);
                    string = (String)map2.get("nt1");
                    String string2 = (String)map2.get("nt2");
                    int n3 = modelSet.getSequenceBits(string, bS, bS2).nextSetBit(0);
                    bS2.clearAll();
                    int n4 = modelSet.getSequenceBits(string2, bS, bS2).nextSetBit(0);
                    bS2.clearAll();
                    BasePair.add(map2, this.setRes(atomArray[n3]), this.setRes(atomArray[n4]));
                }
            }
            if (lst != null) {
                n2 = lst.size();
                while (--n2 >= 0) {
                    map2 = (Map)lst.get(n2);
                    string = (String)map2.get("nts_long");
                    modelSet.getSequenceBits(string, bS, bS2);
                    int n5 = bS2.nextSetBit(0);
                    while (n5 >= 0) {
                        this.setRes(atomArray[n5]);
                        n5 = bS2.nextSetBit(n5 + 1);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Logger.error("Exception " + throwable + " in DSSRParser.getBasePairs");
        }
    }

    private void setBioPolymers(BioModel bioModel, boolean bl) {
        int n;
        int n2 = n = bioModel.getBioPolymerCount();
        while (--n2 >= 0) {
            BioPolymer bioPolymer = bioModel.bioPolymers[n2];
            if (!bioPolymer.isNucleic()) continue;
            ((NucleicPolymer)bioPolymer).isDssrSet = bl;
        }
    }

    private NucleicMonomer setRes(Atom atom) {
        if (atom.group.getBioPolymerLength() == 0) {
            return null;
        }
        NucleicMonomer nucleicMonomer = (NucleicMonomer)atom.group;
        ((NucleicPolymer)nucleicMonomer.bioPolymer).isDssrSet = true;
        return nucleicMonomer;
    }

    @Override
    public BS getAtomBits(Viewer viewer, String string, Object object, Map<String, Object> map, int n, int n2, BS bS) {
        boolean bl;
        if (object == null) {
            return new BS();
        }
        boolean bl2 = bl = !string.contains("NOCACHE");
        if (!bl) {
            string = PT.rep(string, "NOCACHE", "").trim();
        }
        BS bS2 = null;
        bS2 = new BS();
        if (bl) {
            map.put(string, bS2);
        }
        try {
            string = PT.rep(string, "[where", "[select * where");
            string = PT.rep(string, "[WHERE", "[select * where");
            String string2 = "";
            int n3 = Integer.MIN_VALUE;
            int n4 = string.toLowerCase().indexOf("[select");
            if (n4 >= 0) {
                string2 = string.substring(n4);
                string = string.substring(0, n4);
                n4 = string2.lastIndexOf("]..");
                if (n4 >= 0 && (n3 = PT.parseInt(string2.substring(n4 + 3))) != Integer.MIN_VALUE) {
                    string2 = string2.substring(0, n4 + 1);
                }
            }
            if ((n4 = string.toLowerCase().indexOf(" where ")) < 0) {
                string = string.toLowerCase();
                n4 = n3 == Integer.MIN_VALUE ? string.lastIndexOf(46) : -1;
                boolean bl3 = false;
                if (n4 >= 0 && (bl3 = (n3 = PT.parseInt(string.substring(n4 + 1))) != Integer.MIN_VALUE)) {
                    string = string.substring(0, n4);
                }
                n4 = DSSR_PATHS.indexOf(".." + string) + 2;
                int n5 = string.length();
                if (n4 < 2) {
                    return bS2;
                }
                int n6 = bl3 ? n4 + n5 : Integer.MAX_VALUE;
                while (n4 >= 2 && n4 < n6 && n5 > 0) {
                    if (string.indexOf(".") < 0 && DSSR_PATHS.substring(n4 + n5, n4 + n5 + 2).equals("..")) {
                        string = "[select (" + string + ")]";
                    }
                    object = viewer.extractProperty(object, string, -1);
                    n4 += n5 + 1;
                    if (string2.length() > 0) {
                        object = viewer.extractProperty(object, string2, -1);
                        string2 = "";
                    }
                    int n7 = DSSR_PATHS.indexOf(".", n4);
                    string = DSSR_PATHS.substring(n4, n7);
                    n5 = string.length();
                }
            } else {
                string = String.valueOf(string.substring(0, n4).trim()) + "[select * " + string.substring(n4 + 1) + "]" + string2;
                object = viewer.extractProperty(object, string, -1);
            }
            if (n3 != Integer.MIN_VALUE && object instanceof Lst) {
                if (n3 <= 0) {
                    n3 += ((Lst)object).size();
                }
                object = ((Lst)object).get(n3 - 1);
            }
            bS2.or(viewer.ms.getAtoms(1086324744, object.toString()));
            bS2.and(bS);
        }
        catch (Throwable throwable) {
            System.out.println(String.valueOf(throwable.toString()) + " in AnnotationParser");
            bS2.clearAll();
        }
        return bS2;
    }

    @Override
    public String getHBonds(ModelSet modelSet, int n, Lst<Bond> lst, boolean bl) {
        Lst lst2;
        Map map = (Map)modelSet.getInfo(n, "dssr");
        if (map == null || (lst2 = (Lst)map.get("hbonds")) == null) {
            return "no DSSR hydrogen-bond data";
        }
        BS bS = modelSet.am[n].bsAtoms;
        String string = null;
        String string2 = null;
        int n2 = 0;
        int n3 = 0;
        try {
            BS bS2 = new BS();
            int n4 = lst2.size();
            while (--n4 >= 0) {
                Map map2 = (Map)lst2.get(n4);
                string = (String)map2.get("atom1_id");
                n2 = modelSet.getSequenceBits(string, bS, bS2).nextSetBit(0);
                if (n2 < 0) {
                    Logger.error("Atom " + string + " was not found");
                    continue;
                }
                string2 = (String)map2.get("atom2_id");
                bS2.clearAll();
                n3 = modelSet.getSequenceBits(string2, bS, bS2).nextSetBit(0);
                if (n3 < 0) {
                    Logger.error("Atom " + string2 + " was not found");
                    continue;
                }
                bS2.clearAll();
                float f = 0.0f;
                lst.addLast(new HBond(modelSet.at[n2], modelSet.at[n3], 2048, 1, 0, f));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "DSSR reports " + lst2.size() + " hydrogen bonds";
    }

    @Override
    public void setGroup1(ModelSet modelSet, int n) {
        Lst lst;
        Map map = (Map)modelSet.getInfo(n, "dssr");
        if (map == null || (lst = (Lst)map.get("nts")) == null) {
            return;
        }
        Model model = modelSet.am[n];
        BS bS = model.bsAtoms;
        Atom[] atomArray = modelSet.at;
        BS bS2 = new BS();
        int n2 = lst.size();
        while (--n2 >= 0) {
            Map map2 = (Map)lst.get(n2);
            char c = ((String)map2.get("nt_code")).charAt(0);
            String string = (String)map2.get("nt_id");
            modelSet.bioModelset.getAllSequenceBits(string, bS, bS2);
            int n3 = bS2.nextSetBit(0);
            if (n3 < 0) continue;
            if ("ACGTU".indexOf(c) < 0) {
                atomArray[n3].group.group1 = c;
            }
            atomArray[n3].group.dssrNT = map2;
            bS2.clearAll();
        }
    }

    @Override
    public void getAtomicDSSRData(ModelSet modelSet, int n, float[] fArray, String string) {
        Lst lst;
        Map map = (Map)modelSet.getInfo(n, "dssr");
        if (map == null || (lst = (Lst)map.get(string)) == null) {
            return;
        }
        BS bS = modelSet.am[n].bsAtoms;
        try {
            BS bS2 = new BS();
            int n2 = lst.size();
            while (--n2 >= 0) {
                Map map2 = (Map)lst.get(n2);
                bS2.clearAll();
                modelSet.getSequenceBits(map2.toString(), bS, bS2);
                int n3 = bS2.nextSetBit(0);
                while (n3 >= 0) {
                    fArray[n3] = n2;
                    n3 = bS2.nextSetBit(n3 + 1);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public P3[] getDSSRFrame(Map<String, Object> map) {
        Map map2 = (Map)map.get("frame");
        if (map2 == null) {
            return null;
        }
        P3[] p3Array = new P3[4];
        int n = 4;
        while (--n >= 0) {
            p3Array[n] = new P3();
        }
        this.getPoint(map2, "origin", p3Array[0]);
        this.getPoint(map2, "x_axis", p3Array[1]);
        this.getPoint(map2, "y_axis", p3Array[2]);
        this.getPoint(map2, "z_axis", p3Array[3]);
        return p3Array;
    }

    private void getPoint(Map<String, Object> map, String string, P3 p3) {
        Lst lst = (Lst)map.get(string);
        p3.x = ((Float)lst.get(0)).floatValue();
        p3.y = ((Float)lst.get(1)).floatValue();
        p3.z = ((Float)lst.get(2)).floatValue();
    }
}

