/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.util.A4;
import javajs.util.BS;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.render.MeshRenderer;
import org.jmol.render.ShapeRenderer;
import org.jmol.renderbio.BioShapeRenderer;
import org.jmol.shape.Mesh;
import org.jmol.shapebio.BioShape;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.util.Normix;

public class BioMeshRenderer
extends MeshRenderer {
    private Mesh[] meshes;
    private boolean[] meshReady;
    private BS bsRenderMesh;
    private BioShapeRenderer bsr;
    private boolean doCap0;
    private boolean doCap1;
    private static final int ABSOLUTE_MIN_MESH_SIZE = 3;
    private static final int MIN_MESH_RENDER_SIZE = 8;
    private P3[] controlHermites;
    private V3[] wingHermites;
    private P3[] radiusHermites;
    private V3 norm = new V3();
    private final V3 wing = new V3();
    private final V3 wing1 = new V3();
    private final V3 wingT = new V3();
    private final A4 aa = new A4();
    private final P3 pt = new P3();
    private final P3 pt1 = new P3();
    private final P3 ptPrev = new P3();
    private final P3 ptNext = new P3();
    private final M3 mat = new M3();
    private static final int MODE_TUBE = 0;
    private static final int MODE_FLAT = 1;
    private static final int MODE_ELLIPTICAL = 2;
    private static final int MODE_NONELLIPTICAL = 3;
    private BS bsTemp;
    private final V3 norml = new V3();

    @Override
    protected boolean render() {
        return false;
    }

    public void initialize(ShapeRenderer shapeRenderer, BioShape bioShape, int n) {
        this.bsr = (BioShapeRenderer)shapeRenderer;
        this.bsRenderMesh = BS.newN(n);
        this.meshReady = bioShape.meshReady;
        this.meshes = bioShape.meshes;
    }

    private void renderBioMesh(Mesh mesh) {
        if (mesh.normalsTemp != null) {
            mesh.setNormixes(mesh.normalsTemp);
            mesh.normalsTemp = null;
        } else if (mesh.normixes == null) {
            mesh.initialize(1073741958, null, null);
        }
        this.renderMesh2(mesh);
    }

    public void setFancyRibbon(int n) {
        try {
            if (!(this.meshes[n] != null && this.meshReady[n] || this.createMesh(n, this.bsr.madBeg, this.bsr.madMid, this.bsr.madEnd, this.bsr.aspectRatio, this.bsr.isNucleic ? 4 : 7))) {
                return;
            }
            this.meshes[n].setColix(this.bsr.colix);
            this.meshes[n].setColixBack(this.bsr.colixBack);
            this.bsRenderMesh.set(n);
        }
        catch (Exception exception) {
            this.bsRenderMesh.clear(n);
            this.meshes[n] = null;
            Logger.error("render mesh error hermiteRibbon: " + exception.toString());
        }
    }

    public void setFancyConic(int n, int n2) {
        try {
            if (!(this.meshes[n] != null && this.meshReady[n] || this.createMesh(n, this.bsr.madBeg, this.bsr.madMid, this.bsr.madEnd, 1.0f, n2))) {
                return;
            }
            this.meshes[n].setColix(this.bsr.colix);
            this.bsRenderMesh.set(n);
            return;
        }
        catch (Exception exception) {
            this.bsRenderMesh.clear(n);
            this.meshes[n] = null;
            Logger.error("render mesh error hermiteConic: " + exception.toString());
            return;
        }
    }

    public void setFancyArrowHead(int n) {
        try {
            this.doCap0 = true;
            this.doCap1 = false;
            if (!(this.meshes[n] != null && this.meshReady[n] || this.createMesh(n, (int)Math.floor((double)this.bsr.madBeg * 1.2), (int)Math.floor((double)this.bsr.madBeg * 0.6), 0, this.bsr.aspectRatio == 1.0f ? this.bsr.aspectRatio : this.bsr.aspectRatio / 2.0f, 7))) {
                return;
            }
            this.meshes[n].setColix(this.bsr.colix);
            this.bsRenderMesh.set(n);
            return;
        }
        catch (Exception exception) {
            this.bsRenderMesh.clear(n);
            this.meshes[n] = null;
            Logger.error("render mesh error hermiteArrowHead: " + exception.toString());
            return;
        }
    }

    private boolean createMesh(int n, int n2, int n3, int n4, float f, int n5) {
        boolean bl;
        this.bsr.setNeighbors(n);
        P3[] p3Array = this.bsr.controlPoints;
        if (p3Array[n].distanceSquared(p3Array[this.bsr.iNext]) == 0.0f) {
            return false;
        }
        boolean bl2 = f != 1.0f && this.bsr.wingVectors != null;
        boolean bl3 = f == 0.0f;
        boolean bl4 = this.bsr.cartoonsFancy || this.bsr.hermiteLevel >= 6;
        int n6 = (this.bsr.hermiteLevel + 1) * 2 + 1;
        int n7 = bl3 ? 4 : (this.bsr.hermiteLevel + 1) * 4 - 2;
        float f2 = (float)(bl3 ? Math.PI / (double)(n7 - 1) : Math.PI * 2 / (double)n7);
        Mesh mesh = this.meshes[n] = new Mesh().mesh1(this.vwr, "mesh_" + this.shapeID + "_" + n, (short)0, n);
        boolean bl5 = bl = n2 != n3 || n3 != n4;
        if (this.controlHermites == null || this.controlHermites.length < n6 + 1) {
            this.controlHermites = new P3[n6 + 1];
        }
        GData.getHermiteList(n5, p3Array[this.bsr.iPrev], p3Array[n], p3Array[this.bsr.iNext], p3Array[this.bsr.iNext2], p3Array[this.bsr.iNext3], this.controlHermites, 0, n6, true);
        if (this.wingHermites == null || this.wingHermites.length < n6 + 1) {
            this.wingHermites = new V3[n6 + 1];
        }
        this.wing.setT(this.bsr.wingVectors[this.bsr.iPrev]);
        if (n4 == 0) {
            this.wing.scale(2.0f);
        }
        GData.getHermiteList(n5, this.wing, this.bsr.wingVectors[n], this.bsr.wingVectors[this.bsr.iNext], this.bsr.wingVectors[this.bsr.iNext2], this.bsr.wingVectors[this.bsr.iNext3], this.wingHermites, 0, n6, false);
        float f3 = (float)n2 / 2000.0f;
        float f4 = (float)n3 / 2000.0f;
        float f5 = (float)n4 / 2000.0f;
        if (bl) {
            if (this.radiusHermites == null || this.radiusHermites.length < (n6 + 1 >> 1) + 1) {
                this.radiusHermites = new P3[(n6 + 1 >> 1) + 1];
            }
            this.ptPrev.set(f3, f3, 0.0f);
            this.pt.set(f3, f4, 0.0f);
            this.pt1.set(f4, f5, 0.0f);
            this.ptNext.set(f5, f5, 0.0f);
            GData.getHermiteList(4, this.ptPrev, this.pt, this.pt1, this.ptNext, this.ptNext, this.radiusHermites, 0, n6 + 1 >> 1, true);
        }
        int n8 = 0;
        int n9 = n6 >> 1;
        int n10 = (n7 + 2) / 4;
        int n11 = (3 * n7 + 2) / 4;
        int n12 = !bl2 ? 0 : (bl3 ? 1 : (bl4 ? 2 : 3));
        boolean bl6 = n12 == 0 || n12 == 3;
        int n13 = 0;
        while (n13 < n6) {
            this.norm.sub2(this.controlHermites[n13 + 1], this.controlHermites[n13]);
            float f6 = !bl ? f3 : (n13 < n9 ? this.radiusHermites[n13].x : this.radiusHermites[n13 - n9].y);
            this.wing.setT(this.wingHermites[n13]);
            this.wing1.setT(this.wing);
            switch (n12) {
                case 1: {
                    break;
                }
                case 2: {
                    this.wing1.cross(this.norm, this.wing);
                    this.wing1.normalize();
                    this.wing1.scale(this.wing.length() / f);
                    break;
                }
                case 3: {
                    this.wing.scale(2.0f / f);
                    this.wing1.sub(this.wing);
                    break;
                }
                case 0: {
                    this.wing.cross(this.wing, this.norm);
                    this.wing.normalize();
                }
            }
            this.wing.scale(f6);
            this.wing1.scale(f6);
            if (bl6) {
                this.aa.setVA(this.norm, f2);
                this.mat.setAA(this.aa);
            }
            this.pt1.setT(this.controlHermites[n13]);
            float f7 = bl3 ? 0.0f : f2;
            int n14 = 0;
            while (n14 < n7) {
                if (bl6 && n14 > 0) {
                    this.mat.rotate(this.wing);
                }
                switch (n12) {
                    case 1: {
                        this.wingT.setT(this.wing1);
                        this.wingT.scale((float)Math.cos(f7));
                        break;
                    }
                    case 2: {
                        this.wingT.setT(this.wing1);
                        this.wingT.scale((float)Math.sin(f7));
                        this.wingT.scaleAdd2((float)Math.cos(f7), this.wing, this.wingT);
                        break;
                    }
                    case 3: {
                        this.wingT.setT(this.wing);
                        if (n14 == n10 || n14 == n11) {
                            this.wing1.scale(-1.0f);
                        }
                        this.wingT.add(this.wing1);
                        break;
                    }
                    case 0: {
                        this.wingT.setT(this.wing);
                    }
                }
                this.pt.add2(this.pt1, this.wingT);
                mesh.addV(this.pt, true);
                ++n14;
                f7 += f2;
            }
            if (n13 > 0) {
                n14 = bl3 ? n7 - 1 : n7;
                int n15 = 0;
                while (n15 < n14) {
                    int n16 = n8 - n7 + n15;
                    int n17 = n8 - n7 + (n15 + 1) % n7;
                    int n18 = n8 + (n15 + 1) % n7;
                    int n19 = n8 + n15;
                    if (n15 < n14 / 2) {
                        mesh.addQuad(n16, n17, n18, n19);
                    } else {
                        mesh.addQuad(n17, n18, n19, n16);
                    }
                    ++n15;
                }
            }
            n8 += n7;
            ++n13;
        }
        if (!bl3) {
            n13 = n8;
            if (this.doCap0) {
                T3[] t3Array = mesh.getVertices();
                int n20 = 0;
                while (n20 < n7) {
                    mesh.addV(t3Array[n20], true);
                    ++n20;
                }
                n8 += n7;
                n20 = this.bsr.hermiteLevel * 2;
                while (--n20 >= 0) {
                    mesh.addQuad(n8 - n7 + n20 + 2, n8 - n7 + n20 + 1, n8 - n7 + (n7 - n20) % n7, n8 - n20 - 1);
                }
            }
            if (this.doCap1) {
                T3[] t3Array = mesh.getVertices();
                int n21 = 0;
                while (n21 < n7) {
                    mesh.addV(t3Array[n13 - n7 + n21], true);
                    ++n21;
                }
                n8 += n7;
                n21 = this.bsr.hermiteLevel * 2;
                while (--n21 >= 0) {
                    mesh.addQuad(n8 - n21 - 1, n8 - n7 + (n7 - n21) % n7, n8 - n7 + n21 + 1, n8 - n7 + n21 + 2);
                }
            }
        }
        this.meshReady[n] = true;
        this.adjustCartoonSeamNormals(n, n7);
        mesh.setVisibilityFlags(1);
        return true;
    }

    void adjustCartoonSeamNormals(int n, int n2) {
        if (this.bsTemp == null) {
            this.bsTemp = Normix.newVertexBitSet();
        }
        if (n == this.bsr.iNext - 1 && this.bsr.iNext < this.bsr.monomerCount && this.bsr.monomers[n].getStrucNo() == this.bsr.monomers[this.bsr.iNext].getStrucNo() && this.meshReady[n] && this.meshReady[this.bsr.iNext]) {
            try {
                V3[] v3Array = this.meshes[this.bsr.iNext].getNormalsTemp();
                V3[] v3Array2 = this.meshes[n].getNormalsTemp();
                int n3 = v3Array2.length;
                if (this.doCap0) {
                    n3 -= n2;
                }
                int n4 = 1;
                while (n4 <= n2) {
                    this.norml.add2(v3Array2[n3 - n4], v3Array[n2 - n4]);
                    this.norml.normalize();
                    v3Array2[n3 - n4].setT(this.norml);
                    v3Array[n2 - n4].setT(this.norml);
                    ++n4;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void renderMeshes() {
        if (this.bsRenderMesh.isEmpty()) {
            return;
        }
        this.setColix(this.bsr.colix);
        int n = this.bsRenderMesh.nextSetBit(0);
        while (n >= 0) {
            this.renderBioMesh(this.meshes[n]);
            n = this.bsRenderMesh.nextSetBit(n + 1);
        }
    }

    public void initBS() {
        this.bsRenderMesh.clearAll();
    }

    public boolean check(boolean bl, boolean bl2) {
        this.doCap0 = bl;
        this.doCap1 = bl2;
        return this.exportType == 1 || this.checkDiameter(this.bsr.diameterBeg) || this.checkDiameter(this.bsr.diameterMid) || this.checkDiameter(this.bsr.diameterEnd);
    }

    private boolean checkDiameter(int n) {
        return this.bsr.isHighRes && n > 3 || n >= 8;
    }
}

