/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.python.core.BaseSet;
import org.python.core.JavaIterator;
import org.python.core.Py;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyFrozenSet;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySet;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.Untraversable;

class JavaProxySet {
    private static final SetMethod cmpProxy = new SetMethod("__cmp__", 1){

        @Override
        public PyObject __call__(PyObject value) {
            throw Py.TypeError("cannot compare sets using cmp()");
        }
    };
    private static final SetMethod eqProxy = new SetMethod("__eq__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            return Py.newBoolean(this.isEqual(other));
        }
    };
    private static final SetMethod ltProxy = new SetMethod("__lt__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            return Py.newBoolean(!this.isEqual(other) && this.isSubset(other));
        }
    };
    private static final SetMethod gtProxy = new SetMethod("__gt__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            return Py.newBoolean(!this.isEqual(other) && this.isSuperset(other));
        }
    };
    private static final SetMethod isDisjointProxy = new SetMethod("isdisjoint", 1){

        @Override
        public PyObject __call__(PyObject other) {
            return Py.newBoolean(this.intersect(new Collection[]{JavaProxySet.getJavaCollection(other)}).size() == 0);
        }
    };
    private static final SetMethod differenceProxy = new SetMethodVarargs("difference"){

        @Override
        public PyObject __call__(PyObject[] others) {
            return this.makePySet(this.difference(JavaProxySet.getCombinedJavaCollections(others)));
        }
    };
    private static final SetMethod differenceUpdateProxy = new SetMethodVarargs("difference_update"){

        @Override
        public PyObject __call__(PyObject[] others) {
            this.differenceUpdate(JavaProxySet.getCombinedJavaCollections(others));
            return Py.None;
        }
    };
    private static final SetMethod subProxy = new SetMethod("__sub__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            return this.makePySet(this.difference(JavaProxySet.getJavaSet(this.self, "-", other)));
        }
    };
    private static final SetMethod isubProxy = new SetMethod("__isub__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            this.differenceUpdate(JavaProxySet.getJavaSet(this.self, "-=", other));
            return this.self;
        }
    };
    private static final SetMethod intersectionProxy = new SetMethodVarargs("intersection"){

        @Override
        public PyObject __call__(PyObject[] others) {
            return this.makePySet(this.intersect(JavaProxySet.getJavaCollections(others)));
        }
    };
    private static final SetMethod intersectionUpdateProxy = new SetMethodVarargs("intersection_update"){

        @Override
        public PyObject __call__(PyObject[] others) {
            this.intersectUpdate(JavaProxySet.getJavaCollections(others));
            return Py.None;
        }
    };
    private static final SetMethod andProxy = new SetMethod("__and__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            return this.makePySet(this.intersect(new Collection[]{JavaProxySet.getJavaSet(this.self, "&", other)}));
        }
    };
    private static final SetMethod iandProxy = new SetMethod("__iand__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            this.intersectUpdate(new Collection[]{JavaProxySet.getJavaSet(this.self, "&=", other)});
            return this.self;
        }
    };
    private static final SetMethod symDiffProxy = new SetMethod("symmetric_difference", 1){

        @Override
        public PyObject __call__(PyObject other) {
            return this.makePySet(this.symDiff(JavaProxySet.getJavaCollection(other)));
        }
    };
    private static final SetMethod symDiffUpdateProxy = new SetMethod("symmetric_difference_update", 1){

        @Override
        public PyObject __call__(PyObject other) {
            this.symDiffUpdate(JavaProxySet.getJavaCollection(other));
            return Py.None;
        }
    };
    private static final SetMethod xorProxy = new SetMethod("__xor__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            return this.makePySet(this.symDiff(JavaProxySet.getJavaSet(this.self, "^", other)));
        }
    };
    private static final SetMethod ixorProxy = new SetMethod("__ixor__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            this.symDiffUpdate(JavaProxySet.getJavaSet(this.self, "^=", other));
            return this.self;
        }
    };
    private static final SetMethod unionProxy = new SetMethodVarargs("union"){

        @Override
        public PyObject __call__(PyObject[] others) {
            return this.makePySet(this.union(JavaProxySet.getCombinedJavaCollections(others)));
        }
    };
    private static final SetMethod updateProxy = new SetMethodVarargs("update"){

        @Override
        public PyObject __call__(PyObject[] others) {
            this.update(JavaProxySet.getCombinedJavaCollections(others));
            return Py.None;
        }
    };
    private static final SetMethod orProxy = new SetMethod("__or__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            return this.makePySet(this.union(JavaProxySet.getJavaSet(this.self, "|", other)));
        }
    };
    private static final SetMethod iorProxy = new SetMethod("__ior__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            this.update(JavaProxySet.getJavaSet(this.self, "|=", other));
            return this.self;
        }
    };
    private static final SetMethod deepcopyOverrideProxy = new SetMethod("__deepcopy__", 1){

        @Override
        public PyObject __call__(PyObject memo) {
            HashSet<Object> newSet = new HashSet<Object>();
            for (Object obj : this.asSet()) {
                PyObject pyobj = Py.java2py(obj);
                PyObject newobj = pyobj.invoke("__deepcopy__", memo);
                newSet.add(newobj.__tojava__(Object.class));
            }
            return this.makePySet(newSet);
        }
    };
    private static final SetMethod reduceProxy = new SetMethod("__reduce__", 0){

        @Override
        public PyObject __call__() {
            PyTuple args = new PyTuple(new PyList(new JavaIterator(this.asSet())));
            PyObject dict = this.__findattr__("__dict__");
            if (dict == null) {
                dict = Py.None;
            }
            return new PyTuple(this.self.getType(), args, dict);
        }
    };
    private static final SetMethod containsProxy = new SetMethod("__contains__", 1){

        @Override
        public PyObject __call__(PyObject value) {
            return Py.newBoolean(this.asSet().contains(value.__tojava__(Object.class)));
        }
    };
    private static final SetMethod hashProxy = new SetMethod("__hash__", 0){

        @Override
        public PyObject __call__(PyObject value) {
            throw Py.TypeError(String.format("unhashable type: '%.200s'", this.self.getType().fastGetName()));
        }
    };
    private static final SetMethod discardProxy = new SetMethod("discard", 1){

        @Override
        public PyObject __call__(PyObject value) {
            this.asSet().remove(value.__tojava__(Object.class));
            return Py.None;
        }
    };
    private static final SetMethod popProxy = new SetMethod("pop", 0){

        @Override
        public PyObject __call__() {
            Set<Object> selfSet = this.asSet();
            Iterator<Object> it = selfSet instanceof NavigableSet ? ((NavigableSet)selfSet).descendingIterator() : selfSet.iterator();
            try {
                PyObject value = Py.java2py(it.next());
                it.remove();
                return value;
            }
            catch (NoSuchElementException ex) {
                throw Py.KeyError("pop from an empty set");
            }
        }
    };
    private static final SetMethod removeOverrideProxy = new SetMethod("remove", 1){

        @Override
        public PyObject __call__(PyObject value) {
            boolean removed = this.asSet().remove(value.__tojava__(Object.class));
            if (!removed) {
                throw Py.KeyError(value);
            }
            return Py.None;
        }
    };

    JavaProxySet() {
    }

    private static boolean isPySet(PyObject obj) {
        PyType type = obj.getType();
        return type.isSubType(PySet.TYPE) || type.isSubType(PyFrozenSet.TYPE);
    }

    private static Collection<Object> getJavaSet(PyObject self, String op, PyObject obj) {
        ArrayList<Object> items;
        if (JavaProxySet.isPySet(obj)) {
            Set<PyObject> otherPySet = ((BaseSet)obj).getSet();
            items = new ArrayList(otherPySet.size());
            for (PyObject pyobj : otherPySet) {
                items.add(pyobj.__tojava__(Object.class));
            }
        } else {
            Object oj = obj.getJavaProxy();
            if (oj instanceof Set) {
                Set jSet = (Set)oj;
                items = jSet;
            } else {
                throw Py.TypeError(String.format("unsupported operand type(s) for %s: '%.200s' and '%.200s'", op, self.getType().fastGetName(), obj.getType().fastGetName()));
            }
        }
        return items;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Collection<Object> getJavaCollection(PyObject obj) {
        HashSet<Object> items;
        Object oj = obj.getJavaProxy();
        if (oj != null) {
            if (oj instanceof Collection) {
                Collection jCollection = (Collection)oj;
                return jCollection;
            }
            if (!(oj instanceof Iterable)) throw Py.TypeError(String.format("unsupported operand type(s): '%.200s'", obj.getType().fastGetName()));
            items = new HashSet();
            Iterator iterator = ((Iterable)oj).iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                items.add(item);
            }
            return items;
        }
        items = new HashSet();
        Iterator<PyObject> iterator = obj.asIterable().iterator();
        while (iterator.hasNext()) {
            PyObject pyobj = iterator.next();
            items.add(pyobj.__tojava__(Object.class));
        }
        return items;
    }

    private static Collection<Object>[] getJavaCollections(PyObject[] objs) {
        Collection[] collections = new Collection[objs.length];
        int i = 0;
        for (PyObject obj : objs) {
            collections[i++] = JavaProxySet.getJavaCollection(obj);
        }
        return collections;
    }

    private static Collection<Object> getCombinedJavaCollections(PyObject[] objs) {
        if (objs.length == 0) {
            return Collections.emptyList();
        }
        if (objs.length == 1) {
            return JavaProxySet.getJavaCollection(objs[0]);
        }
        HashSet<Object> items = new HashSet<Object>();
        for (PyObject obj : objs) {
            Object oj = obj.getJavaProxy();
            if (oj != null) {
                if (oj instanceof Iterable) {
                    for (PyObject item : (Iterable)oj) {
                        items.add(item);
                    }
                    continue;
                }
                throw Py.TypeError(String.format("unsupported operand type(s): '%.200s'", obj.getType().fastGetName()));
            }
            for (PyObject pyobj : obj.asIterable()) {
                items.add(pyobj.__tojava__(Object.class));
            }
        }
        return items;
    }

    static PyBuiltinMethod[] getProxyMethods() {
        return new PyBuiltinMethod[]{cmpProxy, eqProxy, ltProxy, new IsSubsetMethod("__le__"), new IsSubsetMethod("issubset"), new IsSupersetMethod("__ge__"), new IsSupersetMethod("issuperset"), gtProxy, isDisjointProxy, differenceProxy, differenceUpdateProxy, subProxy, isubProxy, intersectionProxy, intersectionUpdateProxy, andProxy, iandProxy, symDiffProxy, symDiffUpdateProxy, xorProxy, ixorProxy, unionProxy, updateProxy, orProxy, iorProxy, new CopyMethod("copy"), new CopyMethod("__copy__"), reduceProxy, containsProxy, hashProxy, discardProxy, popProxy};
    }

    static PyBuiltinMethod[] getPostProxyMethods() {
        return new PyBuiltinMethod[]{deepcopyOverrideProxy, removeOverrideProxy};
    }

    @Untraversable
    private static class CopyMethod
    extends SetMethod {
        protected CopyMethod(String name) {
            super(name, 0);
        }

        @Override
        public PyObject __call__() {
            return this.makePySet(this.asSet());
        }
    }

    @Untraversable
    private static class IsSupersetMethod
    extends SetMethod {
        protected IsSupersetMethod(String name) {
            super(name, 1);
        }

        @Override
        public PyObject __call__(PyObject other) {
            return Py.newBoolean(this.isSuperset(other));
        }
    }

    @Untraversable
    private static class IsSubsetMethod
    extends SetMethod {
        protected IsSubsetMethod(String name) {
            super(name, 1);
        }

        @Override
        public PyObject __call__(PyObject other) {
            return Py.newBoolean(this.isSubset(other));
        }
    }

    @Untraversable
    private static class SetMethodVarargs
    extends SetMethod {
        protected SetMethodVarargs(String name) {
            super(name, 0, -1);
        }

        @Override
        public PyObject __call__() {
            return this.__call__(Py.EmptyObjects);
        }

        @Override
        public PyObject __call__(PyObject obj) {
            return this.__call__(new PyObject[]{obj});
        }

        @Override
        public PyObject __call__(PyObject obj1, PyObject obj2) {
            return this.__call__(new PyObject[]{obj1, obj2});
        }

        @Override
        public PyObject __call__(PyObject obj1, PyObject obj2, PyObject obj3) {
            return this.__call__(new PyObject[]{obj1, obj2, obj3});
        }

        @Override
        public PyObject __call__(PyObject obj1, PyObject obj2, PyObject obj3, PyObject obj4) {
            return this.__call__(new PyObject[]{obj1, obj2, obj3, obj4});
        }
    }

    @Untraversable
    private static class SetMethod
    extends PyBuiltinMethodNarrow {
        protected SetMethod(String name, int numArgs) {
            super(name, numArgs);
        }

        protected SetMethod(String name, int minArgs, int maxArgs) {
            super(name, minArgs, maxArgs);
        }

        protected Set<Object> asSet() {
            return (Set)this.self.getJavaProxy();
        }

        protected PyObject makePySet(Set newSet) {
            PyObject newPySet = this.self.getType().__call__();
            Set jSet = (Set)newPySet.getJavaProxy();
            jSet.addAll(newSet);
            return newPySet;
        }

        public boolean isEqual(PyObject other) {
            Set<Object> selfSet = this.asSet();
            Object oj = other.getJavaProxy();
            if (oj != null && oj instanceof Set) {
                Set otherSet = (Set)oj;
                if (selfSet.size() != otherSet.size()) {
                    return false;
                }
                return selfSet.containsAll(otherSet);
            }
            if (JavaProxySet.isPySet(other)) {
                Set<PyObject> otherPySet = ((BaseSet)other).getSet();
                if (selfSet.size() != otherPySet.size()) {
                    return false;
                }
                for (PyObject pyobj : otherPySet) {
                    if (selfSet.contains(pyobj.__tojava__(Object.class))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean isSuperset(PyObject other) {
            Set<Object> selfSet = this.asSet();
            Object oj = other.getJavaProxy();
            if (oj != null && oj instanceof Set) {
                Set otherSet = (Set)oj;
                return selfSet.containsAll(otherSet);
            }
            if (JavaProxySet.isPySet(other)) {
                Set<PyObject> otherPySet = ((BaseSet)other).getSet();
                for (PyObject pyobj : otherPySet) {
                    if (selfSet.contains(pyobj.__tojava__(Object.class))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean isSubset(PyObject other) {
            Set<Object> selfSet = this.asSet();
            Object oj = other.getJavaProxy();
            if (oj != null && oj instanceof Set) {
                Set otherSet = (Set)oj;
                return otherSet.containsAll(selfSet);
            }
            if (JavaProxySet.isPySet(other)) {
                Set<PyObject> otherPySet = ((BaseSet)other).getSet();
                for (Object obj : selfSet) {
                    if (otherPySet.contains(Py.java2py(obj))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        protected Set difference(Collection<Object> other) {
            Set<Object> selfSet = this.asSet();
            HashSet<Object> diff = new HashSet<Object>(selfSet);
            diff.removeAll(other);
            return diff;
        }

        protected void differenceUpdate(Collection other) {
            this.asSet().removeAll(other);
        }

        protected Set intersect(Collection[] others) {
            Set<Object> selfSet = this.asSet();
            HashSet<Object> intersection = new HashSet<Object>(selfSet);
            for (Collection other : others) {
                intersection.retainAll(other);
            }
            return intersection;
        }

        protected void intersectUpdate(Collection[] others) {
            Set<Object> selfSet = this.asSet();
            for (Collection other : others) {
                selfSet.retainAll(other);
            }
        }

        protected Set union(Collection<Object> other) {
            Set<Object> selfSet = this.asSet();
            HashSet<Object> u = new HashSet<Object>(selfSet);
            u.addAll(other);
            return u;
        }

        protected void update(Collection<Object> other) {
            this.asSet().addAll(other);
        }

        protected Set symDiff(Collection<Object> other) {
            Set<Object> selfSet = this.asSet();
            HashSet<Object> symDiff = new HashSet<Object>(selfSet);
            symDiff.addAll(other);
            HashSet<Object> intersection = new HashSet<Object>(selfSet);
            intersection.retainAll(other);
            symDiff.removeAll(intersection);
            return symDiff;
        }

        protected void symDiffUpdate(Collection<Object> other) {
            Set<Object> selfSet = this.asSet();
            HashSet<Object> intersection = new HashSet<Object>(selfSet);
            intersection.retainAll(other);
            selfSet.addAll(other);
            selfSet.removeAll(intersection);
        }
    }
}

