/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.ArrayUtil;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.keyFMap.MapBackedFMap;
import com.intellij.util.keyFMap.OneElementFMap;
import com.intellij.util.keyFMap.PairElementsFMap;
import org.jetbrains.annotations.NotNull;

public class ArrayBackedFMap
implements KeyFMap {
    private final int[] keys;
    private final Object[] values;

    ArrayBackedFMap(@NotNull int[] keys, @NotNull Object[] values) {
        if (keys == null) {
            ArrayBackedFMap.$$$reportNull$$$0(0);
        }
        if (values == null) {
            ArrayBackedFMap.$$$reportNull$$$0(1);
        }
        this.keys = keys;
        this.values = values;
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        int keyCode;
        int keyPos;
        if (key == null) {
            ArrayBackedFMap.$$$reportNull$$$0(2);
        }
        if (value == null) {
            ArrayBackedFMap.$$$reportNull$$$0(3);
        }
        if ((keyPos = this.indexOf(keyCode = key.hashCode())) >= 0) {
            if (this.values[keyPos] == value) {
                ArrayBackedFMap arrayBackedFMap = this;
                if (arrayBackedFMap == null) {
                    ArrayBackedFMap.$$$reportNull$$$0(4);
                }
                return arrayBackedFMap;
            }
            Object[] newValues = (Object[])this.values.clone();
            newValues[keyPos] = value;
            ArrayBackedFMap arrayBackedFMap = new ArrayBackedFMap(this.keys, newValues);
            if (arrayBackedFMap == null) {
                ArrayBackedFMap.$$$reportNull$$$0(5);
            }
            return arrayBackedFMap;
        }
        if (this.size() < 8) {
            int[] newKeys = ArrayUtil.insert(this.keys, -keyPos - 1, keyCode);
            Object[] newValues = ArrayUtil.insert(this.values, -keyPos - 1, value);
            ArrayBackedFMap arrayBackedFMap = new ArrayBackedFMap(newKeys, newValues);
            if (arrayBackedFMap == null) {
                ArrayBackedFMap.$$$reportNull$$$0(6);
            }
            return arrayBackedFMap;
        }
        MapBackedFMap mapBackedFMap = new MapBackedFMap(this.keys, keyCode, this.values, value);
        if (mapBackedFMap == null) {
            ArrayBackedFMap.$$$reportNull$$$0(7);
        }
        return mapBackedFMap;
    }

    public int size() {
        return this.keys.length;
    }

    private int indexOf(int keyCode) {
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            if (key == keyCode) {
                return i;
            }
            if (key <= keyCode) continue;
            return -i - 1;
        }
        return -this.keys.length - 1;
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        int i;
        if (key == null) {
            ArrayBackedFMap.$$$reportNull$$$0(8);
        }
        if ((i = this.indexOf(key.hashCode())) >= 0) {
            if (this.size() == 3) {
                int i1 = (2 - i) / 2;
                int i2 = 3 - (i + 2) / 2;
                Key key1 = Key.getKeyByIndex(this.keys[i1]);
                Key key2 = Key.getKeyByIndex(this.keys[i2]);
                if (key1 == null && key2 == null) {
                    KeyFMap keyFMap = EMPTY_MAP;
                    if (keyFMap == null) {
                        ArrayBackedFMap.$$$reportNull$$$0(9);
                    }
                    return keyFMap;
                }
                if (key1 == null) {
                    OneElementFMap oneElementFMap = new OneElementFMap(key2, this.values[i2]);
                    if (oneElementFMap == null) {
                        ArrayBackedFMap.$$$reportNull$$$0(10);
                    }
                    return oneElementFMap;
                }
                if (key2 == null) {
                    OneElementFMap oneElementFMap = new OneElementFMap(key1, this.values[i1]);
                    if (oneElementFMap == null) {
                        ArrayBackedFMap.$$$reportNull$$$0(11);
                    }
                    return oneElementFMap;
                }
                PairElementsFMap pairElementsFMap = new PairElementsFMap(key1, this.values[i1], key2, this.values[i2]);
                if (pairElementsFMap == null) {
                    ArrayBackedFMap.$$$reportNull$$$0(12);
                }
                return pairElementsFMap;
            }
            int[] newKeys = ArrayUtil.remove(this.keys, i);
            Object[] newValues = ArrayUtil.remove(this.values, i, ArrayUtil.OBJECT_ARRAY_FACTORY);
            ArrayBackedFMap arrayBackedFMap = new ArrayBackedFMap(newKeys, newValues);
            if (arrayBackedFMap == null) {
                ArrayBackedFMap.$$$reportNull$$$0(13);
            }
            return arrayBackedFMap;
        }
        ArrayBackedFMap arrayBackedFMap = this;
        if (arrayBackedFMap == null) {
            ArrayBackedFMap.$$$reportNull$$$0(14);
        }
        return arrayBackedFMap;
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        int i;
        if (key == null) {
            ArrayBackedFMap.$$$reportNull$$$0(15);
        }
        return (V)((i = this.indexOf(key.hashCode())) < 0 ? null : this.values[i]);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("{");
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            Object value = this.values[i];
            s.append(s.length() == 1 ? "" : ", ").append(Key.getKeyByIndex(key)).append("=").append(value);
        }
        return s.append("}").toString();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    @NotNull
    public Key[] getKeys() {
        Key[] keyArray = ArrayBackedFMap.getKeysByIndices(this.keys);
        if (keyArray == null) {
            ArrayBackedFMap.$$$reportNull$$$0(16);
        }
        return keyArray;
    }

    @NotNull
    static Key[] getKeysByIndices(int[] indexes) {
        Key[] result2 = new Key[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            result2[i] = Key.getKeyByIndex(indexes[i]);
        }
        if (result2 == null) {
            ArrayBackedFMap.$$$reportNull$$$0(17);
        }
        return result2;
    }

    public int hashCode() {
        int hash = 0;
        int length = this.keys.length;
        for (int i = 0; i < length; ++i) {
            hash += this.keys[i] ^ this.values[i].hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayBackedFMap)) {
            return false;
        }
        ArrayBackedFMap map2 = (ArrayBackedFMap)o;
        if (map2.size() != this.size()) {
            return false;
        }
        int length = this.keys.length;
        for (int i = 0; i < length; ++i) {
            if (this.keys[i] == map2.keys[i] && this.values[i].equals(map2.values[i])) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 2: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/keyFMap/ArrayBackedFMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/keyFMap/ArrayBackedFMap";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "plus";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeysByIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "plus";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "minus";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

