/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.gosen;

import java.io.IOException;
import java.io.Reader;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.java.sen.StringTagger;
import net.java.sen.dictionary.Token;
import org.apache.lucene.analysis.gosen.CharArrayIterator;

public final class StreamTagger2 {
    private static final int IOBUFFER = 4096;
    private final char[] buffer = new char[4096];
    private int length = 0;
    private int usableLength = 0;
    private int offset = 0;
    private StringTagger tagger;
    private Reader input;
    private final BreakIterator breaker = BreakIterator.getSentenceInstance(Locale.JAPANESE);
    private final CharArrayIterator iterator = new CharArrayIterator();
    private List<Token> tokens = new ArrayList<Token>();
    private int index = 0;

    public StreamTagger2(StringTagger tagger, Reader input) {
        this.tagger = tagger;
        this.input = input;
    }

    public Token next() throws IOException {
        if (this.tokens == null || this.index >= this.tokens.size()) {
            if (this.length == 0) {
                this.refill();
            }
            while (!this.incrementTokenBuffer()) {
                this.refill();
                if (this.length > 0) continue;
                return null;
            }
        }
        return this.tokens.get(this.index++);
    }

    public void reset() throws IOException {
        this.iterator.setText(this.buffer, 0, 0);
        this.breaker.setText(this.iterator);
        this.index = 0;
        this.offset = 0;
        this.usableLength = 0;
        this.length = 0;
        this.tokens.clear();
    }

    public void reset(Reader input) throws IOException {
        this.input = input;
        this.reset();
    }

    public int end() throws IOException {
        return this.length < 0 ? this.offset : this.offset + this.length;
    }

    private int findSafeEnd() {
        for (int i = this.length - 1; i >= 0; --i) {
            if (!this.isSafeEnd(this.buffer[i])) continue;
            return i + 1;
        }
        return -1;
    }

    private boolean isSafeEnd(char ch) {
        switch (ch) {
            case '\n': 
            case '\r': 
            case '\u0085': 
            case '\u2028': 
            case '\u2029': {
                return true;
            }
        }
        return false;
    }

    private void refill() throws IOException {
        this.offset += this.usableLength;
        int leftover = this.length - this.usableLength;
        System.arraycopy(this.buffer, this.usableLength, this.buffer, 0, leftover);
        int requested = this.buffer.length - leftover;
        int returned = StreamTagger2.read(this.input, this.buffer, leftover, requested);
        int n = this.length = returned < 0 ? leftover : returned + leftover;
        if (returned < requested) {
            this.usableLength = this.length;
        } else {
            this.usableLength = this.findSafeEnd();
            if (this.usableLength < 0) {
                this.usableLength = this.length;
            }
        }
        this.iterator.setText(this.buffer, 0, Math.max(0, this.usableLength));
        this.breaker.setText(this.iterator);
    }

    private static int read(Reader input, char[] buffer, int offset, int length) throws IOException {
        int location;
        int remaining;
        int count;
        assert (length >= 0) : "length must not be negative: " + length;
        for (remaining = length; remaining > 0 && -1 != (count = input.read(buffer, offset + (location = length - remaining), remaining)); remaining -= count) {
        }
        return length - remaining;
    }

    private boolean incrementTokenBuffer() throws IOException {
        int start;
        do {
            if ((start = this.breaker.current()) == -1) {
                return false;
            }
            int end = this.breaker.next();
            if (end == -1) {
                return false;
            }
            String text = new String(this.buffer, start, end - start);
            this.tokens = this.tagger.analyze(text, this.tokens);
        } while (this.tokens == null || this.tokens.isEmpty());
        for (int i = 0; i < this.tokens.size(); ++i) {
            Token token = this.tokens.get(i);
            token.setSentenceStart(i == 0);
            token.setStart(token.getStart() + start + this.offset);
        }
        this.index = 0;
        return true;
    }
}

