/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleArrayRetained;
import javax.media.j3d.UnorderList;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class Font3D
extends NodeComponent {
    Font font;
    double tessellationTolerance;
    FontExtrusion fontExtrusion;
    FontRenderContext frc;
    static final float EPS = 1.0E-6f;
    Hashtable<Character, GeometryArrayRetained> geomHash = new Hashtable(20);

    public Font3D(Font font, FontExtrusion fontExtrusion) {
        this(font, 0.01, fontExtrusion);
    }

    public Font3D(Font font, double d, FontExtrusion fontExtrusion) {
        this.font = font;
        this.tessellationTolerance = d;
        this.fontExtrusion = fontExtrusion;
        this.frc = new FontRenderContext(new AffineTransform(), true, true);
    }

    public Font getFont() {
        return this.font;
    }

    public double getTessellationTolerance() {
        return this.tessellationTolerance;
    }

    public void getFontExtrusion(FontExtrusion fontExtrusion) {
        fontExtrusion = this.fontExtrusion;
    }

    public void getBoundingBox(int n, BoundingBox boundingBox) {
        int[] nArray = new int[]{n};
        GlyphVector glyphVector = this.font.createGlyphVector(this.frc, nArray);
        Rectangle2D.Float float_ = (Rectangle2D.Float)glyphVector.getGlyphMetrics(0).getBounds2D();
        Point3d point3d = new Point3d((double)float_.x, (double)float_.y, 0.0);
        Point3d point3d2 = this.fontExtrusion != null ? new Point3d((double)(float_.x + float_.width), (double)(float_.y + float_.height), (double)this.fontExtrusion.length) : new Point3d((double)(float_.x + float_.width), (double)(float_.y + float_.height), 0.0);
        boundingBox.setLower(point3d);
        boundingBox.setUpper(point3d2);
    }

    public GeometryArray getGlyphGeometry(char c) {
        char[] cArray = new char[]{c};
        GlyphVector glyphVector = this.font.createGlyphVector(this.frc, cArray);
        GeometryArrayRetained geometryArrayRetained = this.triangulateGlyphs(glyphVector, cArray[0]);
        assert (geometryArrayRetained instanceof TriangleArrayRetained) : "Font3D: GeometryArray is not an instance of TrangleArray";
        assert (geometryArrayRetained.getVertexFormat() == 3) : "Font3D: Illegal GeometryArray format -- only coordinates and normals expected";
        TriangleArray triangleArray = new TriangleArray(geometryArrayRetained.getVertexCount(), geometryArrayRetained.getVertexFormat());
        float[] fArray = new float[3];
        int n = triangleArray.getVertexCount();
        for (int i = 0; i < n; ++i) {
            geometryArrayRetained.getCoordinate(i, fArray);
            triangleArray.setCoordinate(i, fArray);
            geometryArrayRetained.getNormal(i, fArray);
            triangleArray.setNormal(i, fArray);
        }
        return triangleArray;
    }

    GeometryArrayRetained triangulateGlyphs(GlyphVector glyphVector, char c) {
        GeometryArrayRetained geometryArrayRetained;
        block84: {
            Object object;
            TriangleArray triangleArray;
            int n;
            int n2;
            int n3;
            Point3f point3f;
            Character c2 = new Character(c);
            geometryArrayRetained = this.geomHash.get(c2);
            if (geometryArrayRetained != null) break block84;
            Rectangle2D rectangle2D = glyphVector.getVisualBounds();
            AffineTransform affineTransform = new AffineTransform();
            double d = rectangle2D.getX() + 0.5 * rectangle2D.getWidth();
            double d2 = rectangle2D.getY() + 0.5 * rectangle2D.getHeight();
            affineTransform.setToTranslation(-d, -d2);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(d, -d2);
            Shape shape = glyphVector.getOutline();
            PathIterator pathIterator = shape.getPathIterator(affineTransform, this.tessellationTolerance);
            int n4 = -1;
            int n5 = 0;
            int n6 = 0;
            UnorderList unorderList = new UnorderList(100, Point3f.class);
            float[] fArray = new float[6];
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = Float.MAX_VALUE;
            float f4 = Float.MAX_VALUE;
            IntVector intVector = new IntVector();
            float f5 = -3.4028235E38f;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            boolean bl = false;
            while (!pathIterator.isDone()) {
                point3f = new Point3f();
                n4 = pathIterator.currentSegment(fArray);
                if (n4 == 4) {
                    if (n6 > 0) {
                        if (bl) {
                            n8 = n10;
                            n9 = n5 - 1;
                        }
                        intVector.add(n6);
                        n6 = 0;
                    }
                } else if (n4 == 0) {
                    point3f.x = fArray[0];
                    point3f.y = fArray[1];
                    f = point3f.x;
                    f2 = point3f.y;
                    if (f == f3 && f2 == f4) {
                        pathIterator.next();
                        continue;
                    }
                    bl = false;
                    unorderList.add(point3f);
                    f3 = f;
                    f4 = f2;
                    if (n6 > 0) {
                        intVector.add(n6);
                        n6 = 0;
                    }
                    ++n6;
                    n10 = ++n5;
                } else if (n4 == 1) {
                    point3f.x = fArray[0];
                    point3f.y = fArray[1];
                    if (point3f.x == f && point3f.y == f2) {
                        pathIterator.next();
                        continue;
                    }
                    if (point3f.y > f5) {
                        f5 = point3f.y;
                        n7 = n5;
                        bl = true;
                    }
                    f = point3f.x;
                    f2 = point3f.y;
                    unorderList.add(point3f);
                    ++n6;
                    ++n5;
                }
                pathIterator.next();
            }
            if (n5 == 0) {
                return null;
            }
            point3f = new Point3f();
            Point3f point3f2 = new Point3f();
            Point3f point3f3 = new Point3f();
            boolean bl2 = true;
            Point3f[] point3fArray = (Point3f[])unorderList.toArray(false);
            if (n9 - n8 > 0) {
                if (n7 == n8) {
                    point3f.set((Tuple3f)point3fArray[n9]);
                } else {
                    point3f.set((Tuple3f)point3fArray[n7 - 1]);
                }
                point3f2.set((Tuple3f)point3fArray[n7]);
                if (n7 == n9) {
                    point3f3.set((Tuple3f)point3fArray[n8]);
                } else {
                    point3f3.set((Tuple3f)point3fArray[n7 + 1]);
                }
                bl2 = point3f3.x != point3f2.x ? (point3f.x != point3f2.x ? (Math.abs((point3f2.y - point3f.y) / (point3f2.x - point3f.x)) > Math.abs((point3f3.y - point3f2.y) / (point3f3.x - point3f2.x)) ? point3f3.x > point3f2.x : point3f2.x > point3f.x) : point3f3.x > point3f2.x) : point3f2.x > point3f.x;
            }
            int n11 = 0;
            IslandsNode islandsNode = new IslandsNode(-1, -1);
            for (int i = 0; i < intVector.size; ++i) {
                n9 = n11 + intVector.data[i];
                islandsNode.insert(new IslandsNode(n11, n9), point3fArray);
                n11 = n9;
            }
            unorderList = null;
            intVector = null;
            UnorderList unorderList2 = new UnorderList(10, IslandsNode.class);
            islandsNode.collectOddLevelNode(unorderList2, 0);
            IslandsNode[] islandsNodeArray = (IslandsNode[])unorderList2.toArray(false);
            int[][] nArrayArray = new int[unorderList2.arraySize()][];
            Point3f[][] point3fArrayArray = new Point3f[nArrayArray.length][];
            for (n3 = 0; n3 < nArrayArray.length; ++n3) {
                IslandsNode islandsNode2 = islandsNodeArray[n3];
                int n12 = islandsNode2.numChild();
                nArrayArray[n3] = new int[n12 + 1];
                nArrayArray[n3][0] = islandsNode2.numVertices();
                int n13 = 0;
                n13 += nArrayArray[n3][0];
                for (n2 = 0; n2 < n12; ++n2) {
                    nArrayArray[n3][n2 + 1] = islandsNode2.getChild(n2).numVertices();
                    n13 += nArrayArray[n3][n2 + 1];
                }
                point3fArrayArray[n3] = new Point3f[n13];
                n11 = 0;
                for (n = islandsNode2.startIdx; n < islandsNode2.endIdx; ++n) {
                    point3fArrayArray[n3][n11++] = point3fArray[n];
                }
                for (n2 = 0; n2 < n12; ++n2) {
                    n9 = islandsNode2.getChild((int)n2).endIdx;
                    for (n = islandsNode2.getChild((int)n2).startIdx; n < n9; ++n) {
                        point3fArrayArray[n3][n11++] = point3fArray[n];
                    }
                }
            }
            islandsNode = null;
            unorderList2 = null;
            point3fArray = null;
            int[] nArray = new int[1];
            int n14 = 0;
            int n15 = 0;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Point3f point3f4 = new Point3f();
            Point3f point3f5 = new Point3f();
            Point3f point3f6 = new Point3f();
            Vector3f vector3f = new Vector3f();
            Vector3f vector3f2 = new Vector3f();
            n5 = 0;
            NormalGenerator normalGenerator = new NormalGenerator();
            for (n3 = 0; n3 < nArrayArray.length; ++n3) {
                nArray[0] = nArrayArray[n3].length;
                n5 += point3fArrayArray[n3].length;
                triangleArray = new GeometryInfo(5);
                triangleArray.setCoordinates(point3fArrayArray[n3]);
                triangleArray.setStripCounts(nArrayArray[n3]);
                triangleArray.setContourCounts(nArray);
                normalGenerator.generateNormals((GeometryInfo)triangleArray);
                object = triangleArray.getGeometryArray(false, false, false);
                n15 += ((GeometryArray)object).getVertexCount();
                arrayList.add(object);
            }
            int n16 = this.fontExtrusion == null ? n15 : (this.fontExtrusion.shape == null ? n15 * 2 + n5 * 6 : n15 * 2 + n5 * 6 * (this.fontExtrusion.pnts.length - 1));
            triangleArray = new TriangleArray(n16, 3);
            object = new boolean[nArrayArray.length];
            Vector3f vector3f3 = new Vector3f();
            for (n2 = 0; n2 < nArrayArray.length; ++n2) {
                GeometryArray geometryArray = (GeometryArray)arrayList.get(n2);
                n15 = geometryArray.getVertexCount();
                boolean bl3 = false;
                n3 = 0;
                while (n3 < n15) {
                    block86: {
                        block85: {
                            block88: {
                                block87: {
                                    geometryArray.getCoordinate(n3, point3f);
                                    geometryArray.getNormal(n3, vector3f);
                                    geometryArray.getCoordinate(n3 + 1, point3f2);
                                    geometryArray.getCoordinate(n3 + 2, point3f3);
                                    if (bl3) break block85;
                                    if (!Font3D.getNormal(point3f, point3f2, point3f3, vector3f2)) break block86;
                                    if (!(vector3f2.z >= 1.0E-6f)) break block87;
                                    object[n2] = false;
                                    break block88;
                                }
                                if (!(vector3f2.z <= -1.0E-6f)) break block86;
                                object[n2] = true;
                            }
                            bl3 = true;
                        }
                        if (object[n2] != false) {
                            point3f4.x = point3f2.x;
                            point3f4.y = point3f2.y;
                            point3f4.z = point3f2.z;
                            point3f2.x = point3f3.x;
                            point3f2.y = point3f3.y;
                            point3f2.z = point3f3.z;
                            point3f3.x = point3f4.x;
                            point3f3.y = point3f4.y;
                            point3f3.z = point3f4.z;
                            vector3f.x = -vector3f.x;
                            vector3f.y = -vector3f.y;
                            vector3f.z = -vector3f.z;
                        }
                        if (this.fontExtrusion != null) {
                            vector3f2.x = -vector3f.x;
                            vector3f2.y = -vector3f.y;
                            vector3f2.z = -vector3f.z;
                            triangleArray.setCoordinate(n14, point3f);
                            triangleArray.setNormal(n14, vector3f2);
                            triangleArray.setCoordinate(n14 + 1, point3f3);
                            triangleArray.setNormal(n14 + 1, vector3f2);
                            triangleArray.setCoordinate(n14 + 2, point3f2);
                            triangleArray.setNormal(n14 + 2, vector3f2);
                            point3f4.x = point3f.x;
                            point3f4.y = point3f.y;
                            point3f4.z = point3f.z + this.fontExtrusion.length;
                            point3f5.x = point3f2.x;
                            point3f5.y = point3f2.y;
                            point3f5.z = point3f2.z + this.fontExtrusion.length;
                            point3f6.x = point3f3.x;
                            point3f6.y = point3f3.y;
                            point3f6.z = point3f3.z + this.fontExtrusion.length;
                            triangleArray.setCoordinate(n14 + n15, point3f4);
                            triangleArray.setNormal(n14 + n15, vector3f);
                            triangleArray.setCoordinate(n14 + 1 + n15, point3f5);
                            triangleArray.setNormal(n14 + 1 + n15, vector3f);
                            triangleArray.setCoordinate(n14 + 2 + n15, point3f6);
                            triangleArray.setNormal(n14 + 2 + n15, vector3f);
                        } else {
                            triangleArray.setCoordinate(n14, point3f);
                            triangleArray.setNormal(n14, vector3f);
                            triangleArray.setCoordinate(n14 + 1, point3f2);
                            triangleArray.setNormal(n14 + 1, vector3f);
                            triangleArray.setCoordinate(n14 + 2, point3f3);
                            triangleArray.setNormal(n14 + 2, vector3f);
                        }
                    }
                    n3 += 3;
                    n14 += 3;
                }
                if (this.fontExtrusion == null) continue;
                n14 += n15;
            }
            if (this.fontExtrusion != null) {
                if (this.fontExtrusion.shape == null) {
                    float f6 = (float)Math.cos(0.767944870877505);
                    Vector3f vector3f4 = null;
                    Vector3f vector3f5 = null;
                    Vector3f vector3f6 = new Vector3f();
                    Vector3f vector3f7 = new Vector3f();
                    Vector3f vector3f8 = new Vector3f();
                    Vector3f vector3f9 = new Vector3f();
                    Vector3f vector3f10 = new Vector3f();
                    Vector3f vector3f11 = new Vector3f();
                    Vector3f vector3f12 = new Vector3f();
                    Vector3f vector3f13 = new Vector3f();
                    for (n3 = 0; n3 < nArrayArray.length; ++n3) {
                        n = 0;
                        n6 = 0;
                        for (n2 = 0; n2 < nArrayArray[n3].length; ++n2) {
                            point3f.x = point3fArrayArray[n3][(n6 += nArrayArray[n3][n2]) - 1].x;
                            point3f.y = point3fArrayArray[n3][n6 - 1].y;
                            point3f.z = 0.0f;
                            point3f4.x = point3f.x;
                            point3f4.y = point3f.y;
                            point3f4.z = point3f.z + this.fontExtrusion.length;
                            point3f2.z = 0.0f;
                            point3f5.z = point3f2.z + this.fontExtrusion.length;
                            for (int i = 0; i < n6; ++i) {
                                point3f2.x = point3fArrayArray[n3][i].x;
                                point3f2.y = point3fArrayArray[n3][i].y;
                                point3f5.x = point3f2.x;
                                point3f5.y = point3f2.y;
                                if (!Font3D.getNormal(point3f, point3f4, point3f2, vector3f)) continue;
                                if (!bl2) {
                                    vector3f.negate();
                                }
                                vector3f3.set((Tuple3f)vector3f);
                                break;
                            }
                            while (n < n6) {
                                boolean bl4;
                                float f7;
                                point3f2.x = point3fArrayArray[n3][n].x;
                                point3f2.y = point3fArrayArray[n3][n].y;
                                point3f2.z = 0.0f;
                                point3f5.x = point3f2.x;
                                point3f5.y = point3f2.y;
                                point3f5.z = point3f2.z + this.fontExtrusion.length;
                                if (!Font3D.getNormal(point3f, point3f4, point3f2, vector3f)) {
                                    vector3f.set((Tuple3f)vector3f3);
                                } else {
                                    if (!bl2) {
                                        vector3f.negate();
                                    }
                                    vector3f3.set((Tuple3f)vector3f);
                                }
                                if (!Font3D.getNormal(point3f2, point3f4, point3f5, vector3f2)) {
                                    vector3f2.set((Tuple3f)vector3f3);
                                } else {
                                    if (!bl2) {
                                        vector3f2.negate();
                                    }
                                    vector3f3.set((Tuple3f)vector3f2);
                                }
                                if (vector3f4 != null) {
                                    f7 = vector3f.dot(vector3f5);
                                    boolean bl5 = bl4 = f7 > f6;
                                    if (bl4) {
                                        vector3f8.x = vector3f4.x + vector3f5.x + vector3f.x;
                                        vector3f8.y = vector3f4.y + vector3f5.y + vector3f.y;
                                        vector3f8.z = vector3f4.z + vector3f5.z + vector3f.z;
                                        Font3D.normalize(vector3f8);
                                        vector3f11.x = vector3f5.x + vector3f.x + vector3f2.x;
                                        vector3f11.y = vector3f5.y + vector3f.y + vector3f2.y;
                                        vector3f11.z = vector3f5.z + vector3f.z + vector3f2.z;
                                        Font3D.normalize(vector3f11);
                                    } else {
                                        vector3f8.x = vector3f.x;
                                        vector3f8.y = vector3f.y;
                                        vector3f8.z = vector3f.z;
                                        vector3f11.x = vector3f.x + vector3f2.x;
                                        vector3f11.y = vector3f.y + vector3f2.y;
                                        vector3f11.z = vector3f.z + vector3f2.z;
                                        Font3D.normalize(vector3f11);
                                    }
                                } else {
                                    vector3f4 = new Vector3f();
                                    vector3f5 = new Vector3f();
                                    vector3f8.x = vector3f.x;
                                    vector3f8.y = vector3f.y;
                                    vector3f8.z = vector3f.z;
                                    vector3f11.x = vector3f.x + vector3f2.x;
                                    vector3f11.y = vector3f.y + vector3f2.y;
                                    vector3f11.z = vector3f.z + vector3f2.z;
                                    Font3D.normalize(vector3f11);
                                }
                                if (n + 1 < n6) {
                                    point3f3.x = point3fArrayArray[n3][n + 1].x;
                                    point3f3.y = point3fArrayArray[n3][n + 1].y;
                                    point3f3.z = 0.0f;
                                    point3f6.x = point3f3.x;
                                    point3f6.y = point3f3.y;
                                    point3f6.z = point3f3.z + this.fontExtrusion.length;
                                    if (!Font3D.getNormal(point3f2, point3f5, point3f3, vector3f6)) {
                                        vector3f6.set((Tuple3f)vector3f3);
                                    } else {
                                        if (!bl2) {
                                            vector3f6.negate();
                                        }
                                        vector3f3.set((Tuple3f)vector3f6);
                                    }
                                    if (!Font3D.getNormal(point3f3, point3f5, point3f6, vector3f7)) {
                                        vector3f7.set((Tuple3f)vector3f3);
                                    } else {
                                        if (!bl2) {
                                            vector3f7.negate();
                                        }
                                        vector3f3.set((Tuple3f)vector3f7);
                                    }
                                    f7 = vector3f2.dot(vector3f6);
                                    boolean bl6 = bl4 = f7 > f6;
                                    if (bl4) {
                                        vector3f9.x = vector3f.x + vector3f2.x + vector3f6.x;
                                        vector3f9.y = vector3f.y + vector3f2.y + vector3f6.y;
                                        vector3f9.z = vector3f.z + vector3f2.z + vector3f6.z;
                                        Font3D.normalize(vector3f9);
                                        vector3f12.x = vector3f2.x + vector3f6.x + vector3f7.x;
                                        vector3f12.y = vector3f2.y + vector3f6.y + vector3f7.y;
                                        vector3f12.z = vector3f2.z + vector3f6.z + vector3f7.z;
                                        Font3D.normalize(vector3f12);
                                    } else {
                                        vector3f9.x = vector3f.x + vector3f2.x;
                                        vector3f9.y = vector3f.y + vector3f2.y;
                                        vector3f9.z = vector3f.z + vector3f2.z;
                                        Font3D.normalize(vector3f9);
                                        vector3f12.x = vector3f2.x;
                                        vector3f12.y = vector3f2.y;
                                        vector3f12.z = vector3f2.z;
                                    }
                                } else {
                                    vector3f9.x = vector3f.x + vector3f2.x;
                                    vector3f9.y = vector3f.y + vector3f2.y;
                                    vector3f9.z = vector3f.z + vector3f2.z;
                                    Font3D.normalize(vector3f9);
                                    vector3f12.x = vector3f2.x;
                                    vector3f12.y = vector3f2.y;
                                    vector3f12.z = vector3f2.z;
                                }
                                if (bl2) {
                                    triangleArray.setCoordinate(n14, point3f);
                                    triangleArray.setNormal(n14, vector3f8);
                                    triangleArray.setCoordinate(++n14, point3f4);
                                    triangleArray.setNormal(n14, vector3f11);
                                    triangleArray.setCoordinate(++n14, point3f2);
                                    triangleArray.setNormal(n14, vector3f9);
                                    triangleArray.setCoordinate(++n14, point3f2);
                                    triangleArray.setNormal(n14, vector3f9);
                                    triangleArray.setCoordinate(++n14, point3f4);
                                    triangleArray.setNormal(n14, vector3f11);
                                    ++n14;
                                } else {
                                    triangleArray.setCoordinate(n14, point3f4);
                                    triangleArray.setNormal(n14, vector3f11);
                                    triangleArray.setCoordinate(++n14, point3f);
                                    triangleArray.setNormal(n14, vector3f8);
                                    triangleArray.setCoordinate(++n14, point3f2);
                                    triangleArray.setNormal(n14, vector3f9);
                                    triangleArray.setCoordinate(++n14, point3f4);
                                    triangleArray.setNormal(n14, vector3f11);
                                    triangleArray.setCoordinate(++n14, point3f2);
                                    triangleArray.setNormal(n14, vector3f9);
                                    ++n14;
                                }
                                triangleArray.setCoordinate(n14, point3f5);
                                triangleArray.setNormal(n14, vector3f12);
                                ++n14;
                                vector3f4.x = vector3f.x;
                                vector3f4.y = vector3f.y;
                                vector3f4.z = vector3f.z;
                                vector3f5.x = vector3f2.x;
                                vector3f5.y = vector3f2.y;
                                vector3f5.z = vector3f2.z;
                                point3f.x = point3f2.x;
                                point3f.y = point3f2.y;
                                point3f.z = point3f2.z;
                                point3f4.x = point3f5.x;
                                point3f4.y = point3f5.y;
                                point3f4.z = point3f5.z;
                                ++n;
                            }
                            vector3f4 = null;
                            vector3f5 = null;
                        }
                    }
                } else {
                    int n17 = 0;
                    Point3f point3f7 = new Point3f();
                    Point3f point3f8 = new Point3f();
                    Point3f point3f9 = new Point3f();
                    Vector3f vector3f14 = new Vector3f();
                    Vector3f vector3f15 = new Vector3f();
                    Vector3f vector3f16 = new Vector3f();
                    Vector3f vector3f17 = new Vector3f();
                    Vector3f vector3f18 = new Vector3f();
                    Vector3f vector3f19 = new Vector3f();
                    boolean bl7 = false;
                    for (n3 = 0; n3 < nArrayArray.length; ++n3) {
                        n = 0;
                        n6 = 0;
                        n17 = 0;
                        for (n2 = 0; n2 < nArrayArray[n3].length; ++n2) {
                            int n18;
                            point3f.x = point3fArrayArray[n3][(n6 += nArrayArray[n3][n2]) - 1].x;
                            point3f.y = point3fArrayArray[n3][n6 - 1].y;
                            point3f.z = 0.0f;
                            point3f4.x = point3f.x;
                            point3f4.y = point3f.y;
                            point3f4.z = point3f.z + this.fontExtrusion.length;
                            point3f3.z = 0.0f;
                            for (n18 = n6 - 2; n18 >= 0; --n18) {
                                point3f3.x = point3fArrayArray[n3][n18].x;
                                point3f3.y = point3fArrayArray[n3][n18].y;
                                if (!Font3D.getNormal(point3f3, point3f4, point3f, vector3f15)) continue;
                                if (!bl2) {
                                    vector3f15.negate();
                                }
                                vector3f3.set((Tuple3f)vector3f15);
                                break;
                            }
                            while (n < n6) {
                                point3f2.x = point3fArrayArray[n3][n].x;
                                point3f2.y = point3fArrayArray[n3][n].y;
                                point3f2.z = 0.0f;
                                point3f5.x = point3f2.x;
                                point3f5.y = point3f2.y;
                                point3f5.z = point3f2.z + this.fontExtrusion.length;
                                Font3D.getNormal(point3f, point3f4, point3f2, vector3f16);
                                point3f3.x = point3fArrayArray[n3][n + 1 == n6 ? n17 : n + 1].x;
                                point3f3.y = point3fArrayArray[n3][n + 1 == n6 ? n17 : n + 1].y;
                                point3f3.z = 0.0f;
                                if (!Font3D.getNormal(point3f3, point3f2, point3f5, vector3f17)) {
                                    vector3f17.set((Tuple3f)vector3f3);
                                } else {
                                    if (!bl2) {
                                        vector3f17.negate();
                                    }
                                    vector3f3.set((Tuple3f)vector3f17);
                                }
                                vector3f18.x = vector3f15.x + vector3f16.x;
                                vector3f18.y = vector3f15.y + vector3f16.y;
                                vector3f18.z = vector3f15.z + vector3f16.z;
                                Font3D.normalize(vector3f18);
                                vector3f19.x = vector3f17.x + vector3f16.x;
                                vector3f19.y = vector3f17.y + vector3f16.y;
                                vector3f19.z = vector3f17.z + vector3f16.z;
                                Font3D.normalize(vector3f19);
                                point3f9.x = point3f.x;
                                point3f9.y = point3f.y;
                                point3f9.z = point3f.z;
                                point3f7.x = point3f2.x;
                                point3f7.y = point3f2.y;
                                point3f7.z = point3f2.z;
                                point3f8.x = point3f5.x;
                                point3f8.y = point3f5.y;
                                point3f8.z = point3f5.z;
                                for (n18 = 1; n18 < this.fontExtrusion.pnts.length; ++n18) {
                                    point3f4.z = point3f5.z = this.fontExtrusion.pnts[n18].x;
                                    point3f4.x = point3f9.x + vector3f18.x * this.fontExtrusion.pnts[n18].y;
                                    point3f4.y = point3f9.y + vector3f18.y * this.fontExtrusion.pnts[n18].y;
                                    point3f5.x = point3f7.x + vector3f19.x * this.fontExtrusion.pnts[n18].y;
                                    point3f5.y = point3f7.y + vector3f19.y * this.fontExtrusion.pnts[n18].y;
                                    if (!Font3D.getNormal(point3f, point3f4, point3f2, vector3f)) {
                                        vector3f.set((Tuple3f)vector3f3);
                                    } else {
                                        if (!bl2) {
                                            vector3f.negate();
                                        }
                                        vector3f3.set((Tuple3f)vector3f);
                                    }
                                    if (bl2) {
                                        triangleArray.setCoordinate(n14, point3f);
                                        triangleArray.setNormal(n14, vector3f);
                                        triangleArray.setCoordinate(++n14, point3f4);
                                        triangleArray.setNormal(n14, vector3f);
                                        ++n14;
                                    } else {
                                        triangleArray.setCoordinate(n14, point3f4);
                                        triangleArray.setNormal(n14, vector3f);
                                        triangleArray.setCoordinate(++n14, point3f);
                                        triangleArray.setNormal(n14, vector3f);
                                        ++n14;
                                    }
                                    triangleArray.setCoordinate(n14, point3f2);
                                    triangleArray.setNormal(n14, vector3f);
                                    ++n14;
                                    if (!Font3D.getNormal(point3f2, point3f4, point3f5, vector3f)) {
                                        vector3f.set((Tuple3f)vector3f3);
                                    } else {
                                        if (!bl2) {
                                            vector3f.negate();
                                        }
                                        vector3f3.set((Tuple3f)vector3f);
                                    }
                                    if (bl2) {
                                        triangleArray.setCoordinate(n14, point3f2);
                                        triangleArray.setNormal(n14, vector3f);
                                        triangleArray.setCoordinate(++n14, point3f4);
                                        triangleArray.setNormal(n14, vector3f);
                                        ++n14;
                                    } else {
                                        triangleArray.setCoordinate(n14, point3f4);
                                        triangleArray.setNormal(n14, vector3f);
                                        triangleArray.setCoordinate(++n14, point3f2);
                                        triangleArray.setNormal(n14, vector3f);
                                        ++n14;
                                    }
                                    triangleArray.setCoordinate(n14, point3f5);
                                    triangleArray.setNormal(n14, vector3f);
                                    ++n14;
                                    point3f.x = point3f4.x;
                                    point3f.y = point3f4.y;
                                    point3f.z = point3f4.z;
                                    point3f2.x = point3f5.x;
                                    point3f2.y = point3f5.y;
                                    point3f2.z = point3f5.z;
                                }
                                point3f.x = point3f7.x;
                                point3f.y = point3f7.y;
                                point3f.z = point3f7.z;
                                point3f4.x = point3f8.x;
                                point3f4.y = point3f8.y;
                                point3f4.z = point3f8.z;
                                vector3f15.x = vector3f16.x;
                                vector3f15.y = vector3f16.y;
                                vector3f15.z = vector3f16.z;
                                ++n;
                            }
                            n17 = n6;
                        }
                    }
                }
            }
            geometryArrayRetained = (GeometryArrayRetained)triangleArray.retained;
            this.geomHash.put(c2, geometryArrayRetained);
        }
        return geometryArrayRetained;
    }

    static boolean getNormal(Point3f point3f, Point3f point3f2, Point3f point3f3, Vector3f vector3f) {
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        vector3f2.sub((Tuple3f)point3f2, (Tuple3f)point3f);
        vector3f3.sub((Tuple3f)point3f2, (Tuple3f)point3f3);
        vector3f.cross(vector3f2, vector3f3);
        vector3f.negate();
        float f = vector3f.length();
        if (f > 0.0f) {
            f = 1.0f / f;
            vector3f.x *= f;
            vector3f.y *= f;
            vector3f.z *= f;
            return true;
        }
        return false;
    }

    static int check2Contours(int n, int n2, int n3, int n4, Point3f[] point3fArray) {
        int n5;
        boolean bl = Font3D.pointInPolygon2D(point3fArray[n].x, point3fArray[n].y, n3, n4, point3fArray);
        for (n5 = n + 1; n5 < n2; ++n5) {
            if (Font3D.pointInPolygon2D(point3fArray[n5].x, point3fArray[n5].y, n3, n4, point3fArray) == bl) continue;
            return 1;
        }
        boolean bl2 = Font3D.pointInPolygon2D(point3fArray[n3].x, point3fArray[n3].y, n, n2, point3fArray);
        for (n5 = n3 + 1; n5 < n4; ++n5) {
            if (Font3D.pointInPolygon2D(point3fArray[n5].x, point3fArray[n5].y, n, n2, point3fArray) == bl2) continue;
            return 1;
        }
        if (!bl) {
            if (!bl2) {
                return 0;
            }
            return 3;
        }
        return 2;
    }

    static boolean pointInPolygon2D(float f, float f2, int n, int n2, Point3f[] point3fArray) {
        float f3;
        int n3;
        int n4 = 0;
        for (n3 = n; n3 < n2 - 1; ++n3) {
            if (point3fArray[n3].y >= f2 && point3fArray[n3 + 1].y >= f2 || point3fArray[n3].y < f2 && point3fArray[n3 + 1].y < f2 || !(f < (f3 = point3fArray[n3].x + (point3fArray[n3].x - point3fArray[n3 + 1].x) * (f2 - point3fArray[n3].y) / (point3fArray[n3].y - point3fArray[n3 + 1].y)))) continue;
            ++n4;
        }
        if (!(point3fArray[n3].y >= f2 && point3fArray[n].y >= f2 || point3fArray[n3].y < f2 && point3fArray[n].y < f2 || !(f < (f3 = point3fArray[n3].x + (point3fArray[n3].x - point3fArray[n].x) * (f2 - point3fArray[n3].y) / (point3fArray[n3].y - point3fArray[n].y))))) {
            ++n4;
        }
        return n4 % 2 != 0;
    }

    static final boolean normalize(Vector3f vector3f) {
        float f = vector3f.length();
        if (f > 0.0f) {
            f = 1.0f / f;
            vector3f.x *= f;
            vector3f.y *= f;
            vector3f.z *= f;
            return true;
        }
        return false;
    }

    private static class IslandsNode {
        private ArrayList<IslandsNode> islandsList = null;
        int startIdx;
        int endIdx;

        IslandsNode(int n, int n2) {
            this.startIdx = n;
            this.endIdx = n2;
            this.islandsList = null;
        }

        void addChild(IslandsNode islandsNode) {
            if (this.islandsList == null) {
                this.islandsList = new ArrayList(5);
            }
            this.islandsList.add(islandsNode);
        }

        void removeChild(IslandsNode islandsNode) {
            this.islandsList.remove(this.islandsList.indexOf(islandsNode));
        }

        IslandsNode getChild(int n) {
            return this.islandsList.get(n);
        }

        int numChild() {
            return this.islandsList == null ? 0 : this.islandsList.size();
        }

        int numVertices() {
            return this.endIdx - this.startIdx;
        }

        void insert(IslandsNode islandsNode, Point3f[] point3fArray) {
            boolean bl = false;
            if (this.islandsList != null) {
                block4: for (int i = this.numChild() - 1; i >= 0; --i) {
                    IslandsNode islandsNode2 = this.getChild(i);
                    int n = Font3D.check2Contours(islandsNode.startIdx, islandsNode.endIdx, islandsNode2.startIdx, islandsNode2.endIdx, point3fArray);
                    switch (n) {
                        case 2: {
                            islandsNode2.insert(islandsNode, point3fArray);
                            return;
                        }
                        case 3: {
                            islandsNode.addChild(islandsNode2);
                            bl = true;
                            continue block4;
                        }
                    }
                }
            }
            if (bl) {
                for (int i = islandsNode.numChild() - 1; i >= 0; --i) {
                    this.removeChild(islandsNode.getChild(i));
                }
            }
            this.addChild(islandsNode);
        }

        void collectOddLevelNode(UnorderList unorderList, int n) {
            if (n % 2 == 1) {
                unorderList.add(this);
            }
            if (this.islandsList != null) {
                ++n;
                for (int i = this.numChild() - 1; i >= 0; --i) {
                    this.getChild(i).collectOddLevelNode(unorderList, n);
                }
            }
        }
    }

    private static class IntVector {
        int[] data = new int[10];
        int size = 0;

        IntVector() {
        }

        void add(int n) {
            if (this.size == this.data.length) {
                this.data = Arrays.copyOf(this.data, 2 * this.size);
            }
            this.data[this.size] = n;
            ++this.size;
        }
    }
}

