/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.statistics;

import java.util.ArrayList;
import org.gephi.desktop.statistics.StatisticsModelUIImpl;
import org.gephi.desktop.statistics.api.StatisticsControllerUI;
import org.gephi.statistics.api.StatisticsController;
import org.gephi.statistics.spi.Statistics;
import org.gephi.statistics.spi.StatisticsUI;
import org.gephi.utils.longtask.api.LongTaskListener;
import org.gephi.utils.longtask.spi.LongTask;
import org.openide.util.Lookup;

public class StatisticsControllerUIImpl
implements StatisticsControllerUI {
    private StatisticsModelUIImpl model;

    public void setup(StatisticsModelUIImpl model) {
        if (this.model == model) {
            return;
        }
        this.model = model;
        this.unsetup();
        if (model != null) {
            // empty if block
        }
    }

    public void unsetup() {
        if (this.model != null) {
            // empty if block
        }
    }

    @Override
    public void execute(final Statistics statistics) {
        StatisticsUI[] uis;
        StatisticsController controller = (StatisticsController)Lookup.getDefault().lookup(StatisticsController.class);
        for (StatisticsUI s : uis = this.getUI(statistics)) {
            s.setup(statistics);
        }
        this.model.setRunning(statistics, true);
        controller.execute(statistics, new LongTaskListener(){

            public void taskFinished(LongTask task) {
                StatisticsControllerUIImpl.this.model.setRunning(statistics, false);
                for (StatisticsUI s : uis) {
                    StatisticsControllerUIImpl.this.model.addResult(s);
                    s.unsetup();
                }
            }
        });
    }

    @Override
    public void execute(final Statistics statistics, final LongTaskListener listener) {
        StatisticsUI[] uis;
        StatisticsController controller = (StatisticsController)Lookup.getDefault().lookup(StatisticsController.class);
        for (StatisticsUI s : uis = this.getUI(statistics)) {
            s.setup(statistics);
        }
        this.model.setRunning(statistics, true);
        controller.execute(statistics, new LongTaskListener(){

            public void taskFinished(LongTask task) {
                StatisticsControllerUIImpl.this.model.setRunning(statistics, false);
                for (StatisticsUI s : uis) {
                    StatisticsControllerUIImpl.this.model.addResult(s);
                    s.unsetup();
                }
                if (listener != null) {
                    listener.taskFinished(statistics instanceof LongTask ? (LongTask)statistics : null);
                }
            }
        });
    }

    public StatisticsUI[] getUI(Statistics statistics) {
        boolean dynamic = false;
        ArrayList<StatisticsUI> list = new ArrayList<StatisticsUI>();
        for (StatisticsUI sui : Lookup.getDefault().lookupAll(StatisticsUI.class)) {
            if (!sui.getStatisticsClass().equals(statistics.getClass())) continue;
            list.add(sui);
        }
        return list.toArray(new StatisticsUI[0]);
    }

    @Override
    public void setStatisticsUIVisible(StatisticsUI ui, boolean visible) {
        if (this.model != null) {
            this.model.setVisible(ui, visible);
        }
    }
}

