/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.settings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.lock.LockStrategy;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.Configurator;
import org.apache.ivy.util.FileResolver;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.CredentialsStore;
import org.apache.ivy.util.url.URLHandlerRegistry;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSettingsParser
extends DefaultHandler {
    private Configurator configurator;
    private List configuratorTags = Arrays.asList("resolvers", "namespaces", "parsers", "latest-strategies", "conflict-managers", "outputters", "version-matchers", "statuses", "circular-dependency-strategies", "triggers", "lock-strategies", "caches", "signers");
    private IvySettings ivy;
    private String defaultResolver;
    private String defaultCM;
    private String defaultLatest;
    private String defaultCacheManager;
    private String defaultCircular;
    private String defaultLock;
    private String currentConfiguratorTag;
    private URL settings;
    private boolean deprecatedMessagePrinted = false;

    public XmlSettingsParser(IvySettings ivy) {
        this.ivy = ivy;
    }

    public void parse(URL settings) throws ParseException, IOException {
        this.configurator = new Configurator();
        this.configurator.setFileResolver(new FileResolver(){

            @Override
            public File resolveFile(String path, String filename) {
                return Checks.checkAbsolute(path, filename);
            }
        });
        Map typeDefs = this.ivy.getTypeDefs();
        for (String name : typeDefs.keySet()) {
            this.configurator.typeDef(name, (Class)typeDefs.get(name));
        }
        this.doParse(settings);
    }

    private void doParse(URL settingsUrl) throws IOException, ParseException {
        this.settings = settingsUrl;
        InputStream stream = null;
        try {
            stream = URLHandlerRegistry.getDefault().openStream(settingsUrl);
            InputSource inSrc = new InputSource(stream);
            inSrc.setSystemId(settingsUrl.toExternalForm());
            SAXParserFactory.newInstance().newSAXParser().parse(settingsUrl.toExternalForm(), (DefaultHandler)this);
            this.ivy.validate();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            ParseException pe = new ParseException("failed to load settings from " + settingsUrl + ": " + e.getMessage(), 0);
            pe.initCause(e);
            throw pe;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void parse(Configurator configurator, URL configuration) throws IOException, ParseException {
        this.configurator = configurator;
        this.doParse(configuration);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = 0; i < att.getLength(); ++i) {
            attributes.put(att.getQName(i), this.ivy.substitute(att.getValue(i)));
        }
        try {
            if ("ivyconf".equals(qName)) {
                this.deprecatedMessagePrinted = true;
                Message.deprecated("'ivyconf' element is deprecated, use 'ivysettings' instead (" + this.settings + ")");
            }
            if (this.configurator.getCurrent() != null) {
                this.inConfiguratorStarted(qName, attributes);
            } else if ("classpath".equals(qName)) {
                this.classpathStarted(attributes);
            } else if ("typedef".equals(qName)) {
                this.typedefStarted(attributes);
            } else if ("property".equals(qName)) {
                this.propertyStarted(attributes);
            } else if ("properties".equals(qName)) {
                this.propertiesStarted(attributes);
            } else if ("include".equals(qName)) {
                this.includeStarted(attributes);
            } else if ("settings".equals(qName) || "conf".equals(qName)) {
                this.settingsStarted(qName, attributes);
            } else if ("caches".equals(qName)) {
                this.cachesStarted(qName, attributes);
            } else if ("version-matchers".equals(qName)) {
                this.versionMatchersStarted(qName, attributes);
            } else if ("statuses".equals(qName)) {
                this.statusesStarted(qName, attributes);
            } else if (this.configuratorTags.contains(qName)) {
                this.anyConfiguratorStarted(qName);
            } else if ("macrodef".equals(qName)) {
                this.macrodefStarted(qName, attributes);
            } else if ("module".equals(qName)) {
                this.moduleStarted(attributes);
            } else if ("credentials".equals(qName)) {
                this.credentialsStarted(attributes);
            }
        }
        catch (ParseException ex) {
            SAXException sax = new SAXException("problem in config file: " + ex.getMessage(), ex);
            sax.initCause(ex);
            throw sax;
        }
        catch (IOException ex) {
            SAXException sax = new SAXException("io problem while parsing config file: " + ex.getMessage(), ex);
            sax.initCause(ex);
            throw sax;
        }
    }

    private void credentialsStarted(Map attributes) {
        String realm = (String)attributes.remove("realm");
        String host = (String)attributes.remove("host");
        String userName = (String)attributes.remove("username");
        String passwd = (String)attributes.remove("passwd");
        CredentialsStore.INSTANCE.addCredentials(realm, host, userName, passwd);
    }

    private void moduleStarted(Map attributes) {
        attributes.put("module", attributes.remove("name"));
        String resolver = (String)attributes.remove("resolver");
        String branch = (String)attributes.remove("branch");
        String cm = (String)attributes.remove("conflict-manager");
        String resolveMode = (String)attributes.remove("resolveMode");
        String matcher = (String)attributes.remove("matcher");
        matcher = matcher == null ? "exactOrRegexp" : matcher;
        this.ivy.addModuleConfiguration(attributes, this.ivy.getMatcher(matcher), resolver, branch, cm, resolveMode);
    }

    private void macrodefStarted(String qName, Map attributes) {
        this.currentConfiguratorTag = qName;
        Configurator.MacroDef macrodef = this.configurator.startMacroDef((String)attributes.get("name"));
        macrodef.addAttribute("name", null);
    }

    private void anyConfiguratorStarted(String qName) {
        this.currentConfiguratorTag = qName;
        this.configurator.setRoot(this.ivy);
    }

    private void statusesStarted(String qName, Map attributes) {
        this.currentConfiguratorTag = qName;
        StatusManager m = new StatusManager();
        String defaultStatus = (String)attributes.get("default");
        if (defaultStatus != null) {
            m.setDefaultStatus(defaultStatus);
        }
        this.ivy.setStatusManager(m);
        this.configurator.setRoot(m);
    }

    private void versionMatchersStarted(String qName, Map attributes) {
        this.anyConfiguratorStarted(qName);
        if ("true".equals(attributes.get("usedefaults"))) {
            this.ivy.configureDefaultVersionMatcher();
        }
    }

    private void cachesStarted(String qName, Map attributes) {
        String repositoryDir;
        String cacheArtPattern;
        String cacheIvyPattern;
        String useOrigin;
        String resolutionDir;
        String up2d;
        this.anyConfiguratorStarted(qName);
        this.defaultLock = (String)attributes.get("lockStrategy");
        this.defaultCacheManager = (String)attributes.get("default");
        String cache = (String)attributes.get("defaultCacheDir");
        if (cache != null) {
            this.ivy.setDefaultCache(Checks.checkAbsolute(cache, "defaultCacheDir"));
        }
        if ((up2d = (String)attributes.get("checkUpToDate")) != null) {
            Message.deprecated("'checkUpToDate' is deprecated, use the 'overwriteMode' on the 'ivy:retrieve' task instead (" + this.settings + ")");
            this.ivy.setCheckUpToDate(Boolean.valueOf(up2d));
        }
        if ((resolutionDir = (String)attributes.get("resolutionCacheDir")) != null) {
            this.ivy.setDefaultResolutionCacheBasedir(resolutionDir);
        }
        if ((useOrigin = (String)attributes.get("useOrigin")) != null) {
            this.ivy.setDefaultUseOrigin(Boolean.valueOf(useOrigin));
        }
        if ((cacheIvyPattern = (String)attributes.get("ivyPattern")) != null) {
            this.ivy.setDefaultCacheIvyPattern(cacheIvyPattern);
        }
        if ((cacheArtPattern = (String)attributes.get("artifactPattern")) != null) {
            this.ivy.setDefaultCacheArtifactPattern(cacheArtPattern);
        }
        if ((repositoryDir = (String)attributes.get("repositoryCacheDir")) != null) {
            this.ivy.setDefaultRepositoryCacheBasedir(repositoryDir);
        }
    }

    private void settingsStarted(String qName, Map attributes) {
        String cacheArtPattern;
        String cacheIvyPattern;
        String useRemoteConfig;
        String up2d;
        String validate;
        String defaultResolveMode;
        String defaultBranch;
        String cache;
        if ("conf".equals(qName) && !this.deprecatedMessagePrinted) {
            Message.deprecated("'conf' is deprecated, use 'settings' instead (" + this.settings + ")");
        }
        if ((cache = (String)attributes.get("defaultCache")) != null) {
            Message.deprecated("'defaultCache' is deprecated, use 'caches[@defaultCacheDir]' instead (" + this.settings + ")");
            this.ivy.setDefaultCache(Checks.checkAbsolute(cache, "defaultCache"));
        }
        if ((defaultBranch = (String)attributes.get("defaultBranch")) != null) {
            this.ivy.setDefaultBranch(defaultBranch);
        }
        if ((defaultResolveMode = (String)attributes.get("defaultResolveMode")) != null) {
            this.ivy.setDefaultResolveMode(defaultResolveMode);
        }
        if ((validate = (String)attributes.get("validate")) != null) {
            this.ivy.setValidate(Boolean.valueOf(validate));
        }
        if ((up2d = (String)attributes.get("checkUpToDate")) != null) {
            Message.deprecated("'checkUpToDate' is deprecated, use the 'overwriteMode' on the 'ivy:retrieve' task instead (" + this.settings + ")");
            this.ivy.setCheckUpToDate(Boolean.valueOf(up2d));
        }
        if ((useRemoteConfig = (String)attributes.get("useRemoteConfig")) != null) {
            this.ivy.setUseRemoteConfig(Boolean.valueOf(useRemoteConfig));
        }
        if ((cacheIvyPattern = (String)attributes.get("cacheIvyPattern")) != null) {
            Message.deprecated("'cacheIvyPattern' is deprecated, use 'caches[@ivyPattern]' instead (" + this.settings + ")");
            this.ivy.setDefaultCacheIvyPattern(cacheIvyPattern);
        }
        if ((cacheArtPattern = (String)attributes.get("cacheArtifactPattern")) != null) {
            Message.deprecated("'cacheArtifactPattern' is deprecated, use 'caches[@artifactPattern]' instead (" + this.settings + ")");
            this.ivy.setDefaultCacheArtifactPattern(cacheArtPattern);
        }
        this.defaultResolver = (String)attributes.get("defaultResolver");
        this.defaultCM = (String)attributes.get("defaultConflictManager");
        this.defaultLatest = (String)attributes.get("defaultLatestStrategy");
        this.defaultCircular = (String)attributes.get("circularDependencyStrategy");
        String requestMethod = (String)attributes.get("httpRequestMethod");
        if ("head".equalsIgnoreCase(requestMethod)) {
            URLHandlerRegistry.getHttp().setRequestMethod(2);
        } else if ("get".equalsIgnoreCase(requestMethod)) {
            URLHandlerRegistry.getHttp().setRequestMethod(1);
        } else if (requestMethod != null && requestMethod.trim().length() > 0) {
            throw new IllegalArgumentException("Invalid httpRequestMethod specified, must be one of {'HEAD', 'GET'}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void includeStarted(Map attributes) throws IOException, ParseException {
        IvyVariableContainer variables = this.ivy.getVariableContainer();
        this.ivy.setVariableContainer(new IvyVariableContainerWrapper(variables));
        try {
            String propFilePath = (String)attributes.get("file");
            URL settingsURL = null;
            if (propFilePath == null) {
                propFilePath = (String)attributes.get("url");
                if (propFilePath == null) {
                    throw new IllegalArgumentException("bad include tag: specify file or url to include");
                }
                try {
                    settingsURL = new URL(propFilePath);
                }
                catch (MalformedURLException e) {
                    settingsURL = new URL(this.settings, propFilePath);
                }
                Message.verbose("including url: " + settingsURL.toString());
                this.ivy.setSettingsVariables(settingsURL);
            } else {
                settingsURL = this.urlFromFileAttribute(propFilePath);
                Message.verbose("including file: " + settingsURL);
                if ("file".equals(settingsURL.getProtocol())) {
                    File settingsFile;
                    block14: {
                        settingsFile = new File(new URI(settingsURL.toExternalForm()));
                        String optional = (String)attributes.get("optional");
                        if (!"true".equals(optional) || settingsFile.exists()) break block14;
                        return;
                    }
                    try {
                        this.ivy.setSettingsVariables(Checks.checkAbsolute(settingsFile, "settings include path"));
                    }
                    catch (URISyntaxException e) {
                        this.ivy.setSettingsVariables(Checks.checkAbsolute(settingsURL.getPath(), "settings include path"));
                    }
                } else {
                    this.ivy.setSettingsVariables(settingsURL);
                }
            }
            new XmlSettingsParser(this.ivy).parse(this.configurator, settingsURL);
        }
        finally {
            this.ivy.setVariableContainer(variables);
        }
    }

    private URL urlFromFileAttribute(String filePath) throws IOException {
        try {
            return new URL(filePath);
        }
        catch (MalformedURLException malformedURLException) {
            File incFile = new File(filePath);
            if (incFile.isAbsolute()) {
                if (!incFile.exists()) {
                    throw new FileNotFoundException(incFile.getAbsolutePath());
                }
                return incFile.toURI().toURL();
            }
            if ("file".equals(this.settings.getProtocol())) {
                try {
                    File settingsFile = new File(new URI(this.settings.toExternalForm()));
                    if (!settingsFile.exists()) {
                        throw new FileNotFoundException(settingsFile.getAbsolutePath());
                    }
                    return new File(settingsFile.getParentFile(), filePath).toURI().toURL();
                }
                catch (URISyntaxException e) {
                    return new URL(this.settings, filePath);
                }
            }
            return new URL(this.settings, filePath);
        }
    }

    private void propertiesStarted(Map attributes) throws IOException {
        String propFilePath = (String)attributes.get("file");
        String environmentPrefix = (String)attributes.get("environment");
        if (propFilePath != null) {
            String overrideStr = (String)attributes.get("override");
            boolean override = overrideStr == null ? true : Boolean.valueOf(overrideStr);
            Message.verbose("loading properties: " + propFilePath);
            try {
                URL fileUrl = this.urlFromFileAttribute(propFilePath);
                this.ivy.loadProperties(fileUrl, override);
            }
            catch (FileNotFoundException e) {
                Message.verbose("Unable to find property file: " + propFilePath);
            }
        } else if (environmentPrefix != null) {
            this.ivy.getVariableContainer().setEnvironmentPrefix(environmentPrefix);
        } else {
            throw new IllegalArgumentException("Didn't find a 'file' or 'environment' attribute on the 'properties' element");
        }
    }

    private void propertyStarted(Map attributes) {
        String name = (String)attributes.get("name");
        String value = (String)attributes.get("value");
        String override = (String)attributes.get("override");
        String isSetVar = (String)attributes.get("ifset");
        String unlessSetVar = (String)attributes.get("unlessset");
        if (name == null) {
            throw new IllegalArgumentException("missing attribute name on property tag");
        }
        if (value == null) {
            throw new IllegalArgumentException("missing attribute value on property tag");
        }
        this.ivy.setVariable(name, value, override == null ? true : Boolean.valueOf(override), isSetVar, unlessSetVar);
    }

    private void typedefStarted(Map attributes) {
        String name = (String)attributes.get("name");
        String className = (String)attributes.get("classname");
        Class clazz = this.ivy.typeDef(name, className);
        this.configurator.typeDef(name, clazz);
    }

    private void classpathStarted(Map attributes) throws IOException {
        String urlStr = (String)attributes.get("url");
        URL url = null;
        if (urlStr == null) {
            String file = (String)attributes.get("file");
            if (file == null) {
                throw new IllegalArgumentException("either url or file should be given for classpath element");
            }
            url = this.urlFromFileAttribute(file);
        } else {
            url = new URL(urlStr);
        }
        this.ivy.addClasspathURL(url);
    }

    private void inConfiguratorStarted(String qName, Map attributes) {
        String name;
        if ("macrodef".equals(this.currentConfiguratorTag) && this.configurator.getTypeDef(qName) != null) {
            name = (String)attributes.get("name");
            if (name == null) {
                attributes.put("name", "@{name}");
            } else if (name.indexOf("@{name}") != -1) {
                attributes.put("name", name);
            } else {
                attributes.put("name", "@{name}-" + name);
            }
        }
        if (attributes.get("ref") != null) {
            if (attributes.size() != 1) {
                throw new IllegalArgumentException("ref attribute should be the only one ! found " + attributes.size() + " in " + qName);
            }
            name = (String)attributes.get("ref");
            Object child = null;
            if ("resolvers".equals(this.currentConfiguratorTag) || "resolver".equals(qName)) {
                child = this.ivy.getResolver(name);
                if (child == null) {
                    throw new IllegalArgumentException("unknown resolver " + name + ": resolver should be defined before being referenced");
                }
            } else if ("latest-strategies".equals(this.currentConfiguratorTag)) {
                child = this.ivy.getLatestStrategy(name);
                if (child == null) {
                    throw new IllegalArgumentException("unknown latest strategy " + name + ": latest strategy should be defined before being referenced");
                }
            } else if ("conflict-managers".equals(this.currentConfiguratorTag) && (child = this.ivy.getConflictManager(name)) == null) {
                throw new IllegalArgumentException("unknown conflict manager " + name + ": conflict manager should be defined before being referenced");
            }
            if (child == null) {
                throw new IllegalArgumentException("bad reference " + name);
            }
            this.configurator.addChild(qName, child);
        } else {
            this.configurator.startCreateChild(qName);
            for (String attName : attributes.keySet()) {
                this.configurator.setAttribute(attName, (String)attributes.get(attName));
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.configurator.getCurrent() != null) {
            if (this.configuratorTags.contains(qName) && this.configurator.getDepth() == 1) {
                this.configurator.clear();
                this.currentConfiguratorTag = null;
            } else if ("macrodef".equals(qName) && this.configurator.getDepth() == 1) {
                this.configurator.endMacroDef();
                this.currentConfiguratorTag = null;
            } else {
                this.configurator.endCreateChild();
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        Object strategy;
        if (this.defaultResolver != null) {
            this.ivy.setDefaultResolver(this.ivy.substitute(this.defaultResolver));
        }
        if (this.defaultCM != null) {
            ConflictManager conflictManager = this.ivy.getConflictManager(this.ivy.substitute(this.defaultCM));
            if (conflictManager == null) {
                throw new IllegalArgumentException("unknown conflict manager " + this.ivy.substitute(this.defaultCM));
            }
            this.ivy.setDefaultConflictManager(conflictManager);
        }
        if (this.defaultLatest != null) {
            LatestStrategy latestStrategy = this.ivy.getLatestStrategy(this.ivy.substitute(this.defaultLatest));
            if (latestStrategy == null) {
                throw new IllegalArgumentException("unknown latest strategy " + this.ivy.substitute(this.defaultLatest));
            }
            this.ivy.setDefaultLatestStrategy(latestStrategy);
        }
        if (this.defaultCacheManager != null) {
            RepositoryCacheManager cache = this.ivy.getRepositoryCacheManager(this.ivy.substitute(this.defaultCacheManager));
            if (cache == null) {
                throw new IllegalArgumentException("unknown cache manager " + this.ivy.substitute(this.defaultCacheManager));
            }
            this.ivy.setDefaultRepositoryCacheManager(cache);
        }
        if (this.defaultCircular != null) {
            strategy = this.ivy.getCircularDependencyStrategy(this.ivy.substitute(this.defaultCircular));
            if (strategy == null) {
                throw new IllegalArgumentException("unknown circular dependency strategy " + this.ivy.substitute(this.defaultCircular));
            }
            this.ivy.setCircularDependencyStrategy((CircularDependencyStrategy)strategy);
        }
        if (this.defaultLock != null) {
            strategy = this.ivy.getLockStrategy(this.ivy.substitute(this.defaultLock));
            if (strategy == null) {
                throw new IllegalArgumentException("unknown lock strategy " + this.ivy.substitute(this.defaultLock));
            }
            this.ivy.setDefaultLockStrategy((LockStrategy)strategy);
        }
    }

    private static final class IvyVariableContainerWrapper
    implements IvyVariableContainer {
        private static final Collection SETTINGS_VARIABLES = Arrays.asList("ivy.settings.dir", "ivy.settings.url", "ivy.settings.file", "ivy.conf.dir", "ivy.conf.url", "ivy.conf.file");
        private final IvyVariableContainer variables;
        private Map localVariables = new HashMap();

        private IvyVariableContainerWrapper(IvyVariableContainer variables) {
            this.variables = variables;
        }

        @Override
        public void setVariable(String varName, String value, boolean overwrite) {
            if (SETTINGS_VARIABLES.contains(varName)) {
                if (!this.localVariables.containsKey(varName) || overwrite) {
                    this.localVariables.put(varName, value);
                }
            } else {
                this.variables.setVariable(varName, value, overwrite);
            }
        }

        @Override
        public void setEnvironmentPrefix(String prefix) {
            this.variables.setEnvironmentPrefix(prefix);
        }

        @Override
        public String getVariable(String name) {
            if (this.localVariables.containsKey(name)) {
                return (String)this.localVariables.get(name);
            }
            return this.variables.getVariable(name);
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException();
        }
    }
}

