/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.validator;

import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.dialogs.validator.ValidatorTreeRenderer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ListenerList;

public class ValidatorTreePanel
extends JTree
implements Destroyable,
DataSetListener {
    protected DefaultTreeModel valTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private transient List<TestError> errors;
    private transient Set<? extends OsmPrimitive> filter;
    private final transient ListenerList<Runnable> invalidationListeners = ListenerList.create();
    private boolean resetScheduled;

    public ValidatorTreePanel(List<TestError> errors) {
        this.setErrorList(errors);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setModel(this.valTreeModel);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRow(0);
        this.setVisibleRowCount(8);
        this.setCellRenderer(new ValidatorTreeRenderer());
        this.getSelectionModel().setSelectionMode(4);
        for (KeyListener keyListener : this.getKeyListeners()) {
            if (!"javax.swing.plaf.basic.BasicTreeUI$Handler".equals(keyListener.getClass().getName())) continue;
            this.removeKeyListener(keyListener);
        }
        DatasetEventManager.getInstance().addDatasetListener(this, DatasetEventManager.FireMode.IN_EDT);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String res = null;
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object nodeInfo = node.getUserObject();
            if (nodeInfo instanceof TestError) {
                TestError error = (TestError)nodeInfo;
                res = "<html>" + error.getNameVisitor().getText() + "<br>" + error.getMessage();
                String d = error.getDescription();
                if (d != null) {
                    res = res + "<br>" + d;
                }
                res = res + "</html>";
            } else {
                res = node.toString();
            }
        }
        return res;
    }

    public ValidatorTreePanel() {
        this((List<TestError>)null);
    }

    @Override
    public void setVisible(boolean v) {
        if (v) {
            this.buildTree();
        } else {
            this.valTreeModel.setRoot(new DefaultMutableTreeNode());
        }
        super.setVisible(v);
        this.invalidationListeners.fireEvent(Runnable::run);
    }

    public void buildTree() {
        this.buildTree(true);
    }

    public void buildTree(boolean expandAgain) {
        DefaultMutableTreeNode node;
        Object object;
        Enumeration<TreePath> expanded;
        if (this.resetScheduled) {
            return;
        }
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        if (this.errors == null || this.errors.isEmpty()) {
            GuiHelper.runInEDTAndWait(() -> this.valTreeModel.setRoot(rootNode));
            return;
        }
        TreePath selPath = this.getSelectionPath();
        int selRow = selPath == null ? -1 : this.getRowForPath(selPath);
        HashSet<Object> oldExpandedRows = new HashSet<Object>();
        if (expandAgain && (expanded = this.getExpandedDescendants(new TreePath(this.getRoot()))) != null) {
            while (expanded.hasMoreElements()) {
                TreePath path = expanded.nextElement();
                DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object userObject2 = node2.getUserObject();
                if (userObject2 instanceof Severity) {
                    oldExpandedRows.add(userObject2);
                    continue;
                }
                if (!(userObject2 instanceof String)) continue;
                String string = ValidatorTreePanel.removeSize((String)userObject2);
                oldExpandedRows.add(string);
            }
        }
        Predicate<TestError> filterToUse = e -> !e.isIgnored();
        if (!ValidatorPrefHelper.PREF_OTHER.get().booleanValue()) {
            filterToUse = filterToUse.and(e -> e.getSeverity() != Severity.OTHER);
        }
        if (this.filter != null) {
            filterToUse = filterToUse.and(e -> e.getPrimitives().stream().anyMatch(this.filter::contains));
        }
        Map<Severity, Map<String, Map<String, List<TestError>>>> errorsBySeverityMessageDescription = OsmValidator.getErrorsBySeverityMessageDescription(this.errors, filterToUse);
        ArrayList<TreePath> expandedPaths = new ArrayList<TreePath>();
        for (Map.Entry entry : errorsBySeverityMessageDescription.entrySet()) {
            Map errorsWithEmptyMessageByDescription;
            Severity severity = (Severity)((Object)entry.getKey());
            Map errorsByMessageDescription = (Map)entry.getValue();
            GroupTreeNode severityNode = new GroupTreeNode((Object)severity);
            rootNode.add(severityNode);
            if (oldExpandedRows.contains((Object)severity)) {
                expandedPaths.add(new TreePath(severityNode.getPath()));
            }
            if ((errorsWithEmptyMessageByDescription = (Map)errorsByMessageDescription.get("")) != null) {
                errorsWithEmptyMessageByDescription.forEach((description, noDescriptionErrors) -> {
                    String msg = ValidatorTreePanel.addSize(description, noDescriptionErrors);
                    DefaultMutableTreeNode messageNode = new DefaultMutableTreeNode(msg);
                    severityNode.add(messageNode);
                    if (oldExpandedRows.contains(description)) {
                        expandedPaths.add(new TreePath(messageNode.getPath()));
                    }
                    noDescriptionErrors.stream().map(DefaultMutableTreeNode::new).forEach(messageNode::add);
                });
            }
            errorsByMessageDescription.forEach((message, errorsByDescription) -> {
                GroupTreeNode groupNode;
                if (message.isEmpty()) {
                    return;
                }
                if (errorsByDescription.size() > 1) {
                    groupNode = new GroupTreeNode(message);
                    severityNode.add(groupNode);
                    if (oldExpandedRows.contains(message)) {
                        expandedPaths.add(new TreePath(groupNode.getPath()));
                    }
                } else {
                    groupNode = null;
                }
                errorsByDescription.forEach((description, errorsWithDescription) -> {
                    String searchMsg = groupNode != null ? description : (description == null || description.isEmpty() ? message : message + " - " + description);
                    String msg = ValidatorTreePanel.addSize(searchMsg, errorsWithDescription);
                    DefaultMutableTreeNode messageNode = new DefaultMutableTreeNode(msg);
                    DefaultMutableTreeNode currNode = groupNode != null ? groupNode : severityNode;
                    currNode.add(messageNode);
                    if (oldExpandedRows.contains(searchMsg)) {
                        expandedPaths.add(new TreePath(messageNode.getPath()));
                    }
                    errorsWithDescription.stream().map(DefaultMutableTreeNode::new).forEach(messageNode::add);
                });
            });
        }
        this.valTreeModel.setRoot(rootNode);
        for (TreePath treePath : expandedPaths) {
            this.expandPath(treePath);
        }
        if (selPath != null && (object = (node = (DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject()) instanceof TestError && ((TestError)object).isIgnored()) {
            selPath = null;
        }
        if (selPath != null) {
            node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            Object object2 = node.getUserObject();
            String msg = null;
            if (object2 instanceof String) {
                msg = ValidatorTreePanel.removeSize((String)object2);
            }
            String searchString = msg;
            ValidatorTreePanel.visitTreeNodes(this.getRoot(), n -> {
                boolean found = false;
                Object userInfo = n.getUserObject();
                if (searchObject instanceof TestError && userInfo instanceof TestError) {
                    TestError e1 = (TestError)searchObject;
                    TestError e2 = (TestError)userInfo;
                    found |= e1.getCode() == e2.getCode() && e1.getMessage().equals(e2.getMessage()) && e1.getPrimitives().size() == e2.getPrimitives().size() && e1.getPrimitives().containsAll(e2.getPrimitives());
                } else if (searchObject instanceof String && userInfo instanceof String) {
                    found |= ((String)userInfo).startsWith(searchString);
                } else if (searchObject instanceof Severity) {
                    found |= searchObject.equals(userInfo);
                }
                if (found) {
                    TreePath path = new TreePath(n.getPath());
                    this.setSelectionPath(path);
                    this.scrollPathToVisible(path);
                }
            });
        }
        if (selRow >= 0 && selRow < this.getRowCount() && this.getSelectionCount() == 0) {
            this.setSelectionRow(selRow);
            this.scrollRowToVisible(selRow);
        }
        this.invalidationListeners.fireEvent(Runnable::run);
    }

    private static String addSize(String msg, Collection<?> coll) {
        return msg + " (" + coll.size() + ")";
    }

    private static String removeSize(String msg) {
        int index = msg.lastIndexOf(" (");
        return index > 0 ? msg.substring(0, index) : msg;
    }

    public void addInvalidationListener(Runnable listener) {
        this.invalidationListeners.addListener(listener);
    }

    public void removeInvalidationListener(Runnable listener) {
        this.invalidationListeners.removeListener(listener);
    }

    public final void setErrorList(List<TestError> errors) {
        if (errors != null && errors == this.errors) {
            return;
        }
        ArrayList arrayList = this.errors = errors != null ? errors : new ArrayList();
        if (this.isVisible()) {
            this.clearSelection();
            this.buildTree(false);
        }
    }

    public void setErrors(List<TestError> newerrors) {
        this.errors.clear();
        for (TestError error : newerrors) {
            if (error.isIgnored()) continue;
            this.errors.add(error);
        }
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public List<TestError> getErrors() {
        return this.errors;
    }

    public void selectRelatedErrors(Collection<OsmPrimitive> primitives) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        this.walkAndSelectRelatedErrors(new TreePath(this.getRoot()), new HashSet<OsmPrimitive>(primitives)::contains, paths);
        this.clearSelection();
        this.setSelectionPaths(paths.toArray(new TreePath[0]));
        if (!paths.isEmpty()) {
            this.scrollPathToVisible((TreePath)paths.get(0));
        }
    }

    private void walkAndSelectRelatedErrors(TreePath p, Predicate<OsmPrimitive> isRelevant, Collection<TreePath> paths) {
        int count = this.getModel().getChildCount(p.getLastPathComponent());
        for (int i = 0; i < count; ++i) {
            Object child = this.getModel().getChild(p.getLastPathComponent(), i);
            if (this.getModel().isLeaf(child) && child instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)child).getUserObject() instanceof TestError) {
                TestError error = (TestError)((DefaultMutableTreeNode)child).getUserObject();
                if (!error.getPrimitives().stream().anyMatch(isRelevant)) continue;
                paths.add(p.pathByAddingChild(child));
                continue;
            }
            this.walkAndSelectRelatedErrors(p.pathByAddingChild(child), isRelevant, paths);
        }
    }

    public Set<? extends OsmPrimitive> getFilter() {
        return this.filter;
    }

    public void setFilter(Set<? extends OsmPrimitive> filter) {
        this.filter = filter != null && filter.isEmpty() ? null : filter;
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public void resetErrors() {
        this.resetScheduled = false;
        this.filterRemovedPrimitives();
        this.setErrors(new ArrayList<TestError>(this.errors));
    }

    public void expandAll() {
        ValidatorTreePanel.visitTreeNodes(this.getRoot(), x -> this.expandPath(new TreePath(x.getPath())));
    }

    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.valTreeModel.getRoot();
    }

    @Override
    public void destroy() {
        DatasetEventManager.getInstance().removeDatasetListener(this);
        ToolTipManager.sharedInstance().unregisterComponent(this);
        this.errors.clear();
    }

    public static void visitTreeNodes(DefaultMutableTreeNode root, Consumer<DefaultMutableTreeNode> visitor) {
        Enumeration<TreeNode> errorMessages = root.breadthFirstEnumeration();
        while (errorMessages.hasMoreElements()) {
            visitor.accept((DefaultMutableTreeNode)errorMessages.nextElement());
        }
    }

    public static void visitTestErrors(DefaultMutableTreeNode root, Consumer<TestError> visitor) {
        ValidatorTreePanel.visitTestErrors(root, visitor, null);
    }

    public static void visitTestErrors(DefaultMutableTreeNode root, Consumer<TestError> visitor, Set<DefaultMutableTreeNode> processedNodes) {
        ValidatorTreePanel.visitTreeNodes(root, n -> {
            if (processedNodes == null || !processedNodes.contains(n)) {
                Object o;
                if (processedNodes != null) {
                    processedNodes.add((DefaultMutableTreeNode)n);
                }
                if ((o = n.getUserObject()) instanceof TestError) {
                    visitor.accept((TestError)o);
                }
            }
        });
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        if (this.filterRemovedPrimitives()) {
            this.buildTree();
        }
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
        if (this.filterRemovedPrimitives()) {
            this.buildTree();
        }
    }

    public void setResetScheduled() {
        this.resetScheduled = true;
    }

    private boolean filterRemovedPrimitives() {
        return this.errors.removeIf(error -> error.getPrimitives().stream().anyMatch(p -> p.isDeleted() || p.getDataSet() == null));
    }

    private static final class GroupTreeNode
    extends DefaultMutableTreeNode {
        GroupTreeNode(Object userObject) {
            super(userObject);
        }

        @Override
        public String toString() {
            return I18n.tr("{0} ({1})", super.toString(), this.getLeafCount());
        }
    }
}

