/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.gui.preferences.plugin.PluginInstallation;
import org.openstreetmap.josm.gui.util.ChangeNotifier;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;

public class PluginPreferencesModel
extends ChangeNotifier {
    private final Set<String> currentActivePlugins;
    private final List<PluginInformation> availablePlugins = new ArrayList<PluginInformation>();
    private PluginInstallation filterStatus;
    private String filterExpression;
    private final List<PluginInformation> displayedPlugins = new ArrayList<PluginInformation>();
    private final Map<PluginInformation, Boolean> selectedPluginsMap = new HashMap<PluginInformation, Boolean>();
    private final Set<String> pendingDownloads = new HashSet<String>();

    public PluginPreferencesModel() {
        this.currentActivePlugins = new HashSet<String>();
        this.currentActivePlugins.addAll(Config.getPref().getList("plugins"));
    }

    public void filterDisplayedPlugins(PluginInstallation status) {
        this.filterStatus = status;
        this.doFilter();
    }

    public void filterDisplayedPlugins(String filter) {
        this.filterExpression = filter;
        this.doFilter();
    }

    private void doFilter() {
        this.displayedPlugins.clear();
        for (PluginInformation pi : this.availablePlugins) {
            if (this.filterStatus != null && !this.matchesInstallationStatus(pi) || this.filterExpression != null && !pi.matches(this.filterExpression)) continue;
            this.displayedPlugins.add(pi);
        }
        this.fireStateChanged();
    }

    private boolean matchesInstallationStatus(PluginInformation pi) {
        boolean installed = this.currentActivePlugins.contains(pi.getName());
        return PluginInstallation.ALL == this.filterStatus || PluginInstallation.INSTALLED == this.filterStatus && installed || PluginInstallation.AVAILABLE == this.filterStatus && !installed;
    }

    public void setAvailablePlugins(Collection<PluginInformation> available) {
        this.availablePlugins.clear();
        if (available != null) {
            this.availablePlugins.addAll(available);
        }
        this.availablePluginsModified();
    }

    protected final void availablePluginsModified() {
        this.sort();
        this.filterDisplayedPlugins(this.filterStatus);
        this.filterDisplayedPlugins(this.filterExpression);
        HashSet<String> activePlugins = new HashSet<String>();
        activePlugins.addAll(Config.getPref().getList("plugins"));
        for (PluginInformation pi : this.availablePlugins) {
            if (this.selectedPluginsMap.get(pi) != null || !activePlugins.contains(pi.name)) continue;
            this.selectedPluginsMap.put(pi, Boolean.TRUE);
        }
        this.fireStateChanged();
    }

    protected void updateAvailablePlugin(PluginInformation other) {
        if (other != null) {
            PluginInformation pi = this.getPluginInformation(other.name);
            if (pi == null) {
                this.availablePlugins.add(other);
                return;
            }
            pi.updateFromPluginSite(other);
        }
    }

    public void updateAvailablePlugins(Collection<PluginInformation> fromPluginSite) {
        for (PluginInformation other : fromPluginSite) {
            this.updateAvailablePlugin(other);
        }
        this.availablePluginsModified();
    }

    public List<PluginInformation> getSelectedPlugins() {
        LinkedList<PluginInformation> ret = new LinkedList<PluginInformation>();
        for (PluginInformation pi : this.availablePlugins) {
            if (this.selectedPluginsMap.get(pi) == null || !this.selectedPluginsMap.get(pi).booleanValue()) continue;
            ret.add(pi);
        }
        return ret;
    }

    public Set<String> getSelectedPluginNames() {
        HashSet<String> ret = new HashSet<String>();
        for (PluginInformation pi : this.getSelectedPlugins()) {
            ret.add(pi.name);
        }
        return ret;
    }

    protected void sort() {
        this.availablePlugins.sort(Comparator.comparing(o -> o.getName() == null ? "" : o.getName().toLowerCase(Locale.ENGLISH)));
    }

    public List<PluginInformation> getDisplayedPlugins() {
        return this.displayedPlugins;
    }

    public Set<PluginInformation> getPluginsScheduledForUpdateOrDownload() {
        HashSet<PluginInformation> ret = new HashSet<PluginInformation>();
        for (String plugin : this.pendingDownloads) {
            PluginInformation pi = this.getPluginInformation(plugin);
            if (pi == null) continue;
            ret.add(pi);
        }
        return ret;
    }

    public void setPluginSelected(String name, boolean selected) {
        PluginInformation pi = this.getPluginInformation(name);
        if (pi != null) {
            this.selectedPluginsMap.put(pi, selected);
            if (pi.isUpdateRequired()) {
                this.pendingDownloads.add(pi.name);
            }
        }
        if (!selected) {
            this.pendingDownloads.remove(name);
        }
    }

    public void clearPendingPlugins(Collection<PluginInformation> plugins) {
        if (plugins != null) {
            for (PluginInformation pi : plugins) {
                this.pendingDownloads.remove(pi.name);
            }
        }
    }

    public PluginInformation getPluginInformation(String name) {
        if (name != null) {
            for (PluginInformation pi : this.availablePlugins) {
                if (!name.equals(pi.getName()) && !name.equals(pi.provides)) continue;
                return pi;
            }
        }
        return null;
    }

    public void initFromPreferences() {
        List<String> enabledPlugins = Config.getPref().getList("plugins", null);
        if (enabledPlugins == null) {
            this.selectedPluginsMap.clear();
            return;
        }
        for (String name : enabledPlugins) {
            PluginInformation pi = this.getPluginInformation(name);
            if (pi == null) continue;
            this.setPluginSelected(name, true);
        }
    }

    public boolean isSelectedPlugin(String name) {
        PluginInformation pi = this.getPluginInformation(name);
        if (pi == null || this.selectedPluginsMap.get(pi) == null) {
            return false;
        }
        return this.selectedPluginsMap.get(pi);
    }

    public List<PluginInformation> getNewlyActivatedPlugins() {
        LinkedList<PluginInformation> ret = new LinkedList<PluginInformation>();
        for (Map.Entry<PluginInformation, Boolean> entry : this.selectedPluginsMap.entrySet()) {
            PluginInformation pi = entry.getKey();
            boolean selected = entry.getValue();
            if (!selected || this.currentActivePlugins.contains(pi.name)) continue;
            ret.add(pi);
        }
        return ret;
    }

    public List<PluginInformation> getNewlyDeactivatedPlugins() {
        LinkedList<PluginInformation> ret = new LinkedList<PluginInformation>();
        for (PluginInformation pi : this.availablePlugins) {
            if (!this.currentActivePlugins.contains(pi.name) || this.selectedPluginsMap.get(pi) != null && this.selectedPluginsMap.get(pi).booleanValue()) continue;
            ret.add(pi);
        }
        return ret;
    }

    public List<PluginInformation> getAvailablePlugins() {
        return new LinkedList<PluginInformation>(this.availablePlugins);
    }

    public Set<String> getNewlyActivatedPluginNames() {
        HashSet<String> ret = new HashSet<String>();
        List<PluginInformation> plugins = this.getNewlyActivatedPlugins();
        for (PluginInformation pi : plugins) {
            ret.add(pi.name);
        }
        return ret;
    }

    public boolean isActivePluginsChanged() {
        Set<String> newActivePlugins = this.getSelectedPluginNames();
        return !newActivePlugins.equals(this.currentActivePlugins);
    }

    public void refreshLocalPluginVersion(Collection<PluginInformation> plugins) {
        if (plugins != null) {
            for (PluginInformation pi : plugins) {
                File downloadedPluginFile = PluginHandler.findUpdatedJar(pi.name);
                if (downloadedPluginFile == null) continue;
                try {
                    PluginInformation newinfo = new PluginInformation(downloadedPluginFile, pi.name);
                    PluginInformation oldinfo = this.getPluginInformation(pi.name);
                    if (oldinfo == null) continue;
                    oldinfo.updateLocalInfo(newinfo);
                }
                catch (PluginException e) {
                    Logging.error(e);
                }
            }
        }
    }
}

