/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.io.remotecontrol.RequestProcessor;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class RemoteControlHttpServer
extends Thread {
    private final ServerSocket server;
    private static volatile RemoteControlHttpServer instance4;
    private static volatile RemoteControlHttpServer instance6;

    public static void restartRemoteControlHttpServer() {
        block4: {
            RemoteControlHttpServer.stopRemoteControlHttpServer();
            int port = Config.getPref().getInt("remote.control.port", 8111);
            try {
                instance4 = new RemoteControlHttpServer(port, false);
                instance4.start();
            }
            catch (IOException ex) {
                Logging.debug(ex);
                Logging.warn(I18n.marktr("Cannot start IPv4 remotecontrol server on port {0}: {1}"), Integer.toString(port), ex.getLocalizedMessage());
            }
            try {
                instance6 = new RemoteControlHttpServer(port, true);
                instance6.start();
            }
            catch (IOException ex) {
                if (instance4 != null) break block4;
                Logging.debug(ex);
                Logging.warn(I18n.marktr("Cannot start IPv6 remotecontrol server on port {0}: {1}"), Integer.toString(port), ex.getLocalizedMessage());
            }
        }
    }

    public static void stopRemoteControlHttpServer() {
        if (instance4 != null) {
            try {
                instance4.stopServer();
            }
            catch (IOException ioe) {
                Logging.error(ioe);
            }
            instance4 = null;
        }
        if (instance6 != null) {
            try {
                instance6.stopServer();
            }
            catch (IOException ioe) {
                Logging.error(ioe);
            }
            instance6 = null;
        }
    }

    public RemoteControlHttpServer(int port, boolean ipv6) throws IOException {
        super("RemoteControl HTTP Server");
        this.setDaemon(true);
        this.server = new ServerSocket(port, 1, ipv6 ? RemoteControl.getInet6Address() : RemoteControl.getInet4Address());
    }

    @Override
    public void run() {
        Logging.info(I18n.marktr("RemoteControl::Accepting remote connections on {0}:{1}"), this.server.getInetAddress(), Integer.toString(this.server.getLocalPort()));
        while (true) {
            try {
                while (true) {
                    Socket request = this.server.accept();
                    RequestProcessor.processRequest(request);
                }
            }
            catch (SocketException e) {
                if (!this.server.isClosed()) {
                    Logging.error(e);
                    continue;
                }
                return;
            }
            catch (IOException ioe) {
                Logging.error(ioe);
                continue;
            }
            break;
        }
    }

    public void stopServer() throws IOException {
        Logging.info(I18n.marktr("RemoteControl::Server {0}:{1} stopped."), this.server.getInetAddress(), Integer.toString(this.server.getLocalPort()));
        this.server.close();
    }
}

