/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.X509ExtendedKeyManager;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvDHGroupVerifier;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvSSLSessionHandshake;
import org.bouncycastle.jsse.provider.ProvSSLSessionResumed;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.SupportedGroups;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatusRequest;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerName;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsDHGroupVerifier;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.IPAddress;
import org.bouncycastle.util.encoders.Hex;

class ProvTlsClient
extends DefaultTlsClient
implements ProvTlsPeer {
    private static final Logger LOG = Logger.getLogger(ProvTlsClient.class.getName());
    private static final boolean provEnableSNIExtension = PropertyUtils.getBooleanSystemProperty("jsse.enableSNIExtension", true);
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected ProvSSLSession sslSession = null;
    protected boolean handshakeComplete = false;

    ProvTlsClient(ProvTlsManager provTlsManager, ProvSSLParameters provSSLParameters) {
        super(provTlsManager.getContextData().getCrypto());
        this.manager = provTlsManager;
        this.sslParameters = provSSLParameters;
    }

    protected Vector getProtocolNames() {
        return JsseUtils.getProtocolNames(this.sslParameters.getApplicationProtocols());
    }

    protected CertificateStatusRequest getCertificateStatusRequest() {
        return null;
    }

    protected Vector getSupportedGroups(Vector vector) {
        return SupportedGroups.getClientSupportedGroups(this.getCrypto(), this.manager.getContext().isFips(), vector);
    }

    protected Vector getSNIServerNames() {
        if (provEnableSNIExtension) {
            Object object;
            List<BCSNIServerName> list = this.sslParameters.getServerNames();
            if (null == list && null != (object = this.manager.getPeerHostSNI()) && ((String)object).indexOf(46) > 0 && !IPAddress.isValid((String)object)) {
                try {
                    list = Collections.singletonList(new BCSNIHostName((String)object));
                }
                catch (RuntimeException runtimeException) {
                    LOG.fine("Failed to add peer host as default SNI host_name: " + (String)object);
                }
            }
            if (null != list && !list.isEmpty()) {
                object = new Vector(list.size());
                for (BCSNIServerName bCSNIServerName : list) {
                    ((Vector)object).addElement(new ServerName((short)bCSNIServerName.getType(), bCSNIServerName.getEncoded()));
                }
                return object;
            }
        }
        return null;
    }

    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.manager.getContextData().getCrypto(), this.manager.getContext().convertCipherSuites(this.sslParameters.getCipherSuites()));
    }

    protected Vector getSupportedSignatureAlgorithms() {
        return JsseUtils.getSupportedSignatureAlgorithms(this.getCrypto());
    }

    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    public TlsDHGroupVerifier getDHGroupVerifier() {
        return new ProvDHGroupVerifier();
    }

    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                Object object;
                X500Name[] x500NameArray;
                int n = ProvTlsClient.this.context.getSecurityParametersHandshake().getCipherSuite();
                int n2 = TlsUtils.getKeyExchangeAlgorithm(n);
                switch (n2) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 17: 
                    case 19: {
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(80);
                    }
                }
                short[] sArray = certificateRequest.getCertificateTypes();
                if (sArray == null || sArray.length == 0) {
                    return null;
                }
                String[] stringArray = new String[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    stringArray[i] = JsseUtils.getAuthTypeClient(sArray[i]);
                }
                Principal[] principalArray = null;
                Vector vector = certificateRequest.getCertificateAuthorities();
                if (vector != null && vector.size() > 0) {
                    x500NameArray = vector.toArray(new X500Name[vector.size()]);
                    object = JsseUtils.toX500Principals(x500NameArray);
                    principalArray = object.toArray(new Principal[object.size()]);
                }
                if ((x500NameArray = ProvTlsClient.this.manager.chooseClientAlias(stringArray, principalArray)) == null) {
                    return null;
                }
                object = ProvTlsClient.this.getCrypto();
                if (!(object instanceof JcaTlsCrypto)) {
                    throw new UnsupportedOperationException();
                }
                X509ExtendedKeyManager x509ExtendedKeyManager = ProvTlsClient.this.manager.getContextData().getX509KeyManager();
                PrivateKey privateKey = x509ExtendedKeyManager.getPrivateKey((String)x500NameArray);
                Certificate certificate = JsseUtils.getCertificateMessage((TlsCrypto)object, x509ExtendedKeyManager.getCertificateChain((String)x500NameArray));
                if (privateKey == null || certificate.isEmpty()) {
                    return null;
                }
                switch (n2) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 17: 
                    case 19: {
                        short s = certificate.getCertificateAt(0).getLegacySignatureAlgorithm();
                        SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.chooseSignatureAndHashAlgorithm(ProvTlsClient.this.context, ProvTlsClient.this.context.getSecurityParametersHandshake().getClientSigAlgs(), s);
                        return new JcaDefaultTlsCredentialedSigner(new TlsCryptoParameters(ProvTlsClient.this.context), (JcaTlsCrypto)object, privateKey, certificate, signatureAndHashAlgorithm);
                    }
                }
                throw new TlsFatalAlert(80);
            }

            public void notifyServerCertificate(TlsServerCertificate tlsServerCertificate) throws IOException {
                if (null == tlsServerCertificate || null == tlsServerCertificate.getCertificate() || tlsServerCertificate.getCertificate().isEmpty()) {
                    throw new TlsFatalAlert(40);
                }
                X509Certificate[] x509CertificateArray = JsseUtils.getX509CertificateChain(ProvTlsClient.this.manager.getContextData().getCrypto(), tlsServerCertificate.getCertificate());
                int n = ProvTlsClient.this.context.getSecurityParametersHandshake().getCipherSuite();
                String string = JsseUtils.getAuthTypeServer(TlsUtils.getKeyExchangeAlgorithm(n));
                ProvTlsClient.this.manager.checkServerTrusted(x509CertificateArray, string);
            }
        };
    }

    public ProtocolVersion[] getSupportedVersions() {
        return this.manager.getContext().getSupportedVersions(this.sslParameters.getProtocols());
    }

    public TlsSession getSessionToResume() {
        TlsSession tlsSession;
        ProvSSLSessionContext provSSLSessionContext = this.manager.getContextData().getClientSessionContext();
        ProvSSLSession provSSLSession = provSSLSessionContext.getSessionImpl(this.manager.getPeerHost(), this.manager.getPeerPort());
        if (null != provSSLSession && null != (tlsSession = provSSLSession.getTlsSession()) && this.isResumable(provSSLSession)) {
            this.sslSession = provSSLSession;
            return tlsSession;
        }
        if (!this.manager.getEnableSessionCreation()) {
            throw new IllegalStateException("No resumable sessions and session creation is disabled");
        }
        return null;
    }

    public void notifyAlertRaised(short s, short s2, String string, Throwable throwable) {
        Level level;
        super.notifyAlertRaised(s, s2, string, throwable);
        Level level2 = s == 1 ? Level.FINE : (level = s2 == 80 ? Level.WARNING : Level.INFO);
        if (LOG.isLoggable(level)) {
            String string2 = JsseUtils.getAlertLogMessage("Client raised", s, s2);
            if (string != null) {
                string2 = string2 + ": " + string;
            }
            LOG.log(level, string2, throwable);
        }
    }

    public void notifyAlertReceived(short s, short s2) {
        Level level;
        super.notifyAlertReceived(s, s2);
        Level level2 = level = s == 1 ? Level.FINE : Level.INFO;
        if (LOG.isLoggable(level)) {
            String string = JsseUtils.getAlertLogMessage("Client received", s, s2);
            LOG.log(level, string);
        }
    }

    public synchronized void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        this.handshakeComplete = true;
        TlsSession tlsSession = this.context.getSession();
        if (null == this.sslSession || this.sslSession.getTlsSession() != tlsSession) {
            ProvSSLSessionContext provSSLSessionContext = this.manager.getContextData().getClientSessionContext();
            String string = this.manager.getPeerHost();
            int n = this.manager.getPeerPort();
            JsseSessionParameters jsseSessionParameters = new JsseSessionParameters(this.sslParameters.getEndpointIdentificationAlgorithm());
            this.sslSession = provSSLSessionContext.reportSession(string, n, tlsSession, jsseSessionParameters);
        }
        this.manager.notifyHandshakeComplete(new ProvSSLConnection(this.context, this.sslSession));
    }

    public void notifySecureRenegotiation(boolean bl) throws IOException {
        boolean bl2;
        if (!bl && !(bl2 = PropertyUtils.getBooleanSystemProperty("sun.security.ssl.allowLegacyHelloMessages", true))) {
            throw new TlsFatalAlert(40);
        }
    }

    public void notifySelectedCipherSuite(int n) {
        this.manager.getContext().validateNegotiatedCipherSuite(n);
        LOG.fine("Client notified of selected cipher suite: " + this.manager.getContext().getCipherSuiteString(n));
        super.notifySelectedCipherSuite(n);
    }

    public void notifyServerVersion(ProtocolVersion protocolVersion) throws IOException {
        String string = this.manager.getContext().getProtocolString(protocolVersion);
        LOG.fine("Client notified of selected protocol version: " + string);
        super.notifyServerVersion(protocolVersion);
    }

    public void notifySessionID(byte[] byArray) {
        boolean bl;
        boolean bl2 = bl = null != byArray && byArray.length > 0 && null != this.sslSession && Arrays.areEqual((byte[])byArray, (byte[])this.sslSession.getId());
        if (bl) {
            LOG.fine("Server resumed session: " + Hex.toHexString((byte[])byArray));
        } else {
            if (byArray == null || byArray.length < 1) {
                LOG.fine("Server did not specify a session ID");
            } else {
                LOG.fine("Server specified new session: " + Hex.toHexString((byte[])byArray));
            }
            if (!this.manager.getEnableSessionCreation()) {
                throw new IllegalStateException("Server did not resume session and session creation is disabled");
            }
        }
        ProvSSLSessionContext provSSLSessionContext = this.manager.getContextData().getClientSessionContext();
        String string = this.manager.getPeerHost();
        int n = this.manager.getPeerPort();
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        ProvSSLSessionHandshake provSSLSessionHandshake = !bl ? new ProvSSLSessionHandshake(provSSLSessionContext, string, n, securityParameters) : new ProvSSLSessionResumed(provSSLSessionContext, string, n, securityParameters, this.sslSession.getTlsSession(), this.sslSession.getJsseSessionParameters());
        this.manager.notifyHandshakeSession(provSSLSessionHandshake);
    }

    protected boolean isResumable(ProvSSLSession provSSLSession) {
        String string;
        JsseSessionParameters jsseSessionParameters = provSSLSession.getJsseSessionParameters();
        String string2 = this.sslParameters.getEndpointIdentificationAlgorithm();
        if (null != string2 && !string2.equalsIgnoreCase(string = jsseSessionParameters.getIdentificationProtocol())) {
            LOG.finest("Session not resumed - endpoint ID algorithm mismatch; requested: " + string2 + ", session: " + string);
            return false;
        }
        return true;
    }
}

