/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.math.ec.rfc8032.Ed25519;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;

public class BcTlsEd25519Verifier
extends BcTlsVerifier {
    public BcTlsEd25519Verifier(BcTlsCrypto bcTlsCrypto, Ed25519PublicKeyParameters ed25519PublicKeyParameters) {
        super(bcTlsCrypto, (AsymmetricKeyParameter)ed25519PublicKeyParameters);
    }

    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public TlsStreamVerifier getStreamVerifier(DigitallySigned digitallySigned) {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm == null || signatureAndHashAlgorithm.getSignature() != 7 || signatureAndHashAlgorithm.getHash() != 8) {
            throw new IllegalStateException();
        }
        final byte[] byArray = digitallySigned.getSignature();
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        return new TlsStreamVerifier(){

            public OutputStream getOutputStream() {
                return byteArrayOutputStream;
            }

            public boolean isVerified() throws IOException {
                byte[] byArray3 = new byte[32];
                ((Ed25519PublicKeyParameters)BcTlsEd25519Verifier.this.publicKey).encode(byArray3, 0);
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                return Ed25519.verify((byte[])byArray, (int)0, (byte[])byArray3, (int)0, (byte[])byArray2, (int)0, (int)byArray2.length);
            }
        };
    }
}

