/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import json.ext.RuntimeInfo;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

final class Utils {
    public static final String M_GENERATOR_ERROR = "GeneratorError";
    public static final String M_NESTING_ERROR = "NestingError";
    public static final String M_PARSER_ERROR = "ParserError";

    private Utils() {
        throw new RuntimeException();
    }

    static RubyArray ensureArray(IRubyObject iRubyObject) throws RaiseException {
        if (iRubyObject instanceof RubyArray) {
            return (RubyArray)iRubyObject;
        }
        Ruby ruby = iRubyObject.getRuntime();
        throw ruby.newTypeError(iRubyObject, ruby.getArray());
    }

    static RubyHash ensureHash(IRubyObject iRubyObject) throws RaiseException {
        if (iRubyObject instanceof RubyHash) {
            return (RubyHash)iRubyObject;
        }
        Ruby ruby = iRubyObject.getRuntime();
        throw ruby.newTypeError(iRubyObject, ruby.getHash());
    }

    static RubyString ensureString(IRubyObject iRubyObject) throws RaiseException {
        if (iRubyObject instanceof RubyString) {
            return (RubyString)iRubyObject;
        }
        Ruby ruby = iRubyObject.getRuntime();
        throw ruby.newTypeError(iRubyObject, ruby.getString());
    }

    static RaiseException newException(ThreadContext threadContext, String string, String string2) {
        return Utils.newException(threadContext, string, threadContext.getRuntime().newString(string2));
    }

    static RaiseException newException(ThreadContext threadContext, String string, RubyString rubyString) {
        RuntimeInfo runtimeInfo = RuntimeInfo.forRuntime(threadContext.getRuntime());
        RubyClass rubyClass = ((RubyModule)runtimeInfo.jsonModule.get()).getClass(string);
        RubyException rubyException = (RubyException)rubyClass.newInstance(threadContext, new IRubyObject[]{rubyString}, Block.NULL_BLOCK);
        return new RaiseException(rubyException);
    }

    static byte[] repeat(ByteList byteList, int n) {
        return Utils.repeat(byteList.unsafeBytes(), byteList.begin(), byteList.length(), n);
    }

    static byte[] repeat(byte[] byArray, int n, int n2, int n3) {
        if (n2 == 0) {
            return ByteList.NULL_ARRAY;
        }
        int n4 = n2 * n3;
        byte[] byArray2 = new byte[n4];
        for (int i = 0; i < n4; i += n2) {
            System.arraycopy(byArray, n, byArray2, i, n2);
        }
        return byArray2;
    }
}

