/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.date;

import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.ext.date.RubyDate;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Numeric;

abstract class DateUtils {
    static final int INVALID_OFFSET = Integer.MIN_VALUE;
    private static final int JC_PERIOD0 = 1461;
    private static final int GC_PERIOD0 = 146097;
    private static final int CM_PERIOD0 = 71149239;
    static final int CM_PERIOD = 213447717;
    private static final int CM_PERIOD_JCY = 584388;
    private static final int CM_PERIOD_GCY = 584400;

    DateUtils() {
    }

    static long civil_to_jd(int y, int m, int d, double sg) {
        if (m <= 2) {
            --y;
            m += 12;
        }
        double a = Math.floor((double)y / 100.0);
        double b2 = 2.0 - a + Math.floor(a / 4.0);
        double jd2 = Math.floor(365.25 * (double)(y + 4716)) + Math.floor(30.6001 * (double)(m + 1)) + (double)d + b2 - 1524.0;
        if (jd2 < sg) {
            jd2 -= b2;
        }
        return (long)jd2;
    }

    static int[] jd_to_civil(long jd2, double sg) {
        double y;
        double m;
        double a;
        if ((double)jd2 < sg) {
            a = jd2;
        } else {
            double x = Math.floor(((double)jd2 - 1867216.25) / 36524.25);
            a = (double)(jd2 + 1L) + x - Math.floor(x / 4.0);
        }
        double b2 = a + 1524.0;
        double c = Math.floor((b2 - 122.1) / 365.25);
        double d = Math.floor(365.25 * c);
        double e = Math.floor((b2 - d) / 30.6001);
        double dom = b2 - d - Math.floor(30.6001 * e);
        if (e <= 13.0) {
            m = e - 1.0;
            y = c - 4716.0;
        } else {
            m = e - 13.0;
            y = c - 4715.0;
        }
        return new int[]{(int)y, (int)m, (int)dom};
    }

    static long ordinal_to_jd(int y, int d, long sg) {
        return DateUtils.find_fdoy(y, sg) + (long)d - 1L;
    }

    static int[] jd_to_ordinal(long jd2, double sg) {
        int y = DateUtils.jd_to_civil(jd2, sg)[0];
        long j = DateUtils.find_fdoy(y, (int)sg);
        return new int[]{y, (int)(jd2 - j + 1L)};
    }

    static long commercial_to_jd(int y, int w, int d, long sg) {
        long j = DateUtils.find_fdoy(y, sg) + 3L;
        return j - (j - 1L + 1L) % 7L + (long)(7 * (w - 1)) + (long)(d - 1);
    }

    static int[] jd_to_commercial(long jd2, long sg) {
        int a = DateUtils.jd_to_civil(jd2 - 3L, sg)[0];
        int y = jd2 >= DateUtils.commercial_to_jd(a + 1, 1, 1, sg) ? a + 1 : a;
        int w = 1 + (int)((jd2 - DateUtils.commercial_to_jd(y, 1, 1, sg)) / 7L);
        int d = (int)((jd2 + 1L) % 7L);
        if (d == 0) {
            d = 7;
        }
        return new int[]{y, w, d};
    }

    private static long weeknum_to_jd(int y, int w, int d, int f, long sg) {
        long a = DateUtils.find_fdoy(y, sg) + 6L;
        return a - (a - (long)f + 1L) % 7L - 7L + (long)(7 * w) + (long)d;
    }

    private static int[] jd_to_weeknum(long jd2, int f, long sg) {
        int y = DateUtils.jd_to_civil(jd2, sg)[0];
        long a = DateUtils.find_fdoy(y, sg) + 6L;
        long val = jd2 - (a - (a - (long)f + 1L) % 7L) + 7L;
        int w = (int)(val / 7L);
        int d = (int)(val % 7L);
        return new int[]{y, w, d};
    }

    private static long nth_kday_to_jd(int y, int m, int n, int k, long sg) {
        long j = n > 0 ? DateUtils.find_fdom(y, m, sg) - 1L : DateUtils.find_ldom(y, m, sg) + 7L;
        return j - (j - (long)k + 1L) % 7L + (long)(7 * n);
    }

    private static int[] jd_to_nth_kday(long jd2, long sg) {
        int[] y_m_d = DateUtils.jd_to_civil(jd2, sg);
        int y = y_m_d[0];
        int m = y_m_d[1];
        long j = DateUtils.find_fdom(y, m, sg);
        int jd_to_wday = (int)((jd2 + 1L) % 7L);
        return new int[]{y, m, (int)((jd2 - j) / 7L + 1L), jd_to_wday};
    }

    static boolean valid_time_p(long h, long min2, long s2) {
        if (h < 0L) {
            h += 24L;
        }
        if (min2 < 0L) {
            min2 += 60L;
        }
        if (s2 < 0L) {
            s2 += 60L;
        }
        return h >= 0L && h <= 24L && min2 >= 0L && min2 <= 59L && s2 >= 0L && s2 <= 59L && (h != 24L || min2 <= 0L && s2 <= 0L);
    }

    static IRubyObject day_to_sec(ThreadContext context, IRubyObject d) {
        return RubyFixnum.newFixnum(context.runtime, 86400L).op_mul(context, d);
    }

    static int offset_to_sec(ThreadContext context, IRubyObject of) {
        switch (of.getMetaClass().getClassIndex()) {
            case INTEGER: {
                long i2 = ((RubyInteger)of).getLongValue();
                if (i2 != -1L && i2 != 0L && i2 != 1L) {
                    return Integer.MIN_VALUE;
                }
                return (int)i2 * 86400;
            }
            case FLOAT: {
                double d = ((RubyFloat)of).getDoubleValue();
                if ((d *= 86400.0) < -86400.0 || d > 86400.0) {
                    return Integer.MIN_VALUE;
                }
                long n = Math.round(d);
                return (int)n;
            }
            case STRING: {
                RubyClass date2 = RubyDate.getDate(context.runtime);
                IRubyObject vs = DateUtils.sites((ThreadContext)context).zone_to_diff.call(context, (IRubyObject)date2, (IRubyObject)date2, of);
                if (!(vs instanceof RubyFixnum)) {
                    return Integer.MIN_VALUE;
                }
                long n = ((RubyFixnum)vs).getLongValue();
                if (n < -86400L || n > 86400L) {
                    return Integer.MIN_VALUE;
                }
                return (int)n;
            }
            case RATIONAL: {
                long n;
                IRubyObject vs = DateUtils.day_to_sec(context, of);
                if (!(vs instanceof RubyRational)) {
                    if (!(vs instanceof RubyFixnum)) {
                        return Integer.MIN_VALUE;
                    }
                    long n2 = ((RubyFixnum)vs).getLongValue();
                    if (n2 < -86400L || n2 > 86400L) {
                        return Integer.MIN_VALUE;
                    }
                    return (int)n2;
                }
                RubyInteger vn = ((RubyRational)vs).getNumerator();
                RubyInteger vd = ((RubyRational)vs).getDenominator();
                if (vn instanceof RubyFixnum && vd instanceof RubyFixnum && vd.getLongValue() == 1L) {
                    n = ((RubyFixnum)vn).getLongValue();
                } else {
                    vn = (RubyInteger)((RubyRational)vs).round(context);
                    if (!(vn instanceof RubyFixnum)) {
                        return Integer.MIN_VALUE;
                    }
                    n = ((RubyFixnum)vn).getLongValue();
                    if (n < -86400L || n > 86400L) {
                        return Integer.MIN_VALUE;
                    }
                }
                return (int)n;
            }
        }
        return Integer.MIN_VALUE;
    }

    static Long find_ldom(int y, int m, long sg) {
        Long j = null;
        for (int d = 31; d >= 1 && (j = DateUtils._valid_civil_p(y, m, d, sg)) == null; --d) {
        }
        return j;
    }

    static Long find_fdom(int y, int m, long sg) {
        Long j = null;
        for (int d = 1; d <= 31 && (j = DateUtils._valid_civil_p(y, m, d, sg)) == null; ++d) {
        }
        return j;
    }

    static Long find_fdoy(int y, long sg) {
        Long j = null;
        for (int d = 1; d <= 31 && (j = DateUtils._valid_civil_p(y, 1, d, sg)) == null; ++d) {
        }
        return j;
    }

    static Long find_ldoy(int y, long sg) {
        Long j = null;
        for (int d = 31; d >= 1 && (j = DateUtils._valid_civil_p(y, 12, d, sg)) == null; --d) {
        }
        return j;
    }

    static Long _valid_civil_p(int y, int m, int d, long sg) {
        long jd2;
        int[] y_m_d;
        if (d < 0) {
            Long j = DateUtils.find_ldom(y, m, sg);
            if (j == null) {
                return null;
            }
            int[] ny_nm_nd = DateUtils.jd_to_civil(j + (long)d + 1L, sg);
            if (y != ny_nm_nd[0] || m != ny_nm_nd[1]) {
                return null;
            }
            d = ny_nm_nd[2];
        }
        if (y != (y_m_d = DateUtils.jd_to_civil(jd2 = DateUtils.civil_to_jd(y, m, d, sg), sg))[0] || m != y_m_d[1] || d != y_m_d[2]) {
            return null;
        }
        return jd2;
    }

    static Long _valid_ordinal_p(int y, int d, long sg) {
        long jd2;
        int[] y_d;
        if (d < 0) {
            Long j = DateUtils.find_ldoy(y, sg);
            if (j == null) {
                return null;
            }
            int[] ny_nd = DateUtils.jd_to_ordinal(j + (long)d + 1L, sg);
            if (y != ny_nd[0]) {
                return null;
            }
            d = ny_nd[1];
        }
        if (y != (y_d = DateUtils.jd_to_ordinal(jd2 = DateUtils.ordinal_to_jd(y, d, sg), sg))[0] || d != y_d[1]) {
            return null;
        }
        return jd2;
    }

    static Long _valid_commercial_p(int y, int w, int d, long sg) {
        long jd2;
        int[] ny_nw_nd;
        if (d < 0) {
            d += 8;
        }
        if (w < 0) {
            int[] ny_nw_nd2 = DateUtils.jd_to_commercial(DateUtils.commercial_to_jd(y + 1, 1, 1, sg) + (long)(w * 7), sg);
            if (y != ny_nw_nd2[0]) {
                return null;
            }
            w = ny_nw_nd2[1];
        }
        if (y != (ny_nw_nd = DateUtils.jd_to_commercial(jd2 = DateUtils.commercial_to_jd(y, w, d, sg), sg))[0] || w != ny_nw_nd[1] || d != ny_nw_nd[2]) {
            return null;
        }
        return jd2;
    }

    static Long _valid_weeknum_p(int y, int w, int d, int f, long sg) {
        long jd2;
        int[] ny_nw_nd;
        if (d < 0) {
            d += 7;
        }
        if (w < 0) {
            int[] ny_nw_nd2 = DateUtils.jd_to_weeknum(DateUtils.weeknum_to_jd(y + 1, 1, f, f, sg) + (long)(w * 7), f, sg);
            if (y != ny_nw_nd2[0]) {
                return null;
            }
            w = ny_nw_nd2[1];
        }
        if (y != (ny_nw_nd = DateUtils.jd_to_weeknum(jd2 = DateUtils.weeknum_to_jd(y, w, d, f, sg), f, sg))[0] || w != ny_nw_nd[1] || d != ny_nw_nd[2]) {
            return null;
        }
        return jd2;
    }

    static Long _valid_nth_kday_p(int y, int m, int n, int k, long sg) {
        long jd2;
        int[] ny_nm_nn_nk;
        if (k < 0) {
            k += 7;
        }
        if (n < 0) {
            int val = y * 12 + m;
            int ny = val / 12;
            int nm = val % 12;
            int[] ny_nm_nn_nk2 = DateUtils.jd_to_nth_kday(DateUtils.nth_kday_to_jd(ny, nm = (nm + 1) / 1, 1, k, sg) + (long)(n * 7), sg);
            if (y != ny_nm_nn_nk2[0] || m != ny_nm_nn_nk2[1]) {
                return null;
            }
            n = ny_nm_nn_nk2[2];
        }
        if (y != (ny_nm_nn_nk = DateUtils.jd_to_nth_kday(jd2 = DateUtils.nth_kday_to_jd(y, m, n, k, sg), sg))[0] || m != ny_nm_nn_nk[1] || n != ny_nm_nn_nk[2] || k != ny_nm_nn_nk[3]) {
            return null;
        }
        return jd2;
    }

    static int decode_year(ThreadContext context, IRubyObject y, int style, RubyInteger[] nth) {
        long iy;
        int period;
        int n = period = style < 0 ? 584400 : 584388;
        if (y instanceof RubyFixnum && (iy = ((RubyFixnum)y).getLongValue()) < 9223372036854771095L) {
            long it = iy + 4712L;
            long inth = it / (long)period;
            if (inth != 0L) {
                it %= (long)period;
            }
            nth[0] = RubyFixnum.newFixnum(context.runtime, inth);
            return (int)it - 4712;
        }
        IRubyObject t = Numeric.f_add(context, y, (IRubyObject)RubyFixnum.newFixnum(context.runtime, 4712L));
        nth[0] = (RubyInteger)Numeric.f_idiv(context, t, (IRubyObject)RubyFixnum.newFixnum(context.runtime, period));
        if (!Numeric.f_zero_p(context, nth[0])) {
            t = Numeric.f_mod(context, t, RubyFixnum.newFixnum(context.runtime, period));
        }
        return t.convertToInteger().getIntValue() - 4712;
    }

    static long guess_style(ThreadContext context, IRubyObject y, double sg) {
        long style = 0L;
        if (sg == Double.POSITIVE_INFINITY) {
            style = Long.MAX_VALUE;
        } else if (sg == Double.NEGATIVE_INFINITY) {
            style = Long.MIN_VALUE;
        } else if (!(y instanceof RubyFixnum)) {
            style = ((RubyNumeric)y).isPositive(context).isTrue() ? Long.MIN_VALUE : Long.MAX_VALUE;
        } else {
            long iy = y.convertToInteger().getLongValue();
            if (iy < 1582L) {
                style = Long.MAX_VALUE;
            } else if (iy > 1930L) {
                style = Long.MIN_VALUE;
            }
        }
        return style;
    }

    private static JavaSites.DateSites sites(ThreadContext context) {
        return context.sites.Date;
    }
}

