/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.IPProto;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import jnr.constants.platform.TCP;
import jnr.unixsocket.UnixSocketAddress;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.ext.socket.Addrinfo;
import org.jruby.ext.socket.MulticastStateManager;
import org.jruby.ext.socket.Option;
import org.jruby.ext.socket.SocketType;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.platform.Platform;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelFD;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.Sockaddr;

@JRubyClass(name={"BasicSocket"}, parent="IO")
public class RubyBasicSocket
extends RubyIO {
    private static ObjectAllocator BASICSOCKET_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyBasicSocket(runtime2, klass);
        }
    };
    private static final ByteList FORMAT_SMALL_I = new ByteList(new byte[]{105}, false);
    protected MulticastStateManager multicastStateManager = null;
    private boolean doNotReverseLookup = true;

    static void createBasicSocket(Ruby runtime2) {
        RubyClass rb_cBasicSocket = runtime2.defineClass("BasicSocket", runtime2.getIO(), BASICSOCKET_ALLOCATOR);
        rb_cBasicSocket.defineAnnotatedMethods(RubyBasicSocket.class);
        rb_cBasicSocket.undefineMethod("initialize");
    }

    public RubyBasicSocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject for_fd(ThreadContext context, IRubyObject _klass, IRubyObject _fileno) {
        Ruby runtime2 = context.runtime;
        int fileno2 = (int)_fileno.convertToInteger().getLongValue();
        RubyClass klass = (RubyClass)_klass;
        ChannelFD fd = runtime2.getFilenoUtil().getWrapperFromFileno(fileno2);
        RubyBasicSocket basicSocket = (RubyBasicSocket)klass.getAllocator().allocate(runtime2, klass);
        basicSocket.initSocket(fd);
        return basicSocket;
    }

    @JRubyMethod(name={"do_not_reverse_lookup"})
    public IRubyObject do_not_reverse_lookup19(ThreadContext context) {
        return context.runtime.newBoolean(this.doNotReverseLookup);
    }

    @JRubyMethod(name={"do_not_reverse_lookup="})
    public IRubyObject set_do_not_reverse_lookup19(ThreadContext context, IRubyObject flag) {
        this.doNotReverseLookup = flag.isTrue();
        return this.do_not_reverse_lookup19(context);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject do_not_reverse_lookup(ThreadContext context, IRubyObject recv2) {
        return context.runtime.newBoolean(context.runtime.isDoNotReverseLookupEnabled());
    }

    @JRubyMethod(name={"do_not_reverse_lookup="}, meta=true)
    public static IRubyObject set_do_not_reverse_lookup(ThreadContext context, IRubyObject recv2, IRubyObject flag) {
        context.runtime.setDoNotReverseLookupEnabled(flag.isTrue());
        return flag;
    }

    @JRubyMethod(name={"send"})
    public IRubyObject send(ThreadContext context, IRubyObject _mesg, IRubyObject _flags) {
        return this.syswrite(context, _mesg);
    }

    @JRubyMethod(name={"send"})
    public IRubyObject send(ThreadContext context, IRubyObject _mesg, IRubyObject _flags, IRubyObject _to) {
        return this.send(context, _mesg, _flags);
    }

    @JRubyMethod
    public IRubyObject recv(ThreadContext context, IRubyObject length2) {
        return this.recv(context, length2, null, null);
    }

    @JRubyMethod(required=2, optional=1)
    public IRubyObject recv(ThreadContext context, IRubyObject[] args2) {
        IRubyObject flags2;
        RubyString str;
        IRubyObject length2;
        switch (args2.length) {
            case 3: {
                length2 = args2[0];
                str = (RubyString)args2[1];
                flags2 = args2[2].convertToHash();
                break;
            }
            case 2: {
                length2 = args2[0];
                flags2 = TypeConverter.checkHashType(context.runtime, args2[1]);
                str = flags2.isNil() ? (RubyString)args2[1] : null;
                break;
            }
            case 1: {
                length2 = args2[0];
                str = null;
                flags2 = null;
                break;
            }
            default: {
                length2 = context.nil;
                str = null;
                flags2 = null;
            }
        }
        return this.recv(context, length2, str, flags2);
    }

    private IRubyObject recv(ThreadContext context, IRubyObject length2, RubyString str, IRubyObject flags2) {
        ByteBuffer buffer = ByteBuffer.allocate(RubyNumeric.fix2int(length2));
        ByteList bytes2 = this.doRead(context, buffer);
        if (bytes2 == null) {
            return context.nil;
        }
        if (str != null) {
            str.setValue(bytes2);
            return str;
        }
        return RubyString.newString(context.runtime, bytes2);
    }

    @JRubyMethod(required=1, optional=3)
    public IRubyObject recv_nonblock(ThreadContext context, IRubyObject[] args2) {
        IRubyObject flags2;
        int argc = args2.length;
        IRubyObject opts = ArgsUtil.getOptionsArg(context.runtime, args2);
        if (opts != context.nil) {
            --argc;
        }
        IRubyObject length2 = flags2 = context.nil;
        IRubyObject str = null;
        switch (argc) {
            case 3: {
                str = args2[2];
            }
            case 2: {
                flags2 = args2[1];
            }
            case 1: {
                length2 = args2[0];
            }
        }
        ByteBuffer buffer = ByteBuffer.allocate(RubyNumeric.fix2int(length2));
        ByteList bytes2 = this.doReadNonblock(context, buffer);
        if (bytes2 == null) {
            if (!RubyBasicSocket.extractExceptionArg(context, opts)) {
                return context.runtime.newSymbol("wait_readable");
            }
            throw context.runtime.newErrnoEAGAINReadableError("recvfrom(2)");
        }
        if (str != null && str != context.nil) {
            str = str.convertToString();
            ((RubyString)str).setValue(bytes2);
            return str;
        }
        return RubyString.newString(context.runtime, bytes2);
    }

    @JRubyMethod
    public IRubyObject getsockopt(ThreadContext context, IRubyObject _level, IRubyObject _opt) {
        Ruby runtime2 = context.runtime;
        SocketLevel level2 = SocketUtils.levelFromArg(_level);
        SocketOption opt = SocketUtils.optionFromArg(_opt);
        try {
            Channel channel = this.getOpenChannel();
            switch (level2) {
                case SOL_SOCKET: 
                case SOL_IP: 
                case SOL_TCP: 
                case SOL_UDP: {
                    if (opt == SocketOption.__UNKNOWN_CONSTANT__) {
                        throw runtime2.newErrnoENOPROTOOPTError();
                    }
                    int value2 = SocketType.forChannel(channel).getSocketOption(channel, opt);
                    ByteList packedValue = opt == SocketOption.SO_LINGER ? (value2 == -1 ? Option.packLinger(0, 0) : Option.packLinger(1, value2)) : Option.packInt(value2);
                    return new Option(runtime2, ProtocolFamily.PF_INET, level2, opt, packedValue);
                }
            }
            throw runtime2.newErrnoENOPROTOOPTError();
        }
        catch (IOException e) {
            throw runtime2.newErrnoENOPROTOOPTError();
        }
    }

    @JRubyMethod
    public IRubyObject setsockopt(ThreadContext context, IRubyObject option) {
        if (option instanceof Option) {
            Option rsockopt = (Option)option;
            return this.setsockopt(context, rsockopt.level(context), rsockopt.optname(context), rsockopt.data(context));
        }
        throw context.runtime.newArgumentError(option.toString() + " is not a Socket::Option");
    }

    @JRubyMethod
    public IRubyObject setsockopt(ThreadContext context, IRubyObject _level, IRubyObject _opt, IRubyObject val) {
        Ruby runtime2 = context.runtime;
        SocketLevel level2 = SocketUtils.levelFromArg(_level);
        SocketOption opt = SocketUtils.optionFromArg(_opt);
        try {
            Channel channel = this.getOpenChannel();
            SocketType socketType = SocketType.forChannel(channel);
            switch (level2) {
                case SOL_SOCKET: 
                case SOL_IP: 
                case SOL_TCP: 
                case SOL_UDP: {
                    if (opt == SocketOption.SO_LINGER) {
                        if (val instanceof RubyString) {
                            int[] linger2 = Option.unpackLinger(val.convertToString().getByteList());
                            socketType.setSoLinger(channel, linger2[0] != 0, linger2[1]);
                            break;
                        }
                        throw runtime2.newErrnoEINVALError("setsockopt(2)");
                    }
                    socketType.setSocketOption(channel, opt, RubyBasicSocket.asNumber(context, val));
                    break;
                }
                default: {
                    int intLevel = (int)_level.convertToInteger().getLongValue();
                    int intOpt = (int)_opt.convertToInteger().getLongValue();
                    if (IPProto.IPPROTO_TCP.intValue() == intLevel && TCP.TCP_NODELAY.intValue() == intOpt) {
                        socketType.setTcpNoDelay(channel, this.asBoolean(context, val));
                        break;
                    }
                    if (IPProto.IPPROTO_IP.intValue() == intLevel) {
                        if (12 == intOpt) {
                            this.joinMulticastGroup(val);
                        }
                        break;
                    }
                    throw runtime2.newErrnoENOPROTOOPTError();
                }
            }
        }
        catch (BadDescriptorException e) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime2.newErrnoENOPROTOOPTError();
        }
        return runtime2.newFixnum(0);
    }

    @JRubyMethod(name={"getsockname"})
    public IRubyObject getsockname(ThreadContext context) {
        return this.getSocknameCommon(context, "getsockname");
    }

    @JRubyMethod(name={"getpeername"})
    public IRubyObject getpeername(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        InetSocketAddress sock = this.getInetRemoteSocket();
        if (sock != null) {
            return Sockaddr.pack_sockaddr_in(context, sock);
        }
        UnixSocketAddress unix2 = this.getUnixRemoteSocket();
        return Sockaddr.pack_sockaddr_un(context, unix2.path());
    }

    @JRubyMethod(name={"getpeereid"}, notImplemented=true)
    public IRubyObject getpeereid(ThreadContext context) {
        throw context.runtime.newNotImplementedError("getpeereid not implemented");
    }

    @JRubyMethod
    public IRubyObject local_address(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        InetSocketAddress address2 = this.getInetSocketAddress();
        if (address2 != null) {
            SocketType socketType = SocketType.forChannel(this.getChannel());
            return new Addrinfo(runtime2, runtime2.getClass("Addrinfo"), address2, socketType.getSocketType(), socketType);
        }
        UnixSocketAddress unix2 = this.getUnixSocketAddress();
        return Addrinfo.unix(context, runtime2.getClass("Addrinfo"), runtime2.newString(unix2.path()));
    }

    @JRubyMethod
    public IRubyObject remote_address(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        InetSocketAddress address2 = this.getInetRemoteSocket();
        if (address2 != null) {
            SocketType socketType = SocketType.forChannel(this.getChannel());
            return new Addrinfo(runtime2, runtime2.getClass("Addrinfo"), address2, socketType.getSocketType(), socketType);
        }
        UnixSocketAddress unix2 = this.getUnixRemoteSocket();
        if (unix2 != null) {
            return Addrinfo.unix(context, runtime2.getClass("Addrinfo"), runtime2.newString(unix2.path()));
        }
        throw runtime2.newErrnoENOTCONNError();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(optional=1)
    public IRubyObject shutdown(ThreadContext context, IRubyObject[] args2) {
        int how = 2;
        if (args2.length > 0) {
            String howString = null;
            if (args2[0] instanceof RubyString || args2[0] instanceof RubySymbol) {
                howString = args2[0].asJavaString();
            } else {
                Ruby runtime2 = context.runtime;
                IRubyObject maybeString = TypeConverter.checkStringType(runtime2, args2[0]);
                if (!maybeString.isNil()) {
                    howString = maybeString.toString();
                }
            }
            if (howString != null) {
                if (howString.equals("RD") || howString.equals("SHUT_RD")) {
                    how = 0;
                } else if (howString.equals("WR") || howString.equals("SHUT_WR")) {
                    how = 1;
                } else {
                    if (!howString.equals("RDWR") && !howString.equals("SHUT_RDWR")) throw SocketUtils.sockerr(context.runtime, "`how' should be either :SHUT_RD, :SHUT_WR, :SHUT_RDWR");
                    how = 2;
                }
            } else {
                how = RubyNumeric.fix2int(args2[0]);
            }
        }
        OpenFile fptr = this.getOpenFileChecked();
        return RubyBasicSocket.shutdownInternal(context, fptr, how);
    }

    @Override
    @JRubyMethod
    public IRubyObject close_write(ThreadContext context) {
        return this.closeHalf(context, 2);
    }

    @Override
    @JRubyMethod
    public IRubyObject close_read(ThreadContext context) {
        return this.closeHalf(context, 1);
    }

    private IRubyObject closeHalf(ThreadContext context, int closeHalf) {
        int otherHalf = closeHalf == 1 ? 2 : 1;
        OpenFile fptr = this.getOpenFileChecked();
        if ((fptr.getMode() & otherHalf) == 0) {
            return this.rbIoClose(context);
        }
        int how = closeHalf == 1 ? 0 : 1;
        RubyBasicSocket.shutdownInternal(context, fptr, how);
        return context.nil;
    }

    @JRubyMethod(rest=true, notImplemented=true)
    public IRubyObject sendmsg(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("sendmsg is not implemented");
    }

    @JRubyMethod(rest=true, notImplemented=true)
    public IRubyObject sendmsg_nonblock(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("sendmsg_nonblock is not implemented");
    }

    @JRubyMethod(rest=true, notImplemented=true)
    public IRubyObject recvmsg(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("recvmsg is not implemented");
    }

    @JRubyMethod(rest=true, notImplemented=true)
    public IRubyObject recvmsg_nonblock(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("recvmsg_nonblock is not implemented");
    }

    protected ByteList doRead(ThreadContext context, ByteBuffer buffer) {
        OpenFile fptr = this.getOpenFileInitialized();
        fptr.checkReadable(context);
        try {
            context.getThread().beforeBlockingCall();
            int read2 = this.openFile.readChannel().read(buffer);
            if (read2 == 0) {
                ByteList byteList = null;
                return byteList;
            }
            ByteList byteList = new ByteList(buffer.array(), 0, buffer.position(), false);
            return byteList;
        }
        catch (IOException e) {
            if ("Socket not open".equals(e.getMessage())) {
                throw context.runtime.newIOError(e.getMessage());
            }
            throw context.runtime.newSystemCallError(e.getMessage());
        }
        finally {
            context.getThread().afterBlockingCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ByteList doReadNonblock(ThreadContext context, ByteBuffer buffer) {
        Channel channel = this.getChannel();
        if (!(channel instanceof SelectableChannel)) {
            throw context.runtime.newErrnoEAGAINReadableError(channel.getClass().getName() + " does not support nonblocking");
        }
        SelectableChannel selectable = (SelectableChannel)channel;
        Object object = selectable.blockingLock();
        synchronized (object) {
            ByteList byteList;
            boolean oldBlocking = selectable.isBlocking();
            selectable.configureBlocking(false);
            try {
                byteList = this.doRead(context, buffer);
            }
            catch (Throwable throwable) {
                try {
                    selectable.configureBlocking(oldBlocking);
                    throw throwable;
                }
                catch (IOException e) {
                    throw context.runtime.newIOErrorFromException(e);
                }
            }
            selectable.configureBlocking(oldBlocking);
            return byteList;
        }
    }

    private void joinMulticastGroup(IRubyObject val) throws IOException, BadDescriptorException {
        Channel socketChannel = this.getOpenChannel();
        if (socketChannel instanceof DatagramChannel) {
            if (this.multicastStateManager == null) {
                this.multicastStateManager = new MulticastStateManager();
            }
            if (val instanceof RubyString) {
                byte[] ipaddr_buf = val.convertToString().getBytes();
                this.multicastStateManager.addMembership(ipaddr_buf);
            }
        }
    }

    protected InetSocketAddress getInetSocketAddress() {
        SocketAddress socketAddress = this.getSocketAddress();
        if (socketAddress instanceof InetSocketAddress) {
            return (InetSocketAddress)socketAddress;
        }
        return null;
    }

    protected InetSocketAddress getInetRemoteSocket() {
        SocketAddress socketAddress = this.getRemoteSocket();
        if (socketAddress instanceof InetSocketAddress) {
            return (InetSocketAddress)socketAddress;
        }
        return null;
    }

    protected UnixSocketAddress getUnixSocketAddress() {
        SocketAddress socketAddress = this.getSocketAddress();
        if (socketAddress instanceof UnixSocketAddress) {
            return (UnixSocketAddress)socketAddress;
        }
        return null;
    }

    protected UnixSocketAddress getUnixRemoteSocket() {
        SocketAddress socketAddress = this.getRemoteSocket();
        if (socketAddress instanceof UnixSocketAddress) {
            return (UnixSocketAddress)socketAddress;
        }
        return null;
    }

    protected SocketAddress getSocketAddress() {
        Channel channel = this.getOpenChannel();
        return SocketType.forChannel(channel).getLocalSocketAddress(channel);
    }

    protected SocketAddress getRemoteSocket() {
        Channel channel = this.getOpenChannel();
        SocketAddress address2 = SocketType.forChannel(channel).getRemoteSocketAddress(channel);
        if (address2 == null) {
            throw this.getRuntime().newErrnoENOTCONNError();
        }
        return address2;
    }

    protected IRubyObject getSocknameCommon(ThreadContext context, String caller2) {
        if (this.getInetSocketAddress() != null) {
            return Sockaddr.pack_sockaddr_in(context, this.getInetSocketAddress());
        }
        if (this.getUnixSocketAddress() != null) {
            return Sockaddr.pack_sockaddr_un(context, this.getUnixSocketAddress().path());
        }
        return Sockaddr.pack_sockaddr_in(context, 0, "0.0.0.0");
    }

    private static IRubyObject shutdownInternal(ThreadContext context, OpenFile fptr, int how) {
        Ruby runtime2 = context.runtime;
        switch (how) {
            case 0: {
                Channel channel = fptr.channel();
                try {
                    SocketType.forChannel(channel).shutdownInput(channel);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                fptr.setMode(fptr.getMode() & 0xFFFFFFFE);
                return RubyFixnum.zero(runtime2);
            }
            case 1: {
                Channel channel = fptr.channel();
                try {
                    SocketType.forChannel(channel).shutdownOutput(channel);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                fptr.setMode(fptr.getMode() & 0xFFFFFFFD);
                return RubyFixnum.zero(runtime2);
            }
            case 2: {
                RubyBasicSocket.shutdownInternal(context, fptr, 0);
                RubyBasicSocket.shutdownInternal(context, fptr, 1);
                return RubyFixnum.zero(runtime2);
            }
        }
        throw runtime2.newArgumentError("`how' should be either :SHUT_RD, :SHUT_WR, :SHUT_RDWR");
    }

    public boolean doNotReverseLookup(ThreadContext context) {
        return context.runtime.isDoNotReverseLookupEnabled() || this.doNotReverseLookup;
    }

    protected static ChannelFD newChannelFD(Ruby runtime2, Channel channel) {
        ChannelFD fd = new ChannelFD(channel, runtime2.getPosix(), runtime2.getFilenoUtil());
        if (runtime2.getPosix().isNative() && fd.realFileno >= 0 && !Platform.IS_WINDOWS) {
            runtime2.getPosix().fcntlInt(fd.realFileno, Fcntl.F_SETFD, 1);
        }
        return fd;
    }

    protected void initSocket(ChannelFD fd) {
        this.MakeOpenFile();
        this.openFile.setFD(fd);
        this.openFile.setMode(11);
        this.setAscii8bitBinmode();
    }

    private Channel getOpenChannel() {
        return this.getOpenFileChecked().channel();
    }

    static RuntimeException sockerr(Ruby runtime2, String msg, Exception cause2) {
        RuntimeException ex = SocketUtils.sockerr(runtime2, msg);
        if (cause2 != null) {
            ex.initCause(cause2);
        }
        return ex;
    }

    static boolean extractExceptionArg(ThreadContext context, IRubyObject opts) {
        return ArgsUtil.extractKeywordArg(context, "exception", opts) != context.fals;
    }

    private static int asNumber(ThreadContext context, IRubyObject val) {
        if (val instanceof RubyNumeric) {
            return RubyNumeric.fix2int(val);
        }
        if (val instanceof RubyBoolean) {
            return val.isTrue() ? 1 : 0;
        }
        return RubyBasicSocket.stringAsNumber(context, val);
    }

    private static int stringAsNumber(ThreadContext context, IRubyObject val) {
        IRubyObject res = Pack.unpack(context, val.convertToString(), FORMAT_SMALL_I).entry(0);
        if (res == context.nil) {
            throw context.runtime.newErrnoEINVALError();
        }
        return RubyNumeric.fix2int(res);
    }

    protected boolean asBoolean(ThreadContext context, IRubyObject val) {
        if (val instanceof RubyString) {
            return RubyBasicSocket.stringAsNumber(context, val) != 0;
        }
        if (val instanceof RubyNumeric) {
            return RubyNumeric.fix2int(val) != 0;
        }
        return val.isTrue();
    }

    protected IRubyObject addrFor(ThreadContext context, InetSocketAddress addr2, boolean reverse2) {
        Ruby runtime2 = context.runtime;
        RubyString ret0 = addr2.getAddress() instanceof Inet6Address ? runtime2.newString("AF_INET6") : runtime2.newString("AF_INET");
        RubyFixnum ret1 = runtime2.newFixnum(addr2.getPort());
        String hostAddress = addr2.getAddress().getHostAddress();
        RubyString ret2 = !reverse2 || this.doNotReverseLookup(context) ? runtime2.newString(hostAddress) : runtime2.newString(addr2.getHostName());
        RubyString ret3 = runtime2.newString(hostAddress);
        return RubyArray.newArray(runtime2, ret0, ret1, ret2, ret3);
    }

    @Deprecated
    public IRubyObject recv(IRubyObject[] args2) {
        return this.recv(this.getRuntime().getCurrentContext(), args2);
    }

    @Deprecated
    public IRubyObject getsockopt(IRubyObject lev, IRubyObject optname2) {
        return this.getsockopt(this.getRuntime().getCurrentContext(), lev, optname2);
    }

    @Deprecated
    public IRubyObject setsockopt(IRubyObject lev, IRubyObject optname2, IRubyObject val) {
        return this.setsockopt(this.getRuntime().getCurrentContext(), lev, optname2, val);
    }

    @Deprecated
    public IRubyObject getsockname() {
        return this.getsockname(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject getpeername() {
        return this.getpeername(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public static IRubyObject do_not_reverse_lookup(IRubyObject recv2) {
        return RubyBasicSocket.do_not_reverse_lookup(recv2.getRuntime().getCurrentContext(), recv2);
    }

    @Deprecated
    public static IRubyObject set_do_not_reverse_lookup(IRubyObject recv2, IRubyObject flag) {
        return RubyBasicSocket.set_do_not_reverse_lookup(recv2.getRuntime().getCurrentContext(), recv2, flag);
    }

    protected static class ReceiveTuple {
        RubyString result;
        InetSocketAddress sender;

        ReceiveTuple() {
        }

        ReceiveTuple(RubyString result2, InetSocketAddress sender) {
            this.result = result2;
            this.sender = sender;
        }
    }
}

