/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.Arrays;
import java.util.List;
import org.jruby.ir.IRScope;
import org.jruby.ir.dataflow.analyses.UnboxableOpsAnalysisProblem;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.LiveVariableAnalysis;

public class UnboxingPass
extends CompilerPass {
    public static List<Class<? extends CompilerPass>> DEPENDENCIES = Arrays.asList(LiveVariableAnalysis.class);

    @Override
    public String getLabel() {
        return "Unboxing Pass";
    }

    @Override
    public List<Class<? extends CompilerPass>> getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public Object execute(IRScope scope, Object ... data2) {
        UnboxableOpsAnalysisProblem problem = new UnboxableOpsAnalysisProblem();
        problem.setup(scope);
        problem.compute_MOP_Solution();
        problem.unbox();
        new LiveVariableAnalysis().invalidate(scope);
        return true;
    }

    @Override
    public Object previouslyRun(IRScope scope) {
        return scope.getUnboxableOpsAnalysisProblem();
    }

    @Override
    public boolean invalidate(IRScope scope) {
        return false;
    }
}

