/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.binding;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.binding.NamedInstaller;

public abstract class MethodInstaller
extends NamedInstaller {
    final ArrayList<Method> methods = new ArrayList(4);
    private List<String> aliases;
    private boolean localMethod;

    public MethodInstaller(String name2, int type2) {
        super(name2, type2);
    }

    final void addMethod(Method method2, Class<?> clazz) {
        this.methods.add(method2);
        this.localMethod |= clazz == method2.getDeclaringClass() || method2.getDeclaringClass().isInterface();
    }

    final void addAlias(String alias) {
        List<String> aliases2 = this.aliases;
        if (aliases2 == null) {
            aliases2 = this.aliases = new ArrayList<String>(4);
        }
        if (!aliases2.contains(alias)) {
            aliases2.add(alias);
        }
    }

    final void removeAlias(String alias) {
        List<String> aliases2 = this.aliases;
        if (aliases2 == null) {
            return;
        }
        aliases2.remove(alias);
    }

    final void defineMethods(RubyModule target, DynamicMethod invoker) {
        this.defineMethods(target, invoker, true);
    }

    protected final void defineMethods(RubyModule target, DynamicMethod invoker, boolean checkDups) {
        String oldName = this.name;
        target.addMethod(oldName, invoker);
        List<String> aliases2 = this.aliases;
        if (aliases2 != null && this.isPublic()) {
            for (int i2 = 0; i2 < aliases2.size(); ++i2) {
                String name2 = aliases2.get(i2);
                if (checkDups && oldName.equals(name2)) continue;
                target.addMethod(name2, invoker);
            }
        }
    }

    @Override
    boolean hasLocalMethod() {
        return this.localMethod;
    }

    void setLocalMethod(boolean flag) {
        this.localMethod = flag;
    }
}

