/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.python.core.ArgParser;
import org.python.core.ClasspathPyImporter$PyExposer;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.core.Untraversable;
import org.python.core.imp;
import org.python.core.util.FileUtil;
import org.python.core.util.StringUtil;
import org.python.core.util.importer;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.util.Generic;

@Untraversable
@ExposedType(name="ClasspathPyImporter")
public class ClasspathPyImporter
extends importer<String> {
    public static final String PYCLASSPATH_PREFIX = "__pyclasspath__/";
    public static final PyType TYPE;
    private Map<String, InputStream> entries = Generic.map();
    private String path;

    public ClasspathPyImporter(PyType subType) {
        super(subType);
    }

    public ClasspathPyImporter() {
    }

    @ExposedNew
    final void ClasspathPyImporter___init__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("__init__", args, kwds, new String[]{"path"});
        String path = ap.getString(0);
        if (path == null || !path.startsWith(PYCLASSPATH_PREFIX)) {
            throw Py.ImportError("path isn't for classpath importer");
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.path = path;
    }

    @Override
    public String get_data(String path) {
        return this.ClasspathPyImporter_get_data(path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final String ClasspathPyImporter_get_data(String path) {
        int len = PYCLASSPATH_PREFIX.length();
        if (len < path.length() && path.startsWith(PYCLASSPATH_PREFIX)) {
            path = path.substring(len);
        }
        try (importer.Bundle bundle = this.makeBundle(path, this.makeEntry(path));){
            byte[] data = FileUtil.readBytes(bundle.inputStream);
            String string = StringUtil.fromBytes(data);
            return string;
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public String get_source(String fullname) {
        return this.ClasspathPyImporter_get_source(fullname);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final String ClasspathPyImporter_get_source(String fullname) {
        importer.ModuleInfo moduleInfo = this.getModuleInfo(fullname);
        if (moduleInfo == importer.ModuleInfo.ERROR) {
            return null;
        }
        if (moduleInfo == importer.ModuleInfo.NOT_FOUND) {
            throw Py.ImportError(String.format("can't find module '%s'", fullname));
        }
        String path = this.makeFilename(fullname);
        path = moduleInfo == importer.ModuleInfo.PACKAGE ? path + File.separator + "__init__.py" : path + ".py";
        try (importer.Bundle bundle = this.makeBundle(path, this.makeEntry(path));){
            InputStream is = bundle.inputStream;
            if (is != null) {
                byte[] data = FileUtil.readBytes(is);
                String string = StringUtil.fromBytes(data);
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    final PyObject ClasspathPyImporter_find_module(String fullname, String path) {
        return this.importer_find_module(fullname, path);
    }

    final boolean ClasspathPyImporter_is_package(String fullname) {
        return this.importer_is_package(fullname);
    }

    final PyObject ClasspathPyImporter_get_code(String fullname) {
        importer.ModuleCodeData moduleCodeData = this.getModuleCode(fullname);
        if (moduleCodeData != null) {
            return moduleCodeData.code;
        }
        return Py.None;
    }

    final PyObject ClasspathPyImporter_load_module(String fullname) {
        return this.importer_load_module(fullname);
    }

    @Override
    protected long getSourceMtime(String path) {
        return -1L;
    }

    @Override
    protected importer.Bundle makeBundle(String fullFilename, String entry) {
        InputStream is = this.entries.remove(entry);
        return new importer.Bundle(is){

            @Override
            public void close() {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    throw Py.JavaError(e);
                }
            }
        };
    }

    @Override
    protected String makeEntry(String filename) {
        if (!this.getSeparator().equals(File.separator)) {
            filename = filename.replace(File.separator, this.getSeparator());
        }
        if (this.entries.containsKey(filename)) {
            return filename;
        }
        InputStream is = Py.getSystemState().getClassLoader() != null ? this.tryClassLoader(filename, Py.getSystemState().getClassLoader(), "sys") : this.tryClassLoader(filename, imp.getParentClassLoader(), "parent");
        if (is != null) {
            this.entries.put(filename, is);
            return filename;
        }
        return null;
    }

    private InputStream tryClassLoader(String fullFilename, ClassLoader loader, String name) {
        if (loader != null) {
            Py.writeDebug("import", "trying " + fullFilename + " in " + name + " class loader");
            return loader.getResourceAsStream(fullFilename);
        }
        return null;
    }

    @Override
    protected String makeFilename(String fullname) {
        return this.path.replace(PYCLASSPATH_PREFIX, "") + fullname.replace('.', '/');
    }

    @Override
    protected String makeFilePath(String fullname) {
        return this.path + fullname.replace('.', '/');
    }

    @Override
    protected String makePackagePath(String fullname) {
        return this.path;
    }

    @Override
    protected String getSeparator() {
        return "/";
    }

    static {
        PyType.addBuilder(ClasspathPyImporter.class, new ClasspathPyImporter$PyExposer());
        TYPE = PyType.fromClass(ClasspathPyImporter.class);
    }
}

