/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.actions;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.osmand.PlatformUtil;
import net.osmand.data.LatLon;
import net.osmand.data.RotatedTileBox;
import net.osmand.plus.render.OsmandRenderer;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.actions.OffRoadAction;
import net.sourceforge.offroad.data.Pair;
import net.sourceforge.offroad.ui.OsmBitmapPanel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class DirectSearchAction
extends OffRoadAction
implements DocumentListener {
    private List<DirectSearchReceiver> mDirectSearchReceiverList = new ArrayList<DirectSearchReceiver>();
    private static final Log log = PlatformUtil.getLog(DirectSearchAction.class);
    private static final int TYPE_DELAY_TIME = 500;
    private Timer mTypeDelayTimer = null;
    private JTextField mTextField;
    private ISearchProvider mProvider;
    private JCheckBox mDirectSearchFuzzy;
    private JButton mDirectSearchForward;
    private JButton mDirectSearchBackward;
    private int mSearchIndex = -1;
    private Pair<OsmandRenderer.TextInfo, OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage> mSearchHit;
    private JButton mDirectSearchClose;

    public void registerDirectSearchReceiver(DirectSearchReceiver pDirectSearchReceiver) {
        this.mDirectSearchReceiverList.add(pDirectSearchReceiver);
    }

    public void deregisterDirectSearchReceiver(DirectSearchReceiver pDirectSearchReceiver) {
        this.mDirectSearchReceiverList.remove(pDirectSearchReceiver);
    }

    private synchronized void change(DocumentEvent event) {
        if (this.mTypeDelayTimer != null) {
            this.mTypeDelayTimer.stop();
            this.mTypeDelayTimer = null;
        }
        this.mTypeDelayTimer = new Timer(500, this);
        this.mTypeDelayTimer.setRepeats(false);
        this.mTypeDelayTimer.start();
    }

    public DirectSearchAction(OsmWindow pContext, JTextField pTextField, JCheckBox pDirectSearchFuzzy, JButton pDirectSearchBackward, JButton pDirectSearchForward, JButton pDirectSearchClose) {
        super(pContext, pContext.getOffRoadString("offroad.show_direct_search"), null);
        this.mTextField = pTextField;
        this.mDirectSearchFuzzy = pDirectSearchFuzzy;
        this.mDirectSearchBackward = pDirectSearchBackward;
        this.mDirectSearchForward = pDirectSearchForward;
        this.mDirectSearchClose = pDirectSearchClose;
        this.mDirectSearchFuzzy.addActionListener(this);
        this.mProvider = new FuzzySearchProvider();
        this.mTextField.getDocument().addDocumentListener(this);
        this.mTextField.addActionListener(event -> this.moveToNextHit());
        this.mDirectSearchForward.addActionListener(event -> this.moveToNextHit());
        this.mDirectSearchBackward.addActionListener(event -> this.moveToPreviousHit());
        this.mDirectSearchClose.addActionListener(event -> this.setEnabled(false));
    }

    Map.Entry<OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage, OsmandRenderer.TextInfo> getFirstHit() {
        if (this.mProvider.isValid()) {
            List<OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage> list = this.mContext.getDrawPanel().getEffectivelyDrawnImages();
            for (OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage imageStorage : list) {
                for (OsmandRenderer.TextInfo to : imageStorage.mResult.effectiveTextObjects) {
                    if (to.mText == null || !this.mProvider.matches(to.mText)) continue;
                    return new Pair<OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage, OsmandRenderer.TextInfo>(imageStorage, to);
                }
            }
        }
        return null;
    }

    TreeSet<Pair<OsmandRenderer.TextInfo, OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage>> getHits() {
        TreeSet<Pair<OsmandRenderer.TextInfo, OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage>> res = new TreeSet<Pair<OsmandRenderer.TextInfo, OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage>>(new TextLocationComparator(this.mContext.getDrawPanel().copyCurrentTileBox()));
        if (this.mProvider.isValid()) {
            List<OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage> list = this.mContext.getDrawPanel().getEffectivelyDrawnImages();
            for (OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage imageStorage : list) {
                for (OsmandRenderer.TextInfo to : imageStorage.mResult.effectiveTextObjects) {
                    if (to.mText == null || !this.mProvider.matches(to.mText)) continue;
                    res.add(new Pair<OsmandRenderer.TextInfo, OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage>(to, imageStorage));
                }
            }
        }
        return res;
    }

    @Override
    public void actionPerformed(ActionEvent pE) {
        this.mContext.showDirectSearch();
        if (this.mContext.getOffRoadString("offroad.DirectSearchText").equals(this.mTextField.getText())) {
            this.mProvider = new NullProvider();
            this.mTextField.setBackground(null);
        } else {
            this.mProvider = this.mDirectSearchFuzzy.isSelected() ? new FuzzySearchProvider() : new CaseInsensitiveSearchProvider();
            if (!this.mProvider.isValid() || this.getFirstHit() != null) {
                this.mTextField.setBackground(null);
            } else {
                this.mTextField.setBackground(Color.red);
            }
        }
        this.publishProvider();
    }

    protected void publishProvider() {
        for (DirectSearchReceiver directSearchReceiver : this.mDirectSearchReceiverList) {
            directSearchReceiver.setSearchProvider(this.mProvider);
        }
        this.mContext.getDrawPanel().drawLater();
        this.mTextField.requestFocusInWindow();
    }

    public ISearchProvider getSelectionProvider() {
        return new SelectionSearchProvider();
    }

    @Override
    public void insertUpdate(DocumentEvent pE) {
        this.change(pE);
    }

    @Override
    public void removeUpdate(DocumentEvent pE) {
        this.change(pE);
    }

    @Override
    public void changedUpdate(DocumentEvent pE) {
        this.change(pE);
    }

    public void moveToNextHit() {
        TreeSet<Pair<OsmandRenderer.TextInfo, OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage>> hits = this.getHits();
        if (this.mSearchIndex + 1 < hits.size()) {
            ++this.mSearchIndex;
        }
        this.jumpToHit(hits);
    }

    public void moveToPreviousHit() {
        TreeSet<Pair<OsmandRenderer.TextInfo, OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage>> hits = this.getHits();
        if (this.mSearchIndex - 1 >= 0) {
            --this.mSearchIndex;
        }
        this.jumpToHit(hits);
    }

    public Pair<OsmandRenderer.TextInfo, OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage> getHit(TreeSet<Pair<OsmandRenderer.TextInfo, OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage>> pHits) {
        if (this.mSearchIndex < 0 || this.mSearchIndex >= pHits.size()) {
            this.mSearchIndex = 0;
        }
        int index = 0;
        for (Pair<OsmandRenderer.TextInfo, OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage> hit : pHits) {
            if (index == this.mSearchIndex) {
                return hit;
            }
            ++index;
        }
        return null;
    }

    public LatLon getLocation(Pair<OsmandRenderer.TextInfo, OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage> hit) {
        PathIterator it = hit.getKey().path.getPathIterator(null);
        if (!it.isDone()) {
            float[] coords = new float[2];
            it.currentSegment(coords);
            OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage storage = hit.getValue();
            return storage.mTileBox.getLatLonFromPixel(coords[0], coords[1]);
        }
        return null;
    }

    public void jumpToHit(TreeSet<Pair<OsmandRenderer.TextInfo, OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage>> pHits) {
        Pair<OsmandRenderer.TextInfo, OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage> hit = this.getHit(pHits);
        this.mSearchHit = hit;
        if (hit == null) {
            return;
        }
        LatLon destination = this.getLocation(hit);
        if (destination != null) {
            RotatedTileBox ctb = this.mContext.getDrawPanel().copyCurrentTileBox();
            RotatedTileBox dest = ctb.copy();
            dest.setLatLonCenter(destination);
            this.mContext.moveAnimated(dest, ctb, destination);
            this.mContext.setCursorPosition(destination);
        }
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        if (!pEnabled) {
            this.mProvider = new NullProvider();
            this.mSearchHit = null;
            this.publishProvider();
        } else {
            this.actionPerformed(null);
        }
    }

    public class SelectionSearchProvider
    implements ISearchProvider {
        @Override
        public String getSearchString() {
            return this.isValid() ? this.getText() : null;
        }

        @Override
        public boolean matches(String pCandidate) {
            return this.getText().equals(pCandidate);
        }

        public String getText() {
            return ((OsmandRenderer.TextInfo)((DirectSearchAction)DirectSearchAction.this).mSearchHit.getKey()).mText;
        }

        @Override
        public boolean isValid() {
            return DirectSearchAction.this.mSearchHit != null;
        }
    }

    public class FuzzySearchProvider
    extends DefaultSearchProvider {
        @Override
        public boolean matches(String pCandidate) {
            double dist = StringUtils.getJaroWinklerDistance(pCandidate.toLowerCase(), this.getSearchString().toLowerCase());
            return dist >= (double)0.7f;
        }
    }

    public class CaseInsensitiveSearchProvider
    extends DefaultSearchProvider {
        public CaseInsensitiveSearchProvider() {
            this.mSearchString = DirectSearchAction.this.mTextField.getText().toLowerCase();
        }

        @Override
        public boolean matches(String pCandidate) {
            return pCandidate.toLowerCase().contains(this.getSearchString());
        }
    }

    public class DefaultSearchProvider
    implements ISearchProvider {
        protected String mSearchString;

        public DefaultSearchProvider() {
            this.mSearchString = DirectSearchAction.this.mTextField.getText();
        }

        @Override
        public String getSearchString() {
            return this.mSearchString;
        }

        @Override
        public boolean matches(String pCandidate) {
            return pCandidate.contains(this.getSearchString());
        }

        @Override
        public boolean isValid() {
            return this.mSearchString != null && this.mSearchString.length() >= 3;
        }
    }

    public static interface ISearchProvider {
        public String getSearchString();

        public boolean matches(String var1);

        public boolean isValid();
    }

    public static interface DirectSearchReceiver {
        public void setSearchProvider(ISearchProvider var1);
    }

    public class NullProvider
    implements ISearchProvider {
        @Override
        public String getSearchString() {
            return "";
        }

        @Override
        public boolean matches(String pCandidate) {
            return false;
        }

        @Override
        public boolean isValid() {
            return false;
        }
    }

    private class TextLocationComparator
    implements Comparator<Pair<OsmandRenderer.TextInfo, OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage>> {
        private RotatedTileBox mTileBox;

        public TextLocationComparator(RotatedTileBox pTileBox) {
            this.mTileBox = pTileBox;
        }

        @Override
        public int compare(Pair<OsmandRenderer.TextInfo, OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage> pO1, Pair<OsmandRenderer.TextInfo, OsmBitmapPanel.CalculateUnzoomedPicturesAction.ImageStorage> pO2) {
            LatLon l1 = DirectSearchAction.this.getLocation(pO1);
            LatLon l2 = DirectSearchAction.this.getLocation(pO2);
            int diffX = (int)(this.mTileBox.getPixXFromLatLon(l1) - this.mTileBox.getPixXFromLatLon(l2));
            if (Math.abs(diffX) < 2) {
                int diffY = (int)(this.mTileBox.getPixYFromLatLon(l1) - this.mTileBox.getPixYFromLatLon(l2));
                if (Math.abs(diffX) < 2) {
                    return 0;
                }
                return diffY;
            }
            return diffX;
        }
    }
}

