/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ivy.util.filter.ArtifactTypeFilter;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.NoFilter;

public final class FilterHelper {
    public static final Filter NO_FILTER = NoFilter.INSTANCE;

    private FilterHelper() {
    }

    public static Filter getArtifactTypeFilter(String string) {
        if (string == null || string.trim().equals("*")) {
            return NO_FILTER;
        }
        String[] stringArray = string.split(",");
        return FilterHelper.getArtifactTypeFilter(stringArray);
    }

    public static Filter getArtifactTypeFilter(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return NO_FILTER;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].trim();
            if ("*".equals(string)) {
                return NO_FILTER;
            }
            arrayList.add(string);
        }
        return new ArtifactTypeFilter(arrayList);
    }

    public static Collection filter(Collection collection, Filter filter) {
        if (filter == null) {
            return collection;
        }
        ArrayList arrayList = new ArrayList(collection);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (filter.accept(e)) continue;
            iterator.remove();
        }
        return arrayList;
    }
}

