/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.version;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.version.AbstractVersionMatcher;
import org.apache.ivy.plugins.version.VersionRangeMatcher$1;

public final class VersionRangeMatcher
extends AbstractVersionMatcher {
    private static final Pattern FINITE_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]");
    private static final Pattern LOWER_INFINITE_RANGE = Pattern.compile("\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]");
    private static final Pattern UPPER_INFINITE_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)");
    private static final Pattern ALL_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]|\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]|[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)");
    private final Comparator comparator = new VersionRangeMatcher$1(this);
    private LatestStrategy latestStrategy;
    private String latestStrategyName = "default";

    public VersionRangeMatcher() {
        super("version-range");
    }

    @Override
    public final boolean isDynamic(ModuleRevisionId moduleRevisionId) {
        String string = moduleRevisionId.getRevision();
        return ALL_RANGE.matcher(string).matches();
    }

    @Override
    public final boolean accept(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2) {
        String string = moduleRevisionId.getRevision();
        Matcher matcher = FINITE_RANGE.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            return this.isUpper(moduleRevisionId, string2, moduleRevisionId2, string.startsWith("[")) && this.isLower(moduleRevisionId, string3, moduleRevisionId2, string.endsWith("]"));
        }
        matcher = LOWER_INFINITE_RANGE.matcher(string);
        if (matcher.matches()) {
            String string4 = matcher.group(1);
            return this.isLower(moduleRevisionId, string4, moduleRevisionId2, string.endsWith("]"));
        }
        matcher = UPPER_INFINITE_RANGE.matcher(string);
        if (matcher.matches()) {
            String string5 = matcher.group(1);
            return this.isUpper(moduleRevisionId, string5, moduleRevisionId2, string.startsWith("["));
        }
        return false;
    }

    private boolean isLower(ModuleRevisionId moduleRevisionId, String string, ModuleRevisionId moduleRevisionId2, boolean bl) {
        ModuleRevisionId moduleRevisionId3 = ModuleRevisionId.newInstance(moduleRevisionId, string);
        return this.comparator.compare(moduleRevisionId3, moduleRevisionId2) <= (bl ? 0 : -1);
    }

    private boolean isUpper(ModuleRevisionId moduleRevisionId, String string, ModuleRevisionId moduleRevisionId2, boolean bl) {
        ModuleRevisionId moduleRevisionId3 = ModuleRevisionId.newInstance(moduleRevisionId, string);
        return this.comparator.compare(moduleRevisionId3, moduleRevisionId2) >= (bl ? 0 : 1);
    }

    @Override
    public final int compare(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2, Comparator comparator) {
        String string;
        String string2 = moduleRevisionId.getRevision();
        if (UPPER_INFINITE_RANGE.matcher(string2).matches()) {
            return 1;
        }
        Matcher matcher = FINITE_RANGE.matcher(string2);
        if (matcher.matches()) {
            string = matcher.group(2);
        } else {
            matcher = LOWER_INFINITE_RANGE.matcher(string2);
            if (matcher.matches()) {
                string = matcher.group(1);
            } else {
                throw new IllegalArgumentException("impossible to compare: askedMrid is not a dynamic revision: " + moduleRevisionId);
            }
        }
        int n = comparator.compare(ModuleRevisionId.newInstance(moduleRevisionId, string), moduleRevisionId2);
        if (n == 0) {
            return -1;
        }
        return n;
    }

    public final LatestStrategy getLatestStrategy() {
        if (this.latestStrategy == null) {
            if (this.getSettings() == null) {
                throw new IllegalStateException("no ivy instance nor latest strategy configured in version range matcher " + this);
            }
            if (this.latestStrategyName == null) {
                throw new IllegalStateException("null latest strategy defined in version range matcher " + this);
            }
            this.latestStrategy = this.getSettings().getLatestStrategy(this.latestStrategyName);
            if (this.latestStrategy == null) {
                throw new IllegalStateException("unknown latest strategy '" + this.latestStrategyName + "' configured in version range matcher " + this);
            }
        }
        return this.latestStrategy;
    }
}

