/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import net.sf.sdedit.util.collection.BulkRemoveIterator;
import net.sf.sdedit.util.collection.OntoMap;

public class IndexedList<T>
implements Collection<T>,
Serializable {
    private static final long serialVersionUID = -2733083143456198060L;
    private static int annotationId = 0;
    private transient Map<T, Entry> entryMap = new IdentityHashMap<T, Entry>();
    private transient Entry first = null;
    private transient Entry last = null;
    private transient OntoMap<Annotation, Entry> annotations;

    public void addAnnotation(T from, T to, String type, Object value) {
        if (this.annotations == null) {
            this.annotations = new OntoMap(LinkedList.class);
        }
        Annotation annot = new Annotation();
        annot.annotationStart = this.entryMap.get(from);
        annot.annotationEnd = this.entryMap.get(to);
        annot.type = type;
        annot.value = value;
        this.annotations.add(annot, annot.annotationStart);
    }

    public Collection<Annotation> getAnnotations(T of) {
        if (this.annotations == null) {
            return new LinkedList<Annotation>();
        }
        Entry begin = this.entryMap.get(of);
        AnnotationComparator comp = new AnnotationComparator(begin);
        TreeSet<Annotation> set = new TreeSet<Annotation>(comp);
        set.addAll(this.annotations.getPreImages(begin));
        return set;
    }

    protected void _remove(Entry entry) {
        this.entryMap.remove(entry.content);
        if (entry.previous != null) {
            entry.previous.next = entry.next;
        }
        if (entry.next != null) {
            entry.next.previous = entry.previous;
        }
        if (entry == this.first) {
            this.first = entry.next;
        }
        if (entry == this.last) {
            this.last = entry.previous;
        }
    }

    @Override
    public boolean remove(Object elem) {
        Entry entry = this.entryMap.get(elem);
        if (entry != null) {
            this._remove(entry);
            return true;
        }
        return false;
    }

    protected void setContent(Entry e, T t) {
        e.content = t;
    }

    protected T getContent(Entry e) {
        return (T)e.content;
    }

    @Override
    public boolean add(T o) {
        if (this.entryMap.containsKey(o)) {
            throw new IllegalArgumentException("already in list: " + o);
        }
        Entry entry = new Entry(o);
        if (this.last == null) {
            this.first = this.last = entry;
        } else {
            this.last.next = entry;
            entry.previous = this.last;
        }
        this.last = entry;
        this.entryMap.put(o, entry);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c == null) {
            return false;
        }
        for (T t : c) {
            this.add(t);
        }
        return !c.isEmpty();
    }

    @Override
    public void clear() {
        this.entryMap.clear();
        this.first = null;
        this.last = null;
        if (this.annotations != null) {
            this.annotations.clear();
        }
        this.annotations = null;
    }

    @Override
    public boolean contains(Object o) {
        return this.entryMap.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.entryMap.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.entryMap.isEmpty();
    }

    @Override
    public BulkRemoveIterator<T> iterator() {
        return new Iter(this.first);
    }

    public BulkRemoveIterator<T> reverseIterator() {
        return new Iter(this.last, this.first, false, Integer.MAX_VALUE);
    }

    public BulkRemoveIterator<T> iterator(T start) {
        return new Iter(this.entryMap.get(start), this.last, true, Integer.MAX_VALUE);
    }

    public BulkRemoveIterator<T> reverseIterator(T start) {
        return new Iter(this.entryMap.get(start), this.first, false, Integer.MAX_VALUE);
    }

    public BulkRemoveIterator<T> iterator(T start, T end) {
        return new Iter(this.entryMap.get(start), this.entryMap.get(end), true, Integer.MAX_VALUE);
    }

    public BulkRemoveIterator<T> reverseIterator(T start, T end) {
        return new Iter(this.entryMap.get(start), this.entryMap.get(end), false, Integer.MAX_VALUE);
    }

    public BulkRemoveIterator<T> boundedIterator(T start, int steps) {
        return new Iter(this.entryMap.get(start), this.last, true, steps);
    }

    public BulkRemoveIterator<T> boundedReverseIterator(T start, int steps) {
        return new Iter(this.entryMap.get(start), this.first, false, steps);
    }

    public T previous(T elem) {
        Entry previous = this.entryMap.get(elem).previous;
        if (previous == null) {
            return null;
        }
        return (T)previous.content;
    }

    public T next(T elem) {
        Entry next = this.entryMap.get(elem).next;
        if (next == null) {
            return null;
        }
        return (T)next.content;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed |= this.remove(o);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Iterator iter = this.iterator();
        HashSet set = new HashSet();
        set.addAll(c);
        int n = this.size();
        while (iter.hasNext()) {
            Object elem = iter.next();
            if (set.contains(elem)) continue;
            iter.remove();
        }
        return this.size() != n;
    }

    @Override
    public int size() {
        return this.entryMap.size();
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    @Override
    public boolean equals(Object o) {
        IndexedList list = (IndexedList)o;
        return Arrays.equals(this.toArray(), list.toArray());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.toArray());
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Object[this.size()];
        int i = 0;
        for (Object t : this) {
            arr[i++] = t;
        }
        return arr;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] arr = a.length >= this.size() ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        int i = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            arr[i++] = iter.next();
        }
        return arr;
    }

    public T removeFirst() {
        this._remove(this.first);
        return (T)this.first.content;
    }

    public T getFirst() {
        return (T)this.first.content;
    }

    protected Entry insertAfter(Entry _where, T what) {
        Entry newEntry = new Entry(what);
        newEntry.next = _where.next;
        if (_where.next != null) {
            _where.next.previous = newEntry;
        }
        _where.next = newEntry;
        newEntry.previous = _where;
        this.entryMap.put(what, newEntry);
        if (this.last == _where) {
            this.last = newEntry;
        }
        return newEntry;
    }

    public void addFirst(T first) {
        Entry entry = new Entry(first);
        if (this.first != null) {
            this.first.previous = entry;
            entry.next = this.first;
        }
        this.first = entry;
        this.entryMap.put(first, entry);
        if (this.last == null) {
            this.last = this.first;
        }
    }

    public T removeLast() {
        this._remove(this.last);
        return (T)this.last.content;
    }

    public T getLast() {
        return (T)this.last.content;
    }

    public void addLast(T last) {
        this.add(last);
    }

    public void replace(T whom, Collection<T> by) {
        Entry _whom;
        Entry entry = _whom = this.entryMap.get(whom);
        for (T t : by) {
            entry = this.insertAfter(entry, t);
        }
        this.remove(whom);
    }

    public int indexOf(T elem) {
        Entry entry = this.entryMap.get(elem);
        int i = -1;
        while (entry != null) {
            ++i;
            entry = entry.previous;
        }
        return i;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        LinkedList ll = new LinkedList();
        ll.addAll(this);
        out.defaultWriteObject();
        out.writeObject(ll);
        if (this.annotations == null) {
            out.writeObject(new LinkedList());
        } else {
            out.writeObject(this.annotations.getPreImages());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.entryMap = new IdentityHashMap<T, Entry>();
        LinkedList ll = (LinkedList)in.readObject();
        this.addAll(ll);
        Collection annots = (Collection)in.readObject();
        for (Annotation a : annots) {
            this.addAnnotation(a.getStart(), a.getEnd(), a.getType(), a.getValue());
        }
    }

    static /* synthetic */ int access$008() {
        return annotationId++;
    }

    protected class AnnotationComparator
    implements Comparator<Annotation> {
        private Entry annotationBegin;
        private Map<Entry, Integer> entryDistances;

        AnnotationComparator(Entry begin) {
            this.annotationBegin = begin;
            this.entryDistances = new HashMap<Entry, Integer>();
            this.entryDistances.put(this.annotationBegin, 0);
        }

        private int getDistance(Entry f) {
            Integer d = 0;
            int s = 0;
            Entry e = f;
            do {
                if ((d = this.entryDistances.get(e)) != null) {
                    if (s > 0) {
                        this.entryDistances.put(f, d + s);
                    }
                    return d + s;
                }
                ++s;
            } while ((e = e.previous) != null);
            throw new IllegalStateException("Cannot find distance.");
        }

        @Override
        public int compare(Annotation a1, Annotation a2) {
            int d2;
            if (a1.annotationStart != this.annotationBegin || a2.annotationStart != this.annotationBegin) {
                throw new IllegalStateException("Cannot compare annotations");
            }
            int d1 = this.getDistance(a1.annotationEnd);
            if (d1 == (d2 = this.getDistance(a2.annotationEnd))) {
                return a1.id - a2.id;
            }
            return d2 - d1;
        }
    }

    protected class Iter
    implements BulkRemoveIterator<T> {
        private boolean direction;
        private Entry end;
        private Entry previous;
        private Entry current;
        private int maxSteps;
        private int steps;

        Iter(Entry start, Entry end, boolean direction, int maxSteps) {
            this.end = end;
            this.direction = direction;
            this.current = maxSteps == 0 ? null : start;
            this.maxSteps = maxSteps;
            this.steps = 0;
        }

        Iter(Entry start) {
            this(start, true);
        }

        Iter(Entry start, boolean direction) {
            this(start, this$0.last, direction, Integer.MAX_VALUE);
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public T next() {
            ++this.steps;
            this.previous = this.current;
            this.current = this.steps == this.maxSteps || this.current == this.end ? null : (this.direction ? this.current.next : this.current.previous);
            return this.previous.content;
        }

        @Override
        public void remove() {
            this.remove(1);
        }

        @Override
        public void remove(int num) {
            Entry current = this.previous;
            for (int i = 0; i < num; ++i) {
                IndexedList.this.remove(current.content);
                current = this.direction ? current.previous : current.next;
            }
        }
    }

    public class Annotation
    implements Serializable {
        private static final long serialVersionUID = -6841715770952621120L;
        protected Entry annotationStart;
        protected Entry annotationEnd;
        protected String type;
        protected Object value;
        protected int id = IndexedList.access$008();

        Annotation() {
        }

        public String getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public T getStart() {
            return this.annotationStart.content;
        }

        public T getEnd() {
            return this.annotationEnd.content;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    protected static class Entry
    implements Serializable {
        private static final long serialVersionUID = 4675147272167494931L;
        transient Entry previous;
        transient Entry next;
        Object content;

        Entry(Object content, Entry previous, Entry next) {
            this.content = content;
            this.previous = previous;
            this.content = content;
        }

        Entry(Object content, Entry previous) {
            this(content, previous, null);
        }

        Entry(Object content) {
            this(content, null, null);
        }

        public String toString() {
            return "[" + (this.previous == null ? "N" : this.previous.content.toString()) + " < " + this.content.toString() + " > " + (this.next == null ? "N" : this.next.content.toString()) + "]";
        }
    }
}

