/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.fx.ui.resources;

import com.sun.deploy.trace.Trace;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class ResourceManager {
    private static ResourceBundle rbFX;
    private static ResourceBundle rbJRE;
    private static final String UNDERSCORE = "_";
    private static final String ESC_UNDERSCORE = "__";
    private static final String AMPERSAND = "&";
    private static final String ESC_AMPERSAND = "&&";
    private static Pattern p_start;
    private static Pattern p_other;
    private static Pattern p_underscore;
    private static Pattern p_escampersand;

    static void reset() {
        rbFX = ResourceBundle.getBundle("com.sun.deploy.uitoolkit.impl.fx.ui.resources.Deployment");
        try {
            rbJRE = ResourceBundle.getBundle("com.sun.deploy.resources.Deployment");
        }
        catch (MissingResourceException ex) {
            Trace.ignoredException((Exception)ex);
            rbJRE = rbFX;
        }
    }

    public static String getMessage(String key) {
        return ResourceManager.convertMnemonics(ResourceManager.getString(key));
    }

    private static String escapeUnderscore(String s) {
        return p_underscore.matcher(s).replaceAll(ESC_UNDERSCORE);
    }

    private static String unescapeAmpersand(String s) {
        return p_escampersand.matcher(s).replaceAll(AMPERSAND);
    }

    private static String convertMnemonics(String s) {
        Matcher m;
        String tmp = p_start.matcher(s).find() ? UNDERSCORE + s.substring(1) : ((m = p_other.matcher(s)).find() ? ResourceManager.escapeUnderscore(s.substring(0, m.start() + 1)) + UNDERSCORE + s.substring(m.end() - 1) : ResourceManager.escapeUnderscore(s));
        return ResourceManager.unescapeAmpersand(tmp);
    }

    public static String getFormattedMessage(String key, Object[] args) {
        try {
            return new MessageFormat(ResourceManager.getMessage(key)).format(args);
        }
        catch (MissingResourceException ex) {
            Trace.ignoredException((Exception)ex);
            return key;
        }
    }

    public static String getString(String key) {
        try {
            return rbFX.containsKey(key) ? rbFX.getString(key) : rbJRE.getString(key);
        }
        catch (MissingResourceException ex) {
            return key;
        }
    }

    public static String getString(String key, Object ... args) {
        return MessageFormat.format(ResourceManager.getString(key), args);
    }

    public static ImageView getIcon(final String key) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ImageView>(){

                @Override
                public ImageView run() {
                    return ResourceManager.getIcon_(key);
                }
            });
        }
        catch (Exception ex) {
            Trace.ignoredException((Exception)ex);
            return null;
        }
    }

    public static ImageView getIcon_(String key) {
        String resourceName = ResourceManager.getString(key);
        URL url = rbFX.getClass().getResource(resourceName);
        String className = rbFX.getClass().getName();
        if (url == null || key.equals("about.java.image")) {
            url = rbJRE.getClass().getResource(resourceName);
            className = rbJRE.getClass().getName();
        }
        return ResourceManager.getIcon(url);
    }

    public static ImageView getIcon(URL url) {
        Image image = new Image(url.toString());
        return new ImageView(image);
    }

    static {
        p_start = Pattern.compile("^&[^&]");
        p_other = Pattern.compile("[^&]&[^&]");
        p_underscore = Pattern.compile(UNDERSCORE);
        p_escampersand = Pattern.compile(ESC_AMPERSAND);
        ResourceManager.reset();
    }
}

