/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.ClipboardAssistance;
import com.sun.javafx.embed.EmbeddedSceneDragSourceInterface;
import com.sun.javafx.embed.EmbeddedSceneDropTargetInterface;
import com.sun.javafx.tk.quantum.EmbeddedSceneDnD;
import com.sun.javafx.tk.quantum.FxEventLoop;
import com.sun.javafx.tk.quantum.GlassSceneDnDEventHandler;
import java.util.concurrent.Callable;
import javafx.application.Platform;
import javafx.scene.input.TransferMode;

final class EmbeddedSceneDropTarget
implements EmbeddedSceneDropTargetInterface {
    private final EmbeddedSceneDnD dnd;
    private final GlassSceneDnDEventHandler dndHandler;
    private EmbeddedSceneDragSourceInterface dragSource;
    private int dndCounter;

    public EmbeddedSceneDropTarget(EmbeddedSceneDnD embeddedSceneDnD, GlassSceneDnDEventHandler glassSceneDnDEventHandler) {
        this.dnd = embeddedSceneDnD;
        this.dndHandler = glassSceneDnDEventHandler;
    }

    private boolean isDnDCounterValid() {
        assert (Platform.isFxApplicationThread());
        assert (this.dndCounter == 1);
        return true;
    }

    private ClipboardAssistance getClipboardAssistance() {
        assert (this.isDnDCounterValid());
        assert (this.dnd.isValid(this));
        return this.dnd.getClipboardAssistance(this.dragSource);
    }

    private void close() {
        assert (this.isDnDCounterValid());
        --this.dndCounter;
        this.dnd.onDropTargetReleased(this);
    }

    @Override
    public TransferMode handleDragEnter(final int n, final int n2, final int n3, final int n4, final TransferMode transferMode, final EmbeddedSceneDragSourceInterface embeddedSceneDragSourceInterface) {
        assert (this.dnd.isHostThread());
        return FxEventLoop.sendEvent(new Callable<TransferMode>(){

            @Override
            public TransferMode call() {
                ++EmbeddedSceneDropTarget.this.dndCounter;
                assert (EmbeddedSceneDropTarget.this.dnd.isFxDragSource() || EmbeddedSceneDropTarget.this.dragSource == null);
                EmbeddedSceneDropTarget.this.dragSource = embeddedSceneDragSourceInterface;
                return EmbeddedSceneDropTarget.this.dndHandler.handleDragEnter(n, n2, n3, n4, transferMode, EmbeddedSceneDropTarget.this.getClipboardAssistance());
            }
        });
    }

    @Override
    public void handleDragLeave() {
        assert (this.dnd.isHostThread());
        FxEventLoop.sendEvent(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    EmbeddedSceneDropTarget.this.dndHandler.handleDragLeave(EmbeddedSceneDropTarget.this.getClipboardAssistance());
                }
                finally {
                    EmbeddedSceneDropTarget.this.close();
                }
            }
        });
    }

    @Override
    public TransferMode handleDragDrop(final int n, final int n2, final int n3, final int n4, final TransferMode transferMode) {
        assert (this.dnd.isHostThread());
        return FxEventLoop.sendEvent(new Callable<TransferMode>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TransferMode call() {
                try {
                    TransferMode transferMode2 = EmbeddedSceneDropTarget.this.dndHandler.handleDragDrop(n, n2, n3, n4, transferMode, EmbeddedSceneDropTarget.this.getClipboardAssistance());
                    return transferMode2;
                }
                finally {
                    EmbeddedSceneDropTarget.this.close();
                }
            }
        });
    }

    @Override
    public TransferMode handleDragOver(final int n, final int n2, final int n3, final int n4, final TransferMode transferMode) {
        assert (this.dnd.isHostThread());
        return FxEventLoop.sendEvent(new Callable<TransferMode>(){

            @Override
            public TransferMode call() {
                return EmbeddedSceneDropTarget.this.dndHandler.handleDragOver(n, n2, n3, n4, transferMode, EmbeddedSceneDropTarget.this.getClipboardAssistance());
            }
        });
    }
}

