/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.Media;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.track.Track;
import com.sun.media.jfxmediaimpl.MarkerStateListener;
import com.sun.media.jfxmediaimpl.platform.Platform;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NativeMedia
extends Media {
    protected final Lock markerLock = new ReentrantLock();
    protected final Lock listenerLock = new ReentrantLock();
    protected Map<String, Double> markersByName;
    protected NavigableMap<Double, String> markersByTime;
    protected WeakHashMap<MarkerStateListener, Boolean> markerListeners;

    protected NativeMedia(Locator locator) {
        super(locator);
    }

    public abstract Platform getPlatform();

    @Override
    public void addTrack(Track track) {
        super.addTrack(track);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMarker(String markerName, double presentationTime) {
        if (markerName == null) {
            throw new IllegalArgumentException("markerName == null!");
        }
        if (presentationTime < 0.0) {
            throw new IllegalArgumentException("presentationTime < 0");
        }
        this.markerLock.lock();
        try {
            if (this.markersByName == null) {
                this.markersByName = new HashMap<String, Double>();
                this.markersByTime = new TreeMap<Double, String>();
            }
            this.markersByName.put(markerName, presentationTime);
            this.markersByTime.put(presentationTime, markerName);
            this.fireMarkerStateEvent(true);
        }
        finally {
            this.markerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Double> getMarkers() {
        Map<String, Double> markers = null;
        this.markerLock.lock();
        try {
            if (this.markersByName != null && !this.markersByName.isEmpty()) {
                markers = Collections.unmodifiableMap(this.markersByName);
            }
        }
        finally {
            this.markerLock.unlock();
        }
        return markers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double removeMarker(String markerName) {
        if (markerName == null) {
            throw new IllegalArgumentException("markerName == null!");
        }
        double time = -1.0;
        this.markerLock.lock();
        try {
            if (this.markersByName.containsKey(markerName)) {
                time = this.markersByName.get(markerName);
                this.markersByName.remove(markerName);
                this.markersByTime.remove(time);
                this.fireMarkerStateEvent(this.markersByName.size() > 0);
            }
        }
        finally {
            this.markerLock.unlock();
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllMarkers() {
        this.markerLock.lock();
        try {
            this.markersByName.clear();
            this.markersByTime.clear();
            this.fireMarkerStateEvent(false);
        }
        finally {
            this.markerLock.unlock();
        }
    }

    public abstract void dispose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map.Entry<Double, String> getNextMarker(double time, boolean inclusive) {
        Map.Entry<Double, String> entry = null;
        this.markerLock.lock();
        try {
            if (this.markersByTime != null) {
                entry = inclusive ? this.markersByTime.ceilingEntry(time) : this.markersByTime.higherEntry(time);
            }
        }
        finally {
            this.markerLock.unlock();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMarkerStateListener(MarkerStateListener listener) {
        if (listener != null) {
            this.listenerLock.lock();
            try {
                if (this.markerListeners == null) {
                    this.markerListeners = new WeakHashMap();
                }
                this.markerListeners.put(listener, Boolean.TRUE);
            }
            finally {
                this.listenerLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMarkerStateListener(MarkerStateListener listener) {
        if (listener != null) {
            this.listenerLock.lock();
            try {
                if (this.markerListeners != null) {
                    this.markerListeners.remove(listener);
                }
            }
            finally {
                this.listenerLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMarkerStateEvent(boolean hasMarkers) {
        this.listenerLock.lock();
        try {
            if (this.markerListeners != null && !this.markerListeners.isEmpty()) {
                for (MarkerStateListener listener : this.markerListeners.keySet()) {
                    if (listener == null) continue;
                    listener.markerStateChanged(hasMarkers);
                }
            }
        }
        finally {
            this.listenerLock.unlock();
        }
    }
}

