/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.MediaManager;
import com.sun.media.jfxmedia.MediaPlayer;
import com.sun.media.jfxmedia.events.MediaErrorListener;
import com.sun.media.jfxmedia.events.PlayerStateEvent;
import com.sun.media.jfxmedia.events.PlayerStateListener;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.NativeMediaAudioClip;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public final class NativeMediaAudioClipPlayer
implements PlayerStateListener,
MediaErrorListener {
    private MediaPlayer mediaPlayer;
    private int playCount;
    private int loopCount;
    private boolean playing;
    private boolean ready;
    private NativeMediaAudioClip sourceClip;
    private double volume;
    private double balance;
    private double pan;
    private double rate;
    private int priority;
    private final ReentrantLock playerStateLock = new ReentrantLock();
    private static final int MAX_PLAYER_COUNT = 16;
    private static final List<NativeMediaAudioClipPlayer> activePlayers = new ArrayList<NativeMediaAudioClipPlayer>(16);
    private static final ReentrantLock playerListLock = new ReentrantLock();
    private static Thread schedulerThread;
    private static final LinkedBlockingQueue<SchedulerEntry> schedule;

    public static int getPlayerLimit() {
        return 16;
    }

    public static int getPlayerCount() {
        return activePlayers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clipScheduler() {
        while (true) {
            SchedulerEntry entry = null;
            try {
                entry = schedule.take();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (null == entry) continue;
            if (entry.getCommand() == 0) {
                NativeMediaAudioClipPlayer player = entry.getPlayer();
                if (null != player) {
                    if (NativeMediaAudioClipPlayer.addPlayer(player)) {
                        player.play();
                    } else {
                        player.sourceClip.playFinished();
                    }
                }
            } else if (entry.getCommand() == 1) {
                ArrayList<SchedulerEntry> killList = null;
                URI sourceURI = entry.getClipURI();
                playerListLock.lock();
                try {
                    NativeMediaAudioClipPlayer[] players = new NativeMediaAudioClipPlayer[16];
                    players = activePlayers.toArray(players);
                    if (null != players) {
                        for (int index = 0; index < players.length; ++index) {
                            if (null == players[index] || null != sourceURI && !players[index].source().getURI().equals(sourceURI)) continue;
                            players[index].invalidate();
                        }
                    }
                }
                finally {
                    playerListLock.unlock();
                }
                if (null != sourceURI) {
                    killList = new ArrayList<SchedulerEntry>();
                }
                LinkedBlockingQueue<SchedulerEntry> linkedBlockingQueue = schedule;
                synchronized (linkedBlockingQueue) {
                    for (SchedulerEntry killEntry : schedule) {
                        NativeMediaAudioClipPlayer player = killEntry.getPlayer();
                        if (sourceURI != null && !player.sourceClip.getLocator().getURI().equals(sourceURI)) continue;
                        if (null != killList) {
                            killList.add(entry);
                        }
                        player.sourceClip.playFinished();
                    }
                    if (null != killList) {
                        schedule.removeAll(killList);
                    } else {
                        schedule.clear();
                    }
                }
            }
            entry.signal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void playClip(NativeMediaAudioClip clip, double volume, double balance, double rate, double pan, int loopCount, int priority) {
        LinkedBlockingQueue<SchedulerEntry> linkedBlockingQueue = schedule;
        synchronized (linkedBlockingQueue) {
            if (null == schedulerThread) {
                schedulerThread = new Thread(new Runnable(){

                    public void run() {
                        NativeMediaAudioClipPlayer.clipScheduler();
                    }
                });
                schedulerThread.setDaemon(true);
                schedulerThread.start();
            }
        }
        NativeMediaAudioClipPlayer newPlayer = new NativeMediaAudioClipPlayer(clip, volume, balance, rate, pan, loopCount, priority);
        SchedulerEntry entry = new SchedulerEntry(newPlayer);
        if (!schedule.contains(entry)) {
            schedule.offer(entry);
        } else {
            clip.playFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addPlayer(NativeMediaAudioClipPlayer newPlayer) {
        playerListLock.lock();
        try {
            int priority = newPlayer.priority();
            while (activePlayers.size() >= 16) {
                NativeMediaAudioClipPlayer target = null;
                for (NativeMediaAudioClipPlayer player : activePlayers) {
                    if (player.priority() > priority || target != null && (!target.isReady() || player.priority() >= target.priority())) continue;
                    target = player;
                }
                if (null == target) {
                    boolean bl = false;
                    return bl;
                }
                target.invalidate();
            }
            activePlayers.add(newPlayer);
        }
        finally {
            playerListLock.unlock();
        }
        return true;
    }

    public static void stopPlayers(Locator source) {
        CountDownLatch stopSignal;
        SchedulerEntry entry;
        URI sourceURI;
        URI uRI = sourceURI = source != null ? source.getURI() : null;
        if (null != schedulerThread && schedule.offer(entry = new SchedulerEntry(sourceURI, stopSignal = new CountDownLatch(1)))) {
            try {
                stopSignal.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    private NativeMediaAudioClipPlayer(NativeMediaAudioClip clip, double volume, double balance, double rate, double pan, int loopCount, int priority) {
        this.sourceClip = clip;
        this.volume = volume;
        this.balance = balance;
        this.pan = pan;
        this.rate = rate;
        this.loopCount = loopCount;
        this.priority = priority;
        this.ready = false;
    }

    private Locator source() {
        return this.sourceClip.getLocator();
    }

    public double volume() {
        return this.volume;
    }

    public void setVolume(double volume) {
        this.volume = volume;
    }

    public double balance() {
        return this.balance;
    }

    public void setBalance(double balance) {
        this.balance = balance;
    }

    public double pan() {
        return this.pan;
    }

    public void setPan(double pan) {
        this.pan = pan;
    }

    public double playbackRate() {
        return this.rate;
    }

    public void setPlaybackRate(double rate) {
        this.rate = rate;
    }

    public int priority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int loopCount() {
        return this.loopCount;
    }

    public void setLoopCount(int loopCount) {
        this.loopCount = loopCount;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    private boolean isReady() {
        return this.ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void play() {
        this.playerStateLock.lock();
        try {
            this.playing = true;
            this.playCount = 0;
            if (null == this.mediaPlayer) {
                this.mediaPlayer = MediaManager.getPlayer(this.source());
                this.mediaPlayer.addMediaPlayerListener(this);
                this.mediaPlayer.addMediaErrorListener(this);
            } else {
                this.mediaPlayer.play();
            }
        }
        finally {
            this.playerStateLock.unlock();
        }
    }

    public void stop() {
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void invalidate() {
        this.playerStateLock.lock();
        playerListLock.lock();
        try {
            this.playing = false;
            this.playCount = 0;
            this.ready = false;
            activePlayers.remove(this);
            this.sourceClip.playFinished();
            if (null != this.mediaPlayer) {
                this.mediaPlayer.dispose();
                this.mediaPlayer = null;
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.playerStateLock.unlock();
            playerListLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReady(PlayerStateEvent evt) {
        this.playerStateLock.lock();
        try {
            this.ready = true;
            if (this.playing) {
                this.mediaPlayer.setVolume((float)this.volume);
                this.mediaPlayer.setBalance((float)this.balance);
                this.mediaPlayer.setRate((float)this.rate);
                this.mediaPlayer.play();
            }
        }
        finally {
            this.playerStateLock.unlock();
        }
    }

    public void onPlaying(PlayerStateEvent evt) {
    }

    public void onPause(PlayerStateEvent evt) {
    }

    public void onStop(PlayerStateEvent evt) {
        this.invalidate();
    }

    public void onStall(PlayerStateEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinish(PlayerStateEvent evt) {
        this.playerStateLock.lock();
        try {
            if (this.playing) {
                if (this.loopCount != -1) {
                    ++this.playCount;
                    if (this.playCount <= this.loopCount) {
                        this.mediaPlayer.seek(0.0);
                    } else {
                        this.invalidate();
                    }
                } else {
                    this.mediaPlayer.seek(0.0);
                }
            }
        }
        finally {
            this.playerStateLock.unlock();
        }
    }

    public void onHalt(PlayerStateEvent evt) {
        this.invalidate();
    }

    public void onWarning(Object source, String message) {
    }

    public void onError(Object source, int errorCode, String message) {
        if (Logger.canLog(4)) {
            Logger.logMsg(4, "Error with AudioClip player: code " + errorCode + " : " + message);
        }
        this.invalidate();
    }

    public boolean equals(Object other) {
        URI otherURI;
        if (other == null || !(other instanceof NativeMediaAudioClipPlayer)) {
            return false;
        }
        NativeMediaAudioClipPlayer otherPlayer = (NativeMediaAudioClipPlayer)other;
        URI myURI = this.sourceClip.getLocator().getURI();
        return myURI.equals(otherURI = otherPlayer.sourceClip.getLocator().getURI()) && this.priority == otherPlayer.priority && this.loopCount == otherPlayer.loopCount && this.volume == otherPlayer.volume && this.balance == otherPlayer.balance && this.rate == otherPlayer.rate && this.pan == otherPlayer.pan;
    }

    static {
        schedule = new LinkedBlockingQueue();
    }

    private static class SchedulerEntry {
        private final int command;
        private final NativeMediaAudioClipPlayer player;
        private final URI clipURI;
        private final CountDownLatch commandSignal;

        public SchedulerEntry(NativeMediaAudioClipPlayer player) {
            this.command = 0;
            this.player = player;
            this.clipURI = null;
            this.commandSignal = null;
        }

        public SchedulerEntry(URI sourceURI, CountDownLatch signal) {
            this.command = 1;
            this.player = null;
            this.clipURI = sourceURI;
            this.commandSignal = signal;
        }

        public int getCommand() {
            return this.command;
        }

        public NativeMediaAudioClipPlayer getPlayer() {
            return this.player;
        }

        public URI getClipURI() {
            return this.clipURI;
        }

        public void signal() {
            if (null != this.commandSignal) {
                this.commandSignal.countDown();
            }
        }

        public boolean equals(Object other) {
            if (other instanceof SchedulerEntry && null != this.player) {
                return this.player.equals(((SchedulerEntry)other).getPlayer());
            }
            return false;
        }
    }
}

