/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.Media;
import com.sun.media.jfxmedia.MediaError;
import com.sun.media.jfxmedia.MediaException;
import com.sun.media.jfxmedia.MediaPlayer;
import com.sun.media.jfxmedia.control.VideoRenderControl;
import com.sun.media.jfxmedia.effects.AudioEqualizer;
import com.sun.media.jfxmedia.effects.AudioSpectrum;
import com.sun.media.jfxmedia.events.AudioSpectrumEvent;
import com.sun.media.jfxmedia.events.AudioSpectrumListener;
import com.sun.media.jfxmedia.events.BufferListener;
import com.sun.media.jfxmedia.events.BufferProgressEvent;
import com.sun.media.jfxmedia.events.MarkerEvent;
import com.sun.media.jfxmedia.events.MarkerListener;
import com.sun.media.jfxmedia.events.MediaErrorListener;
import com.sun.media.jfxmedia.events.NewFrameEvent;
import com.sun.media.jfxmedia.events.PlayerEvent;
import com.sun.media.jfxmedia.events.PlayerStateEvent;
import com.sun.media.jfxmedia.events.PlayerStateListener;
import com.sun.media.jfxmedia.events.PlayerTimeListener;
import com.sun.media.jfxmedia.events.VideoFrameRateListener;
import com.sun.media.jfxmedia.events.VideoRendererListener;
import com.sun.media.jfxmedia.events.VideoTrackSizeListener;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmedia.track.AudioTrack;
import com.sun.media.jfxmedia.track.Track;
import com.sun.media.jfxmedia.track.VideoResolution;
import com.sun.media.jfxmedia.track.VideoTrack;
import com.sun.media.jfxmediaimpl.MarkerStateListener;
import com.sun.media.jfxmediaimpl.MediaPulseTask;
import com.sun.media.jfxmediaimpl.MediaUtils;
import com.sun.media.jfxmediaimpl.NativeMedia;
import com.sun.media.jfxmediaimpl.NativeVideoBuffer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class NativeMediaPlayer
implements MediaPlayer,
MarkerStateListener {
    public static final int eventPlayerUnknown = 100;
    public static final int eventPlayerReady = 101;
    public static final int eventPlayerPlaying = 102;
    public static final int eventPlayerPaused = 103;
    public static final int eventPlayerStopped = 104;
    public static final int eventPlayerStalled = 105;
    public static final int eventPlayerFinished = 106;
    public static final int eventPlayerError = 107;
    private static final int NOMINAL_VIDEO_FPS = 30;
    public static final long ONE_SECOND = 1000000000L;
    private NativeMedia media;
    private VideoRenderControl videoRenderControl;
    private final List<WeakReference<MediaErrorListener>> errorListeners = new ArrayList<WeakReference<MediaErrorListener>>();
    private final List<WeakReference<PlayerStateListener>> playerStateListeners = new ArrayList<WeakReference<PlayerStateListener>>();
    private final List<WeakReference<PlayerTimeListener>> playerTimeListeners = new ArrayList<WeakReference<PlayerTimeListener>>();
    private final List<WeakReference<VideoTrackSizeListener>> videoTrackSizeListeners = new ArrayList<WeakReference<VideoTrackSizeListener>>();
    private final List<WeakReference<VideoRendererListener>> videoUpdateListeners = new ArrayList<WeakReference<VideoRendererListener>>();
    private final List<WeakReference<VideoFrameRateListener>> videoFrameRateListeners = new ArrayList<WeakReference<VideoFrameRateListener>>();
    private final List<WeakReference<MarkerListener>> markerListeners = new ArrayList<WeakReference<MarkerListener>>();
    private final List<WeakReference<BufferListener>> bufferListeners = new ArrayList<WeakReference<BufferListener>>();
    private final List<WeakReference<AudioSpectrumListener>> audioSpectrumListeners = new ArrayList<WeakReference<AudioSpectrumListener>>();
    private final List<PlayerStateEvent> cachedStateEvents = new ArrayList<PlayerStateEvent>();
    private final List<PlayerTimeEvent> cachedTimeEvents = new ArrayList<PlayerTimeEvent>();
    private final List<BufferProgressEvent> cachedBufferEvents = new ArrayList<BufferProgressEvent>();
    private final List<MediaErrorEvent> cachedErrorEvents = new ArrayList<MediaErrorEvent>();
    private boolean isFirstFrame = true;
    private NewFrameEvent firstFrameEvent = null;
    private double firstFrameTime;
    private final Object firstFrameLock = new Object();
    private EventQueueThread eventLoop = new EventQueueThread();
    private int frameWidth = -1;
    private int frameHeight = -1;
    private AtomicBoolean isMediaPulseEnabled = new AtomicBoolean(false);
    private final Lock mediaPulseLock = new ReentrantLock();
    private Timer mediaPulseTimer;
    private Lock markerLock = new ReentrantLock();
    private boolean checkSeek = false;
    private double timeBeforeSeek = 0.0;
    private double timeAfterSeek = 0.0;
    private double previousTime = 0.0;
    private double firedMarkerTime = -1.0;
    private double encodedFrameRate = 0.0;
    private boolean recomputeFrameRate = true;
    private double previousFrameTime;
    private long numFramesSincePlaying;
    private double meanFrameDuration;
    private double decodedFrameRate;
    private PlayerStateEvent.PlayerState playerState = PlayerStateEvent.PlayerState.UNKNOWN;
    private Lock disposeLock = new ReentrantLock();
    private boolean isDisposed = false;
    private Runnable onDispose;

    protected NativeMediaPlayer(NativeMedia clip) {
        if (clip == null) {
            throw new IllegalArgumentException("clip == null!");
        }
        this.media = clip;
        this.media.addMarkerStateListener(this);
        this.videoRenderControl = new VideoRenderer();
        this.eventLoop.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOnDispose(Runnable onDispose) {
        this.disposeLock.lock();
        try {
            if (!this.isDisposed) {
                this.onDispose = onDispose;
            }
        }
        finally {
            this.disposeLock.unlock();
        }
    }

    private synchronized void onNativeInit() {
        try {
            this.playerInit();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaErrorListener(MediaErrorListener listener) {
        if (listener != null) {
            this.errorListeners.add(new WeakReference<MediaErrorListener>(listener));
            List<MediaErrorEvent> list = this.cachedErrorEvents;
            synchronized (list) {
                if (!this.cachedErrorEvents.isEmpty() && !this.errorListeners.isEmpty()) {
                    for (MediaErrorEvent evt : this.cachedErrorEvents) {
                        this.sendPlayerEvent(evt);
                    }
                    this.cachedErrorEvents.clear();
                }
            }
        }
    }

    public void removeMediaErrorListener(MediaErrorListener listener) {
        if (listener != null) {
            ListIterator<WeakReference<MediaErrorListener>> it = this.errorListeners.listIterator();
            while (it.hasNext()) {
                MediaErrorListener l = (MediaErrorListener)it.next().get();
                if (l != null && l != listener) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaPlayerListener(PlayerStateListener listener) {
        if (listener != null) {
            List<PlayerStateEvent> list = this.cachedStateEvents;
            synchronized (list) {
                if (!this.cachedStateEvents.isEmpty() && this.playerStateListeners.isEmpty()) {
                    for (PlayerStateEvent evt : this.cachedStateEvents) {
                        switch (evt.getState()) {
                            case READY: {
                                listener.onReady(evt);
                                break;
                            }
                            case PLAYING: {
                                listener.onPlaying(evt);
                                break;
                            }
                            case PAUSED: {
                                listener.onPause(evt);
                                break;
                            }
                            case STOPPED: {
                                listener.onStop(evt);
                                break;
                            }
                            case STALLED: {
                                listener.onStall(evt);
                                break;
                            }
                            case FINISHED: {
                                listener.onFinish(evt);
                            }
                        }
                    }
                    this.cachedStateEvents.clear();
                }
                this.playerStateListeners.add(new WeakReference<PlayerStateListener>(listener));
            }
        }
    }

    public void removeMediaPlayerListener(PlayerStateListener listener) {
        if (listener != null) {
            ListIterator<WeakReference<PlayerStateListener>> it = this.playerStateListeners.listIterator();
            while (it.hasNext()) {
                PlayerStateListener l = (PlayerStateListener)it.next().get();
                if (l != null && l != listener) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaTimeListener(PlayerTimeListener listener) {
        if (listener != null) {
            List<PlayerTimeEvent> list = this.cachedTimeEvents;
            synchronized (list) {
                if (!this.cachedTimeEvents.isEmpty() && this.playerTimeListeners.isEmpty()) {
                    for (PlayerTimeEvent evt : this.cachedTimeEvents) {
                        switch (evt.getType()) {
                            case STOP_TIME: {
                                this.pause();
                                listener.onStopTimeReached(evt.getTime());
                                break;
                            }
                            case DURATION: {
                                listener.onDurationChanged(evt.getTime());
                            }
                        }
                    }
                    this.cachedTimeEvents.clear();
                } else {
                    double duration = this.getDuration();
                    if (duration != Double.POSITIVE_INFINITY) {
                        listener.onDurationChanged(duration);
                    }
                }
                this.playerTimeListeners.add(new WeakReference<PlayerTimeListener>(listener));
            }
        }
    }

    public void removeMediaTimeListener(PlayerTimeListener listener) {
        if (listener != null) {
            ListIterator<WeakReference<PlayerTimeListener>> it = this.playerTimeListeners.listIterator();
            while (it.hasNext()) {
                PlayerTimeListener l = (PlayerTimeListener)it.next().get();
                if (l != null && l != listener) continue;
                it.remove();
            }
        }
    }

    public void addVideoTrackSizeListener(VideoTrackSizeListener listener) {
        if (listener != null) {
            if (this.frameWidth != -1 && this.frameHeight != -1) {
                listener.onSizeChanged(this.frameWidth, this.frameHeight);
            }
            this.videoTrackSizeListeners.add(new WeakReference<VideoTrackSizeListener>(listener));
        }
    }

    public void removeVideoTrackSizeListener(VideoTrackSizeListener listener) {
        if (listener != null) {
            ListIterator<WeakReference<VideoTrackSizeListener>> it = this.videoTrackSizeListeners.listIterator();
            while (it.hasNext()) {
                VideoTrackSizeListener l = (VideoTrackSizeListener)it.next().get();
                if (l != null && l != listener) continue;
                it.remove();
            }
        }
    }

    public void addMarkerListener(MarkerListener listener) {
        if (listener != null) {
            this.markerListeners.add(new WeakReference<MarkerListener>(listener));
        }
    }

    public void removeMarkerListener(MarkerListener listener) {
        if (listener != null) {
            ListIterator<WeakReference<MarkerListener>> it = this.markerListeners.listIterator();
            while (it.hasNext()) {
                MarkerListener l = (MarkerListener)it.next().get();
                if (l != null && l != listener) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBufferListener(BufferListener listener) {
        if (listener != null) {
            List<BufferProgressEvent> list = this.cachedBufferEvents;
            synchronized (list) {
                if (!this.cachedBufferEvents.isEmpty() && this.bufferListeners.isEmpty()) {
                    for (BufferProgressEvent evt : this.cachedBufferEvents) {
                        listener.onBufferProgress(evt);
                    }
                    this.cachedBufferEvents.clear();
                }
                this.bufferListeners.add(new WeakReference<BufferListener>(listener));
            }
        }
    }

    public void removeBufferListener(BufferListener listener) {
        if (listener != null) {
            ListIterator<WeakReference<BufferListener>> it = this.bufferListeners.listIterator();
            while (it.hasNext()) {
                BufferListener l = (BufferListener)it.next().get();
                if (l != null && l != listener) continue;
                it.remove();
            }
        }
    }

    public void addAudioSpectrumListener(AudioSpectrumListener listener) {
        if (listener != null) {
            this.audioSpectrumListeners.add(new WeakReference<AudioSpectrumListener>(listener));
        }
    }

    public void removeAudioSpectrumListener(AudioSpectrumListener listener) {
        if (listener != null) {
            ListIterator<WeakReference<AudioSpectrumListener>> it = this.audioSpectrumListeners.listIterator();
            while (it.hasNext()) {
                AudioSpectrumListener l = (AudioSpectrumListener)it.next().get();
                if (l != null && l != listener) continue;
                it.remove();
            }
        }
    }

    public VideoRenderControl getVideoRenderControl() {
        return this.videoRenderControl;
    }

    public Media getMedia() {
        return this.media;
    }

    public void setAudioSyncDelay(long delay) {
        try {
            this.playerSetAudioSyncDelay(delay);
        }
        catch (MediaException me) {
            this.sendPlayerEvent(new MediaErrorEvent(this, me.getMediaError()));
        }
    }

    public long getAudioSyncDelay() {
        try {
            return this.playerGetAudioSyncDelay();
        }
        catch (MediaException me) {
            this.sendPlayerEvent(new MediaErrorEvent(this, me.getMediaError()));
            return 0L;
        }
    }

    public void play() {
        try {
            this.playerPlay();
        }
        catch (MediaException me) {
            this.sendPlayerEvent(new MediaErrorEvent(this, me.getMediaError()));
        }
    }

    public void stop() {
        try {
            this.playerStop();
        }
        catch (MediaException me) {
            MediaUtils.warning(this, "stop() failed!");
        }
    }

    public void pause() {
        try {
            this.playerPause();
        }
        catch (MediaException me) {
            this.sendPlayerEvent(new MediaErrorEvent(this, me.getMediaError()));
        }
    }

    public float getRate() {
        try {
            return this.playerGetRate();
        }
        catch (MediaException me) {
            this.sendPlayerEvent(new MediaErrorEvent(this, me.getMediaError()));
            return 0.0f;
        }
    }

    public void setRate(float rate) {
        try {
            this.playerSetRate(rate);
        }
        catch (MediaException me) {
            MediaUtils.warning(this, "setRate(" + rate + ") failed!");
        }
    }

    public double getPresentationTime() {
        try {
            return this.playerGetPresentationTime();
        }
        catch (MediaException mediaException) {
            return -1.0;
        }
    }

    public float getVolume() {
        try {
            return this.playerGetVolume();
        }
        catch (MediaException me) {
            this.sendPlayerEvent(new MediaErrorEvent(this, me.getMediaError()));
            return 0.0f;
        }
    }

    public void setVolume(float vol) {
        if (vol < 0.0f) {
            vol = 0.0f;
        } else if (vol > 1.0f) {
            vol = 1.0f;
        }
        try {
            this.playerSetVolume(vol);
        }
        catch (MediaException me) {
            this.sendPlayerEvent(new MediaErrorEvent(this, me.getMediaError()));
        }
    }

    public boolean getMute() {
        try {
            return this.playerGetMute();
        }
        catch (MediaException me) {
            this.sendPlayerEvent(new MediaErrorEvent(this, me.getMediaError()));
            return false;
        }
    }

    public synchronized void setMute(boolean enable) {
        try {
            this.playerSetMute(enable);
        }
        catch (MediaException me) {
            this.sendPlayerEvent(new MediaErrorEvent(this, me.getMediaError()));
        }
    }

    public float getBalance() {
        try {
            return this.playerGetBalance();
        }
        catch (MediaException me) {
            this.sendPlayerEvent(new MediaErrorEvent(this, me.getMediaError()));
            return 0.0f;
        }
    }

    public void setBalance(float bal) {
        if (bal < -1.0f) {
            bal = -1.0f;
        } else if (bal > 1.0f) {
            bal = 1.0f;
        }
        try {
            this.playerSetBalance(bal);
        }
        catch (MediaException me) {
            this.sendPlayerEvent(new MediaErrorEvent(this, me.getMediaError()));
        }
    }

    public abstract AudioEqualizer getEqualizer();

    public abstract AudioSpectrum getAudioSpectrum();

    public double getDuration() {
        try {
            return this.playerGetDuration();
        }
        catch (MediaException mediaException) {
            return Double.POSITIVE_INFINITY;
        }
    }

    public double getStartTime() {
        try {
            return this.playerGetStartTime();
        }
        catch (MediaException me) {
            this.sendPlayerEvent(new MediaErrorEvent(this, me.getMediaError()));
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartTime(double streamTime) {
        try {
            this.markerLock.lock();
            try {
                this.playerSetStartTime(streamTime);
                this.seek(streamTime);
            }
            finally {
                this.markerLock.unlock();
            }
        }
        catch (MediaException me) {
            this.sendPlayerEvent(new MediaErrorEvent(this, me.getMediaError()));
        }
    }

    public double getStopTime() {
        try {
            return this.playerGetStopTime();
        }
        catch (MediaException me) {
            this.sendPlayerEvent(new MediaErrorEvent(this, me.getMediaError()));
            return Double.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStopTime(double streamTime) {
        try {
            this.markerLock.lock();
            try {
                this.playerSetStopTime(streamTime);
            }
            finally {
                this.markerLock.unlock();
            }
        }
        catch (MediaException me) {
            this.sendPlayerEvent(new MediaErrorEvent(this, me.getMediaError()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seek(double streamTime) {
        if (streamTime < 0.0) {
            streamTime = 0.0;
        } else {
            double duration = this.getDuration();
            if (duration >= 0.0 && streamTime > duration) {
                streamTime = duration;
            }
        }
        if (!this.isMediaPulseEnabled.get() && (this.playerState == PlayerStateEvent.PlayerState.PLAYING || this.playerState == PlayerStateEvent.PlayerState.PAUSED || this.playerState == PlayerStateEvent.PlayerState.FINISHED) && this.getStartTime() <= streamTime && streamTime <= this.getStopTime()) {
            this.isMediaPulseEnabled.set(true);
        }
        this.markerLock.lock();
        try {
            this.timeBeforeSeek = this.getPresentationTime();
            this.timeAfterSeek = streamTime;
            this.checkSeek = this.timeBeforeSeek != this.timeAfterSeek;
            this.previousTime = streamTime;
            this.firedMarkerTime = -1.0;
            try {
                this.playerSeek(streamTime);
            }
            catch (MediaException me) {
                MediaUtils.warning(this, "seek(" + streamTime + ") failed!");
            }
        }
        finally {
            this.markerLock.unlock();
        }
    }

    protected abstract long playerGetAudioSyncDelay() throws MediaException;

    protected abstract void playerSetAudioSyncDelay(long var1) throws MediaException;

    protected abstract void playerPlay() throws MediaException;

    protected abstract void playerStop() throws MediaException;

    protected abstract void playerPause() throws MediaException;

    protected abstract float playerGetRate() throws MediaException;

    protected abstract void playerSetRate(float var1) throws MediaException;

    protected abstract double playerGetPresentationTime() throws MediaException;

    protected abstract boolean playerGetMute() throws MediaException;

    protected abstract void playerSetMute(boolean var1) throws MediaException;

    protected abstract float playerGetVolume() throws MediaException;

    protected abstract void playerSetVolume(float var1) throws MediaException;

    protected abstract float playerGetBalance() throws MediaException;

    protected abstract void playerSetBalance(float var1) throws MediaException;

    protected abstract double playerGetDuration() throws MediaException;

    protected abstract double playerGetStartTime() throws MediaException;

    protected abstract void playerSetStartTime(double var1) throws MediaException;

    protected abstract double playerGetStopTime() throws MediaException;

    protected abstract void playerSetStopTime(double var1) throws MediaException;

    protected abstract void playerSeek(double var1) throws MediaException;

    protected abstract void playerInit() throws MediaException;

    protected abstract void playerDispose();

    public PlayerStateEvent.PlayerState getState() {
        return this.playerState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.disposeLock.lock();
        try {
            if (!this.isDisposed) {
                this.destroyMediaPulse();
                if (this.eventLoop != null) {
                    this.eventLoop.terminateLoop();
                }
                this.playerDispose();
                if (this.media != null) {
                    this.media.dispose();
                    this.media = null;
                }
                if (this.eventLoop != null) {
                    this.eventLoop.eventQueue.clear();
                    this.eventLoop = null;
                }
                ListIterator<WeakReference<VideoRendererListener>> it = this.videoUpdateListeners.listIterator();
                while (it.hasNext()) {
                    VideoRendererListener l = (VideoRendererListener)it.next().get();
                    if (l != null) {
                        l.releaseVideoFrames();
                        continue;
                    }
                    it.remove();
                }
                if (this.videoUpdateListeners != null) {
                    this.videoUpdateListeners.clear();
                }
                if (this.playerStateListeners != null) {
                    this.playerStateListeners.clear();
                }
                if (this.videoTrackSizeListeners != null) {
                    this.videoTrackSizeListeners.clear();
                }
                if (this.videoFrameRateListeners != null) {
                    this.videoFrameRateListeners.clear();
                }
                if (this.cachedStateEvents != null) {
                    this.cachedStateEvents.clear();
                }
                if (this.cachedTimeEvents != null) {
                    this.cachedTimeEvents.clear();
                }
                if (this.cachedBufferEvents != null) {
                    this.cachedBufferEvents.clear();
                }
                if (this.errorListeners != null) {
                    this.errorListeners.clear();
                }
                if (this.playerTimeListeners != null) {
                    this.playerTimeListeners.clear();
                }
                if (this.markerListeners != null) {
                    this.markerListeners.clear();
                }
                if (this.bufferListeners != null) {
                    this.bufferListeners.clear();
                }
                if (this.audioSpectrumListeners != null) {
                    this.audioSpectrumListeners.clear();
                }
                if (this.videoRenderControl != null) {
                    this.videoRenderControl = null;
                }
                if (this.onDispose != null) {
                    this.onDispose.run();
                }
                this.isDisposed = true;
            }
        }
        finally {
            this.disposeLock.unlock();
        }
    }

    protected void sendWarning(int warningCode, String warningMessage) {
        if (this.eventLoop != null) {
            String message = String.format("Internal media warning: %d", warningCode);
            if (warningMessage != null) {
                message = message + ": " + warningMessage;
            }
            this.eventLoop.postEvent(new WarningEvent(this, message));
        }
    }

    protected void sendPlayerEvent(PlayerEvent evt) {
        if (this.eventLoop != null) {
            this.eventLoop.postEvent(evt);
        }
    }

    protected void sendPlayerHaltEvent(String message, double time) {
        Logger.logMsg(4, message);
        if (this.eventLoop != null) {
            this.eventLoop.postEvent(new PlayerStateEvent(PlayerStateEvent.PlayerState.HALTED, time, message));
        }
    }

    protected void sendPlayerMediaErrorEvent(int errorCode) {
        this.sendPlayerEvent(new MediaErrorEvent(this, MediaError.getFromCode(errorCode)));
    }

    protected void sendPlayerStateEvent(int eventID, double time) {
        switch (eventID) {
            case 101: {
                this.sendPlayerEvent(new PlayerStateEvent(PlayerStateEvent.PlayerState.READY, time));
                break;
            }
            case 102: {
                this.sendPlayerEvent(new PlayerStateEvent(PlayerStateEvent.PlayerState.PLAYING, time));
                break;
            }
            case 103: {
                this.sendPlayerEvent(new PlayerStateEvent(PlayerStateEvent.PlayerState.PAUSED, time));
                break;
            }
            case 104: {
                this.sendPlayerEvent(new PlayerStateEvent(PlayerStateEvent.PlayerState.STOPPED, time));
                break;
            }
            case 105: {
                this.sendPlayerEvent(new PlayerStateEvent(PlayerStateEvent.PlayerState.STALLED, time));
                break;
            }
            case 106: {
                this.sendPlayerEvent(new PlayerStateEvent(PlayerStateEvent.PlayerState.FINISHED, time));
            }
        }
    }

    protected void sendNewFrameEvent(long nativeRef) {
        NativeVideoBuffer newFrameData = NativeVideoBuffer.createVideoBuffer(nativeRef);
        this.sendPlayerEvent(new NewFrameEvent(newFrameData));
    }

    protected void sendFrameSizeChangedEvent(int width, int height) {
        this.sendPlayerEvent(new FrameSizeChangedEvent(width, height));
    }

    protected void sendAudioTrack(String name, int encoding, String language, int numChannels, int channelMask, float sampleRate) {
        Locator locator = this.getMedia().getLocator();
        AudioTrack track = new AudioTrack(locator, name, Track.Encoding.toEncoding(encoding), new Locale(language), numChannels, channelMask, sampleRate);
        TrackEvent evt = new TrackEvent(track);
        this.sendPlayerEvent(evt);
    }

    protected void sendVideoTrack(String name, int encoding, int width, int height, float frameRate, boolean hasAlphaChannel) {
        Locator locator = this.getMedia().getLocator();
        VideoTrack track = new VideoTrack(locator, name, Track.Encoding.toEncoding(encoding), new VideoResolution(width, height), frameRate, hasAlphaChannel);
        TrackEvent evt = new TrackEvent(track);
        this.sendPlayerEvent(evt);
    }

    protected void sendMarkerEvent(String name, double time) {
        this.sendPlayerEvent(new MarkerEvent(name, time));
    }

    protected void sendStopReachedEvent(double presentationTime) {
        this.sendPlayerEvent(new PlayerTimeEvent(PlayerTimeEventType.STOP_TIME, presentationTime));
    }

    protected void sendDurationUpdateEvent(double duration) {
        this.sendPlayerEvent(new PlayerTimeEvent(PlayerTimeEventType.DURATION, duration));
    }

    protected void sendBufferProgressEvent(double clipDuration, long bufferStart, long bufferStop, long bufferPosition) {
        this.sendPlayerEvent(new BufferProgressEvent(clipDuration, bufferStart, bufferStop, bufferPosition));
    }

    protected void sendAudioSpectrumEvent(double timestamp, double duration) {
        this.sendPlayerEvent(new AudioSpectrumEvent(this.getAudioSpectrum(), timestamp, duration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markerStateChanged(boolean hasMarkers) {
        if (hasMarkers) {
            this.markerLock.lock();
            try {
                this.previousTime = this.getPresentationTime();
            }
            finally {
                this.markerLock.unlock();
            }
            this.createMediaPulse();
        } else {
            this.destroyMediaPulse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMediaPulse() {
        this.mediaPulseLock.lock();
        try {
            if (this.mediaPulseTimer == null) {
                this.mediaPulseTimer = new Timer(true);
                this.mediaPulseTimer.scheduleAtFixedRate((TimerTask)new MediaPulseTask(this), 0L, 40L);
            }
        }
        finally {
            this.mediaPulseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyMediaPulse() {
        this.mediaPulseLock.lock();
        try {
            if (this.mediaPulseTimer != null) {
                this.mediaPulseTimer.cancel();
                this.mediaPulseTimer = null;
            }
        }
        finally {
            this.mediaPulseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    boolean doMediaPulseTask() {
        block14: {
            if (!this.isMediaPulseEnabled.get()) break block14;
            this.markerLock.lock();
            this.disposeLock.lock();
            if (this.isDisposed) {
                return false;
            }
            try {
                block15: {
                    thisTime = this.getPresentationTime();
                    if (!this.checkSeek) break block15;
                    if (!(this.timeAfterSeek > this.timeBeforeSeek)) ** GOTO lbl15
                    if (thisTime >= this.timeAfterSeek) {
                        this.checkSeek = false;
                    } else {
                        var3_2 = true;
                        return var3_2;
lbl15:
                        // 1 sources

                        if (this.timeAfterSeek < this.timeBeforeSeek) {
                            if (thisTime >= this.timeBeforeSeek) {
                                var3_3 = true;
                                return var3_3;
                            }
                            this.checkSeek = false;
                        }
                    }
                }
                marker = this.media.getNextMarker(this.previousTime, true);
                while (marker != null && !((nextMarkerTime = marker.getKey().doubleValue()) > thisTime)) {
                    if (nextMarkerTime != this.firedMarkerTime && nextMarkerTime >= this.previousTime && nextMarkerTime >= this.getStartTime() && nextMarkerTime <= this.getStopTime()) {
                        evt = new MarkerEvent(marker.getValue(), nextMarkerTime);
                        it = this.markerListeners.listIterator();
                        while (it.hasNext()) {
                            listener = (MarkerListener)it.next().get();
                            if (listener != null) {
                                listener.onMarker(evt);
                                continue;
                            }
                            it.remove();
                        }
                        this.firedMarkerTime = nextMarkerTime;
                    }
                    marker = this.media.getNextMarker(nextMarkerTime, false);
                }
                this.previousTime = thisTime;
            }
            finally {
                this.disposeLock.unlock();
                this.markerLock.unlock();
            }
        }
        return true;
    }

    private class EventQueueThread
    extends Thread {
        private BlockingQueue<PlayerEvent> eventQueue = new LinkedBlockingQueue<PlayerEvent>();
        private volatile boolean stopped = false;

        EventQueueThread() {
            this.setName("JFXMedia Player EventQueueThread");
            this.setDaemon(true);
        }

        public void run() {
            while (!this.stopped) {
                try {
                    PlayerEvent evt = this.eventQueue.take();
                    if (this.stopped) continue;
                    if (evt instanceof NewFrameEvent) {
                        try {
                            this.HandleRendererEvents((NewFrameEvent)evt);
                        }
                        catch (Throwable t) {
                            if (!Logger.canLog(4)) continue;
                            Logger.logMsg(4, "Caught exception in HandleRendererEvents: " + t.toString());
                        }
                        continue;
                    }
                    if (evt instanceof PlayerStateEvent) {
                        this.HandleStateEvents((PlayerStateEvent)evt);
                        continue;
                    }
                    if (evt instanceof FrameSizeChangedEvent) {
                        this.HandleFrameSizeChangedEvents((FrameSizeChangedEvent)evt);
                        continue;
                    }
                    if (evt instanceof TrackEvent) {
                        this.HandleTrackEvents((TrackEvent)evt);
                        continue;
                    }
                    if (evt instanceof MarkerEvent) {
                        this.HandleMarkerEvents((MarkerEvent)evt);
                        continue;
                    }
                    if (evt instanceof WarningEvent) {
                        this.HandleWarningEvents((WarningEvent)evt);
                        continue;
                    }
                    if (evt instanceof PlayerTimeEvent) {
                        this.HandlePlayerTimeEvents((PlayerTimeEvent)evt);
                        continue;
                    }
                    if (evt instanceof BufferProgressEvent) {
                        this.HandleBufferEvents((BufferProgressEvent)evt);
                        continue;
                    }
                    if (evt instanceof AudioSpectrumEvent) {
                        this.HandleAudioSpectrumEvents((AudioSpectrumEvent)evt);
                        continue;
                    }
                    if (!(evt instanceof MediaErrorEvent)) continue;
                    this.HandleErrorEvents((MediaErrorEvent)evt);
                }
                catch (Exception exception) {}
            }
            this.eventQueue.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void HandleRendererEvents(NewFrameEvent evt) {
            Object object;
            if (NativeMediaPlayer.this.isFirstFrame) {
                NativeMediaPlayer.this.isFirstFrame = false;
                object = NativeMediaPlayer.this.firstFrameLock;
                synchronized (object) {
                    NativeMediaPlayer.this.firstFrameEvent = evt;
                    NativeMediaPlayer.this.firstFrameTime = NativeMediaPlayer.this.firstFrameEvent.getFrameData().getTimestamp();
                    NativeMediaPlayer.this.firstFrameEvent.getFrameData().holdFrame();
                }
            }
            if (NativeMediaPlayer.this.firstFrameEvent != null && NativeMediaPlayer.this.firstFrameTime != evt.getFrameData().getTimestamp()) {
                object = NativeMediaPlayer.this.firstFrameLock;
                synchronized (object) {
                    NativeMediaPlayer.this.firstFrameEvent.getFrameData().releaseFrame();
                    NativeMediaPlayer.this.firstFrameEvent = null;
                }
            }
            ListIterator it = NativeMediaPlayer.this.videoUpdateListeners.listIterator();
            while (it.hasNext()) {
                VideoRendererListener l = (VideoRendererListener)((WeakReference)it.next()).get();
                if (l != null) {
                    l.videoFrameUpdated(evt);
                    continue;
                }
                it.remove();
            }
            evt.getFrameData().releaseFrame();
            if (!NativeMediaPlayer.this.videoFrameRateListeners.isEmpty()) {
                double currentFrameTime = (double)System.nanoTime() / 1.0E9;
                if (NativeMediaPlayer.this.recomputeFrameRate) {
                    NativeMediaPlayer.this.recomputeFrameRate = false;
                    NativeMediaPlayer.this.previousFrameTime = currentFrameTime;
                    NativeMediaPlayer.this.numFramesSincePlaying = 1L;
                } else {
                    boolean fireFrameRateEvent = false;
                    if (NativeMediaPlayer.this.numFramesSincePlaying == 1L) {
                        NativeMediaPlayer.this.meanFrameDuration = currentFrameTime - NativeMediaPlayer.this.previousFrameTime;
                        if (NativeMediaPlayer.this.meanFrameDuration > 0.0) {
                            NativeMediaPlayer.this.decodedFrameRate = 1.0 / NativeMediaPlayer.this.meanFrameDuration;
                            fireFrameRateEvent = true;
                        }
                    } else {
                        double previousMeanFrameDuration = NativeMediaPlayer.this.meanFrameDuration;
                        int movingAverageLength = NativeMediaPlayer.this.encodedFrameRate != 0.0 ? (int)(NativeMediaPlayer.this.encodedFrameRate + 0.5) : 30;
                        long numFrames = NativeMediaPlayer.this.numFramesSincePlaying < (long)movingAverageLength ? NativeMediaPlayer.this.numFramesSincePlaying : (long)movingAverageLength;
                        NativeMediaPlayer.this.meanFrameDuration = ((double)(numFrames - 1L) * previousMeanFrameDuration + currentFrameTime - NativeMediaPlayer.this.previousFrameTime) / (double)numFrames;
                        if (NativeMediaPlayer.this.meanFrameDuration > 0.0 && Math.abs(NativeMediaPlayer.this.decodedFrameRate - 1.0 / NativeMediaPlayer.this.meanFrameDuration) > 0.5) {
                            NativeMediaPlayer.this.decodedFrameRate = 1.0 / NativeMediaPlayer.this.meanFrameDuration;
                            fireFrameRateEvent = true;
                        }
                    }
                    if (fireFrameRateEvent) {
                        ListIterator it2 = NativeMediaPlayer.this.videoFrameRateListeners.listIterator();
                        while (it2.hasNext()) {
                            VideoFrameRateListener l = (VideoFrameRateListener)((WeakReference)it2.next()).get();
                            if (l != null) {
                                l.onFrameRateChanged(NativeMediaPlayer.this.decodedFrameRate);
                                continue;
                            }
                            it2.remove();
                        }
                    }
                    NativeMediaPlayer.this.previousFrameTime = currentFrameTime;
                    NativeMediaPlayer.this.numFramesSincePlaying++;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void HandleStateEvents(PlayerStateEvent evt) {
            NativeMediaPlayer.this.playerState = evt.getState();
            List list = NativeMediaPlayer.this.cachedStateEvents;
            synchronized (list) {
                NativeMediaPlayer.this.recomputeFrameRate = PlayerStateEvent.PlayerState.PLAYING == evt.getState();
                switch (NativeMediaPlayer.this.playerState) {
                    case READY: {
                        break;
                    }
                    case PLAYING: {
                        NativeMediaPlayer.this.isMediaPulseEnabled.set(true);
                        break;
                    }
                    case STOPPED: 
                    case FINISHED: {
                        NativeMediaPlayer.this.doMediaPulseTask();
                    }
                    case PAUSED: 
                    case STALLED: 
                    case HALTED: {
                        NativeMediaPlayer.this.isMediaPulseEnabled.set(false);
                    }
                }
                if (NativeMediaPlayer.this.playerStateListeners.isEmpty()) {
                    NativeMediaPlayer.this.cachedStateEvents.add(evt);
                    return;
                }
            }
            ListIterator it = NativeMediaPlayer.this.playerStateListeners.listIterator();
            while (it.hasNext()) {
                PlayerStateListener listener = (PlayerStateListener)((WeakReference)it.next()).get();
                if (listener != null) {
                    switch (NativeMediaPlayer.this.playerState) {
                        case READY: {
                            NativeMediaPlayer.this.onNativeInit();
                            listener.onReady(evt);
                            break;
                        }
                        case PLAYING: {
                            listener.onPlaying(evt);
                            break;
                        }
                        case PAUSED: {
                            listener.onPause(evt);
                            break;
                        }
                        case STOPPED: {
                            listener.onStop(evt);
                            break;
                        }
                        case STALLED: {
                            listener.onStall(evt);
                            break;
                        }
                        case FINISHED: {
                            listener.onFinish(evt);
                            break;
                        }
                        case HALTED: {
                            listener.onHalt(evt);
                        }
                    }
                    continue;
                }
                it.remove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void HandlePlayerTimeEvents(PlayerTimeEvent evt) {
            List list = NativeMediaPlayer.this.cachedTimeEvents;
            synchronized (list) {
                if (NativeMediaPlayer.this.playerTimeListeners.isEmpty()) {
                    NativeMediaPlayer.this.cachedTimeEvents.add(evt);
                    return;
                }
            }
            ListIterator it = NativeMediaPlayer.this.playerTimeListeners.listIterator();
            while (it.hasNext()) {
                PlayerTimeListener listener = (PlayerTimeListener)((WeakReference)it.next()).get();
                if (listener != null) {
                    switch (evt.getType()) {
                        case STOP_TIME: {
                            NativeMediaPlayer.this.pause();
                            listener.onStopTimeReached(evt.getTime());
                            break;
                        }
                        case DURATION: {
                            listener.onDurationChanged(evt.getTime());
                        }
                    }
                    continue;
                }
                it.remove();
            }
        }

        private void HandleFrameSizeChangedEvents(FrameSizeChangedEvent evt) {
            NativeMediaPlayer.this.frameWidth = evt.getWidth();
            NativeMediaPlayer.this.frameHeight = evt.getHeight();
            Logger.logMsg(1, "** Frame size changed (" + NativeMediaPlayer.this.frameWidth + ", " + NativeMediaPlayer.this.frameHeight + ")");
            ListIterator it = NativeMediaPlayer.this.videoTrackSizeListeners.listIterator();
            while (it.hasNext()) {
                VideoTrackSizeListener listener = (VideoTrackSizeListener)((WeakReference)it.next()).get();
                if (listener != null) {
                    listener.onSizeChanged(NativeMediaPlayer.this.frameWidth, NativeMediaPlayer.this.frameHeight);
                    continue;
                }
                it.remove();
            }
        }

        private void HandleTrackEvents(TrackEvent evt) {
            NativeMediaPlayer.this.media.addTrack(evt.getTrack());
            if (evt.getTrack() instanceof VideoTrack) {
                NativeMediaPlayer.this.encodedFrameRate = ((VideoTrack)evt.getTrack()).getEncodedFrameRate();
            }
        }

        private void HandleMarkerEvents(MarkerEvent evt) {
            ListIterator it = NativeMediaPlayer.this.markerListeners.listIterator();
            while (it.hasNext()) {
                MarkerListener listener = (MarkerListener)((WeakReference)it.next()).get();
                if (listener != null) {
                    listener.onMarker(evt);
                    continue;
                }
                it.remove();
            }
        }

        private void HandleWarningEvents(WarningEvent evt) {
            Logger.logMsg(3, evt.getSource() + evt.getMessage());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void HandleErrorEvents(MediaErrorEvent evt) {
            Logger.logMsg(4, evt.getMessage());
            List list = NativeMediaPlayer.this.cachedErrorEvents;
            synchronized (list) {
                if (NativeMediaPlayer.this.errorListeners.isEmpty()) {
                    NativeMediaPlayer.this.cachedErrorEvents.add(evt);
                    return;
                }
            }
            ListIterator it = NativeMediaPlayer.this.errorListeners.listIterator();
            while (it.hasNext()) {
                MediaErrorListener l = (MediaErrorListener)((WeakReference)it.next()).get();
                if (l != null) {
                    l.onError(evt.getSource(), evt.getErrorCode(), evt.getMessage());
                    continue;
                }
                it.remove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void HandleBufferEvents(BufferProgressEvent evt) {
            List list = NativeMediaPlayer.this.cachedBufferEvents;
            synchronized (list) {
                if (NativeMediaPlayer.this.bufferListeners.isEmpty()) {
                    NativeMediaPlayer.this.cachedBufferEvents.add(evt);
                    return;
                }
            }
            ListIterator it = NativeMediaPlayer.this.bufferListeners.listIterator();
            while (it.hasNext()) {
                BufferListener listener = (BufferListener)((WeakReference)it.next()).get();
                if (listener != null) {
                    listener.onBufferProgress(evt);
                    continue;
                }
                it.remove();
            }
        }

        private void HandleAudioSpectrumEvents(AudioSpectrumEvent evt) {
            ListIterator it = NativeMediaPlayer.this.audioSpectrumListeners.listIterator();
            while (it.hasNext()) {
                AudioSpectrumListener listener = (AudioSpectrumListener)((WeakReference)it.next()).get();
                if (listener != null) {
                    listener.onAudioSpectrumEvent(evt);
                    continue;
                }
                it.remove();
            }
        }

        public void postEvent(PlayerEvent event) {
            if (this.eventQueue != null) {
                this.eventQueue.offer(event);
            }
        }

        public void terminateLoop() {
            this.stopped = true;
            this.eventQueue.offer(new PlayerEvent());
        }
    }

    private class FrameSizeChangedEvent
    extends PlayerEvent {
        private int width;
        private int height;

        public FrameSizeChangedEvent(int width, int height) {
            this.width = width > 0 ? width : 0;
            this.height = height > 0 ? height : 0;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }

    public class MediaErrorEvent
    extends PlayerEvent {
        private Object source;
        private MediaError error;

        public MediaErrorEvent(Object source, MediaError error) {
            this.source = source;
            this.error = error;
        }

        public Object getSource() {
            return this.source;
        }

        public String getMessage() {
            return this.error.description();
        }

        public int getErrorCode() {
            return this.error.code();
        }
    }

    private class PlayerTimeEvent
    extends PlayerEvent {
        private PlayerTimeEventType type;
        private double time;

        public PlayerTimeEvent(PlayerTimeEventType type, double time) {
            this.type = type;
            this.time = time;
        }

        public PlayerTimeEventType getType() {
            return this.type;
        }

        public double getTime() {
            return this.time;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PlayerTimeEventType {
        STOP_TIME,
        DURATION;

    }

    private class TrackEvent
    extends PlayerEvent {
        private Track track;

        TrackEvent(Track track) {
            this.track = track;
        }

        public Track getTrack() {
            return this.track;
        }
    }

    private class VideoRenderer
    implements VideoRenderControl {
        private VideoRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addVideoRendererListener(VideoRendererListener listener) {
            if (listener != null) {
                Object object = NativeMediaPlayer.this.firstFrameLock;
                synchronized (object) {
                    if (NativeMediaPlayer.this.firstFrameEvent != null) {
                        listener.videoFrameUpdated(NativeMediaPlayer.this.firstFrameEvent);
                    }
                }
                NativeMediaPlayer.this.videoUpdateListeners.add(new WeakReference<VideoRendererListener>(listener));
            }
        }

        public void removeVideoRendererListener(VideoRendererListener listener) {
            if (listener != null) {
                ListIterator it = NativeMediaPlayer.this.videoUpdateListeners.listIterator();
                while (it.hasNext()) {
                    VideoRendererListener l = (VideoRendererListener)((WeakReference)it.next()).get();
                    if (l != null && l != listener) continue;
                    it.remove();
                }
            }
        }

        public void addVideoFrameRateListener(VideoFrameRateListener listener) {
            if (listener != null) {
                NativeMediaPlayer.this.videoFrameRateListeners.add(new WeakReference<VideoFrameRateListener>(listener));
            }
        }

        public void removeVideoFrameRateListener(VideoFrameRateListener listener) {
            if (listener != null) {
                ListIterator it = NativeMediaPlayer.this.videoFrameRateListeners.listIterator();
                while (it.hasNext()) {
                    VideoFrameRateListener l = (VideoFrameRateListener)((WeakReference)it.next()).get();
                    if (l != null && l != listener) continue;
                    it.remove();
                }
            }
        }

        public int getFrameWidth() {
            return NativeMediaPlayer.this.frameWidth;
        }

        public int getFrameHeight() {
            return NativeMediaPlayer.this.frameHeight;
        }
    }

    private class WarningEvent
    extends PlayerEvent {
        private Object source;
        private String message;

        WarningEvent(Object source, String message) {
            this.source = source;
            this.message = message;
        }

        public Object getSource() {
            return this.source;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

