/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.StyleableProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;

public class ToggleButton
extends ButtonBase
implements Toggle {
    private BooleanProperty selected;
    private ObjectProperty<ToggleGroup> toggleGroup;
    private static final String DEFAULT_STYLE_CLASS = "toggle-button";
    private static final String PSEUDO_CLASS_SELECTED = "selected";
    private static final long SELECTED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("selected");

    public ToggleButton() {
        this.initialize();
    }

    public ToggleButton(String string) {
        this.setText(string);
        this.initialize();
    }

    public ToggleButton(String string, Node node) {
        this.setText(string);
        this.setGraphic(node);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        StyleableProperty styleableProperty = StyleableProperty.getStyleableProperty(this.alignmentProperty());
        styleableProperty.set(this, Pos.CENTER);
        this.setMnemonicParsing(true);
    }

    @Override
    public final void setSelected(boolean bl) {
        this.selectedProperty().set(bl);
    }

    @Override
    public final boolean isSelected() {
        return this.selected == null ? false : this.selected.get();
    }

    @Override
    public final BooleanProperty selectedProperty() {
        if (this.selected == null) {
            this.selected = new BooleanPropertyBase(){

                @Override
                protected void invalidated() {
                    if (ToggleButton.this.getToggleGroup() != null) {
                        if (this.get()) {
                            ToggleButton.this.getToggleGroup().selectToggle(ToggleButton.this);
                        } else if (ToggleButton.this.getToggleGroup().getSelectedToggle() == ToggleButton.this) {
                            ToggleButton.this.getToggleGroup().clearSelectedToggle();
                        }
                    }
                    ToggleButton.this.impl_pseudoClassStateChanged(ToggleButton.PSEUDO_CLASS_SELECTED);
                }

                @Override
                public Object getBean() {
                    return ToggleButton.this;
                }

                @Override
                public String getName() {
                    return ToggleButton.PSEUDO_CLASS_SELECTED;
                }
            };
        }
        return this.selected;
    }

    @Override
    public final void setToggleGroup(ToggleGroup toggleGroup) {
        this.toggleGroupProperty().set(toggleGroup);
    }

    @Override
    public final ToggleGroup getToggleGroup() {
        return this.toggleGroup == null ? null : (ToggleGroup)this.toggleGroup.get();
    }

    @Override
    public final ObjectProperty<ToggleGroup> toggleGroupProperty() {
        if (this.toggleGroup == null) {
            this.toggleGroup = new ObjectPropertyBase<ToggleGroup>(){
                private ToggleGroup old;

                @Override
                protected void invalidated() {
                    ToggleGroup toggleGroup = (ToggleGroup)this.get();
                    if (toggleGroup != null && !toggleGroup.getToggles().contains(ToggleButton.this)) {
                        if (this.old != null) {
                            this.old.getToggles().remove(ToggleButton.this);
                        }
                        toggleGroup.getToggles().add(ToggleButton.this);
                    } else if (toggleGroup == null) {
                        this.old.getToggles().remove(ToggleButton.this);
                    }
                    this.old = toggleGroup;
                }

                @Override
                public Object getBean() {
                    return ToggleButton.this;
                }

                @Override
                public String getName() {
                    return "toggleGroup";
                }
            };
        }
        return this.toggleGroup;
    }

    @Override
    public void fire() {
        this.setSelected(!this.isSelected());
        this.fireEvent(new ActionEvent());
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        if (this.isSelected()) {
            l |= SELECTED_PSEUDOCLASS_STATE;
        }
        return l;
    }

    @Override
    @Deprecated
    protected Pos impl_cssGetAlignmentInitialValue() {
        return Pos.CENTER;
    }
}

