/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.core.scanner.VariantScript;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptWrapper;

public class VariantCustom
implements Variant {
    ExtensionScript extension = null;
    private ScriptWrapper wrapper = null;
    private VariantScript script = null;
    private final List<NameValuePair> params = new ArrayList<NameValuePair>();
    private static final Pattern BASE64_PATTERN = Pattern.compile("^[a-zA-Z0-9/+]+={0,2}$");

    public VariantCustom(ScriptWrapper wrapper, ExtensionScript extension) {
        this.wrapper = wrapper;
        this.extension = extension;
        if (wrapper != null && extension != null && wrapper.isEnabled()) {
            try {
                this.script = extension.getInterface(wrapper, VariantScript.class);
                if (this.script == null) {
                    extension.handleFailedScriptInterface(wrapper, Constant.messages.getString("variant.scripts.interface.variant.error", wrapper.getName()));
                }
            }
            catch (Exception ex) {
                this.extension.handleScriptException(wrapper, ex);
            }
        }
    }

    @Override
    public void setMessage(HttpMessage msg) {
        try {
            if (this.script != null) {
                this.script.parseParameters(this, msg);
            }
        }
        catch (Exception e) {
            this.extension.handleScriptException(this.wrapper, e);
        }
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.params;
    }

    public String getParamName(int index) {
        return index < this.params.size() ? this.params.get(index).getName() : null;
    }

    public String getParamValue(int index) {
        return index < this.params.size() ? this.params.get(index).getValue() : null;
    }

    public int getParamNumber() {
        return this.params.size();
    }

    public void addParam(String name, String value, int type) {
        this.params.add(new NameValuePair(type, name, value, this.params.size()));
    }

    public void addParamQuery(String name, String value) {
        this.addParam(name, value, 1);
    }

    public void addParamPost(String name, String value) {
        this.addParam(name, value, 2);
    }

    public void addParamHeader(String name, String value) {
        this.addParam(name, value, 8);
    }

    public String encodeBase64(String value) {
        return Base64.encodeBase64String((byte[])value.getBytes());
    }

    public String decodeBase64(String value) {
        return new String(Base64.decodeBase64((String)value));
    }

    public boolean isBase64(String value) {
        return BASE64_PATTERN.matcher(value).matches() && value.length() % 4 == 0;
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String param, String value) {
        return this.setParameter(msg, param, value, false);
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String param, String value) {
        return this.setParameter(msg, param, value, true);
    }

    private String setParameter(HttpMessage msg, String paramName, String value, boolean escaped) {
        try {
            if (this.script != null) {
                this.script.setParameter(this, msg, paramName, value, escaped);
            }
        }
        catch (Exception e) {
            this.extension.handleScriptException(this.wrapper, e);
        }
        return value;
    }
}

