/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.filter;

import java.util.Vector;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.filter.FilterAdaptor;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;

public class FilterLogCookie
extends FilterAdaptor {
    private static final String DELIM = "\t";
    private Vector<String> cookieList = null;

    @Override
    public int getId() {
        return 100;
    }

    @Override
    public String getName() {
        return Constant.messages.getString("filter.logcookies.name");
    }

    public void init() {
        this.cookieList = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onHttpRequestSend(HttpMessage msg) {
        HttpRequestHeader header = msg.getRequestHeader();
        if (header != null) {
            String cookie = header.getHeader("Cookie");
            Vector<String> vector = this.cookieList;
            synchronized (vector) {
                if (cookie != null && this.cookieList.indexOf(cookie) == -1) {
                    try {
                        URI uri;
                        try {
                            uri = (URI)header.getURI().clone();
                        }
                        catch (CloneNotSupportedException e) {
                            throw new URIException(e.getMessage());
                        }
                        uri.setQuery(null);
                        String sUri = uri.toString();
                        this.cookieList.add(cookie);
                        this.getView().getOutputPanel().append(sUri + DELIM + cookie + "\n");
                    }
                    catch (URIException e) {
                        this.getView().getOutputPanel().append((Exception)((Object)e));
                    }
                }
            }
        }
    }

    @Override
    public void onHttpResponseReceive(HttpMessage httpMessage) {
    }
}

